;;; http-status-codes.el --- Look up the meaning of HTTP status codes
;;
;; This file was automatically generated by
;; https://github.com/for-GET/know-your-http-well
;; based on the template of Ruslan Spivak
;;
;; Copyright (C) 2011  Ruslan Spivak
;;
;; Author: Ruslan Spivak <ruslan.spivak@gmail.com>
;; URL: http://github.com/rspivak/httpcode.el
;; Version: 0.1
;;
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2 of
;; the License, or (at your option) any later version.
;;
;; This program is distributed in the hope that it will be
;; useful, but WITHOUT ANY WARRANTY; without even the implied
;; warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
;; PURPOSE.  See the GNU General Public License for more details.
;;
;;; Commentary:
;;
;; Explain the meaning of an HTTP status code. Copy http-status-codes.el to your
;; load-path and add to your .emacs:
;;
;;   (require 'http-status-codes)
;;
;; Then run it with M-x http-status-code
;;
;;; Code goes here:

(defconst http-status
  '(("100" ("Continue" "indicates that the initial part of a request has been received and has not yet been rejected by the server."))
("CONTINUE" ("100" "indicates that the initial part of a request has been received and has not yet been rejected by the server."))
("101" ("Switching Protocols" "indicates that the server understands and is willing to comply with the client's request, via the Upgrade header field, for a change in the application protocol being used on this connection."))
("SWITCHING_PROTOCOLS" ("101" "indicates that the server understands and is willing to comply with the client's request, via the Upgrade header field, for a change in the application protocol being used on this connection."))
("200" ("OK" "indicates that the request has succeeded."))
("OK" ("200" "indicates that the request has succeeded."))
("201" ("Created" "indicates that the request has been fulfilled and has resulted in one or more new resources being created."))
("CREATED" ("201" "indicates that the request has been fulfilled and has resulted in one or more new resources being created."))
("202" ("Accepted" "indicates that the request has been accepted for processing, but the processing has not been completed."))
("ACCEPTED" ("202" "indicates that the request has been accepted for processing, but the processing has not been completed."))
("203" ("Non-Authoritative Information" "indicates that the request was successful but the enclosed payload has been modified from that of the origin server's 200 (OK) response by a transforming proxy."))
("NON_AUTHORITATIVE_INFORMATION" ("203" "indicates that the request was successful but the enclosed payload has been modified from that of the origin server's 200 (OK) response by a transforming proxy."))
("204" ("No Content" "indicates that the server has successfully fulfilled the request and that there is no additional content to send in the response payload body."))
("NO_CONTENT" ("204" "indicates that the server has successfully fulfilled the request and that there is no additional content to send in the response payload body."))
("205" ("Reset Content" "indicates that the server has fulfilled the request and desires that the user agent reset the document view, which caused the request to be sent, to its original state as received from the origin server."))
("RESET_CONTENT" ("205" "indicates that the server has fulfilled the request and desires that the user agent reset the document view, which caused the request to be sent, to its original state as received from the origin server."))
("206" ("Partial Content" "indicates that the server is successfully fulfilling a range request for the target resource by transferring one or more parts of the selected representation that correspond to the satisfiable ranges found in the requests's Range header field."))
("PARTIAL_CONTENT" ("206" "indicates that the server is successfully fulfilling a range request for the target resource by transferring one or more parts of the selected representation that correspond to the satisfiable ranges found in the requests's Range header field."))
("300" ("Multiple Choices" "indicates that the target resource has more than one representation, each with its own more specific identifier, and information about the alternatives is being provided so that the user (or user agent) can select a preferred representation by redirecting its request to one or more of those identifiers."))
("MULTIPLE_CHOICES" ("300" "indicates that the target resource has more than one representation, each with its own more specific identifier, and information about the alternatives is being provided so that the user (or user agent) can select a preferred representation by redirecting its request to one or more of those identifiers."))
("301" ("Moved Permanently" "indicates that the target resource has been assigned a new permanent URI and any future references to this resource ought to use one of the enclosed URIs."))
("MOVED_PERMANENTLY" ("301" "indicates that the target resource has been assigned a new permanent URI and any future references to this resource ought to use one of the enclosed URIs."))
("302" ("Found" "indicates that the target resource resides temporarily under a different URI."))
("FOUND" ("302" "indicates that the target resource resides temporarily under a different URI."))
("303" ("See Other" "indicates that the server is redirecting the user agent to a different resource, as indicated by a URI in the Location header field, that is intended to provide an indirect response to the original request."))
("SEE_OTHER" ("303" "indicates that the server is redirecting the user agent to a different resource, as indicated by a URI in the Location header field, that is intended to provide an indirect response to the original request."))
("304" ("Not Modified" "indicates that a conditional GET request has been received and would have resulted in a 200 (OK) response if it were not for the fact that the condition has evaluated to false."))
("NOT_MODIFIED" ("304" "indicates that a conditional GET request has been received and would have resulted in a 200 (OK) response if it were not for the fact that the condition has evaluated to false."))
("305" ("Use Proxy" "*deprecated*"))
("USE_PROXY" ("305" "*deprecated*"))
("307" ("Temporary Redirect" "indicates that the target resource resides temporarily under a different URI and the user agent MUST NOT change the request method if it performs an automatic redirection to that URI."))
("TEMPORARY_REDIRECT" ("307" "indicates that the target resource resides temporarily under a different URI and the user agent MUST NOT change the request method if it performs an automatic redirection to that URI."))
("400" ("Bad Request" "indicates that the server cannot or will not process the request because the received syntax is invalid, nonsensical, or exceeds some limitation on what the server is willing to process."))
("BAD_REQUEST" ("400" "indicates that the server cannot or will not process the request because the received syntax is invalid, nonsensical, or exceeds some limitation on what the server is willing to process."))
("401" ("Unauthorized" "indicates that the request has not been applied because it lacks valid authentication credentials for the target resource."))
("UNAUTHORIZED" ("401" "indicates that the request has not been applied because it lacks valid authentication credentials for the target resource."))
("402" ("Payment Required" "*reserved*"))
("PAYMENT_REQUIRED" ("402" "*reserved*"))
("403" ("Forbidden" "indicates that the server understood the request but refuses to authorize it."))
("FORBIDDEN" ("403" "indicates that the server understood the request but refuses to authorize it."))
("404" ("Not Found" "indicates that the origin server did not find a current representation for the target resource or is not willing to disclose that one exists."))
("NOT_FOUND" ("404" "indicates that the origin server did not find a current representation for the target resource or is not willing to disclose that one exists."))
("405" ("Method Not Allowed" "indicates that the method specified in the request-line is known by the origin server but not supported by the target resource."))
("METHOD_NOT_ALLOWED" ("405" "indicates that the method specified in the request-line is known by the origin server but not supported by the target resource."))
("406" ("Not Acceptable" "indicates that the target resource does not have a current representation that would be acceptable to the user agent, according to the proactive negotiation header fields received in the request, and the server is unwilling to supply a default representation."))
("NOT_ACCEPTABLE" ("406" "indicates that the target resource does not have a current representation that would be acceptable to the user agent, according to the proactive negotiation header fields received in the request, and the server is unwilling to supply a default representation."))
("407" ("Proxy Authentication Required" "is similar to 401 (Unauthorized), but indicates that the client needs to authenticate itself in order to use a proxy."))
("PROXY_AUTHENTICATION_REQUIRED" ("407" "is similar to 401 (Unauthorized), but indicates that the client needs to authenticate itself in order to use a proxy."))
("408" ("Request Timeout" "indicates that the server did not receive a complete request message within the time that it was prepared to wait."))
("REQUEST_TIMEOUT" ("408" "indicates that the server did not receive a complete request message within the time that it was prepared to wait."))
("409" ("Conflict" "indicates that the request could not be completed due to a conflict with the current state of the resource."))
("CONFLICT" ("409" "indicates that the request could not be completed due to a conflict with the current state of the resource."))
("410" ("Gone" "indicates that access to the target resource is no longer available at the origin server and that this condition is likely to be permanent."))
("GONE" ("410" "indicates that access to the target resource is no longer available at the origin server and that this condition is likely to be permanent."))
("411" ("Length Required" "indicates that the server refuses to accept the request without a defined Content-Length."))
("LENGTH_REQUIRED" ("411" "indicates that the server refuses to accept the request without a defined Content-Length."))
("412" ("Precondition Failed" "indicates that one or more preconditions given in the request header fields evaluated to false when tested on the server."))
("PRECONDITION_FAILED" ("412" "indicates that one or more preconditions given in the request header fields evaluated to false when tested on the server."))
("413" ("Payload Too Large" "indicates that the server is refusing to process a request because the request payload is larger than the server is willing or able to process."))
("PAYLOAD_TOO_LARGE" ("413" "indicates that the server is refusing to process a request because the request payload is larger than the server is willing or able to process."))
("414" ("URI Too Long" "indicates that the server is refusing to service the request because the request-target is longer than the server is willing to interpret."))
("URI_TOO_LONG" ("414" "indicates that the server is refusing to service the request because the request-target is longer than the server is willing to interpret."))
("415" ("Unsupported Media Type" "indicates that the origin server is refusing to service the request because the payload is in a format not supported by the target resource for this method."))
("UNSUPPORTED_MEDIA_TYPE" ("415" "indicates that the origin server is refusing to service the request because the payload is in a format not supported by the target resource for this method."))
("416" ("Range Not Satisfiable" "indicates that none of the ranges in the request's Range header field overlap the current extent of the selected resource or that the set of ranges requested has been rejected due to invalid ranges or an excessive request of small or overlapping ranges."))
("RANGE_NOT_SATISFIABLE" ("416" "indicates that none of the ranges in the request's Range header field overlap the current extent of the selected resource or that the set of ranges requested has been rejected due to invalid ranges or an excessive request of small or overlapping ranges."))
("417" ("Expectation Failed" "indicates that the expectation given in the request's Expect header field could not be met by at least one of the inbound servers."))
("EXPECTATION_FAILED" ("417" "indicates that the expectation given in the request's Expect header field could not be met by at least one of the inbound servers."))
("418" ("I'm a teapot" "Any attempt to brew coffee with a teapot should result in the error code 418 I'm a teapot."))
("I_M_A_TEAPOT" ("418" "Any attempt to brew coffee with a teapot should result in the error code 418 I'm a teapot."))
("426" ("Upgrade Required" "indicates that the server refuses to perform the request using the current protocol but might be willing to do so after the client upgrades to a different protocol."))
("UPGRADE_REQUIRED" ("426" "indicates that the server refuses to perform the request using the current protocol but might be willing to do so after the client upgrades to a different protocol."))
("500" ("Internal Server Error" "indicates that the server encountered an unexpected condition that prevented it from fulfilling the request."))
("INTERNAL_SERVER_ERROR" ("500" "indicates that the server encountered an unexpected condition that prevented it from fulfilling the request."))
("501" ("Not Implemented" "indicates that the server does not support the functionality required to fulfill the request."))
("NOT_IMPLEMENTED" ("501" "indicates that the server does not support the functionality required to fulfill the request."))
("502" ("Bad Gateway" "indicates that the server, while acting as a gateway or proxy, received an invalid response from an inbound server it accessed while attempting to fulfill the request."))
("BAD_GATEWAY" ("502" "indicates that the server, while acting as a gateway or proxy, received an invalid response from an inbound server it accessed while attempting to fulfill the request."))
("503" ("Service Unavailable" "indicates that the server is currently unable to handle the request due to a temporary overload or scheduled maintenance, which will likely be alleviated after some delay."))
("SERVICE_UNAVAILABLE" ("503" "indicates that the server is currently unable to handle the request due to a temporary overload or scheduled maintenance, which will likely be alleviated after some delay."))
("504" ("Gateway Time-out" "indicates that the server, while acting as a gateway or proxy, did not receive a timely response from an upstream server it needed to access in order to complete the request."))
("GATEWAY_TIME_OUT" ("504" "indicates that the server, while acting as a gateway or proxy, did not receive a timely response from an upstream server it needed to access in order to complete the request."))
("505" ("HTTP Version Not Supported" "indicates that the server does not support, or refuses to support, the protocol version that was used in the request message."))
("HTTP_VERSION_NOT_SUPPORTED" ("505" "indicates that the server does not support, or refuses to support, the protocol version that was used in the request message."))
("102" ("Processing" "is an interim response used to inform the client that the server has accepted the complete request, but has not yet completed it."))
("PROCESSING" ("102" "is an interim response used to inform the client that the server has accepted the complete request, but has not yet completed it."))
("207" ("Multi-Status" "provides status for multiple independent operations."))
("MULTI_STATUS" ("207" "provides status for multiple independent operations."))
("226" ("IM Used" "The server has fulfilled a GET request for the resource, and the response is a representation of the result of one or more instance-manipulations applied to the current instance."))
("IM_USED" ("226" "The server has fulfilled a GET request for the resource, and the response is a representation of the result of one or more instance-manipulations applied to the current instance."))
("308" ("Permanent Redirect" "The target resource has been assigned a new permanent URI and any future references to this resource outght to use one of the enclosed URIs. [...] This status code is similar to 301 Moved Permanently (Section 7.3.2 of rfc7231), except that it does not allow rewriting the request method from POST to GET."))
("PERMANENT_REDIRECT" ("308" "The target resource has been assigned a new permanent URI and any future references to this resource outght to use one of the enclosed URIs. [...] This status code is similar to 301 Moved Permanently (Section 7.3.2 of rfc7231), except that it does not allow rewriting the request method from POST to GET."))
("422" ("Unprocessable Entity" "means the server understands the content type of the request entity (hence a 415(Unsupported Media Type) status code is inappropriate), and the syntax of the request entity is correct (thus a 400 (Bad Request) status code is inappropriate) but was unable to process the contained instructions."))
("UNPROCESSABLE_ENTITY" ("422" "means the server understands the content type of the request entity (hence a 415(Unsupported Media Type) status code is inappropriate), and the syntax of the request entity is correct (thus a 400 (Bad Request) status code is inappropriate) but was unable to process the contained instructions."))
("423" ("Locked" "means the source or destination resource of a method is locked."))
("LOCKED" ("423" "means the source or destination resource of a method is locked."))
("424" ("Failed Dependency" "means that the method could not be performed on the resource because the requested action depended on another action and that action failed."))
("FAILED_DEPENDENCY" ("424" "means that the method could not be performed on the resource because the requested action depended on another action and that action failed."))
("428" ("Precondition Required" "indicates that the origin server requires the request to be conditional."))
("PRECONDITION_REQUIRED" ("428" "indicates that the origin server requires the request to be conditional."))
("429" ("Too Many Requests" "indicates that the user has sent too many requests in a given amount of time (rate limiting)."))
("TOO_MANY_REQUESTS" ("429" "indicates that the user has sent too many requests in a given amount of time (rate limiting)."))
("431" ("Request Header Fields Too Large" "indicates that the server is unwilling to process the request because its header fields are too large."))
("REQUEST_HEADER_FIELDS_TOO_LARGE" ("431" "indicates that the server is unwilling to process the request because its header fields are too large."))
("451" ("Unavailable For Legal Reasons" "This status code indicates that the server is denying access to the resource in response to a legal demand."))
("UNAVAILABLE_FOR_LEGAL_REASONS" ("451" "This status code indicates that the server is denying access to the resource in response to a legal demand."))
("506" ("Variant Also Negotiates" "indicates that the server has an internal configuration error: the chosen variant resource is configured to engage in transparent content negotiation itself, and is therefore not a proper end point in the negotiation process."))
("VARIANT_ALSO_NEGOTIATES" ("506" "indicates that the server has an internal configuration error: the chosen variant resource is configured to engage in transparent content negotiation itself, and is therefore not a proper end point in the negotiation process."))
("507" ("Insufficient Storage" "means the method could not be performed on the resource because the server is unable to store the representation needed to successfully complete the request."))
("INSUFFICIENT_STORAGE" ("507" "means the method could not be performed on the resource because the server is unable to store the representation needed to successfully complete the request."))
("511" ("Network Authentication Required" "indicates that the client needs to authenticate to gain network access."))
("NETWORK_AUTHENTICATION_REQUIRED" ("511" "indicates that the client needs to authenticate to gain network access."))))

;;;###autoload
(defun http-status-code (status)
  "Display the meaning of an HTTP status code or phrase"
  (interactive
   (list (completing-read "Enter HTTP status code or phrase: " http-status)))
  (let* ((uppercased-status (upcase status))
        (found (assoc uppercased-status http-status)))
    (if found
        (let* ((status-code (car found))
               (status-code-attrib (cdr found))
               (phrase (car (car status-code-attrib)))
               (description (car (cdr (car status-code-attrib)))))
          (message
           "%s - HTTP status\n%s\n%s"
           status-code phrase description))
      (message "%s - HTTP status\nUNKNOWN" uppercased-status))
    ))

(provide 'http-status-codes)

;;; http-status-codes.el ends here

