/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.openssl;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.python.bouncycastle.asn1.ASN1EncodableVector;
import org.python.bouncycastle.asn1.ASN1Integer;
import org.python.bouncycastle.asn1.ASN1Object;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.ASN1Primitive;
import org.python.bouncycastle.asn1.DERSequence;
import org.python.bouncycastle.asn1.cms.ContentInfo;
import org.python.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.python.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.python.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.python.bouncycastle.asn1.x509.DSAParameter;
import org.python.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.python.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.python.bouncycastle.cert.X509AttributeCertificateHolder;
import org.python.bouncycastle.cert.X509CRLHolder;
import org.python.bouncycastle.cert.X509CertificateHolder;
import org.python.bouncycastle.openssl.PEMEncryptor;
import org.python.bouncycastle.openssl.X509TrustedCertificateBlock;
import org.python.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.python.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.python.bouncycastle.util.Strings;
import org.python.bouncycastle.util.io.pem.PemGenerationException;
import org.python.bouncycastle.util.io.pem.PemHeader;
import org.python.bouncycastle.util.io.pem.PemObject;
import org.python.bouncycastle.util.io.pem.PemObjectGenerator;

public class MiscPEMGenerator
implements PemObjectGenerator {
    private static final ASN1ObjectIdentifier[] dsaOids = new ASN1ObjectIdentifier[]{X9ObjectIdentifiers.id_dsa, OIWObjectIdentifiers.dsaWithSHA1};
    private static final byte[] hexEncodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private final Object obj;
    private final PEMEncryptor encryptor;

    public MiscPEMGenerator(Object object) {
        this.obj = object;
        this.encryptor = null;
    }

    public MiscPEMGenerator(Object object, PEMEncryptor pEMEncryptor) {
        this.obj = object;
        this.encryptor = pEMEncryptor;
    }

    private PemObject createPemObject(Object object) throws IOException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        byte[] byArray;
        String string;
        if (object instanceof PemObject) {
            return (PemObject)object;
        }
        if (object instanceof PemObjectGenerator) {
            return ((PemObjectGenerator)object).generate();
        }
        if (object instanceof X509CertificateHolder) {
            string = "CERTIFICATE";
            byArray = ((X509CertificateHolder)object).getEncoded();
        } else if (object instanceof X509CRLHolder) {
            string = "X509 CRL";
            byArray = ((X509CRLHolder)object).getEncoded();
        } else if (object instanceof X509TrustedCertificateBlock) {
            string = "TRUSTED CERTIFICATE";
            byArray = ((X509TrustedCertificateBlock)object).getEncoded();
        } else if (object instanceof PrivateKeyInfo) {
            object5 = (PrivateKeyInfo)object;
            object4 = ((PrivateKeyInfo)object5).getPrivateKeyAlgorithm().getAlgorithm();
            if (((ASN1Primitive)object4).equals(PKCSObjectIdentifiers.rsaEncryption)) {
                string = "RSA PRIVATE KEY";
                byArray = ((PrivateKeyInfo)object5).parsePrivateKey().toASN1Primitive().getEncoded();
            } else if (((ASN1Primitive)object4).equals(dsaOids[0]) || ((ASN1Primitive)object4).equals(dsaOids[1])) {
                string = "DSA PRIVATE KEY";
                object3 = DSAParameter.getInstance(((PrivateKeyInfo)object5).getPrivateKeyAlgorithm().getParameters());
                object2 = new ASN1EncodableVector();
                ((ASN1EncodableVector)object2).add(new ASN1Integer(0L));
                ((ASN1EncodableVector)object2).add(new ASN1Integer(((DSAParameter)object3).getP()));
                ((ASN1EncodableVector)object2).add(new ASN1Integer(((DSAParameter)object3).getQ()));
                ((ASN1EncodableVector)object2).add(new ASN1Integer(((DSAParameter)object3).getG()));
                BigInteger bigInteger = ASN1Integer.getInstance(((PrivateKeyInfo)object5).parsePrivateKey()).getValue();
                BigInteger bigInteger2 = ((DSAParameter)object3).getG().modPow(bigInteger, ((DSAParameter)object3).getP());
                ((ASN1EncodableVector)object2).add(new ASN1Integer(bigInteger2));
                ((ASN1EncodableVector)object2).add(new ASN1Integer(bigInteger));
                byArray = new DERSequence((ASN1EncodableVector)object2).getEncoded();
            } else if (((ASN1Primitive)object4).equals(X9ObjectIdentifiers.id_ecPublicKey)) {
                string = "EC PRIVATE KEY";
                byArray = ((PrivateKeyInfo)object5).parsePrivateKey().toASN1Primitive().getEncoded();
            } else {
                string = "PRIVATE KEY";
                byArray = ((ASN1Object)object5).getEncoded();
            }
        } else if (object instanceof SubjectPublicKeyInfo) {
            string = "PUBLIC KEY";
            byArray = ((SubjectPublicKeyInfo)object).getEncoded();
        } else if (object instanceof X509AttributeCertificateHolder) {
            string = "ATTRIBUTE CERTIFICATE";
            byArray = ((X509AttributeCertificateHolder)object).getEncoded();
        } else if (object instanceof PKCS10CertificationRequest) {
            string = "CERTIFICATE REQUEST";
            byArray = ((PKCS10CertificationRequest)object).getEncoded();
        } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
            string = "ENCRYPTED PRIVATE KEY";
            byArray = ((PKCS8EncryptedPrivateKeyInfo)object).getEncoded();
        } else if (object instanceof ContentInfo) {
            string = "PKCS7";
            byArray = ((ContentInfo)object).getEncoded();
        } else {
            throw new PemGenerationException("unknown object passed - can't encode.");
        }
        if (this.encryptor != null) {
            object5 = Strings.toUpperCase(this.encryptor.getAlgorithm());
            if (((String)object5).equals("DESEDE")) {
                object5 = "DES-EDE3-CBC";
            }
            object4 = this.encryptor.getIV();
            object3 = this.encryptor.encrypt(byArray);
            object2 = new ArrayList<PemHeader>(2);
            object2.add(new PemHeader("Proc-Type", "4,ENCRYPTED"));
            object2.add(new PemHeader("DEK-Info", (String)object5 + "," + this.getHexEncoded((byte[])object4)));
            return new PemObject(string, (List)object2, (byte[])object3);
        }
        return new PemObject(string, byArray);
    }

    private String getHexEncoded(byte[] byArray) throws IOException {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i != byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[2 * i] = (char)hexEncodingTable[n >>> 4];
            cArray[2 * i + 1] = (char)hexEncodingTable[n & 0xF];
        }
        return new String(cArray);
    }

    @Override
    public PemObject generate() throws PemGenerationException {
        try {
            return this.createPemObject(this.obj);
        }
        catch (IOException iOException) {
            throw new PemGenerationException("encoding exception: " + iOException.getMessage(), iOException);
        }
    }
}

