/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import org.jruby.RubySymbol;
import org.jruby.ast.IterNode;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.builder.LazyMethodDefinitionAST;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.interpreter.ClosureInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.persistence.IRWriter;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.InterpretedIRBlockBody;
import org.jruby.runtime.MixedModeIRBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.util.ByteList;

public class IRClosure
extends IRScope {
    public final int closureId;
    private boolean isEND;
    private Signature signature;
    private IterNode source;
    protected ArgumentDescriptor[] argDesc = ArgumentDescriptor.EMPTY_ARRAY;
    private IRBlockBody body;
    private static final ByteList CLOSURE = new ByteList(new byte[]{95, 67, 76, 79, 83, 85, 82, 69, 95});
    private static final ByteList CLOSURE_CLONE = new ByteList(new byte[]{95, 67, 76, 79, 83, 85, 82, 69, 95, 67, 76, 79, 78, 69, 95}, false);

    protected IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, ByteList prefix, int coverageMode) {
        super(manager, lexicalParent, null, lineNumber, staticScope, coverageMode);
        this.closureId = lexicalParent.getNextClosureId();
        ByteList name2 = prefix.dup();
        name2.append(Integer.toString(this.closureId).getBytes());
        this.setByteName(name2);
    }

    protected IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, ByteList prefix) {
        this(manager, lexicalParent, lineNumber, staticScope, prefix, 0);
    }

    protected IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, int closureId, ByteList fullName) {
        super(manager, lexicalParent, null, lineNumber, staticScope);
        this.closureId = closureId;
        super.setByteName(fullName);
    }

    protected IRClosure(IRClosure c, IRScope lexicalParent, int closureId, ByteList fullName) {
        super(c, lexicalParent);
        this.closureId = closureId;
        super.setByteName(fullName);
        this.isEND = c.isEND;
        this.signature = c.signature;
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, CLOSURE, false);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, int coverageMode) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, CLOSURE, false, coverageMode);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, ByteList prefix, int coverageMode) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, prefix, false, coverageMode);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, ByteList prefix) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, prefix, false);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, ByteList prefix, boolean isBeginEndBlock) {
        this(manager, lexicalParent, lineNumber, staticScope, signature, prefix, isBeginEndBlock, 0);
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, int lineNumber, StaticScope staticScope, Signature signature, ByteList prefix, boolean isBeginEndBlock, int coverageMode) {
        this(manager, lexicalParent, lineNumber, staticScope, prefix);
        this.signature = signature;
        lexicalParent.addClosure(this);
        if (staticScope != null) {
            staticScope.setIRScope(this);
            staticScope.setScopeType(this.getScopeType());
        }
    }

    @Override
    public InterpreterContext allocateInterpreterContext(List<Instr> instructions, int temporaryVariableCount, EnumSet<IRFlags> flags2) {
        this.interpreterContext = new ClosureInterpreterContext(this, instructions, temporaryVariableCount, flags2);
        return this.interpreterContext;
    }

    @Override
    public InterpreterContext allocateInterpreterContext(Supplier<List<Instr>> instructions, int temporaryVariableCount, EnumSet<IRFlags> flags2) {
        try {
            this.interpreterContext = new ClosureInterpreterContext(this, instructions, temporaryVariableCount, flags2);
        }
        catch (Exception e) {
            Helpers.throwException(e);
        }
        return this.interpreterContext;
    }

    public void setIsEND() {
        this.isEND = true;
    }

    public boolean isEND() {
        return this.isEND;
    }

    @Override
    public boolean isWhereFlipFlopStateVariableIs() {
        return false;
    }

    @Override
    public int getNextClosureId() {
        return this.getLexicalParent().getNextClosureId();
    }

    @Override
    public Label getNewLabel() {
        return this.getNewLabel(this.getManager().getClosurePrefix(this.closureId));
    }

    @Override
    public IRScopeType getScopeType() {
        return IRScopeType.CLOSURE;
    }

    @Override
    public boolean isTopLocalVariableScope() {
        return false;
    }

    public String toStringBody() {
        return this.getId() + " = {\n" + this.toStringInstrs() + "\n}\n\n";
    }

    public BlockBody getBlockBody() {
        IRBlockBody body = this.body;
        if (body != null) {
            return body;
        }
        boolean shouldJit = this.getManager().getInstanceConfig().getCompileMode().shouldJIT();
        this.body = shouldJit ? new MixedModeIRBlockBody(this, this.signature) : new InterpretedIRBlockBody(this, this.signature);
        return this.body;
    }

    public boolean isNestedClosuresSafeForMethodConversion() {
        for (IRClosure closure : this.getClosures()) {
            if (closure.isNestedClosuresSafeForMethodConversion()) continue;
            return false;
        }
        return !this.accessesParentsLocalVariables();
    }

    public IRMethod convertToMethod(ByteList name2) {
        if (this.source == null || this.accessesParentsLocalVariables() || this.receivesClosureArg() || this.usesZSuper() || !this.isNestedClosuresSafeForMethodConversion()) {
            this.source = null;
            return null;
        }
        IterNode def = this.source;
        this.source = null;
        LazyMethodDefinitionAST defn = new LazyMethodDefinitionAST(def);
        return new IRMethod(this.getManager(), this.getLexicalParent(), defn, name2, true, this.getLine(), this.getStaticScope().duplicate(), this.getCoverageMode());
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public void setSource(IterNode iter) {
        this.source = iter;
    }

    @Override
    protected LocalVariable findExistingLocalVariable(RubySymbol name2, int scopeDepth) {
        LocalVariable lvar = this.lookupExistingLVar(name2);
        if (lvar != null) {
            return lvar;
        }
        int newDepth = scopeDepth - 1;
        if (newDepth >= 0 && (lvar = this.getLexicalParent().findExistingLocalVariable(name2, newDepth)) != null) {
            this.setAccessesParentsLocalVariables();
        }
        return lvar;
    }

    @Override
    public LocalVariable getNewLocalVariable(RubySymbol name2, int depth) {
        if (depth == 0 && !(this instanceof IRFor)) {
            ClosureLocalVariable lvar = new ClosureLocalVariable(name2, 0, this.getStaticScope().addVariableThisScope(name2.idString()));
            this.localVars.put(name2, lvar);
            return lvar;
        }
        if (!(this instanceof IRFor)) {
            this.setAccessesParentsLocalVariables();
        }
        IRScope s2 = this;
        int d = depth;
        while (true) {
            if (s2 instanceof IRFor) {
                ++depth;
                s2 = s2.getLexicalParent();
                continue;
            }
            if (--d >= 0) {
                s2 = s2.getLexicalParent();
            }
            if (d < 0) break;
        }
        return s2.getNewLocalVariable(name2, 0).cloneForDepth(depth);
    }

    @Override
    public LocalVariable getLocalVariable(RubySymbol name2, int depth) {
        LocalVariable lvar;
        IRScope s2 = this;
        int d = depth;
        if (depth > 0 && !(this instanceof IRFor)) {
            this.setAccessesParentsLocalVariables();
        }
        if (depth == 0) {
            return s2.getNewLocalVariable(name2, 0);
        }
        while (true) {
            if (s2 instanceof IRFor) {
                ++depth;
                s2 = s2.getLexicalParent();
                continue;
            }
            lvar = s2.lookupExistingLVar(name2);
            if (--d >= 0) {
                s2 = s2.getLexicalParent();
            }
            if (lvar != null || d < 0) break;
        }
        if (lvar == null) {
            lvar = s2.getNewLocalVariable(name2, 0).cloneForDepth(depth);
        } else {
            int lvarDepth = depth - (d + 1);
            if (lvar.getScopeDepth() != lvarDepth) {
                lvar = lvar.cloneForDepth(lvarDepth);
            }
        }
        return lvar;
    }

    protected IRClosure cloneForInlining(CloneInfo ii, IRClosure clone2) {
        SimpleCloneInfo clonedII = ii.cloneForCloningClosure(clone2);
        ArrayList<Instr> newInstrs = new ArrayList<Instr>(this.interpreterContext.getInstructions().length);
        for (Instr i2 : this.interpreterContext.getInstructions()) {
            newInstrs.add(i2.clone(clonedII));
        }
        clone2.allocateInterpreterContext(newInstrs, this.interpreterContext.getTemporaryVariableCount(), this.interpreterContext.getFlags());
        return clone2;
    }

    public IRClosure cloneForInlining(CloneInfo ii) {
        IRClosure clonedClosure;
        IRScope lexicalParent = ii.getScope();
        if (ii instanceof SimpleCloneInfo && !((SimpleCloneInfo)ii).isEnsureBlockCloneMode()) {
            clonedClosure = new IRClosure(this, lexicalParent, this.closureId, this.getByteName());
        } else {
            int id2 = lexicalParent.getNextClosureId();
            ByteList fullName = lexicalParent.getByteName();
            fullName = fullName != null ? fullName.dup() : new ByteList();
            fullName.append(CLOSURE_CLONE);
            fullName.append(Integer.toString(id2).getBytes());
            clonedClosure = new IRClosure(this, lexicalParent, id2, fullName);
        }
        lexicalParent.addClosure(clonedClosure);
        return this.cloneForInlining(ii, clonedClosure);
    }

    public Signature getSignature() {
        return this.signature;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.argDesc;
    }

    public void setArgumentDescriptors(ArgumentDescriptor[] argDesc) {
        this.argDesc = argDesc;
    }

    @Override
    public void persistScopeHeader(IRWriterEncoder file2) {
        super.persistScopeHeader(file2);
        if (this.getScopeType() == IRScopeType.CLOSURE) {
            if (IRWriter.shouldLog(file2)) {
                System.out.println("IRClosure.persistScopeHeader: type       = " + this.isEND());
            }
            file2.encode(this.isEND());
        }
        if (IRWriter.shouldLog(file2)) {
            System.out.println("IRClosure.persistScopeHeader: type       = " + String.valueOf(this.getSignature()));
        }
        file2.encode(this.getSignature());
    }
}

