/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.hunspell.DictEntry;

public class EntrySuggestion {
    private final List<DictEntry> toEdit;
    private final List<DictEntry> toAdd;
    private final List<String> extraGenerated;

    EntrySuggestion(List<DictEntry> toEdit, List<DictEntry> toAdd, List<String> extraGenerated) {
        this.toEdit = Collections.unmodifiableList(toEdit);
        this.toAdd = Collections.unmodifiableList(toAdd);
        this.extraGenerated = Collections.unmodifiableList(extraGenerated);
    }

    public List<DictEntry> getEntriesToEdit() {
        return this.toEdit;
    }

    public List<DictEntry> getEntriesToAdd() {
        return this.toAdd;
    }

    public List<String> getExtraGeneratedWords() {
        return this.extraGenerated;
    }

    public String toString() {
        return "EntrySuggestion{" + this.internalsToString() + "}";
    }

    String internalsToString() {
        return "toEdit=" + this.toEdit + ", toAdd=" + this.toAdd + ", extra=" + this.extraGenerated;
    }
}

