/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.util.Arrays;

public class JceAEADCipherUtil {
    static void setUpAeadCipher(Cipher cipher, SecretKey secretKey, int n, byte[] byArray, int n2, byte[] byArray2) throws InvalidKeyException, InvalidAlgorithmParameterException {
        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec((n2 + 7) / 8 * 8, byArray);
        cipher.init(n, (Key)secretKey, gCMParameterSpec);
        cipher.updateAAD(byArray2);
    }

    static class GCMParameters
    extends ASN1Object {
        private byte[] nonce;
        private int icvLen;

        public GCMParameters(byte[] byArray, int n) {
            this.nonce = Arrays.clone((byte[])byArray);
            this.icvLen = n;
        }

        public byte[] getNonce() {
            return Arrays.clone((byte[])this.nonce);
        }

        public int getIcvLen() {
            return this.icvLen;
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
            aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(this.nonce));
            if (this.icvLen != 12) {
                aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer((long)this.icvLen));
            }
            return new DERSequence(aSN1EncodableVector);
        }
    }
}

