/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.FieldType;
import org.opensearch.Version;
import org.opensearch.common.Explicit;
import org.opensearch.common.TriFunction;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.mapper.ContentPath;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.TypeParsers;

@PublicApi(since="1.0.0")
public abstract class ParametrizedFieldMapper
extends FieldMapper {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ParametrizedFieldMapper.class);

    protected ParametrizedFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, new FieldType(), mappedFieldType, multiFields, copyTo);
    }

    public abstract Builder getMergeBuilder();

    @Override
    public final ParametrizedFieldMapper merge(Mapper mergeWith) {
        if (!(mergeWith instanceof FieldMapper)) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] cannot be changed from type [" + this.contentType() + "] to [" + mergeWith.getClass().getSimpleName() + "]");
        }
        String mergeWithContentType = ((FieldMapper)mergeWith).contentType();
        if (!Objects.equals(this.getClass(), mergeWith.getClass())) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] cannot be changed from type [" + this.contentType() + "] to [" + mergeWithContentType + "]");
        }
        if (!Objects.equals(this.contentType(), mergeWithContentType)) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] cannot be changed from type [" + this.contentType() + "] to [" + mergeWithContentType + "]");
        }
        Builder builder = this.getMergeBuilder();
        if (builder == null) {
            return (ParametrizedFieldMapper)mergeWith;
        }
        Conflicts conflicts = new Conflicts(this.name());
        builder.merge((FieldMapper)mergeWith, conflicts);
        conflicts.check();
        return builder.build(new Mapper.BuilderContext(Settings.EMPTY, ParametrizedFieldMapper.parentPath(this.name())));
    }

    private static ContentPath parentPath(String name) {
        int endPos = name.lastIndexOf(".");
        if (endPos == -1) {
            return new ContentPath(0);
        }
        return new ContentPath(name.substring(0, endPos));
    }

    @Override
    protected final void mergeOptions(FieldMapper other, List<String> conflicts) {
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        this.getMergeBuilder().toXContent(builder, includeDefaults);
        this.multiFields.toXContent(builder, params);
        this.copyTo.toXContent(builder, params);
    }

    @PublicApi(since="1.0.0")
    public static abstract class Builder
    extends Mapper.Builder<Builder> {
        protected final FieldMapper.MultiFields.Builder multiFieldsBuilder = new FieldMapper.MultiFields.Builder();
        protected final FieldMapper.CopyTo.Builder copyTo = new FieldMapper.CopyTo.Builder();
        private static final Set<String> DEPRECATED_PARAMS = new HashSet<String>(Arrays.asList("store", "meta", "boost", "index", "doc_values", "index_options", "similarity"));

        protected Builder(String name) {
            super(name);
        }

        public Builder init(FieldMapper initializer) {
            for (Parameter<?> param : this.getParameters()) {
                param.init(initializer);
            }
            for (Mapper subField : initializer.multiFields) {
                this.multiFieldsBuilder.add(subField);
            }
            return this;
        }

        private void merge(FieldMapper in, Conflicts conflicts) {
            for (Parameter<?> param : this.getParameters()) {
                param.merge(in, conflicts);
            }
            for (Mapper newSubField : in.multiFields) {
                this.multiFieldsBuilder.update(newSubField, ParametrizedFieldMapper.parentPath(newSubField.name()));
            }
            this.copyTo.reset(in.copyTo);
            this.validate();
        }

        private void validate() {
            for (Parameter<?> param : this.getParameters()) {
                param.validate();
            }
        }

        protected abstract List<Parameter<?>> getParameters();

        @Override
        public abstract ParametrizedFieldMapper build(Mapper.BuilderContext var1);

        protected String buildFullName(Mapper.BuilderContext context) {
            return context.path().pathAsText(this.name);
        }

        protected final void toXContent(XContentBuilder builder, boolean includeDefaults) throws IOException {
            for (Parameter<?> parameter : this.getParameters()) {
                parameter.toXContent(builder, includeDefaults);
            }
        }

        public final void parse(String name, Mapper.TypeParser.ParserContext parserContext, Map<String, Object> fieldNode) {
            HashMap paramsMap = new HashMap();
            HashMap deprecatedParamsMap = new HashMap();
            for (Parameter<?> param : this.getParameters()) {
                paramsMap.put(param.name, param);
                for (String deprecatedName : param.deprecatedNames) {
                    deprecatedParamsMap.put(deprecatedName, param);
                }
            }
            String type = (String)fieldNode.get("type");
            if (paramsMap.get("type") == null) {
                fieldNode.remove("type");
            }
            Iterator<Map.Entry<String, Object>> iterator = fieldNode.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (Objects.equals("fields", propName)) {
                    TypeParsers.parseMultiField(this.multiFieldsBuilder::add, name, parserContext, propName, propNode);
                    iterator.remove();
                    continue;
                }
                if (Objects.equals("copy_to", propName)) {
                    TypeParsers.parseCopyFields(propNode).forEach(this.copyTo::add);
                    iterator.remove();
                    continue;
                }
                Parameter parameter = (Parameter)deprecatedParamsMap.get(propName);
                if (parameter != null) {
                    deprecationLogger.deprecate(propName + name, "Parameter [{}] on mapper [{}] is deprecated, use [{}]", propName, name, parameter.name);
                } else {
                    parameter = (Parameter)paramsMap.get(propName);
                }
                if (parameter == null) {
                    if (Builder.isDeprecatedParameter(propName, parserContext.indexVersionCreated())) {
                        deprecationLogger.deprecate(propName + type, "Parameter [{}] has no effect on type [{}] and will be removed in future", propName, type);
                        iterator.remove();
                        continue;
                    }
                    throw new MapperParsingException("unknown parameter [" + propName + "] on mapper [" + name + "] of type [" + type + "]");
                }
                if (Objects.equals("boost", propName)) {
                    deprecationLogger.deprecate("boost_" + name, "Parameter [boost] on field [{}] is deprecated and will be removed in 3.0", name);
                }
                if (propNode == null && !parameter.acceptsNull) {
                    throw new MapperParsingException("[" + propName + "] on mapper [" + name + "] of type [" + type + "] must not have a [null] value");
                }
                parameter.parse(name, parserContext, propNode);
                iterator.remove();
            }
            this.validate();
        }

        private static boolean isDeprecatedParameter(String propName, Version indexCreatedVersion) {
            return DEPRECATED_PARAMS.contains(propName);
        }
    }

    private static final class Conflicts {
        private final String mapperName;
        private final List<String> conflicts = new ArrayList<String>();

        Conflicts(String mapperName) {
            this.mapperName = mapperName;
        }

        void addConflict(String parameter, String existing, String toMerge) {
            this.conflicts.add("Cannot update parameter [" + parameter + "] from [" + existing + "] to [" + toMerge + "]");
        }

        void check() {
            if (this.conflicts.isEmpty()) {
                return;
            }
            String message = "Mapper for [" + this.mapperName + "] conflicts with existing mapper:\n\t" + String.join((CharSequence)"\n\t", this.conflicts);
            throw new IllegalArgumentException(message);
        }
    }

    public static final class TypeParser
    implements Mapper.TypeParser {
        private final BiFunction<String, Mapper.TypeParser.ParserContext, Builder> builderFunction;

        public TypeParser(BiFunction<String, Mapper.TypeParser.ParserContext, Builder> builderFunction) {
            this.builderFunction = builderFunction;
        }

        public Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = this.builderFunction.apply(name, parserContext);
            builder.parse(name, parserContext, node);
            return builder;
        }
    }

    @PublicApi(since="1.0.0")
    public static final class Parameter<T>
    implements Supplier<T> {
        public final String name;
        private final List<String> deprecatedNames = new ArrayList<String>();
        private final Supplier<T> defaultValue;
        private final TriFunction<String, Mapper.TypeParser.ParserContext, Object, T> parser;
        private final Function<FieldMapper, T> initializer;
        private boolean acceptsNull = false;
        private Consumer<T> validator = null;
        private Serializer<T> serializer = XContentBuilder::field;
        private SerializerCheck<T> serializerCheck = (includeDefaults, isConfigured, value) -> includeDefaults || isConfigured;
        private Function<T, String> conflictSerializer = Objects::toString;
        private BiPredicate<T, T> mergeValidator;
        private T value;
        private boolean isSet;

        public Parameter(String name, boolean updateable, Supplier<T> defaultValue, TriFunction<String, Mapper.TypeParser.ParserContext, Object, T> parser, Function<FieldMapper, T> initializer) {
            this.name = name;
            this.defaultValue = Objects.requireNonNull(defaultValue);
            this.value = null;
            this.parser = parser;
            this.initializer = initializer;
            this.mergeValidator = (previous, toMerge) -> updateable || Objects.equals(previous, toMerge);
        }

        public T getValue() {
            return this.isSet ? this.value : this.defaultValue.get();
        }

        @Override
        public T get() {
            return this.getValue();
        }

        public T getDefaultValue() {
            return this.defaultValue.get();
        }

        public void setValue(T value) {
            this.isSet = true;
            this.value = value;
        }

        public boolean isConfigured() {
            return this.isSet && !Objects.equals(this.value, this.defaultValue.get());
        }

        public Parameter<T> acceptsNull() {
            this.acceptsNull = true;
            return this;
        }

        public Parameter<T> addDeprecatedName(String deprecatedName) {
            this.deprecatedNames.add(deprecatedName);
            return this;
        }

        public Parameter<T> setValidator(Consumer<T> validator) {
            this.validator = validator;
            return this;
        }

        public Parameter<T> setSerializer(Serializer<T> serializer, Function<T, String> conflictSerializer) {
            this.serializer = serializer;
            this.conflictSerializer = conflictSerializer;
            return this;
        }

        public Parameter<T> setSerializerCheck(SerializerCheck<T> check) {
            this.serializerCheck = check;
            return this;
        }

        public Parameter<T> alwaysSerialize() {
            this.serializerCheck = (id, ic, v) -> true;
            return this;
        }

        public Parameter<T> neverSerialize() {
            this.serializerCheck = (id, ic, v) -> false;
            return this;
        }

        public Parameter<T> setMergeValidator(BiPredicate<T, T> mergeValidator) {
            this.mergeValidator = mergeValidator;
            return this;
        }

        private void validate() {
            if (this.validator != null) {
                this.validator.accept(this.getValue());
            }
        }

        private void init(FieldMapper toInit) {
            this.setValue(this.initializer.apply(toInit));
        }

        private void parse(String field, Mapper.TypeParser.ParserContext context, Object in) {
            this.setValue(this.parser.apply((Object)field, (Object)context, in));
        }

        private void merge(FieldMapper toMerge, Conflicts conflicts) {
            T value = this.initializer.apply(toMerge);
            T current = this.getValue();
            if (this.mergeValidator.test(current, value)) {
                this.setValue(value);
            } else {
                conflicts.addConflict(this.name, this.conflictSerializer.apply(current), this.conflictSerializer.apply(value));
            }
        }

        protected void toXContent(XContentBuilder builder, boolean includeDefaults) throws IOException {
            if (this.serializerCheck.check(includeDefaults, this.isConfigured(), this.get())) {
                this.serializer.serialize(builder, this.name, this.getValue());
            }
        }

        public static Parameter<Boolean> boolParam(String name, boolean updateable, Function<FieldMapper, Boolean> initializer, boolean defaultValue) {
            return new Parameter<Boolean>(name, updateable, () -> defaultValue, (n, c, o) -> XContentMapValues.nodeBooleanValue(o), initializer);
        }

        public static Parameter<Explicit<Boolean>> explicitBoolParam(String name, boolean updateable, Function<FieldMapper, Explicit<Boolean>> initializer, boolean defaultValue) {
            Explicit defaultExplicit = new Explicit((Object)defaultValue, false);
            return new Parameter<Explicit<Boolean>>(name, updateable, () -> defaultExplicit, (n, c, o) -> new Explicit((Object)XContentMapValues.nodeBooleanValue(o), true), initializer).setSerializer((b, n, v) -> b.field(n, (Boolean)v.value()), v -> Boolean.toString((Boolean)v.value()));
        }

        public static Parameter<Double> doubleParam(String name, boolean updateable, Function<FieldMapper, Double> initializer, double defaultValue) {
            return new Parameter<Double>(name, updateable, () -> defaultValue, (n, c, o) -> XContentMapValues.nodeDoubleValue(o), initializer);
        }

        public static Parameter<Float> floatParam(String name, boolean updateable, Function<FieldMapper, Float> initializer, float defaultValue) {
            return new Parameter<Float>(name, updateable, () -> Float.valueOf(defaultValue), (n, c, o) -> Float.valueOf(XContentMapValues.nodeFloatValue(o)), initializer);
        }

        public static Parameter<Integer> intParam(String name, boolean updateable, Function<FieldMapper, Integer> initializer, int defaultValue) {
            return new Parameter<Integer>(name, updateable, () -> defaultValue, (n, c, o) -> XContentMapValues.nodeIntegerValue(o), initializer);
        }

        public static Parameter<String> stringParam(String name, boolean updateable, Function<FieldMapper, String> initializer, String defaultValue) {
            return new Parameter<String>(name, updateable, () -> defaultValue, (n, c, o) -> XContentMapValues.nodeStringValue(o), initializer);
        }

        public static Parameter<List<String>> stringArrayParam(String name, boolean updateable, Function<FieldMapper, List<String>> initializer, List<String> defaultValue) {
            return new Parameter<List<String>>(name, updateable, () -> defaultValue, (n, c, o) -> {
                List values = (List)o;
                ArrayList<String> strValues = new ArrayList<String>();
                for (Object item : values) {
                    strValues.add(item.toString());
                }
                return strValues;
            }, initializer);
        }

        public static Parameter<String> restrictedStringParam(String name, boolean updateable, Function<FieldMapper, String> initializer, String ... values) {
            assert (values.length > 0);
            LinkedHashSet<String> acceptedValues = new LinkedHashSet<String>(Arrays.asList(values));
            return Parameter.stringParam(name, updateable, initializer, values[0]).setValidator(v -> {
                if (acceptedValues.contains(v)) {
                    return;
                }
                throw new MapperParsingException("Unknown value [" + v + "] for field [" + name + "] - accepted values are " + acceptedValues.toString());
            });
        }

        public static Parameter<NamedAnalyzer> analyzerParam(String name, boolean updateable, Function<FieldMapper, NamedAnalyzer> initializer, Supplier<NamedAnalyzer> defaultAnalyzer) {
            return new Parameter<NamedAnalyzer>(name, updateable, defaultAnalyzer, (n, c, o) -> {
                String analyzerName = o.toString();
                NamedAnalyzer a = c.getIndexAnalyzers().get(analyzerName);
                if (a == null) {
                    throw new IllegalArgumentException("analyzer [" + analyzerName + "] has not been configured in mappings");
                }
                return a;
            }, initializer).setSerializer((b, n, v) -> b.field(n, v.name()), NamedAnalyzer::name);
        }

        public static Parameter<Map<String, String>> metaParam() {
            return new Parameter<Map<String, String>>("meta", true, Collections::emptyMap, (n, c, o) -> TypeParsers.parseMeta(n, o), m -> m.fieldType().meta());
        }

        public static Parameter<Boolean> indexParam(Function<FieldMapper, Boolean> initializer, boolean defaultValue) {
            return Parameter.boolParam("index", false, initializer, defaultValue);
        }

        public static Parameter<Boolean> storeParam(Function<FieldMapper, Boolean> initializer, boolean defaultValue) {
            return Parameter.boolParam("store", false, initializer, defaultValue);
        }

        public static Parameter<Boolean> docValuesParam(Function<FieldMapper, Boolean> initializer, boolean defaultValue) {
            return Parameter.boolParam("doc_values", false, initializer, defaultValue);
        }

        public static Parameter<Float> boostParam() {
            return Parameter.floatParam("boost", true, m -> Float.valueOf(m.fieldType().boost()), 1.0f);
        }
    }

    @PublicApi(since="1.0.0")
    protected static interface SerializerCheck<T> {
        public boolean check(boolean var1, boolean var2, T var3);
    }

    @PublicApi(since="1.0.0")
    protected static interface Serializer<T> {
        public void serialize(XContentBuilder var1, String var2, T var3) throws IOException;
    }
}

