/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.SearchExtBuilder;

public final class GenericSearchExtBuilder
extends SearchExtBuilder {
    public static final ParseField EXT_BUILDER_NAME = new ParseField("generic_ext", new String[0]);
    private final Object genericObj;
    private final ValueType valueType;

    public GenericSearchExtBuilder(Object genericObj, ValueType valueType) {
        this.genericObj = genericObj;
        this.valueType = valueType;
    }

    public GenericSearchExtBuilder(StreamInput in) throws IOException {
        this.valueType = ValueType.fromInt(in.readInt());
        switch (this.valueType) {
            case SIMPLE: {
                this.genericObj = in.readGenericValue();
                break;
            }
            case MAP: {
                this.genericObj = in.readMap();
                break;
            }
            case LIST: {
                this.genericObj = in.readList(r -> r.readGenericValue());
                break;
            }
            default: {
                throw new IllegalStateException("Unable to construct GenericSearchExtBuilder from incoming stream.");
            }
        }
    }

    public static GenericSearchExtBuilder fromXContent(XContentParser parser) throws IOException {
        ValueType valueType;
        Object genericObj;
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_OBJECT) {
            genericObj = parser.map();
            valueType = ValueType.MAP;
        } else if (token == XContentParser.Token.START_ARRAY) {
            genericObj = parser.list();
            valueType = ValueType.LIST;
        } else if (token.isValue()) {
            genericObj = parser.objectText();
            valueType = ValueType.SIMPLE;
        } else {
            throw new XContentParseException("Unknown token: " + String.valueOf(token));
        }
        return new GenericSearchExtBuilder(genericObj, valueType);
    }

    public String getWriteableName() {
        return EXT_BUILDER_NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.valueType.getValue());
        switch (this.valueType) {
            case SIMPLE: {
                out.writeGenericValue(this.genericObj);
                break;
            }
            case MAP: {
                out.writeMap((Map)this.genericObj);
                break;
            }
            case LIST: {
                out.writeCollection((Collection)((List)this.genericObj), StreamOutput::writeGenericValue);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown valueType: " + String.valueOf((Object)this.valueType));
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        switch (this.valueType) {
            case SIMPLE: {
                return builder.field(EXT_BUILDER_NAME.getPreferredName(), this.genericObj);
            }
            case MAP: {
                return builder.field(EXT_BUILDER_NAME.getPreferredName(), (Map)this.genericObj);
            }
            case LIST: {
                return builder.field(EXT_BUILDER_NAME.getPreferredName(), (Iterable)((List)this.genericObj));
            }
        }
        return null;
    }

    Object getValue() {
        return this.genericObj;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.valueType, this.genericObj});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericSearchExtBuilder)) {
            return false;
        }
        return Objects.equals(this.getValue(), ((GenericSearchExtBuilder)obj).getValue()) && Objects.equals((Object)this.valueType, (Object)((GenericSearchExtBuilder)obj).valueType);
    }

    static enum ValueType {
        SIMPLE(0),
        MAP(1),
        LIST(2);

        private final int value;

        private ValueType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static ValueType fromInt(int value) {
            switch (value) {
                case 0: {
                    return SIMPLE;
                }
                case 1: {
                    return MAP;
                }
                case 2: {
                    return LIST;
                }
            }
            throw new IllegalArgumentException("Unsupported value: " + value);
        }
    }
}

