/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.transport.format;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.core.common.Strings;
import org.opensearch.sql.protocol.response.QueryResult;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;
import org.opensearch.sql.spark.transport.model.AsyncQueryResult;

public class AsyncQueryResultResponseFormatter
extends JsonResponseFormatter<AsyncQueryResult> {
    public AsyncQueryResultResponseFormatter(JsonResponseFormatter.Style style) {
        super(style);
    }

    public Object buildJsonObject(AsyncQueryResult response) {
        JsonResponse.JsonResponseBuilder json = JsonResponse.builder();
        if (response.getStatus().equalsIgnoreCase("success")) {
            json.total(response.size()).size(response.size());
            json.schema(response.columnNameTypes().entrySet().stream().map(entry -> new Column((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()));
            json.datarows(this.fetchDataRows(response));
        }
        json.status(response.getStatus());
        if (!Strings.isEmpty((CharSequence)response.getError())) {
            json.error(response.getError());
        }
        return json.build();
    }

    private Object[][] fetchDataRows(QueryResult response) {
        Object[][] rows = new Object[response.size()][];
        int i = 0;
        for (Object[] values : response) {
            rows[i++] = values;
        }
        return rows;
    }

    public static class Column {
        private final String name;
        private final String type;

        @Generated
        public Column(String name, String type) {
            this.name = name;
            this.type = type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonResponse {
        private final String status;
        private final List<Column> schema;
        private final Object[][] datarows;
        private Integer total;
        private Integer size;
        private final String error;

        @Generated
        JsonResponse(String status, List<Column> schema, Object[][] datarows, Integer total, Integer size, String error) {
            this.status = status;
            this.schema = schema;
            this.datarows = datarows;
            this.total = total;
            this.size = size;
            this.error = error;
        }

        @Generated
        public static JsonResponseBuilder builder() {
            return new JsonResponseBuilder();
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public List<Column> getSchema() {
            return this.schema;
        }

        @Generated
        public Object[][] getDatarows() {
            return this.datarows;
        }

        @Generated
        public Integer getTotal() {
            return this.total;
        }

        @Generated
        public Integer getSize() {
            return this.size;
        }

        @Generated
        public String getError() {
            return this.error;
        }

        @Generated
        public static class JsonResponseBuilder {
            @Generated
            private String status;
            @Generated
            private List<Column> schema;
            @Generated
            private Object[][] datarows;
            @Generated
            private Integer total;
            @Generated
            private Integer size;
            @Generated
            private String error;

            @Generated
            JsonResponseBuilder() {
            }

            @Generated
            public JsonResponseBuilder status(String status) {
                this.status = status;
                return this;
            }

            @Generated
            public JsonResponseBuilder schema(List<Column> schema) {
                this.schema = schema;
                return this;
            }

            @Generated
            public JsonResponseBuilder datarows(Object[][] datarows) {
                this.datarows = datarows;
                return this;
            }

            @Generated
            public JsonResponseBuilder total(Integer total) {
                this.total = total;
                return this;
            }

            @Generated
            public JsonResponseBuilder size(Integer size) {
                this.size = size;
                return this;
            }

            @Generated
            public JsonResponseBuilder error(String error) {
                this.error = error;
                return this;
            }

            @Generated
            public JsonResponse build() {
                return new JsonResponse(this.status, this.schema, this.datarows, this.total, this.size, this.error);
            }

            @Generated
            public String toString() {
                return "AsyncQueryResultResponseFormatter.JsonResponse.JsonResponseBuilder(status=" + this.status + ", schema=" + String.valueOf(this.schema) + ", datarows=" + Arrays.deepToString((Object[])this.datarows) + ", total=" + this.total + ", size=" + this.size + ", error=" + this.error + ")";
            }
        }
    }
}

