/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.semantic.scope;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.opensearch.sql.legacy.antlr.semantic.SemanticAnalysisException;
import org.opensearch.sql.legacy.antlr.semantic.types.Type;

public class TypeSupplier
implements Supplier<Type> {
    private final String symbolName;
    private final Type symbolType;
    private final Set<Type> types;

    public TypeSupplier(String symbolName, Type symbolType) {
        this.symbolName = symbolName;
        this.symbolType = symbolType;
        this.types = new HashSet<Type>();
        this.types.add(symbolType);
    }

    public TypeSupplier add(Type type) {
        this.types.add(type);
        return this;
    }

    @Override
    public Type get() {
        if (this.types.size() > 1) {
            throw new SemanticAnalysisException(String.format("Field [%s] have conflict type [%s]", this.symbolName, this.types));
        }
        return this.symbolType;
    }
}

