import { SourceMapWithDocuments } from '@volar/language-service';
import { TextDocument } from 'vscode-languageserver-textdocument';
import type * as html from 'vscode-html-languageservice';
export interface PugDocument extends ReturnType<ReturnType<typeof register>> {
}
export declare function register(htmlLs: html.LanguageService): (pugCode: string) => {
    htmlTextDocument: TextDocument;
    htmlDocument: html.HTMLDocument;
    map: SourceMapWithDocuments<any>;
    htmlCode: string;
    mappings: import("@volar/source-map").Mapping<any>[];
    pugTextDocument: TextDocument;
    error: {
        code: string;
        msg: string;
        line: number;
        column: number;
        filename: string;
    } | undefined;
    ast: import("./baseParse").Node | undefined;
    emptyLineEnds: number[];
};
