# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    from .. import models as _models


class OperationDefinition(_serialization.Model):
    """The definition of a container registry operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The display information for the container registry operation.
    :vartype display: ~azure.mgmt.containerregistry.v2017_03_01.models.OperationDisplayDefinition
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplayDefinition"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplayDefinition"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The display information for the container registry operation.
        :paramtype display: ~azure.mgmt.containerregistry.v2017_03_01.models.OperationDisplayDefinition
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplayDefinition(_serialization.Model):
    """The display information for a container registry operation.

    :ivar provider: The resource provider name: Microsoft.ContainerRegistry.
    :vartype provider: str
    :ivar resource: The resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: The operation that users can perform.
    :vartype operation: str
    :ivar description: The description for the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: The resource provider name: Microsoft.ContainerRegistry.
        :paramtype provider: str
        :keyword resource: The resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: The operation that users can perform.
        :paramtype operation: str
        :keyword description: The description for the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """The result of a request to list container registry operations.

    :ivar value: The list of container registry operations. Since this list may be incomplete, the
     nextLink field should be used to request the next list of operations.
    :vartype value: list[~azure.mgmt.containerregistry.v2017_03_01.models.OperationDefinition]
    :ivar next_link: The URI that can be used to request the next list of container registry
     operations.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.OperationDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of container registry operations. Since this list may be incomplete,
         the nextLink field should be used to request the next list of operations.
        :paramtype value: list[~azure.mgmt.containerregistry.v2017_03_01.models.OperationDefinition]
        :keyword next_link: The URI that can be used to request the next list of container registry
         operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RegenerateCredentialParameters(_serialization.Model):
    """The parameters used to regenerate the login credential.

    All required parameters must be populated in order to send to server.

    :ivar name: Specifies name of the password which should be regenerated -- password or
     password2. Required. Known values are: "password" and "password2".
    :vartype name: str or ~azure.mgmt.containerregistry.v2017_03_01.models.PasswordName
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Union[str, "_models.PasswordName"], **kwargs: Any) -> None:
        """
        :keyword name: Specifies name of the password which should be regenerated -- password or
         password2. Required. Known values are: "password" and "password2".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2017_03_01.models.PasswordName
        """
        super().__init__(**kwargs)
        self.name = name


class Resource(_serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class Registry(Resource):
    """An object that represents a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource. This cannot be changed after the resource is
     created. Required.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar sku: The SKU of the container registry. Required.
    :vartype sku: ~azure.mgmt.containerregistry.v2017_03_01.models.Sku
    :ivar login_server: The URL that can be used to log into the container registry.
    :vartype login_server: str
    :ivar creation_date: The creation date of the container registry in ISO8601 format.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the container registry at the time the
     operation was called. Known values are: "Creating" and "Succeeded".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2017_03_01.models.ProvisioningState
    :ivar admin_user_enabled: The value that indicates whether the admin user is enabled.
    :vartype admin_user_enabled: bool
    :ivar storage_account: The properties of the storage account for the container registry.
    :vartype storage_account:
     ~azure.mgmt.containerregistry.v2017_03_01.models.StorageAccountProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "sku": {"required": True},
        "login_server": {"readonly": True},
        "creation_date": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "login_server": {"key": "properties.loginServer", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "admin_user_enabled": {"key": "properties.adminUserEnabled", "type": "bool"},
        "storage_account": {"key": "properties.storageAccount", "type": "StorageAccountProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        admin_user_enabled: bool = False,
        storage_account: Optional["_models.StorageAccountProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This cannot be changed after the resource is
         created. Required.
        :paramtype location: str
        :keyword tags: The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU of the container registry. Required.
        :paramtype sku: ~azure.mgmt.containerregistry.v2017_03_01.models.Sku
        :keyword admin_user_enabled: The value that indicates whether the admin user is enabled.
        :paramtype admin_user_enabled: bool
        :keyword storage_account: The properties of the storage account for the container registry.
        :paramtype storage_account:
         ~azure.mgmt.containerregistry.v2017_03_01.models.StorageAccountProperties
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.login_server = None
        self.creation_date = None
        self.provisioning_state = None
        self.admin_user_enabled = admin_user_enabled
        self.storage_account = storage_account


class RegistryCreateParameters(_serialization.Model):
    """The parameters for creating a container registry.

    All required parameters must be populated in order to send to server.

    :ivar tags: The tags for the container registry.
    :vartype tags: dict[str, str]
    :ivar location: The location of the container registry. This cannot be changed after the
     resource is created. Required.
    :vartype location: str
    :ivar sku: The SKU of the container registry. Required.
    :vartype sku: ~azure.mgmt.containerregistry.v2017_03_01.models.Sku
    :ivar admin_user_enabled: The value that indicates whether the admin user is enabled.
    :vartype admin_user_enabled: bool
    :ivar storage_account: The parameters of a storage account for the container registry. If
     specified, the storage account must be in the same physical location as the container registry.
    :vartype storage_account:
     ~azure.mgmt.containerregistry.v2017_03_01.models.StorageAccountParameters
    """

    _validation = {
        "location": {"required": True},
        "sku": {"required": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "admin_user_enabled": {"key": "properties.adminUserEnabled", "type": "bool"},
        "storage_account": {"key": "properties.storageAccount", "type": "StorageAccountParameters"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        admin_user_enabled: bool = False,
        storage_account: Optional["_models.StorageAccountParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The tags for the container registry.
        :paramtype tags: dict[str, str]
        :keyword location: The location of the container registry. This cannot be changed after the
         resource is created. Required.
        :paramtype location: str
        :keyword sku: The SKU of the container registry. Required.
        :paramtype sku: ~azure.mgmt.containerregistry.v2017_03_01.models.Sku
        :keyword admin_user_enabled: The value that indicates whether the admin user is enabled.
        :paramtype admin_user_enabled: bool
        :keyword storage_account: The parameters of a storage account for the container registry. If
         specified, the storage account must be in the same physical location as the container registry.
        :paramtype storage_account:
         ~azure.mgmt.containerregistry.v2017_03_01.models.StorageAccountParameters
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.sku = sku
        self.admin_user_enabled = admin_user_enabled
        self.storage_account = storage_account


class RegistryListCredentialsResult(_serialization.Model):
    """The response from the ListCredentials operation.

    :ivar username: The username for a container registry.
    :vartype username: str
    :ivar passwords: The list of passwords for a container registry.
    :vartype passwords: list[~azure.mgmt.containerregistry.v2017_03_01.models.RegistryPassword]
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "passwords": {"key": "passwords", "type": "[RegistryPassword]"},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        passwords: Optional[List["_models.RegistryPassword"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword username: The username for a container registry.
        :paramtype username: str
        :keyword passwords: The list of passwords for a container registry.
        :paramtype passwords: list[~azure.mgmt.containerregistry.v2017_03_01.models.RegistryPassword]
        """
        super().__init__(**kwargs)
        self.username = username
        self.passwords = passwords


class RegistryListResult(_serialization.Model):
    """The result of a request to list container registries.

    :ivar value: The list of container registries. Since this list may be incomplete, the nextLink
     field should be used to request the next list of container registries.
    :vartype value: list[~azure.mgmt.containerregistry.v2017_03_01.models.Registry]
    :ivar next_link: The URI that can be used to request the next list of container registries.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Registry]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Registry"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of container registries. Since this list may be incomplete, the
         nextLink field should be used to request the next list of container registries.
        :paramtype value: list[~azure.mgmt.containerregistry.v2017_03_01.models.Registry]
        :keyword next_link: The URI that can be used to request the next list of container registries.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RegistryNameCheckRequest(_serialization.Model):
    """A request to check whether a container registry name is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the container registry. Required.
    :vartype name: str
    :ivar type: The resource type of the container registry. This field must be set to
     'Microsoft.ContainerRegistry/registries'. Required. Default value is
     "Microsoft.ContainerRegistry/registries".
    :vartype type: str
    """

    _validation = {
        "name": {"required": True, "max_length": 50, "min_length": 5, "pattern": r"^[a-zA-Z0-9]*$"},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "Microsoft.ContainerRegistry/registries"

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: The name of the container registry. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class RegistryNameStatus(_serialization.Model):
    """The result of a request to check the availability of a container registry name.

    :ivar name_available: The value that indicates whether the name is available.
    :vartype name_available: bool
    :ivar reason: If any, the reason that the name is not available.
    :vartype reason: str
    :ivar message: If any, the error message that provides more detail for the reason that the name
     is not available.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: The value that indicates whether the name is available.
        :paramtype name_available: bool
        :keyword reason: If any, the reason that the name is not available.
        :paramtype reason: str
        :keyword message: If any, the error message that provides more detail for the reason that the
         name is not available.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class RegistryPassword(_serialization.Model):
    """The login password for the container registry.

    :ivar name: The password name. Known values are: "password" and "password2".
    :vartype name: str or ~azure.mgmt.containerregistry.v2017_03_01.models.PasswordName
    :ivar value: The password value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[Union[str, "_models.PasswordName"]] = None, value: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The password name. Known values are: "password" and "password2".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2017_03_01.models.PasswordName
        :keyword value: The password value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class RegistryUpdateParameters(_serialization.Model):
    """The parameters for updating a container registry.

    :ivar tags: The tags for the container registry.
    :vartype tags: dict[str, str]
    :ivar admin_user_enabled: The value that indicates whether the admin user is enabled.
    :vartype admin_user_enabled: bool
    :ivar storage_account: The parameters of a storage account for the container registry. If
     specified, the storage account must be in the same physical location as the container registry.
    :vartype storage_account:
     ~azure.mgmt.containerregistry.v2017_03_01.models.StorageAccountParameters
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "admin_user_enabled": {"key": "properties.adminUserEnabled", "type": "bool"},
        "storage_account": {"key": "properties.storageAccount", "type": "StorageAccountParameters"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        admin_user_enabled: Optional[bool] = None,
        storage_account: Optional["_models.StorageAccountParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The tags for the container registry.
        :paramtype tags: dict[str, str]
        :keyword admin_user_enabled: The value that indicates whether the admin user is enabled.
        :paramtype admin_user_enabled: bool
        :keyword storage_account: The parameters of a storage account for the container registry. If
         specified, the storage account must be in the same physical location as the container registry.
        :paramtype storage_account:
         ~azure.mgmt.containerregistry.v2017_03_01.models.StorageAccountParameters
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.admin_user_enabled = admin_user_enabled
        self.storage_account = storage_account


class Sku(_serialization.Model):
    """The SKU of a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The SKU name of the container registry. Required for registry creation. Allowed
     value: Basic. Required.
    :vartype name: str
    :ivar tier: The SKU tier based on the SKU name. "Basic"
    :vartype tier: str or ~azure.mgmt.containerregistry.v2017_03_01.models.SkuTier
    """

    _validation = {
        "name": {"required": True},
        "tier": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: The SKU name of the container registry. Required for registry creation. Allowed
         value: Basic. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = None


class StorageAccountParameters(_serialization.Model):
    """The parameters of a storage account for a container registry.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the storage account. Required.
    :vartype name: str
    :ivar access_key: The access key to the storage account. Required.
    :vartype access_key: str
    """

    _validation = {
        "name": {"required": True},
        "access_key": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "access_key": {"key": "accessKey", "type": "str"},
    }

    def __init__(self, *, name: str, access_key: str, **kwargs: Any) -> None:
        """
        :keyword name: The name of the storage account. Required.
        :paramtype name: str
        :keyword access_key: The access key to the storage account. Required.
        :paramtype access_key: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.access_key = access_key


class StorageAccountProperties(_serialization.Model):
    """The properties of a storage account for a container registry.

    :ivar name: The name of the storage account.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the storage account.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
