/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.rewriter.matchtoterm;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlSelectGroupByExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.parser.ParserException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.esdomain.mapping.FieldMappings;
import org.opensearch.sql.legacy.esdomain.mapping.IndexMappings;
import org.opensearch.sql.legacy.rewriter.matchtoterm.TermFieldScope;
import org.opensearch.sql.legacy.rewriter.matchtoterm.VerificationException;

public class TermFieldRewriter
extends MySqlASTVisitorAdapter {
    private Deque<TermFieldScope> environment = new ArrayDeque<TermFieldScope>();
    private TermRewriterFilter filterType;

    public TermFieldRewriter() {
        this.filterType = TermRewriterFilter.COMMA;
    }

    public TermFieldRewriter(TermRewriterFilter filterType) {
        this.filterType = filterType;
    }

    public boolean visit(MySqlSelectQueryBlock query) {
        this.environment.push(new TermFieldScope());
        if (query.getFrom() == null) {
            return false;
        }
        HashMap<String, String> indexToType = new HashMap<String, String>();
        this.collect(query.getFrom(), indexToType, this.curScope().getAliases());
        if (indexToType.isEmpty()) {
            return true;
        }
        this.curScope().setMapper(this.getMappings(indexToType));
        if (this.filterType == TermRewriterFilter.COMMA || this.filterType == TermRewriterFilter.MULTI_QUERY) {
            this.checkMappingCompatibility(this.curScope(), indexToType);
        }
        return true;
    }

    public void endVisit(MySqlSelectQueryBlock query) {
        this.environment.pop();
    }

    public boolean visit(SQLSelectItem sqlSelectItem) {
        return false;
    }

    public boolean visit(SQLJoinTableSource tableSource) {
        return false;
    }

    public boolean visit(SQLExprTableSource tableSource) {
        return false;
    }

    public boolean visit(SQLInListExpr inListExpr) {
        inListExpr.getExpr().setParent((SQLObject)inListExpr);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean visit(SQLIdentifierExpr expr) {
        String keywordAlias;
        if (!this.isValidIdentifierForTerm(expr)) return true;
        Object source = null;
        if (this.filterType == TermRewriterFilter.COMMA || this.filterType == TermRewriterFilter.MULTI_QUERY) {
            Optional<Map<String, Object>> optionalMap = this.curScope().resolveFieldMapping(expr.getName());
            if (!optionalMap.isPresent()) return true;
            source = optionalMap.get();
        } else if (this.filterType == TermRewriterFilter.JOIN) {
            String[] arr = expr.getName().split("\\.", 2);
            if (arr.length < 2) {
                throw new VerificationException("table alias or field name missing");
            }
            String alias = arr[0];
            String fullFieldName = arr[1];
            String index = this.curScope().getAliases().get(alias);
            if (index == null) {
                throw new IndexNotFoundException(String.format("The requested table '%s' does not correspond to any known index. Only indices or table aliases are allowed.", alias.replaceFirst("_\\d+$", "")));
            }
            FieldMappings fieldMappings = (FieldMappings)this.curScope().getMapper().mapping(index);
            if (fieldMappings == null) {
                throw new IndexNotFoundException(String.format("The index '%s' could not be found. Note that wildcard indices are not permitted in SQL.", index));
            }
            if (!fieldMappings.has(fullFieldName)) return true;
            source = fieldMappings.mapping(fullFieldName);
        }
        if ((keywordAlias = this.isBothTextAndKeyword((Map<String, Object>)source)) == null) return true;
        expr.setName(expr.getName() + "." + keywordAlias);
        return true;
    }

    public void collect(SQLTableSource tableSource, Map<String, String> indexToType, Map<String, String> aliases) {
        if (tableSource instanceof SQLExprTableSource) {
            String tableName = null;
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)tableSource;
            if (sqlExprTableSource.getExpr() instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr sqlIdentifier = (SQLIdentifierExpr)sqlExprTableSource.getExpr();
                tableName = sqlIdentifier.getName();
                indexToType.put(tableName, null);
            } else if (sqlExprTableSource.getExpr() instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr sqlBinaryOpExpr = (SQLBinaryOpExpr)sqlExprTableSource.getExpr();
                SQLExpr leftSideOfExpression = sqlBinaryOpExpr.getLeft();
                if (!(leftSideOfExpression instanceof SQLIdentifierExpr)) {
                    throw new ParserException("Left side of the expression [" + leftSideOfExpression.toString() + "] is expected to be an identifier");
                }
                tableName = ((SQLIdentifierExpr)sqlBinaryOpExpr.getLeft()).getName();
                SQLExpr rightSideOfExpression = sqlBinaryOpExpr.getRight();
                if (rightSideOfExpression instanceof SQLIdentifierExpr) {
                    SQLIdentifierExpr right = (SQLIdentifierExpr)rightSideOfExpression;
                    indexToType.put(tableName, right.getName());
                } else {
                    throw new ParserException("Right side of the expression [" + rightSideOfExpression.toString() + "] is expected to be an identifier");
                }
            }
            if (tableSource.getAlias() != null) {
                aliases.put(tableSource.getAlias(), tableName);
            } else {
                aliases.put(tableName, tableName);
            }
        } else if (tableSource instanceof SQLJoinTableSource) {
            this.collect(((SQLJoinTableSource)tableSource).getLeft(), indexToType, aliases);
            this.collect(((SQLJoinTableSource)tableSource).getRight(), indexToType, aliases);
        }
    }

    private TermFieldScope curScope() {
        return this.environment.peek();
    }

    public String isBothTextAndKeyword(Map<String, Object> source) {
        if (source.containsKey("fields")) {
            for (Object key : ((Map)source.get("fields")).keySet()) {
                if (!(key instanceof String) || !((Map)((Map)source.get("fields")).get(key)).get("type").equals("keyword")) continue;
                return (String)key;
            }
        }
        return null;
    }

    public boolean isValidIdentifierForTerm(SQLIdentifierExpr expr) {
        return !expr.getName().startsWith("_") && (this.isValidIdentifier((SQLObject)expr) || this.checkIfNestedIdentifier(expr));
    }

    private boolean checkIfNestedIdentifier(SQLIdentifierExpr expr) {
        return expr.getParent() instanceof SQLMethodInvokeExpr && ((SQLMethodInvokeExpr)expr.getParent()).getMethodName().equals("nested") && this.isValidIdentifier(expr.getParent());
    }

    private boolean isValidIdentifier(SQLObject expr) {
        SQLObject parent = expr.getParent();
        return this.isBinaryExprWithValidOperators(parent) || parent instanceof SQLInListExpr || parent instanceof SQLInSubQueryExpr || parent instanceof SQLSelectOrderByItem || parent instanceof MySqlSelectGroupByExpr;
    }

    private boolean isBinaryExprWithValidOperators(SQLObject expr) {
        if (!(expr instanceof SQLBinaryOpExpr)) {
            return false;
        }
        return Stream.of(SQLBinaryOperator.Equality, SQLBinaryOperator.Is, SQLBinaryOperator.IsNot).anyMatch(operator -> operator == ((SQLBinaryOpExpr)expr).getOperator());
    }

    private void checkMappingCompatibility(TermFieldScope scope, Map<String, String> indexToType) {
        if (scope.getMapper().isEmpty()) {
            throw new VerificationException("Unknown index " + String.valueOf(indexToType.keySet()));
        }
    }

    public IndexMappings getMappings(Map<String, String> indexToType) {
        String[] allIndexes = (String[])indexToType.keySet().stream().toArray(String[]::new);
        return LocalClusterState.state().getFieldMappings(allIndexes);
    }

    public static enum TermRewriterFilter {
        COMMA(","),
        JOIN("JOIN"),
        MULTI_QUERY("MULTI_QUERY");

        public final String name;

        private TermRewriterFilter(String name) {
            this.name = name;
        }

        public static String toString(TermRewriterFilter filter) {
            return filter.name;
        }
    }
}

