
use builtin;
use str;

set edit:completion:arg-completer[satty] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'satty'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'satty'= {
            cand -c 'Path to the config file. Otherwise will be read from XDG_CONFIG_DIR/satty/config.toml'
            cand --config 'Path to the config file. Otherwise will be read from XDG_CONFIG_DIR/satty/config.toml'
            cand -f 'Path to input image or ''-'' to read from stdin'
            cand --filename 'Path to input image or ''-'' to read from stdin'
            cand -o 'Filename to use for saving action. Omit to disable saving to file. Might contain format specifiers: <https://docs.rs/chrono/latest/chrono/format/strftime/index.html>'
            cand --output-filename 'Filename to use for saving action. Omit to disable saving to file. Might contain format specifiers: <https://docs.rs/chrono/latest/chrono/format/strftime/index.html>'
            cand --corner-roundness 'Draw corners of rectangles round if the value is greater than 0 (Defaults to 12) (0 disables rounded corners)'
            cand --initial-tool 'Select the tool on startup'
            cand --init-tool 'Select the tool on startup'
            cand --copy-command 'Configure the command to be called on copy, for example `wl-copy`'
            cand --annotation-size-factor 'Increase or decrease the size of the annotations'
            cand --action-on-enter 'Action to perform when pressing Enter'
            cand --font-family 'Font family to use for text annotations'
            cand --font-style 'Font style to use for text annotations'
            cand --primary-highlighter 'The primary highlighter to use, secondary is accessible with CTRL'
            cand --fullscreen 'Start Satty in fullscreen mode'
            cand --early-exit 'Exit directly after copy/save action'
            cand --save-after-copy 'After copying the screenshot, save it to a file as well'
            cand --right-click-copy 'Right click to copy'
            cand -d 'Hide toolbars by default'
            cand --default-hide-toolbars 'Hide toolbars by default'
            cand --disable-notifications 'Disable notifications'
            cand --profile-startup 'print profiling'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
        }
    ]
    $completions[$command]
}
