import Extension from "./extension";
export default abstract class ExternalJSExtension<M> extends Extension {
    protected folderName: string;
    protected mqttTopic: string;
    protected requestRegex: RegExp;
    protected basePath: string;
    protected srcBasePath: string;
    constructor(zigbee: Zigbee, mqtt: Mqtt, state: State, publishEntityState: PublishEntityState, eventBus: EventBus, enableDisableExtension: (enable: boolean, name: string) => Promise<void>, restartCallback: () => Promise<void>, addExtension: (extension: Extension) => Promise<void>, mqttTopic: string, folderName: string);
    start(): Promise<void>;
    stop(): Promise<void>;
    private getFilePath;
    protected getFileCode(name: string): string;
    protected getFiles(inSource?: boolean): Generator<{
        name: string;
        code: string;
    }>;
    onMQTTMessage(data: eventdata.MQTTMessage): Promise<void>;
    protected abstract removeJS(name: string, mod: M): Promise<void>;
    protected abstract loadJS(name: string, mod: M, newName?: string): Promise<void>;
    private remove;
    private save;
    private loadFiles;
    private publishExternalJS;
    private getImportPath;
}
//# sourceMappingURL=externalJS.d.ts.map