/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.engine.extension.TimeoutConfiguration;
import org.junit.jupiter.engine.extension.TimeoutDuration;
import org.junit.jupiter.engine.extension.TimeoutInvocationFactory;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.RuntimeUtils;

class TimeoutExtension
implements BeforeAllCallback,
BeforeEachCallback,
InvocationInterceptor {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{Timeout.class});
    private static final String TESTABLE_METHOD_TIMEOUT_KEY = "testable_method_timeout_from_annotation";
    private static final String TESTABLE_METHOD_TIMEOUT_THREAD_MODE_KEY = "testable_method_timeout_thread_mode_from_annotation";
    private static final String GLOBAL_TIMEOUT_CONFIG_KEY = "global_timeout_config";
    private static final String ENABLED_MODE_VALUE = "enabled";
    private static final String DISABLED_MODE_VALUE = "disabled";
    private static final String DISABLED_ON_DEBUG_MODE_VALUE = "disabled_on_debug";

    TimeoutExtension() {
    }

    public void beforeAll(ExtensionContext context) {
        this.readAndStoreTimeoutSoChildrenInheritIt(context);
    }

    public void beforeEach(ExtensionContext context) {
        this.readAndStoreTimeoutSoChildrenInheritIt(context);
    }

    private void readAndStoreTimeoutSoChildrenInheritIt(ExtensionContext context) {
        this.readTimeoutFromAnnotation(context.getElement()).ifPresent(timeout -> context.getStore(NAMESPACE).put((Object)TESTABLE_METHOD_TIMEOUT_KEY, timeout));
        this.readTimeoutThreadModeFromAnnotation(context.getElement()).ifPresent(timeoutThreadMode -> context.getStore(NAMESPACE).put((Object)TESTABLE_METHOD_TIMEOUT_THREAD_MODE_KEY, timeoutThreadMode));
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultBeforeAllMethodTimeout);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultBeforeEachMethodTimeout);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptTestableMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultTestMethodTimeout);
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptTestableMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultTestTemplateMethodTimeout);
    }

    public <T> T interceptTestFactoryMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        return this.interceptTestableMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultTestFactoryMethodTimeout);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultAfterEachMethodTimeout);
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultAfterAllMethodTimeout);
    }

    private void interceptLifecycleMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutProvider defaultTimeoutProvider) throws Throwable {
        TimeoutDuration timeout = this.readTimeoutFromAnnotation(Optional.of(invocationContext.getExecutable())).orElse(null);
        this.intercept(invocation, invocationContext, extensionContext, timeout, defaultTimeoutProvider);
    }

    private Optional<TimeoutDuration> readTimeoutFromAnnotation(Optional<AnnotatedElement> element) {
        return AnnotationSupport.findAnnotation(element, Timeout.class).map(TimeoutDuration::from);
    }

    private Optional<Timeout.ThreadMode> readTimeoutThreadModeFromAnnotation(Optional<AnnotatedElement> element) {
        return AnnotationSupport.findAnnotation(element, Timeout.class).map(Timeout::threadMode);
    }

    private <T> T interceptTestableMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutProvider defaultTimeoutProvider) throws Throwable {
        TimeoutDuration timeout = (TimeoutDuration)extensionContext.getStore(NAMESPACE).get((Object)TESTABLE_METHOD_TIMEOUT_KEY, TimeoutDuration.class);
        return this.intercept(invocation, invocationContext, extensionContext, timeout, defaultTimeoutProvider);
    }

    private <T> T intercept(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutDuration explicitTimeout, TimeoutProvider defaultTimeoutProvider) throws Throwable {
        TimeoutDuration timeout = explicitTimeout == null ? this.getDefaultTimeout(extensionContext, defaultTimeoutProvider) : explicitTimeout;
        return (T)this.decorate(invocation, invocationContext, extensionContext, timeout).proceed();
    }

    private TimeoutDuration getDefaultTimeout(ExtensionContext extensionContext, TimeoutProvider defaultTimeoutProvider) {
        return ((Optional)defaultTimeoutProvider.apply(this.getGlobalTimeoutConfiguration(extensionContext))).orElse(null);
    }

    private TimeoutConfiguration getGlobalTimeoutConfiguration(ExtensionContext extensionContext) {
        ExtensionContext root = extensionContext.getRoot();
        return (TimeoutConfiguration)root.getStore(NAMESPACE).getOrComputeIfAbsent((Object)GLOBAL_TIMEOUT_CONFIG_KEY, key -> new TimeoutConfiguration(root), TimeoutConfiguration.class);
    }

    private <T> InvocationInterceptor.Invocation<T> decorate(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutDuration timeout) {
        if (timeout == null || this.isTimeoutDisabled(extensionContext)) {
            return invocation;
        }
        Timeout.ThreadMode threadMode = this.resolveTimeoutThreadMode(extensionContext);
        return new TimeoutInvocationFactory(extensionContext.getRoot().getStore(NAMESPACE)).create(threadMode, new TimeoutInvocationFactory.TimeoutInvocationParameters<T>(invocation, timeout, () -> this.describe(invocationContext, extensionContext)));
    }

    private Timeout.ThreadMode resolveTimeoutThreadMode(ExtensionContext extensionContext) {
        Timeout.ThreadMode annotationThreadMode = this.getAnnotationThreadMode(extensionContext);
        if (annotationThreadMode == null || annotationThreadMode == Timeout.ThreadMode.INFERRED) {
            return this.getGlobalTimeoutConfiguration(extensionContext).getDefaultTimeoutThreadMode().orElse(Timeout.ThreadMode.SAME_THREAD);
        }
        return annotationThreadMode;
    }

    private Timeout.ThreadMode getAnnotationThreadMode(ExtensionContext extensionContext) {
        return (Timeout.ThreadMode)extensionContext.getStore(NAMESPACE).get((Object)TESTABLE_METHOD_TIMEOUT_THREAD_MODE_KEY, Timeout.ThreadMode.class);
    }

    private String describe(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        Method method = (Method)invocationContext.getExecutable();
        Optional testClass = extensionContext.getTestClass();
        if (testClass.isPresent() && invocationContext.getTargetClass().equals(testClass.get())) {
            return String.format("%s(%s)", method.getName(), ClassUtils.nullSafeToString((Class[])method.getParameterTypes()));
        }
        return ReflectionUtils.getFullyQualifiedMethodName((Class)invocationContext.getTargetClass(), (Method)method);
    }

    private boolean isTimeoutDisabled(ExtensionContext extensionContext) {
        Optional mode = extensionContext.getConfigurationParameter("junit.jupiter.execution.timeout.mode");
        return mode.map(this::isTimeoutDisabled).orElse(false);
    }

    private boolean isTimeoutDisabled(String mode) {
        switch (mode) {
            case "enabled": {
                return false;
            }
            case "disabled": {
                return true;
            }
            case "disabled_on_debug": {
                return RuntimeUtils.isDebugMode();
            }
        }
        throw new ExtensionConfigurationException("Unsupported timeout mode: " + mode);
    }

    @FunctionalInterface
    private static interface TimeoutProvider
    extends Function<TimeoutConfiguration, Optional<TimeoutDuration>> {
    }
}

