/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.QueryEngineException;
import org.opensearch.sql.opensearch.response.error.ErrorMessage;
import org.opensearch.sql.opensearch.response.error.ErrorMessageFactory;
import org.opensearch.sql.protocol.response.QueryResult;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;

public class VisualizationResponseFormatter
extends JsonResponseFormatter<QueryResult> {
    public VisualizationResponseFormatter(JsonResponseFormatter.Style style) {
        super(style);
    }

    @Override
    protected Object buildJsonObject(QueryResult response) {
        return VisualizationResponse.builder().data(this.fetchData(response)).metadata(this.constructMetadata(response)).size(response.size()).status(200).build();
    }

    @Override
    public String format(Throwable t) {
        int status = this.getStatus(t);
        ErrorMessage message = ErrorMessageFactory.createErrorMessage((Throwable)t, (int)status);
        Error error = new Error(message.getType(), message.getReason(), message.getDetails());
        return this.jsonify(new VisualizationErrorResponse(error, status));
    }

    private int getStatus(Throwable t) {
        return t instanceof SyntaxCheckException || t instanceof QueryEngineException ? 400 : 503;
    }

    private Map<String, List<Object>> fetchData(QueryResult response) {
        LinkedHashMap<String, List<Object>> columnMap = new LinkedHashMap<String, List<Object>>();
        response.getSchema().getColumns().forEach(column -> columnMap.put(column.getName(), new LinkedList()));
        for (Object[] dataRow : response) {
            int column2 = 0;
            for (Map.Entry entry : columnMap.entrySet()) {
                List dataColumn = (List)entry.getValue();
                dataColumn.add(dataRow[column2++]);
            }
        }
        return columnMap;
    }

    private Metadata constructMetadata(QueryResult response) {
        return new Metadata(this.fetchFields(response));
    }

    private List<Field> fetchFields(QueryResult response) {
        List columns = response.getSchema().getColumns();
        ImmutableList.Builder fields = ImmutableList.builder();
        columns.forEach(column -> {
            Field field = new Field(column.getName(), this.convertToLegacyType(column.getExprType()));
            fields.add((Object)field);
        });
        return fields.build();
    }

    private String convertToLegacyType(ExprType type) {
        return type.legacyTypeName().toLowerCase();
    }

    public static class Field {
        private final String name;
        private final String type;

        @Generated
        public Field(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }

    public static class Metadata {
        private final List<Field> fields;

        @Generated
        public Metadata(List<Field> fields) {
            this.fields = fields;
        }
    }

    public static class VisualizationResponse {
        private final Map<String, List<Object>> data;
        private final Metadata metadata;
        private final long size;
        private final int status;

        @Generated
        VisualizationResponse(Map<String, List<Object>> data, Metadata metadata, long size, int status) {
            this.data = data;
            this.metadata = metadata;
            this.size = size;
            this.status = status;
        }

        @Generated
        public static VisualizationResponseBuilder builder() {
            return new VisualizationResponseBuilder();
        }

        @Generated
        public Map<String, List<Object>> getData() {
            return this.data;
        }

        @Generated
        public Metadata getMetadata() {
            return this.metadata;
        }

        @Generated
        public long getSize() {
            return this.size;
        }

        @Generated
        public int getStatus() {
            return this.status;
        }

        @Generated
        public static class VisualizationResponseBuilder {
            @Generated
            private Map<String, List<Object>> data;
            @Generated
            private Metadata metadata;
            @Generated
            private long size;
            @Generated
            private int status;

            @Generated
            VisualizationResponseBuilder() {
            }

            @Generated
            public VisualizationResponseBuilder data(Map<String, List<Object>> data) {
                this.data = data;
                return this;
            }

            @Generated
            public VisualizationResponseBuilder metadata(Metadata metadata) {
                this.metadata = metadata;
                return this;
            }

            @Generated
            public VisualizationResponseBuilder size(long size) {
                this.size = size;
                return this;
            }

            @Generated
            public VisualizationResponseBuilder status(int status) {
                this.status = status;
                return this;
            }

            @Generated
            public VisualizationResponse build() {
                return new VisualizationResponse(this.data, this.metadata, this.size, this.status);
            }

            @Generated
            public String toString() {
                return "VisualizationResponseFormatter.VisualizationResponse.VisualizationResponseBuilder(data=" + String.valueOf(this.data) + ", metadata=" + String.valueOf(this.metadata) + ", size=" + this.size + ", status=" + this.status + ")";
            }
        }
    }

    public static class Error {
        private final String type;
        private final String reason;
        private final String details;

        @Generated
        public Error(String type, String reason, String details) {
            this.type = type;
            this.reason = reason;
            this.details = details;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public String getDetails() {
            return this.details;
        }
    }

    public static class VisualizationErrorResponse {
        private final Error error;
        private final int status;

        @Generated
        public VisualizationErrorResponse(Error error, int status) {
            this.error = error;
            this.status = status;
        }

        @Generated
        public Error getError() {
            return this.error;
        }

        @Generated
        public int getStatus() {
            return this.status;
        }
    }
}

