/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.UnpackerImpl;
import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import sun.security.action.LoadLibraryAction;

class NativeUnpack {
    private long unpackerPtr;
    private BufferedInputStream in;
    private int _verbose;
    private long _byteCount;
    private int _segCount;
    private int _fileCount;
    private long _estByteLimit;
    private int _estSegLimit;
    private int _estFileLimit;
    private int _prevPercent = -1;
    private final CRC32 _crc32 = new CRC32();
    private byte[] _buf = new byte[16384];
    private UnpackerImpl _p200;
    private PropMap _props;

    private static synchronized native void initIDs();

    private synchronized native long start(ByteBuffer var1, long var2);

    private synchronized native boolean getNextFile(Object[] var1);

    private synchronized native ByteBuffer getUnusedInput();

    private synchronized native long finish();

    protected synchronized native boolean setOption(String var1, String var2);

    protected synchronized native String getOption(String var1);

    NativeUnpack(UnpackerImpl p200) {
        this._p200 = p200;
        this._props = p200.props;
        p200._nunp = this;
    }

    private static Object currentInstance() {
        UnpackerImpl p200 = (UnpackerImpl)Utils.getTLGlobals();
        return p200 == null ? null : p200._nunp;
    }

    private synchronized long getUnpackerPtr() {
        return this.unpackerPtr;
    }

    private long readInputFn(ByteBuffer pbuf, long minlen) throws IOException {
        if (this.in == null) {
            return 0L;
        }
        long maxlen = pbuf.capacity() - pbuf.position();
        assert (minlen <= maxlen);
        long numread = 0L;
        int steps = 0;
        while (numread < minlen) {
            int nr;
            ++steps;
            int readlen = this._buf.length;
            if ((long)readlen > maxlen - numread) {
                readlen = (int)(maxlen - numread);
            }
            if ((nr = this.in.read(this._buf, 0, readlen)) <= 0) break;
            assert ((numread += (long)nr) <= maxlen);
            pbuf.put(this._buf, 0, nr);
        }
        if (this._verbose > 1) {
            Utils.log.fine("readInputFn(" + minlen + "," + maxlen + ") => " + numread + " steps=" + steps);
        }
        this._estByteLimit = maxlen > 100L ? this._byteCount + maxlen : (this._byteCount + numread) * 20L;
        this._byteCount += numread;
        this.updateProgress();
        return numread;
    }

    private void updateProgress() {
        double READ_WT = 0.33;
        double WRITE_WT = 0.67;
        double readProgress = this._segCount;
        if (this._estByteLimit > 0L && this._byteCount > 0L) {
            readProgress += (double)this._byteCount / (double)this._estByteLimit;
        }
        double writeProgress = this._fileCount;
        double scaledProgress = 0.33 * readProgress / (double)Math.max(this._estSegLimit, 1) + 0.67 * writeProgress / (double)Math.max(this._estFileLimit, 1);
        int percent = (int)Math.round(100.0 * scaledProgress);
        if (percent > 100) {
            percent = 100;
        }
        if (percent > this._prevPercent) {
            this._prevPercent = percent;
            this._props.setInteger("unpack.progress", percent);
            if (this._verbose > 0) {
                Utils.log.info("progress = " + percent);
            }
        }
    }

    private void copyInOption(String opt) {
        boolean set;
        String val = this._props.getProperty(opt);
        if (this._verbose > 0) {
            Utils.log.info("set " + opt + "=" + val);
        }
        if (val != null && !(set = this.setOption(opt, val))) {
            Utils.log.warning("Invalid option " + opt + "=" + val);
        }
    }

    void run(InputStream inRaw, JarOutputStream jstream, ByteBuffer presetInput) throws IOException {
        BufferedInputStream in0;
        this.in = in0 = new BufferedInputStream(inRaw);
        this._verbose = this._props.getInteger("com.sun.java.util.jar.pack.verbose");
        int modtime = "keep".equals(this._props.getProperty("com.sun.java.util.jar.pack.unpack.modification.time", "0")) ? 0 : this._props.getTime("com.sun.java.util.jar.pack.unpack.modification.time");
        this.copyInOption("com.sun.java.util.jar.pack.verbose");
        this.copyInOption("unpack.deflate.hint");
        if (modtime == 0) {
            this.copyInOption("com.sun.java.util.jar.pack.unpack.modification.time");
        }
        this.updateProgress();
        while (true) {
            long counts = this.start(presetInput, 0L);
            this._estByteLimit = 0L;
            this._byteCount = 0L;
            ++this._segCount;
            int nextSeg = (int)(counts >>> 32);
            int nextFile = (int)(counts >>> 0);
            this._estSegLimit = this._segCount + nextSeg;
            double filesAfterThisSeg = this._fileCount + nextFile;
            this._estFileLimit = (int)(filesAfterThisSeg * (double)this._estSegLimit / (double)this._segCount);
            int[] intParts = new int[]{0, 0, 0, 0};
            Object[] parts = new Object[]{intParts, null, null, null};
            while (this.getNextFile(parts)) {
                String name = (String)parts[1];
                long size = ((long)intParts[0] << 32) + ((long)intParts[1] << 32 >>> 32);
                long mtime = modtime != 0 ? (long)modtime : (long)intParts[2];
                boolean deflateHint = intParts[3] != 0;
                ByteBuffer data0 = (ByteBuffer)parts[2];
                ByteBuffer data1 = (ByteBuffer)parts[3];
                this.writeEntry(jstream, name, mtime, size, deflateHint, data0, data1);
                ++this._fileCount;
                this.updateProgress();
            }
            presetInput = this.getUnusedInput();
            long consumed = this.finish();
            if (this._verbose > 0) {
                Utils.log.info("bytes consumed = " + consumed);
            }
            if (presetInput == null && !Utils.isPackMagic(Utils.readMagic(in0))) break;
            if (this._verbose <= 0 || presetInput == null) continue;
            Utils.log.info("unused input = " + presetInput);
        }
    }

    void run(InputStream in, JarOutputStream jstream) throws IOException {
        this.run(in, jstream, null);
    }

    void run(File inFile, JarOutputStream jstream) throws IOException {
        ByteBuffer mappedFile = null;
        try (FileInputStream fis = new FileInputStream(inFile);){
            this.run(fis, jstream, mappedFile);
        }
    }

    private void writeEntry(JarOutputStream j, String name, long mtime, long lsize, boolean deflateHint, ByteBuffer data0, ByteBuffer data1) throws IOException {
        int size = (int)lsize;
        if ((long)size != lsize) {
            throw new IOException("file too large: " + lsize);
        }
        CRC32 crc322 = this._crc32;
        if (this._verbose > 1) {
            Utils.log.fine("Writing entry: " + name + " size=" + size + (deflateHint ? " deflated" : ""));
        }
        if (this._buf.length < size) {
            int newSize = size;
            while (newSize < this._buf.length) {
                if ((newSize <<= 1) > 0) continue;
                newSize = size;
                break;
            }
            this._buf = new byte[newSize];
        }
        assert (this._buf.length >= size);
        int fillp = 0;
        if (data0 != null) {
            int size0 = data0.capacity();
            data0.get(this._buf, fillp, size0);
            fillp += size0;
        }
        if (data1 != null) {
            int size1 = data1.capacity();
            data1.get(this._buf, fillp, size1);
            fillp += size1;
        }
        while (fillp < size) {
            int nr = this.in.read(this._buf, fillp, size - fillp);
            if (nr <= 0) {
                throw new IOException("EOF at end of archive");
            }
            fillp += nr;
        }
        ZipEntry z = new ZipEntry(name);
        z.setTime(mtime * 1000L);
        if (size == 0) {
            z.setMethod(0);
            z.setSize(0L);
            z.setCrc(0L);
            z.setCompressedSize(0L);
        } else if (!deflateHint) {
            z.setMethod(0);
            z.setSize(size);
            z.setCompressedSize(size);
            crc322.reset();
            crc322.update(this._buf, 0, size);
            z.setCrc(crc322.getValue());
        } else {
            z.setMethod(8);
            z.setSize(size);
        }
        j.putNextEntry(z);
        if (size > 0) {
            j.write(this._buf, 0, size);
        }
        j.closeEntry();
        if (this._verbose > 0) {
            Utils.log.info("Writing " + Utils.zeString(z));
        }
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("unpack"));
        NativeUnpack.initIDs();
    }
}

