/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsAnnotations;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016*\u00020\u0017H\u0002J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016*\u00020\u0018H\u0002J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016*\u00020\u0019H\u0002J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016*\u00020\u001aH\u0002J\f\u0010\u001b\u001a\u00020\u0007*\u00020\u0013H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ImplicitlyExportedDeclarationsMarkingLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "strictImplicitExport", "", "jsExportCtor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "getJsExportCtor", "()Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "jsExportCtor$delegate", "Lkotlin/Lazy;", "jsImplicitExportCtor", "getJsImplicitExportCtor", "jsImplicitExportCtor$delegate", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "collectImplicitlyExportedDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "shouldBeMarkedWithImplicitExportOrUpgraded", "markWithJsImplicitExportOrUpgrade", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nImplicitlyExportedDeclarationsMarkingLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImplicitlyExportedDeclarationsMarkingLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ImplicitlyExportedDeclarationsMarkingLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n*L\n1#1,113:1\n1869#2,2:114\n1563#2:116\n1634#2,3:117\n1374#2:120\n1460#2,5:121\n1374#2:126\n1460#2,5:127\n1374#2:132\n1460#2,5:133\n1634#2,3:140\n1#3:138\n16#4:139\n*S KotlinDebug\n*F\n+ 1 ImplicitlyExportedDeclarationsMarkingLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ImplicitlyExportedDeclarationsMarkingLowering\n*L\n44#1:114,2\n61#1:116\n61#1:117,3\n62#1:120\n62#1:121,5\n65#1:126\n65#1:127,5\n85#1:132\n85#1:133,5\n99#1:140,3\n99#1:139\n*E\n"})
public final class ImplicitlyExportedDeclarationsMarkingLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;
    private final boolean strictImplicitExport;
    @NotNull
    private final Lazy jsExportCtor$delegate;
    @NotNull
    private final Lazy jsImplicitExportCtor$delegate;

    public ImplicitlyExportedDeclarationsMarkingLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.strictImplicitExport = this.context.getConfiguration().getBoolean(JSConfigurationKeys.GENERATE_STRICT_IMPLICIT_EXPORT);
        this.jsExportCtor$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> ImplicitlyExportedDeclarationsMarkingLowering.jsExportCtor_delegate$lambda$0(this));
        this.jsImplicitExportCtor$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> ImplicitlyExportedDeclarationsMarkingLowering.jsImplicitExportCtor_delegate$lambda$1(this));
    }

    private final IrConstructorSymbol getJsExportCtor() {
        Lazy lazy = this.jsExportCtor$delegate;
        return (IrConstructorSymbol)lazy.getValue();
    }

    private final IrConstructorSymbol getJsImplicitExportCtor() {
        Lazy lazy = this.jsImplicitExportCtor$delegate;
        return (IrConstructorSymbol)lazy.getValue();
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!ExportModelGeneratorKt.isExported(declaration, this.context)) {
            return null;
        }
        IrDeclaration irDeclaration2 = declaration;
        Set<IrDeclaration> implicitlyExportedDeclarations = irDeclaration2 instanceof IrFunction ? this.collectImplicitlyExportedDeclarations((IrFunction)declaration) : (irDeclaration2 instanceof IrClass ? this.collectImplicitlyExportedDeclarations((IrClass)declaration) : (irDeclaration2 instanceof IrProperty ? this.collectImplicitlyExportedDeclarations((IrProperty)declaration) : SetsKt.emptySet()));
        Iterable $this$forEach$iv = implicitlyExportedDeclarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            this.markWithJsImplicitExportOrUpgrade(it);
        }
        return null;
    }

    private final Set<IrDeclaration> collectImplicitlyExportedDeclarations(IrClass $this$collectImplicitlyExportedDeclarations) {
        return SequencesKt.toSet(SequencesKt.flatMapIterable(SequencesKt.distinct(SequencesKt.flatMapIterable(kotlin.collections.CollectionsKt.asSequence((Iterable)$this$collectImplicitlyExportedDeclarations.getTypeParameters()), ImplicitlyExportedDeclarationsMarkingLowering::collectImplicitlyExportedDeclarations$lambda$3)), arg_0 -> ImplicitlyExportedDeclarationsMarkingLowering.collectImplicitlyExportedDeclarations$lambda$4(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<IrDeclaration> collectImplicitlyExportedDeclarations(IrFunction $this$collectImplicitlyExportedDeclarations) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMapTo$iv$iv2;
        void $this$flatMap$iv;
        IrTypeParameter it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Set<IrType> set;
        Set<IrType> $this$collectImplicitlyExportedDeclarations_u24lambda_u247 = set = SetsKt.createSetBuilder();
        boolean $i$a$-buildSet-ImplicitlyExportedDeclarationsMarkingLowering$collectImplicitlyExportedDeclarations$types$22 = false;
        $this$collectImplicitlyExportedDeclarations_u24lambda_u247.add($this$collectImplicitlyExportedDeclarations.getReturnType());
        Iterable iterable = $this$collectImplicitlyExportedDeclarations.getValueParameters();
        Set<IrType> set2 = $this$collectImplicitlyExportedDeclarations_u24lambda_u247;
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        set2.addAll((List)destination$iv$iv);
        $this$map$iv = $this$collectImplicitlyExportedDeclarations.getTypeParameters();
        set2 = $this$collectImplicitlyExportedDeclarations_u24lambda_u247;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (IrTypeParameter)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSuperTypes();
            kotlin.collections.CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        set2.addAll((List)destination$iv$iv);
        Set types2 = SetsKt.build(set);
        Iterable $this$flatMap$iv2 = types2;
        boolean $i$f$flatMap2 = false;
        Iterable $i$a$-buildSet-ImplicitlyExportedDeclarationsMarkingLowering$collectImplicitlyExportedDeclarations$types$22 = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrType it2 = (IrType)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.collectImplicitlyExportedDeclarations(it2);
            kotlin.collections.CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        return kotlin.collections.CollectionsKt.toSet((List)destination$iv$iv2);
    }

    private final Set<IrDeclaration> collectImplicitlyExportedDeclarations(IrProperty $this$collectImplicitlyExportedDeclarations) {
        Set<IrDeclaration> set;
        Set<IrDeclaration> setterImplicitlyExportedDeclarations;
        Set<IrDeclaration> set2;
        Set<IrDeclaration> getterImplicitlyExportedDeclarations;
        Object object = $this$collectImplicitlyExportedDeclarations.getGetter();
        if (object == null || (object = this.collectImplicitlyExportedDeclarations((IrFunction)object)) == null) {
            object = getterImplicitlyExportedDeclarations = SetsKt.emptySet();
        }
        if ((set2 = $this$collectImplicitlyExportedDeclarations.getSetter()) == null || (set2 = this.collectImplicitlyExportedDeclarations((IrFunction)((Object)set2))) == null) {
            set2 = setterImplicitlyExportedDeclarations = SetsKt.emptySet();
        }
        if ((set = $this$collectImplicitlyExportedDeclarations.getBackingField()) == null || (set = ((IrField)((Object)set)).getType()) == null || (set = this.collectImplicitlyExportedDeclarations((IrType)((Object)set))) == null) {
            set = SetsKt.emptySet();
        }
        Set<IrDeclaration> fieldImplicitlyExportedDeclarations = set;
        return SetsKt.plus(SetsKt.plus(getterImplicitlyExportedDeclarations, (Iterable)setterImplicitlyExportedDeclarations), (Iterable)fieldImplicitlyExportedDeclarations);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<IrDeclaration> collectImplicitlyExportedDeclarations(IrType $this$collectImplicitlyExportedDeclarations) {
        Set<IrDeclaration> set;
        if ($this$collectImplicitlyExportedDeclarations instanceof IrDynamicType || !($this$collectImplicitlyExportedDeclarations instanceof IrSimpleType)) {
            return SetsKt.emptySet();
        }
        IrType irType = IrTypesKt.makeNotNull($this$collectImplicitlyExportedDeclarations);
        Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrSimpleType nonNullType = (IrSimpleType)irType;
        IrClassifierSymbol classifier = nonNullType.getClassifier();
        if (IrTypePredicatesKt.isPrimitiveType$default(nonNullType, false, 1, null) || IrTypeUtilsKt.isPrimitiveArray(nonNullType) || IrTypePredicatesKt.isAny(nonNullType) || IrTypePredicatesKt.isUnit(nonNullType)) {
            set = SetsKt.emptySet();
        } else if (classifier instanceof IrTypeParameterSymbol) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                IrType it = (IrType)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.collectImplicitlyExportedDeclarations(it);
                kotlin.collections.CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            set = kotlin.collections.CollectionsKt.toSet((List)destination$iv$iv);
        } else if (classifier instanceof IrClassSymbol) {
            Object Owner = ((IrClassSymbol)classifier).getOwner();
            IrClass it = (IrClass)Owner;
            boolean bl = false;
            set = SetsKt.setOfNotNull(this.shouldBeMarkedWithImplicitExportOrUpgraded(it) ? Owner : null);
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final boolean shouldBeMarkedWithImplicitExportOrUpgraded(IrDeclaration $this$shouldBeMarkedWithImplicitExportOrUpgraded) {
        return $this$shouldBeMarkedWithImplicitExportOrUpgraded instanceof IrClass && !((IrClass)$this$shouldBeMarkedWithImplicitExportOrUpgraded).isExternal() && !ExportModelGeneratorKt.isExported($this$shouldBeMarkedWithImplicitExportOrUpgraded, this.context);
    }

    /*
     * WARNING - void declaration
     */
    private final void markWithJsImplicitExportOrUpgrade(IrDeclaration $this$markWithJsImplicitExportOrUpgrade) {
        block4: {
            void $this$markWithJsImplicitExportOrUpgrade_u24lambda_u2412;
            IrConstructorCall irConstructorCall;
            block3: {
                void $this$mapTo$iv$iv;
                void $this$memoryOptimizedMap$iv;
                if (!Intrinsics.areEqual(AnnotationUtilsKt.couldBeConvertedToExplicitExport($this$markWithJsImplicitExportOrUpgrade), true)) break block3;
                Collection collection = $this$markWithJsImplicitExportOrUpgrade.getAnnotations();
                IrDeclaration irDeclaration2 = $this$markWithJsImplicitExportOrUpgrade;
                boolean $i$f$memoryOptimizedMap = false;
                Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
                Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrConstructorCall irConstructorCall2 = (IrConstructorCall)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(IrUtilsKt.isAnnotation((IrConstructorCall)it, JsAnnotations.INSTANCE.getJsImplicitExportFqn()) ? JsIrBuilder.buildConstructorCall$default(JsIrBuilder.INSTANCE, this.getJsExportCtor(), null, null, null, 0, 0, 62, null) : it);
                }
                irDeclaration2.setAnnotations(CollectionsKt.compactIfPossible((List)destination$iv$iv));
                break block4;
            }
            if (!this.strictImplicitExport) break block4;
            IrConstructorCall $i$f$memoryOptimizedMap = irConstructorCall = JsIrBuilder.buildConstructorCall$default(JsIrBuilder.INSTANCE, this.getJsImplicitExportCtor(), null, null, null, 0, 0, 62, null);
            List<IrConstructorCall> list = $this$markWithJsImplicitExportOrUpgrade.getAnnotations();
            IrDeclaration irDeclaration3 = $this$markWithJsImplicitExportOrUpgrade;
            boolean bl = false;
            $this$markWithJsImplicitExportOrUpgrade_u24lambda_u2412.putValueArgument(0, IrUtilsKt.toIrConst$default(false, this.context.getIrBuiltIns().getBooleanType(), 0, 0, 6, null));
            Unit unit = Unit.INSTANCE;
            irDeclaration3.setAnnotations(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus(list, irConstructorCall));
            IrClass irClass = IrUtilsKt.getParentClassOrNull($this$markWithJsImplicitExportOrUpgrade);
            if (irClass != null) {
                IrClass irClass2;
                IrClass it = irClass2 = irClass;
                boolean bl2 = false;
                irClass = this.shouldBeMarkedWithImplicitExportOrUpgraded(it) ? irClass2 : null;
                if (irClass != null) {
                    this.markWithJsImplicitExportOrUpgrade(irClass);
                }
            }
        }
    }

    private static final IrConstructorSymbol jsExportCtor_delegate$lambda$0(ImplicitlyExportedDeclarationsMarkingLowering this$0) {
        return SequencesKt.single(IrUtilsKt.getConstructors(this$0.context.getIntrinsics().getJsExportAnnotationSymbol()));
    }

    private static final IrConstructorSymbol jsImplicitExportCtor_delegate$lambda$1(ImplicitlyExportedDeclarationsMarkingLowering this$0) {
        return SequencesKt.single(IrUtilsKt.getConstructors(this$0.context.getIntrinsics().getJsImplicitExportAnnotationSymbol()));
    }

    private static final Iterable collectImplicitlyExportedDeclarations$lambda$3(IrTypeParameter it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getSuperTypes();
    }

    private static final Iterable collectImplicitlyExportedDeclarations$lambda$4(ImplicitlyExportedDeclarationsMarkingLowering this$0, IrType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.collectImplicitlyExportedDeclarations(it);
    }
}

