"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerQueryRoute = registerQueryRoute;
var _configSchema = require("@osd/config-schema");
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerQueryRoute(server, service) {
  server.post({
    path: _constants.ROUTE_PATH_SQL_QUERY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLQuery(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_QUERY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLQuery(context, request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_CSV,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLCsv(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_CSV,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLCsv(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_JSON,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLJson(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_JSON,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLJson(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_TEXT,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLText(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_TEXT,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLText(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.post({
    path: _constants.ROUTE_PATH_SPARK_SQL_QUERY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLAsyncQuery(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.get({
    path: _constants.ROUTE_PATH_SPARK_SQL_JOB_QUERY + '/{id}' + '/{dataSourceMDSId?}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLAsyncGetQuery(context, request, request.params.id, request.params.dataSourceMDSId);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.delete({
    path: _constants.ROUTE_PATH_SPARK_SQL_JOB_QUERY + '/{id}' + '/{dataSourceMDSId?}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeAsyncDeleteQuery(context, request, request.params.id, request.params.dataSourceMDSId);
    return response.ok({
      body: retVal
    });
  });
  server.get({
    path: `${_constants.ROUTE_PATH_GET_DATASOURCES}/{dataSourceMDSId?}`,
    validate: {
      params: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSyncQueryDataSources(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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