/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.search.spell.StringDistance;

public class SimilarSymbols {
    private static final StringDistance ALGORITHM = new LevenshteinDistance();
    private final Collection<String> candidates;

    public SimilarSymbols(Collection<String> candidates) {
        this.candidates = Collections.unmodifiableCollection(candidates);
    }

    public String mostSimilarTo(String target) {
        Optional<SymbolDistance> closest = this.candidates.stream().map(candidate -> new SymbolDistance((String)candidate, target)).max(Comparator.comparing(SymbolDistance::similarity));
        if (closest.isPresent()) {
            return closest.get().candidate;
        }
        return target;
    }

    private static class SymbolDistance {
        private final String candidate;
        private final String target;

        private SymbolDistance(String candidate, String target) {
            this.candidate = candidate;
            this.target = target;
        }

        public float similarity() {
            return ALGORITHM.getDistance(this.candidate, this.target);
        }
    }
}

