"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const node_1 = require("@volar/language-server/node");
const language_core_1 = require("@vue/language-core");
const language_service_1 = require("@vue/language-service");
const namedPipeClient = require("@vue/typescript-plugin/lib/client");
const hybridModeProject_1 = require("./lib/hybridModeProject");
const initialize_1 = require("./lib/initialize");
const connection = (0, node_1.createConnection)();
const server = (0, node_1.createServer)(connection);
connection.listen();
connection.onInitialize(params => {
    const options = params.initializationOptions;
    const { typescript: ts, diagnosticMessages } = (0, node_1.loadTsdkByPath)(options.typescript.tsdk, params.locale);
    const hybridMode = options.vue?.hybridMode ?? true;
    if (hybridMode) {
        return server.initialize(params, (0, hybridModeProject_1.createHybridModeProject)(({ asFileName, configFileName }) => {
            const commandLine = configFileName
                ? (0, language_core_1.createParsedCommandLine)(ts, ts.sys, configFileName)
                : {
                    vueOptions: (0, language_core_1.getDefaultCompilerOptions)(),
                    options: ts.getDefaultCompilerOptions(),
                };
            commandLine.vueOptions.__test = params.initializationOptions.typescript.disableAutoImportCache;
            return {
                languagePlugins: [
                    (0, language_core_1.createVueLanguagePlugin)(ts, commandLine.options, commandLine.vueOptions, asFileName),
                ],
                setup({ project }) {
                    project.vue = { compilerOptions: commandLine.vueOptions };
                },
            };
        }), (0, language_service_1.getHybridModeLanguageServicePlugins)(ts, namedPipeClient));
    }
    else {
        return (0, initialize_1.initialize)(server, params, ts, diagnosticMessages);
    }
});
connection.onInitialized(server.initialized);
connection.onShutdown(server.shutdown);
//# sourceMappingURL=node.js.map