"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
function create() {
    return {
        name: 'vue-autoinsert-selfClosing',
        capabilities: {
            autoInsertionProvider: {
                triggerCharacters: ['/'],
                configurationSections: ['vue.autoInsert.selfClosing'],
            },
        },
        create(context) {
            return {
                async provideAutoInsertSnippet(document, selection, change) {
                    if (document.languageId !== 'html') {
                        return;
                    }
                    const enabled = await context.env.getConfiguration?.('vue.autoInsert.selfClosing') ?? true;
                    if (!enabled) {
                        return;
                    }
                    if (change.text === '{}'
                        && document.getText().slice(change.rangeOffset - 1, change.rangeOffset + 3) === '{{}}'
                        && document.offsetAt(selection) === change.rangeOffset + 1) {
                        return ` $0 `;
                    }
                },
            };
        },
    };
}
//# sourceMappingURL=vue-autoinsert-self-closing.js.map