"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertFieldCapsToMappingStructure = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const convertFieldCapsToMappingStructure = fieldCapsResponse => {
  let mappings = {};
  fieldCapsResponse.indices.forEach(index => {
    mappings[index] = {
      mappings: {
        properties: {}
      }
    };
  });
  for (const [fieldName, fieldDetails] of Object.entries(fieldCapsResponse.fields)) {
    if (fieldName.startsWith('_')) {
      continue;
    }
    for (const [fieldType, typeDetails] of Object.entries(fieldDetails)) {
      if (fieldType == 'unmapped') {
        continue;
      }
      let mapped_indices = _lodash.default.get(typeDetails, 'indices', fieldCapsResponse.indices);
      mapped_indices.forEach(mappedIndex => {
        mappings[mappedIndex]['mappings']['properties'][fieldName] = {
          type: typeDetails.type
        };
      });
    }
  }
  return mappings;
};
exports.convertFieldCapsToMappingStructure = convertFieldCapsToMappingStructure;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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