/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.platform.apple;

import java.awt.Desktop;
import java.io.File;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.about.AboutPanel;
import org.protege.editor.core.ui.preferences.PreferencesDialogPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtegeAppleApplication {
    private static final Logger logger = LoggerFactory.getLogger(ProtegeAppleApplication.class);
    private EditorKit eKit;
    private static ProtegeAppleApplication instance;

    public static ProtegeAppleApplication getInstance() {
        if (instance == null) {
            instance = new ProtegeAppleApplication();
        }
        return instance;
    }

    private ProtegeAppleApplication() {
        Desktop application = Desktop.getDesktop();
        application.setPreferencesHandler(event -> this.handlePreferencesRequest());
        application.setAboutHandler(event -> this.handleAboutRequest());
        application.setOpenFileHandler(event -> {
            File file = event.getFiles().get(0);
            try {
                this.editFile(file.getAbsolutePath());
            }
            catch (Exception e) {
                logger.error("invalid file: {}", (Object)file);
            }
        });
        application.setQuitHandler((event, response) -> this.handleQuitRequest());
    }

    public void setEditorKit(EditorKit eKit) {
        this.eKit = eKit;
    }

    protected void editFile(String fileName) throws Exception {
        ProtegeManager.getInstance().getApplication().editURI(new File(fileName).toURI());
    }

    protected boolean handlePreferencesRequest() {
        if (this.eKit != null) {
            PreferencesDialogPanel.showPreferencesDialog(null, this.eKit);
            return true;
        }
        return false;
    }

    protected boolean handleAboutRequest() {
        AboutPanel.showDialog();
        return true;
    }

    protected boolean handleQuitRequest() {
        return ProtegeApplication.handleQuit();
    }
}

