"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.getDataStreams = getDataStreams;
exports.getIndexToDataStreamMapping = getIndexToDataStreamMapping;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class DataStreamService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getDataStreams", async (context, request, response) => {
      try {
        const {
          search
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const [dataStreams, apiAccessible, errMsg] = await getDataStreams(callWithRequest, search);
        if (!apiAccessible) return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: errMsg
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              dataStreams: dataStreams,
              totalDataStreams: dataStreams.length
            }
          }
        });
      } catch (err) {
        console.error("Index Management - DataStreamService - getDataStreams:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = DataStreamService;
async function getDataStreams(callWithRequest, search) {
  const searchPattern = search ? `*${search}*` : "*";
  let accessible = true;
  let errMsg = "";
  const dataStreamsResponse = await callWithRequest("transport.request", {
    path: `/_data_stream/${searchPattern}`,
    method: "GET"
  }).catch(e => {
    if (e.statusCode === 403 && e.message.startsWith(_constants.SECURITY_EXCEPTION_PREFIX)) {
      accessible = false;
      errMsg = e.message;
      return {
        data_streams: []
      };
    }
    throw e;
  });
  return [dataStreamsResponse["data_streams"], accessible, errMsg];
}
async function getIndexToDataStreamMapping(callWithRequest) {
  const [dataStreams] = await getDataStreams(callWithRequest);
  const mapping = {};
  dataStreams.forEach(dataStream => {
    dataStream.indices.forEach(index => {
      mapping[index.index_name] = dataStream.name;
    });
  });
  return mapping;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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