"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class RollupService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    /**
     * Calls backend Put Rollup API
     */
    _defineProperty(this, "putRollup", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const {
          seqNo,
          primaryTerm
        } = request.query;
        let method = "ism.putRollup";
        let params = {
          rollupId: id,
          if_seq_no: seqNo,
          if_primary_term: primaryTerm,
          body: JSON.stringify(request.body)
        };
        if (seqNo === undefined || primaryTerm === undefined) {
          method = "ism.createRollup";
          params = {
            rollupId: id,
            body: JSON.stringify(request.body)
          };
        }
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const putRollupResponse = await callWithRequest(method, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: putRollupResponse
          }
        });
      } catch (err) {
        console.error("Index Management - RollupService - putRollup", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    /**
     * Calls backend Delete Rollup API
     */
    _defineProperty(this, "deleteRollup", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          rollupId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const deleteRollupResponse = await callWithRequest("ism.deleteRollup", params);
        if (deleteRollupResponse.result !== "deleted") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: deleteRollupResponse.result
            }
          });
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: true
          }
        });
      } catch (err) {
        console.error("Index Management - RollupService - deleteRollup:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "startRollup", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          rollupId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const startResponse = await callWithRequest("ism.startRollup", params);
        const acknowledged = _lodash.default.get(startResponse, "acknowledged");
        if (acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to start rollup"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - RollupService - startRollup:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "stopRollup", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          rollupId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const stopResponse = await callWithRequest("ism.stopRollup", params);
        const acknowledged = _lodash.default.get(stopResponse, "acknowledged");
        if (acknowledged) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: true
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to stop rollup"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - RollupService - stopRollup:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    /**
     * Calls backend Get Rollup API
     */
    _defineProperty(this, "getRollup", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          rollupId: id
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getResponse = await callWithRequest("ism.getRollup", params);
        const metadata = await callWithRequest("ism.explainRollup", params);
        const rollup = _lodash.default.get(getResponse, "rollup", null);
        const seqNo = _lodash.default.get(getResponse, "_seq_no");
        const primaryTerm = _lodash.default.get(getResponse, "_primary_term");

        //Form response
        if (rollup) {
          if (metadata) {
            return response.custom({
              statusCode: 200,
              body: {
                ok: true,
                response: {
                  _id: id,
                  _seqNo: seqNo,
                  _primaryTerm: primaryTerm,
                  rollup: rollup,
                  metadata: metadata
                }
              }
            });
          } else return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to load metadata"
            }
          });
        } else {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: "Failed to load rollup"
            }
          });
        }
      } catch (err) {
        console.error("Index Management - RollupService - getRollup:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "getMappings", async (context, request, response) => {
      try {
        const {
          index
        } = request.body;
        const params = {
          index: index
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const mappings = await callWithRequest("indices.getMapping", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: mappings
          }
        });
      } catch (err) {
        console.error("Index Management - RollupService - getMapping:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    /**
     * Performs a fuzzy search request on rollup id
     */
    _defineProperty(this, "getRollups", async (context, request, response) => {
      try {
        const {
          from,
          size,
          search,
          sortDirection,
          sortField
        } = request.query;
        const rollupSortMap = {
          _id: "rollup.rollup_id.keyword",
          "rollup.source_index": "rollup.source_index.keyword",
          "rollup.target_index": "rollup.target_index.keyword",
          "rollup.rollup.enabled": "rollup.enabled"
        };
        const params = {
          from: parseInt(from, 10),
          size: parseInt(size, 10),
          search,
          sortField: rollupSortMap[sortField] || rollupSortMap._id,
          sortDirection
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const getRollupResponse = await callWithRequest("ism.getRollups", params);
        const totalRollups = getRollupResponse.total_rollups;
        const rollups = getRollupResponse.rollups.map(rollup => ({
          _seqNo: rollup._seqNo,
          _primaryTerm: rollup._primaryTerm,
          _id: rollup._id,
          rollup: rollup.rollup,
          metadata: null
        }));

        // Call getExplain if any rollup job exists
        if (totalRollups) {
          // Concat rollup job ids
          const ids = rollups.map(rollup => rollup._id).join(",");
          const explainResponse = await callWithRequest("ism.explainRollup", {
            rollupId: ids
          });
          if (!explainResponse.error) {
            rollups.map(rollup => {
              rollup.metadata = explainResponse[rollup._id];
            });
            return response.custom({
              statusCode: 200,
              body: {
                ok: true,
                response: {
                  rollups: rollups,
                  totalRollups: totalRollups,
                  metadata: explainResponse
                }
              }
            });
          } else return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: explainResponse ? explainResponse.error : "An error occurred when calling getExplain API."
            }
          });
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              rollups: rollups,
              totalRollups: totalRollups,
              metadata: {}
            }
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.type === "index_not_found_exception") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                rollups: [],
                totalRollups: 0,
                metadata: null
              }
            }
          });
        }
        console.error("Index Management - RollupService - getRollups", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: "Error in getRollups " + err.message
          }
        });
      }
    });
  }
}
exports.default = RollupService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbG9kYXNoIiwiX2ludGVyb3BSZXF1aXJlRGVmYXVsdCIsInJlcXVpcmUiLCJfTURTRW5hYmxlZENsaWVudFNlcnZpY2UiLCJlIiwiX19lc01vZHVsZSIsImRlZmF1bHQiLCJfZGVmaW5lUHJvcGVydHkiLCJyIiwidCIsIl90b1Byb3BlcnR5S2V5IiwiT2JqZWN0IiwiZGVmaW5lUHJvcGVydHkiLCJ2YWx1ZSIsImVudW1lcmFibGUiLCJjb25maWd1cmFibGUiLCJ3cml0YWJsZSIsImkiLCJfdG9QcmltaXRpdmUiLCJTeW1ib2wiLCJ0b1ByaW1pdGl2ZSIsImNhbGwiLCJUeXBlRXJyb3IiLCJTdHJpbmciLCJOdW1iZXIiLCJSb2xsdXBTZXJ2aWNlIiwiTURTRW5hYmxlZENsaWVudFNlcnZpY2UiLCJjb25zdHJ1Y3RvciIsImFyZ3MiLCJjb250ZXh0IiwicmVxdWVzdCIsInJlc3BvbnNlIiwiaWQiLCJwYXJhbXMiLCJzZXFObyIsInByaW1hcnlUZXJtIiwicXVlcnkiLCJtZXRob2QiLCJyb2xsdXBJZCIsImlmX3NlcV9ubyIsImlmX3ByaW1hcnlfdGVybSIsImJvZHkiLCJKU09OIiwic3RyaW5naWZ5IiwidW5kZWZpbmVkIiwiY2FsbFdpdGhSZXF1ZXN0IiwiZ2V0Q2xpZW50QmFzZWRPbkRhdGFTb3VyY2UiLCJwdXRSb2xsdXBSZXNwb25zZSIsImN1c3RvbSIsInN0YXR1c0NvZGUiLCJvayIsImVyciIsImNvbnNvbGUiLCJlcnJvciIsIm1lc3NhZ2UiLCJkZWxldGVSb2xsdXBSZXNwb25zZSIsInJlc3VsdCIsInN0YXJ0UmVzcG9uc2UiLCJhY2tub3dsZWRnZWQiLCJfIiwiZ2V0Iiwic3RvcFJlc3BvbnNlIiwiZ2V0UmVzcG9uc2UiLCJtZXRhZGF0YSIsInJvbGx1cCIsIl9pZCIsIl9zZXFObyIsIl9wcmltYXJ5VGVybSIsImluZGV4IiwibWFwcGluZ3MiLCJmcm9tIiwic2l6ZSIsInNlYXJjaCIsInNvcnREaXJlY3Rpb24iLCJzb3J0RmllbGQiLCJyb2xsdXBTb3J0TWFwIiwicGFyc2VJbnQiLCJnZXRSb2xsdXBSZXNwb25zZSIsInRvdGFsUm9sbHVwcyIsInRvdGFsX3JvbGx1cHMiLCJyb2xsdXBzIiwibWFwIiwiaWRzIiwiam9pbiIsImV4cGxhaW5SZXNwb25zZSIsInR5cGUiLCJleHBvcnRzIiwibW9kdWxlIl0sInNvdXJjZXMiOlsiUm9sbHVwU2VydmljZS50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCBfIGZyb20gXCJsb2Rhc2hcIjtcbmltcG9ydCB7XG4gIE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnksXG4gIElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlLFxuICBSZXNwb25zZUVycm9yLFxuICBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG59IGZyb20gXCJvcGVuc2VhcmNoLWRhc2hib2FyZHMvc2VydmVyXCI7XG5pbXBvcnQgeyBEZWxldGVSb2xsdXBQYXJhbXMsIERlbGV0ZVJvbGx1cFJlc3BvbnNlLCBHZXRSb2xsdXBzUmVzcG9uc2UsIFB1dFJvbGx1cFBhcmFtcywgUHV0Um9sbHVwUmVzcG9uc2UgfSBmcm9tIFwiLi4vbW9kZWxzL2ludGVyZmFjZXNcIjtcbmltcG9ydCB7IFNlcnZlclJlc3BvbnNlIH0gZnJvbSBcIi4uL21vZGVscy90eXBlc1wiO1xuaW1wb3J0IHsgRG9jdW1lbnRSb2xsdXAsIFJvbGx1cCB9IGZyb20gXCIuLi8uLi9tb2RlbHMvaW50ZXJmYWNlc1wiO1xuaW1wb3J0IHsgTURTRW5hYmxlZENsaWVudFNlcnZpY2UgfSBmcm9tIFwiLi9NRFNFbmFibGVkQ2xpZW50U2VydmljZVwiO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBSb2xsdXBTZXJ2aWNlIGV4dGVuZHMgTURTRW5hYmxlZENsaWVudFNlcnZpY2Uge1xuICAvKipcbiAgICogQ2FsbHMgYmFja2VuZCBQdXQgUm9sbHVwIEFQSVxuICAgKi9cbiAgcHV0Um9sbHVwID0gYXN5bmMgKFxuICAgIGNvbnRleHQ6IFJlcXVlc3RIYW5kbGVyQ29udGV4dCxcbiAgICByZXF1ZXN0OiBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QsXG4gICAgcmVzcG9uc2U6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2VGYWN0b3J5XG4gICk6IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8U2VydmVyUmVzcG9uc2U8UHV0Um9sbHVwUmVzcG9uc2U+IHwgUmVzcG9uc2VFcnJvcj4+ID0+IHtcbiAgICB0cnkge1xuICAgICAgY29uc3QgeyBpZCB9ID0gcmVxdWVzdC5wYXJhbXMgYXMgeyBpZDogc3RyaW5nIH07XG4gICAgICBjb25zdCB7IHNlcU5vLCBwcmltYXJ5VGVybSB9ID0gcmVxdWVzdC5xdWVyeSBhcyB7IHNlcU5vPzogc3RyaW5nOyBwcmltYXJ5VGVybT86IHN0cmluZyB9O1xuICAgICAgbGV0IG1ldGhvZCA9IFwiaXNtLnB1dFJvbGx1cFwiO1xuICAgICAgbGV0IHBhcmFtczogUHV0Um9sbHVwUGFyYW1zID0ge1xuICAgICAgICByb2xsdXBJZDogaWQsXG4gICAgICAgIGlmX3NlcV9ubzogc2VxTm8sXG4gICAgICAgIGlmX3ByaW1hcnlfdGVybTogcHJpbWFyeVRlcm0sXG4gICAgICAgIGJvZHk6IEpTT04uc3RyaW5naWZ5KHJlcXVlc3QuYm9keSksXG4gICAgICB9O1xuICAgICAgaWYgKHNlcU5vID09PSB1bmRlZmluZWQgfHwgcHJpbWFyeVRlcm0gPT09IHVuZGVmaW5lZCkge1xuICAgICAgICBtZXRob2QgPSBcImlzbS5jcmVhdGVSb2xsdXBcIjtcbiAgICAgICAgcGFyYW1zID0geyByb2xsdXBJZDogaWQsIGJvZHk6IEpTT04uc3RyaW5naWZ5KHJlcXVlc3QuYm9keSkgfTtcbiAgICAgIH1cbiAgICAgIGNvbnN0IGNhbGxXaXRoUmVxdWVzdCA9IHRoaXMuZ2V0Q2xpZW50QmFzZWRPbkRhdGFTb3VyY2UoY29udGV4dCwgcmVxdWVzdCk7XG4gICAgICBjb25zdCBwdXRSb2xsdXBSZXNwb25zZTogUHV0Um9sbHVwUmVzcG9uc2UgPSAoYXdhaXQgY2FsbFdpdGhSZXF1ZXN0KG1ldGhvZCwgcGFyYW1zKSkgYXMgUHV0Um9sbHVwUmVzcG9uc2U7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IHRydWUsXG4gICAgICAgICAgcmVzcG9uc2U6IHB1dFJvbGx1cFJlc3BvbnNlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICBjb25zb2xlLmVycm9yKFwiSW5kZXggTWFuYWdlbWVudCAtIFJvbGx1cFNlcnZpY2UgLSBwdXRSb2xsdXBcIiwgZXJyKTtcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogZmFsc2UsXG4gICAgICAgICAgZXJyb3I6IGVyci5tZXNzYWdlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfVxuICB9O1xuXG4gIC8qKlxuICAgKiBDYWxscyBiYWNrZW5kIERlbGV0ZSBSb2xsdXAgQVBJXG4gICAqL1xuICBkZWxldGVSb2xsdXAgPSBhc3luYyAoXG4gICAgY29udGV4dDogUmVxdWVzdEhhbmRsZXJDb250ZXh0LFxuICAgIHJlcXVlc3Q6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgICByZXNwb25zZTogT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnlcbiAgKTogUHJvbWlzZTxJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxTZXJ2ZXJSZXNwb25zZTxib29sZWFuPiB8IFJlc3BvbnNlRXJyb3I+PiA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHsgaWQgfSA9IHJlcXVlc3QucGFyYW1zIGFzIHsgaWQ6IHN0cmluZyB9O1xuICAgICAgY29uc3QgcGFyYW1zOiBEZWxldGVSb2xsdXBQYXJhbXMgPSB7IHJvbGx1cElkOiBpZCB9O1xuICAgICAgY29uc3QgY2FsbFdpdGhSZXF1ZXN0ID0gdGhpcy5nZXRDbGllbnRCYXNlZE9uRGF0YVNvdXJjZShjb250ZXh0LCByZXF1ZXN0KTtcbiAgICAgIGNvbnN0IGRlbGV0ZVJvbGx1cFJlc3BvbnNlOiBEZWxldGVSb2xsdXBSZXNwb25zZSA9IChhd2FpdCBjYWxsV2l0aFJlcXVlc3QoXCJpc20uZGVsZXRlUm9sbHVwXCIsIHBhcmFtcykpIGFzIERlbGV0ZVJvbGx1cFJlc3BvbnNlO1xuICAgICAgaWYgKGRlbGV0ZVJvbGx1cFJlc3BvbnNlLnJlc3VsdCAhPT0gXCJkZWxldGVkXCIpIHtcbiAgICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICAgIGJvZHk6IHtcbiAgICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICAgIGVycm9yOiBkZWxldGVSb2xsdXBSZXNwb25zZS5yZXN1bHQsXG4gICAgICAgICAgfSxcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IHRydWUsXG4gICAgICAgICAgcmVzcG9uc2U6IHRydWUsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoXCJJbmRleCBNYW5hZ2VtZW50IC0gUm9sbHVwU2VydmljZSAtIGRlbGV0ZVJvbGx1cDpcIiwgZXJyKTtcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHtcbiAgICAgICAgICBvazogZmFsc2UsXG4gICAgICAgICAgZXJyb3I6IGVyci5tZXNzYWdlLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfVxuICB9O1xuXG4gIHN0YXJ0Um9sbHVwID0gYXN5bmMgKFxuICAgIGNvbnRleHQ6IFJlcXVlc3RIYW5kbGVyQ29udGV4dCxcbiAgICByZXF1ZXN0OiBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QsXG4gICAgcmVzcG9uc2U6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2VGYWN0b3J5XG4gICk6IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8U2VydmVyUmVzcG9uc2U8Ym9vbGVhbj4+PiA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHsgaWQgfSA9IHJlcXVlc3QucGFyYW1zIGFzIHsgaWQ6IHN0cmluZyB9O1xuICAgICAgY29uc3QgcGFyYW1zID0geyByb2xsdXBJZDogaWQgfTtcbiAgICAgIGNvbnN0IGNhbGxXaXRoUmVxdWVzdCA9IHRoaXMuZ2V0Q2xpZW50QmFzZWRPbkRhdGFTb3VyY2UoY29udGV4dCwgcmVxdWVzdCk7XG4gICAgICBjb25zdCBzdGFydFJlc3BvbnNlID0gYXdhaXQgY2FsbFdpdGhSZXF1ZXN0KFwiaXNtLnN0YXJ0Um9sbHVwXCIsIHBhcmFtcyk7XG4gICAgICBjb25zdCBhY2tub3dsZWRnZWQgPSBfLmdldChzdGFydFJlc3BvbnNlLCBcImFja25vd2xlZGdlZFwiKTtcbiAgICAgIGlmIChhY2tub3dsZWRnZWQpIHtcbiAgICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICAgIGJvZHk6IHsgb2s6IHRydWUsIHJlc3BvbnNlOiB0cnVlIH0sXG4gICAgICAgIH0pO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICAgIGJvZHk6IHsgb2s6IGZhbHNlLCBlcnJvcjogXCJGYWlsZWQgdG8gc3RhcnQgcm9sbHVwXCIgfSxcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICBjb25zb2xlLmVycm9yKFwiSW5kZXggTWFuYWdlbWVudCAtIFJvbGx1cFNlcnZpY2UgLSBzdGFydFJvbGx1cDpcIiwgZXJyKTtcbiAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgIGJvZHk6IHsgb2s6IGZhbHNlLCBlcnJvcjogZXJyLm1lc3NhZ2UgfSxcbiAgICAgIH0pO1xuICAgIH1cbiAgfTtcblxuICBzdG9wUm9sbHVwID0gYXN5bmMgKFxuICAgIGNvbnRleHQ6IFJlcXVlc3RIYW5kbGVyQ29udGV4dCxcbiAgICByZXF1ZXN0OiBPcGVuU2VhcmNoRGFzaGJvYXJkc1JlcXVlc3QsXG4gICAgcmVzcG9uc2U6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2VGYWN0b3J5XG4gICk6IFByb21pc2U8SU9wZW5TZWFyY2hEYXNoYm9hcmRzUmVzcG9uc2U8U2VydmVyUmVzcG9uc2U8Ym9vbGVhbj4+PiA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHsgaWQgfSA9IHJlcXVlc3QucGFyYW1zIGFzIHsgaWQ6IHN0cmluZyB9O1xuICAgICAgY29uc3QgcGFyYW1zID0geyByb2xsdXBJZDogaWQgfTtcbiAgICAgIGNvbnN0IGNhbGxXaXRoUmVxdWVzdCA9IHRoaXMuZ2V0Q2xpZW50QmFzZWRPbkRhdGFTb3VyY2UoY29udGV4dCwgcmVxdWVzdCk7XG4gICAgICBjb25zdCBzdG9wUmVzcG9uc2UgPSBhd2FpdCBjYWxsV2l0aFJlcXVlc3QoXCJpc20uc3RvcFJvbGx1cFwiLCBwYXJhbXMpO1xuICAgICAgY29uc3QgYWNrbm93bGVkZ2VkID0gXy5nZXQoc3RvcFJlc3BvbnNlLCBcImFja25vd2xlZGdlZFwiKTtcbiAgICAgIGlmIChhY2tub3dsZWRnZWQpIHtcbiAgICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICAgIGJvZHk6IHsgb2s6IHRydWUsIHJlc3BvbnNlOiB0cnVlIH0sXG4gICAgICAgIH0pO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICAgIGJvZHk6IHsgb2s6IGZhbHNlLCBlcnJvcjogXCJGYWlsZWQgdG8gc3RvcCByb2xsdXBcIiB9LFxuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoXCJJbmRleCBNYW5hZ2VtZW50IC0gUm9sbHVwU2VydmljZSAtIHN0b3BSb2xsdXA6XCIsIGVycik7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7IG9rOiBmYWxzZSwgZXJyb3I6IGVyci5tZXNzYWdlIH0sXG4gICAgICB9KTtcbiAgICB9XG4gIH07XG5cbiAgLyoqXG4gICAqIENhbGxzIGJhY2tlbmQgR2V0IFJvbGx1cCBBUElcbiAgICovXG4gIGdldFJvbGx1cCA9IGFzeW5jIChcbiAgICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG4gICAgcmVxdWVzdDogT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0LFxuICAgIHJlc3BvbnNlOiBPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlRmFjdG9yeVxuICApOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPFNlcnZlclJlc3BvbnNlPERvY3VtZW50Um9sbHVwPj4+ID0+IHtcbiAgICB0cnkge1xuICAgICAgY29uc3QgeyBpZCB9ID0gcmVxdWVzdC5wYXJhbXMgYXMgeyBpZDogc3RyaW5nIH07XG4gICAgICBjb25zdCBwYXJhbXMgPSB7IHJvbGx1cElkOiBpZCB9O1xuICAgICAgY29uc3QgY2FsbFdpdGhSZXF1ZXN0ID0gdGhpcy5nZXRDbGllbnRCYXNlZE9uRGF0YVNvdXJjZShjb250ZXh0LCByZXF1ZXN0KTtcbiAgICAgIGNvbnN0IGdldFJlc3BvbnNlID0gYXdhaXQgY2FsbFdpdGhSZXF1ZXN0KFwiaXNtLmdldFJvbGx1cFwiLCBwYXJhbXMpO1xuICAgICAgY29uc3QgbWV0YWRhdGEgPSBhd2FpdCBjYWxsV2l0aFJlcXVlc3QoXCJpc20uZXhwbGFpblJvbGx1cFwiLCBwYXJhbXMpO1xuICAgICAgY29uc3Qgcm9sbHVwID0gXy5nZXQoZ2V0UmVzcG9uc2UsIFwicm9sbHVwXCIsIG51bGwpO1xuICAgICAgY29uc3Qgc2VxTm8gPSBfLmdldChnZXRSZXNwb25zZSwgXCJfc2VxX25vXCIpO1xuICAgICAgY29uc3QgcHJpbWFyeVRlcm0gPSBfLmdldChnZXRSZXNwb25zZSwgXCJfcHJpbWFyeV90ZXJtXCIpO1xuXG4gICAgICAvL0Zvcm0gcmVzcG9uc2VcbiAgICAgIGlmIChyb2xsdXApIHtcbiAgICAgICAgaWYgKG1ldGFkYXRhKSB7XG4gICAgICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgICAgICBzdGF0dXNDb2RlOiAyMDAsXG4gICAgICAgICAgICBib2R5OiB7XG4gICAgICAgICAgICAgIG9rOiB0cnVlLFxuICAgICAgICAgICAgICByZXNwb25zZToge1xuICAgICAgICAgICAgICAgIF9pZDogaWQsXG4gICAgICAgICAgICAgICAgX3NlcU5vOiBzZXFObyBhcyBudW1iZXIsXG4gICAgICAgICAgICAgICAgX3ByaW1hcnlUZXJtOiBwcmltYXJ5VGVybSBhcyBudW1iZXIsXG4gICAgICAgICAgICAgICAgcm9sbHVwOiByb2xsdXAgYXMgUm9sbHVwLFxuICAgICAgICAgICAgICAgIG1ldGFkYXRhOiBtZXRhZGF0YSxcbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSk7XG4gICAgICAgIH0gZWxzZVxuICAgICAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICAgICAgYm9keToge1xuICAgICAgICAgICAgICBvazogZmFsc2UsXG4gICAgICAgICAgICAgIGVycm9yOiBcIkZhaWxlZCB0byBsb2FkIG1ldGFkYXRhXCIsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIH0pO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICAgIGJvZHk6IHtcbiAgICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICAgIGVycm9yOiBcIkZhaWxlZCB0byBsb2FkIHJvbGx1cFwiLFxuICAgICAgICAgIH0sXG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgIH0gY2F0Y2ggKGVycikge1xuICAgICAgY29uc29sZS5lcnJvcihcIkluZGV4IE1hbmFnZW1lbnQgLSBSb2xsdXBTZXJ2aWNlIC0gZ2V0Um9sbHVwOlwiLCBlcnIpO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICBlcnJvcjogZXJyLm1lc3NhZ2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9XG4gIH07XG5cbiAgZ2V0TWFwcGluZ3MgPSBhc3luYyAoXG4gICAgY29udGV4dDogUmVxdWVzdEhhbmRsZXJDb250ZXh0LFxuICAgIHJlcXVlc3Q6IE9wZW5TZWFyY2hEYXNoYm9hcmRzUmVxdWVzdCxcbiAgICByZXNwb25zZTogT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZUZhY3RvcnlcbiAgKTogUHJvbWlzZTxJT3BlblNlYXJjaERhc2hib2FyZHNSZXNwb25zZTxTZXJ2ZXJSZXNwb25zZTxhbnk+Pj4gPT4ge1xuICAgIHRyeSB7XG4gICAgICBjb25zdCB7IGluZGV4IH0gPSByZXF1ZXN0LmJvZHkgYXMgeyBpbmRleDogc3RyaW5nIH07XG4gICAgICBjb25zdCBwYXJhbXMgPSB7IGluZGV4OiBpbmRleCB9O1xuICAgICAgY29uc3QgY2FsbFdpdGhSZXF1ZXN0ID0gdGhpcy5nZXRDbGllbnRCYXNlZE9uRGF0YVNvdXJjZShjb250ZXh0LCByZXF1ZXN0KTtcbiAgICAgIGNvbnN0IG1hcHBpbmdzID0gYXdhaXQgY2FsbFdpdGhSZXF1ZXN0KFwiaW5kaWNlcy5nZXRNYXBwaW5nXCIsIHBhcmFtcyk7XG4gICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICBib2R5OiB7XG4gICAgICAgICAgb2s6IHRydWUsXG4gICAgICAgICAgcmVzcG9uc2U6IG1hcHBpbmdzLFxuICAgICAgICB9LFxuICAgICAgfSk7XG4gICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICBjb25zb2xlLmVycm9yKFwiSW5kZXggTWFuYWdlbWVudCAtIFJvbGx1cFNlcnZpY2UgLSBnZXRNYXBwaW5nOlwiLCBlcnIpO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICBlcnJvcjogZXJyLm1lc3NhZ2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9XG4gIH07XG4gIC8qKlxuICAgKiBQZXJmb3JtcyBhIGZ1enp5IHNlYXJjaCByZXF1ZXN0IG9uIHJvbGx1cCBpZFxuICAgKi9cbiAgZ2V0Um9sbHVwcyA9IGFzeW5jIChcbiAgICBjb250ZXh0OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQsXG4gICAgcmVxdWVzdDogT3BlblNlYXJjaERhc2hib2FyZHNSZXF1ZXN0LFxuICAgIHJlc3BvbnNlOiBPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlRmFjdG9yeVxuICApOiBQcm9taXNlPElPcGVuU2VhcmNoRGFzaGJvYXJkc1Jlc3BvbnNlPFNlcnZlclJlc3BvbnNlPEdldFJvbGx1cHNSZXNwb25zZT4+PiA9PiB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IHsgZnJvbSwgc2l6ZSwgc2VhcmNoLCBzb3J0RGlyZWN0aW9uLCBzb3J0RmllbGQgfSA9IHJlcXVlc3QucXVlcnkgYXMge1xuICAgICAgICBmcm9tOiBzdHJpbmc7XG4gICAgICAgIHNpemU6IHN0cmluZztcbiAgICAgICAgc2VhcmNoOiBzdHJpbmc7XG4gICAgICAgIHNvcnREaXJlY3Rpb246IHN0cmluZztcbiAgICAgICAgc29ydEZpZWxkOiBzdHJpbmc7XG4gICAgICB9O1xuXG4gICAgICBjb25zdCByb2xsdXBTb3J0TWFwOiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9ID0ge1xuICAgICAgICBfaWQ6IFwicm9sbHVwLnJvbGx1cF9pZC5rZXl3b3JkXCIsXG4gICAgICAgIFwicm9sbHVwLnNvdXJjZV9pbmRleFwiOiBcInJvbGx1cC5zb3VyY2VfaW5kZXgua2V5d29yZFwiLFxuICAgICAgICBcInJvbGx1cC50YXJnZXRfaW5kZXhcIjogXCJyb2xsdXAudGFyZ2V0X2luZGV4LmtleXdvcmRcIixcbiAgICAgICAgXCJyb2xsdXAucm9sbHVwLmVuYWJsZWRcIjogXCJyb2xsdXAuZW5hYmxlZFwiLFxuICAgICAgfTtcblxuICAgICAgY29uc3QgcGFyYW1zID0ge1xuICAgICAgICBmcm9tOiBwYXJzZUludChmcm9tLCAxMCksXG4gICAgICAgIHNpemU6IHBhcnNlSW50KHNpemUsIDEwKSxcbiAgICAgICAgc2VhcmNoLFxuICAgICAgICBzb3J0RmllbGQ6IHJvbGx1cFNvcnRNYXBbc29ydEZpZWxkXSB8fCByb2xsdXBTb3J0TWFwLl9pZCxcbiAgICAgICAgc29ydERpcmVjdGlvbixcbiAgICAgIH07XG5cbiAgICAgIGNvbnN0IGNhbGxXaXRoUmVxdWVzdCA9IHRoaXMuZ2V0Q2xpZW50QmFzZWRPbkRhdGFTb3VyY2UoY29udGV4dCwgcmVxdWVzdCk7XG4gICAgICBjb25zdCBnZXRSb2xsdXBSZXNwb25zZTogYW55ID0gYXdhaXQgY2FsbFdpdGhSZXF1ZXN0KFwiaXNtLmdldFJvbGx1cHNcIiwgcGFyYW1zKTtcbiAgICAgIGNvbnN0IHRvdGFsUm9sbHVwcyA9IGdldFJvbGx1cFJlc3BvbnNlLnRvdGFsX3JvbGx1cHM7XG4gICAgICBjb25zdCByb2xsdXBzID0gZ2V0Um9sbHVwUmVzcG9uc2Uucm9sbHVwcy5tYXAoKHJvbGx1cDogRG9jdW1lbnRSb2xsdXApID0+ICh7XG4gICAgICAgIF9zZXFObzogcm9sbHVwLl9zZXFObyBhcyBudW1iZXIsXG4gICAgICAgIF9wcmltYXJ5VGVybTogcm9sbHVwLl9wcmltYXJ5VGVybSBhcyBudW1iZXIsXG4gICAgICAgIF9pZDogcm9sbHVwLl9pZCxcbiAgICAgICAgcm9sbHVwOiByb2xsdXAucm9sbHVwLFxuICAgICAgICBtZXRhZGF0YTogbnVsbCxcbiAgICAgIH0pKTtcblxuICAgICAgLy8gQ2FsbCBnZXRFeHBsYWluIGlmIGFueSByb2xsdXAgam9iIGV4aXN0c1xuICAgICAgaWYgKHRvdGFsUm9sbHVwcykge1xuICAgICAgICAvLyBDb25jYXQgcm9sbHVwIGpvYiBpZHNcbiAgICAgICAgY29uc3QgaWRzID0gcm9sbHVwcy5tYXAoKHJvbGx1cDogRG9jdW1lbnRSb2xsdXApID0+IHJvbGx1cC5faWQpLmpvaW4oXCIsXCIpO1xuICAgICAgICBjb25zdCBleHBsYWluUmVzcG9uc2U6IGFueSA9IGF3YWl0IGNhbGxXaXRoUmVxdWVzdChcImlzbS5leHBsYWluUm9sbHVwXCIsIHsgcm9sbHVwSWQ6IGlkcyB9KTtcbiAgICAgICAgaWYgKCFleHBsYWluUmVzcG9uc2UuZXJyb3IpIHtcbiAgICAgICAgICByb2xsdXBzLm1hcCgocm9sbHVwOiBEb2N1bWVudFJvbGx1cCkgPT4ge1xuICAgICAgICAgICAgcm9sbHVwLm1ldGFkYXRhID0gZXhwbGFpblJlc3BvbnNlW3JvbGx1cC5faWRdO1xuICAgICAgICAgIH0pO1xuICAgICAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICAgICAgc3RhdHVzQ29kZTogMjAwLFxuICAgICAgICAgICAgYm9keTogeyBvazogdHJ1ZSwgcmVzcG9uc2U6IHsgcm9sbHVwczogcm9sbHVwcywgdG90YWxSb2xsdXBzOiB0b3RhbFJvbGx1cHMsIG1ldGFkYXRhOiBleHBsYWluUmVzcG9uc2UgfSB9LFxuICAgICAgICAgIH0pO1xuICAgICAgICB9IGVsc2VcbiAgICAgICAgICByZXR1cm4gcmVzcG9uc2UuY3VzdG9tKHtcbiAgICAgICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgICAgIGJvZHk6IHtcbiAgICAgICAgICAgICAgb2s6IGZhbHNlLFxuICAgICAgICAgICAgICBlcnJvcjogZXhwbGFpblJlc3BvbnNlID8gZXhwbGFpblJlc3BvbnNlLmVycm9yIDogXCJBbiBlcnJvciBvY2N1cnJlZCB3aGVuIGNhbGxpbmcgZ2V0RXhwbGFpbiBBUEkuXCIsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIH0pO1xuICAgICAgfVxuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keTogeyBvazogdHJ1ZSwgcmVzcG9uc2U6IHsgcm9sbHVwczogcm9sbHVwcywgdG90YWxSb2xsdXBzOiB0b3RhbFJvbGx1cHMsIG1ldGFkYXRhOiB7fSB9IH0sXG4gICAgICB9KTtcbiAgICB9IGNhdGNoIChlcnIpIHtcbiAgICAgIGlmIChlcnIuc3RhdHVzQ29kZSA9PT0gNDA0ICYmIGVyci5ib2R5LmVycm9yLnR5cGUgPT09IFwiaW5kZXhfbm90X2ZvdW5kX2V4Y2VwdGlvblwiKSB7XG4gICAgICAgIHJldHVybiByZXNwb25zZS5jdXN0b20oe1xuICAgICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgICBib2R5OiB7IG9rOiB0cnVlLCByZXNwb25zZTogeyByb2xsdXBzOiBbXSwgdG90YWxSb2xsdXBzOiAwLCBtZXRhZGF0YTogbnVsbCB9IH0sXG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgICAgY29uc29sZS5lcnJvcihcIkluZGV4IE1hbmFnZW1lbnQgLSBSb2xsdXBTZXJ2aWNlIC0gZ2V0Um9sbHVwc1wiLCBlcnIpO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlLmN1c3RvbSh7XG4gICAgICAgIHN0YXR1c0NvZGU6IDIwMCxcbiAgICAgICAgYm9keToge1xuICAgICAgICAgIG9rOiBmYWxzZSxcbiAgICAgICAgICBlcnJvcjogXCJFcnJvciBpbiBnZXRSb2xsdXBzIFwiICsgZXJyLm1lc3NhZ2UsXG4gICAgICAgIH0sXG4gICAgICB9KTtcbiAgICB9XG4gIH07XG59XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLE9BQUEsR0FBQUMsc0JBQUEsQ0FBQUMsT0FBQTtBQVdBLElBQUFDLHdCQUFBLEdBQUFELE9BQUE7QUFBb0UsU0FBQUQsdUJBQUFHLENBQUEsV0FBQUEsQ0FBQSxJQUFBQSxDQUFBLENBQUFDLFVBQUEsR0FBQUQsQ0FBQSxLQUFBRSxPQUFBLEVBQUFGLENBQUE7QUFBQSxTQUFBRyxnQkFBQUgsQ0FBQSxFQUFBSSxDQUFBLEVBQUFDLENBQUEsWUFBQUQsQ0FBQSxHQUFBRSxjQUFBLENBQUFGLENBQUEsTUFBQUosQ0FBQSxHQUFBTyxNQUFBLENBQUFDLGNBQUEsQ0FBQVIsQ0FBQSxFQUFBSSxDQUFBLElBQUFLLEtBQUEsRUFBQUosQ0FBQSxFQUFBSyxVQUFBLE1BQUFDLFlBQUEsTUFBQUMsUUFBQSxVQUFBWixDQUFBLENBQUFJLENBQUEsSUFBQUMsQ0FBQSxFQUFBTCxDQUFBO0FBQUEsU0FBQU0sZUFBQUQsQ0FBQSxRQUFBUSxDQUFBLEdBQUFDLFlBQUEsQ0FBQVQsQ0FBQSx1Q0FBQVEsQ0FBQSxHQUFBQSxDQUFBLEdBQUFBLENBQUE7QUFBQSxTQUFBQyxhQUFBVCxDQUFBLEVBQUFELENBQUEsMkJBQUFDLENBQUEsS0FBQUEsQ0FBQSxTQUFBQSxDQUFBLE1BQUFMLENBQUEsR0FBQUssQ0FBQSxDQUFBVSxNQUFBLENBQUFDLFdBQUEsa0JBQUFoQixDQUFBLFFBQUFhLENBQUEsR0FBQWIsQ0FBQSxDQUFBaUIsSUFBQSxDQUFBWixDQUFBLEVBQUFELENBQUEsdUNBQUFTLENBQUEsU0FBQUEsQ0FBQSxZQUFBSyxTQUFBLHlFQUFBZCxDQUFBLEdBQUFlLE1BQUEsR0FBQUMsTUFBQSxFQUFBZixDQUFBLEtBaEJwRTtBQUNBO0FBQ0E7QUFDQTtBQWVlLE1BQU1nQixhQUFhLFNBQVNDLGdEQUF1QixDQUFDO0VBQUFDLFlBQUEsR0FBQUMsSUFBQTtJQUFBLFNBQUFBLElBQUE7SUFDakU7QUFDRjtBQUNBO0lBRkVyQixlQUFBLG9CQUdZLE9BQ1ZzQixPQUE4QixFQUM5QkMsT0FBb0MsRUFDcENDLFFBQTZDLEtBQ2lEO01BQzlGLElBQUk7UUFDRixNQUFNO1VBQUVDO1FBQUcsQ0FBQyxHQUFHRixPQUFPLENBQUNHLE1BQXdCO1FBQy9DLE1BQU07VUFBRUMsS0FBSztVQUFFQztRQUFZLENBQUMsR0FBR0wsT0FBTyxDQUFDTSxLQUFpRDtRQUN4RixJQUFJQyxNQUFNLEdBQUcsZUFBZTtRQUM1QixJQUFJSixNQUF1QixHQUFHO1VBQzVCSyxRQUFRLEVBQUVOLEVBQUU7VUFDWk8sU0FBUyxFQUFFTCxLQUFLO1VBQ2hCTSxlQUFlLEVBQUVMLFdBQVc7VUFDNUJNLElBQUksRUFBRUMsSUFBSSxDQUFDQyxTQUFTLENBQUNiLE9BQU8sQ0FBQ1csSUFBSTtRQUNuQyxDQUFDO1FBQ0QsSUFBSVAsS0FBSyxLQUFLVSxTQUFTLElBQUlULFdBQVcsS0FBS1MsU0FBUyxFQUFFO1VBQ3BEUCxNQUFNLEdBQUcsa0JBQWtCO1VBQzNCSixNQUFNLEdBQUc7WUFBRUssUUFBUSxFQUFFTixFQUFFO1lBQUVTLElBQUksRUFBRUMsSUFBSSxDQUFDQyxTQUFTLENBQUNiLE9BQU8sQ0FBQ1csSUFBSTtVQUFFLENBQUM7UUFDL0Q7UUFDQSxNQUFNSSxlQUFlLEdBQUcsSUFBSSxDQUFDQywwQkFBMEIsQ0FBQ2pCLE9BQU8sRUFBRUMsT0FBTyxDQUFDO1FBQ3pFLE1BQU1pQixpQkFBb0MsR0FBSSxNQUFNRixlQUFlLENBQUNSLE1BQU0sRUFBRUosTUFBTSxDQUF1QjtRQUN6RyxPQUFPRixRQUFRLENBQUNpQixNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZSLElBQUksRUFBRTtZQUNKUyxFQUFFLEVBQUUsSUFBSTtZQUNSbkIsUUFBUSxFQUFFZ0I7VUFDWjtRQUNGLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQyxPQUFPSSxHQUFHLEVBQUU7UUFDWkMsT0FBTyxDQUFDQyxLQUFLLENBQUMsOENBQThDLEVBQUVGLEdBQUcsQ0FBQztRQUNsRSxPQUFPcEIsUUFBUSxDQUFDaUIsTUFBTSxDQUFDO1VBQ3JCQyxVQUFVLEVBQUUsR0FBRztVQUNmUixJQUFJLEVBQUU7WUFDSlMsRUFBRSxFQUFFLEtBQUs7WUFDVEcsS0FBSyxFQUFFRixHQUFHLENBQUNHO1VBQ2I7UUFDRixDQUFDLENBQUM7TUFDSjtJQUNGLENBQUM7SUFFRDtBQUNGO0FBQ0E7SUFGRS9DLGVBQUEsdUJBR2UsT0FDYnNCLE9BQThCLEVBQzlCQyxPQUFvQyxFQUNwQ0MsUUFBNkMsS0FDdUM7TUFDcEYsSUFBSTtRQUNGLE1BQU07VUFBRUM7UUFBRyxDQUFDLEdBQUdGLE9BQU8sQ0FBQ0csTUFBd0I7UUFDL0MsTUFBTUEsTUFBMEIsR0FBRztVQUFFSyxRQUFRLEVBQUVOO1FBQUcsQ0FBQztRQUNuRCxNQUFNYSxlQUFlLEdBQUcsSUFBSSxDQUFDQywwQkFBMEIsQ0FBQ2pCLE9BQU8sRUFBRUMsT0FBTyxDQUFDO1FBQ3pFLE1BQU15QixvQkFBMEMsR0FBSSxNQUFNVixlQUFlLENBQUMsa0JBQWtCLEVBQUVaLE1BQU0sQ0FBMEI7UUFDOUgsSUFBSXNCLG9CQUFvQixDQUFDQyxNQUFNLEtBQUssU0FBUyxFQUFFO1VBQzdDLE9BQU96QixRQUFRLENBQUNpQixNQUFNLENBQUM7WUFDckJDLFVBQVUsRUFBRSxHQUFHO1lBQ2ZSLElBQUksRUFBRTtjQUNKUyxFQUFFLEVBQUUsS0FBSztjQUNURyxLQUFLLEVBQUVFLG9CQUFvQixDQUFDQztZQUM5QjtVQUNGLENBQUMsQ0FBQztRQUNKO1FBQ0EsT0FBT3pCLFFBQVEsQ0FBQ2lCLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZlIsSUFBSSxFQUFFO1lBQ0pTLEVBQUUsRUFBRSxJQUFJO1lBQ1JuQixRQUFRLEVBQUU7VUFDWjtRQUNGLENBQUMsQ0FBQztNQUNKLENBQUMsQ0FBQyxPQUFPb0IsR0FBRyxFQUFFO1FBQ1pDLE9BQU8sQ0FBQ0MsS0FBSyxDQUFDLGtEQUFrRCxFQUFFRixHQUFHLENBQUM7UUFDdEUsT0FBT3BCLFFBQVEsQ0FBQ2lCLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZlIsSUFBSSxFQUFFO1lBQ0pTLEVBQUUsRUFBRSxLQUFLO1lBQ1RHLEtBQUssRUFBRUYsR0FBRyxDQUFDRztVQUNiO1FBQ0YsQ0FBQyxDQUFDO01BQ0o7SUFDRixDQUFDO0lBQUEvQyxlQUFBLHNCQUVhLE9BQ1pzQixPQUE4QixFQUM5QkMsT0FBb0MsRUFDcENDLFFBQTZDLEtBQ3VCO01BQ3BFLElBQUk7UUFDRixNQUFNO1VBQUVDO1FBQUcsQ0FBQyxHQUFHRixPQUFPLENBQUNHLE1BQXdCO1FBQy9DLE1BQU1BLE1BQU0sR0FBRztVQUFFSyxRQUFRLEVBQUVOO1FBQUcsQ0FBQztRQUMvQixNQUFNYSxlQUFlLEdBQUcsSUFBSSxDQUFDQywwQkFBMEIsQ0FBQ2pCLE9BQU8sRUFBRUMsT0FBTyxDQUFDO1FBQ3pFLE1BQU0yQixhQUFhLEdBQUcsTUFBTVosZUFBZSxDQUFDLGlCQUFpQixFQUFFWixNQUFNLENBQUM7UUFDdEUsTUFBTXlCLFlBQVksR0FBR0MsZUFBQyxDQUFDQyxHQUFHLENBQUNILGFBQWEsRUFBRSxjQUFjLENBQUM7UUFDekQsSUFBSUMsWUFBWSxFQUFFO1VBQ2hCLE9BQU8zQixRQUFRLENBQUNpQixNQUFNLENBQUM7WUFDckJDLFVBQVUsRUFBRSxHQUFHO1lBQ2ZSLElBQUksRUFBRTtjQUFFUyxFQUFFLEVBQUUsSUFBSTtjQUFFbkIsUUFBUSxFQUFFO1lBQUs7VUFDbkMsQ0FBQyxDQUFDO1FBQ0osQ0FBQyxNQUFNO1VBQ0wsT0FBT0EsUUFBUSxDQUFDaUIsTUFBTSxDQUFDO1lBQ3JCQyxVQUFVLEVBQUUsR0FBRztZQUNmUixJQUFJLEVBQUU7Y0FBRVMsRUFBRSxFQUFFLEtBQUs7Y0FBRUcsS0FBSyxFQUFFO1lBQXlCO1VBQ3JELENBQUMsQ0FBQztRQUNKO01BQ0YsQ0FBQyxDQUFDLE9BQU9GLEdBQUcsRUFBRTtRQUNaQyxPQUFPLENBQUNDLEtBQUssQ0FBQyxpREFBaUQsRUFBRUYsR0FBRyxDQUFDO1FBQ3JFLE9BQU9wQixRQUFRLENBQUNpQixNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZSLElBQUksRUFBRTtZQUFFUyxFQUFFLEVBQUUsS0FBSztZQUFFRyxLQUFLLEVBQUVGLEdBQUcsQ0FBQ0c7VUFBUTtRQUN4QyxDQUFDLENBQUM7TUFDSjtJQUNGLENBQUM7SUFBQS9DLGVBQUEscUJBRVksT0FDWHNCLE9BQThCLEVBQzlCQyxPQUFvQyxFQUNwQ0MsUUFBNkMsS0FDdUI7TUFDcEUsSUFBSTtRQUNGLE1BQU07VUFBRUM7UUFBRyxDQUFDLEdBQUdGLE9BQU8sQ0FBQ0csTUFBd0I7UUFDL0MsTUFBTUEsTUFBTSxHQUFHO1VBQUVLLFFBQVEsRUFBRU47UUFBRyxDQUFDO1FBQy9CLE1BQU1hLGVBQWUsR0FBRyxJQUFJLENBQUNDLDBCQUEwQixDQUFDakIsT0FBTyxFQUFFQyxPQUFPLENBQUM7UUFDekUsTUFBTStCLFlBQVksR0FBRyxNQUFNaEIsZUFBZSxDQUFDLGdCQUFnQixFQUFFWixNQUFNLENBQUM7UUFDcEUsTUFBTXlCLFlBQVksR0FBR0MsZUFBQyxDQUFDQyxHQUFHLENBQUNDLFlBQVksRUFBRSxjQUFjLENBQUM7UUFDeEQsSUFBSUgsWUFBWSxFQUFFO1VBQ2hCLE9BQU8zQixRQUFRLENBQUNpQixNQUFNLENBQUM7WUFDckJDLFVBQVUsRUFBRSxHQUFHO1lBQ2ZSLElBQUksRUFBRTtjQUFFUyxFQUFFLEVBQUUsSUFBSTtjQUFFbkIsUUFBUSxFQUFFO1lBQUs7VUFDbkMsQ0FBQyxDQUFDO1FBQ0osQ0FBQyxNQUFNO1VBQ0wsT0FBT0EsUUFBUSxDQUFDaUIsTUFBTSxDQUFDO1lBQ3JCQyxVQUFVLEVBQUUsR0FBRztZQUNmUixJQUFJLEVBQUU7Y0FBRVMsRUFBRSxFQUFFLEtBQUs7Y0FBRUcsS0FBSyxFQUFFO1lBQXdCO1VBQ3BELENBQUMsQ0FBQztRQUNKO01BQ0YsQ0FBQyxDQUFDLE9BQU9GLEdBQUcsRUFBRTtRQUNaQyxPQUFPLENBQUNDLEtBQUssQ0FBQyxnREFBZ0QsRUFBRUYsR0FBRyxDQUFDO1FBQ3BFLE9BQU9wQixRQUFRLENBQUNpQixNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZSLElBQUksRUFBRTtZQUFFUyxFQUFFLEVBQUUsS0FBSztZQUFFRyxLQUFLLEVBQUVGLEdBQUcsQ0FBQ0c7VUFBUTtRQUN4QyxDQUFDLENBQUM7TUFDSjtJQUNGLENBQUM7SUFFRDtBQUNGO0FBQ0E7SUFGRS9DLGVBQUEsb0JBR1ksT0FDVnNCLE9BQThCLEVBQzlCQyxPQUFvQyxFQUNwQ0MsUUFBNkMsS0FDOEI7TUFDM0UsSUFBSTtRQUNGLE1BQU07VUFBRUM7UUFBRyxDQUFDLEdBQUdGLE9BQU8sQ0FBQ0csTUFBd0I7UUFDL0MsTUFBTUEsTUFBTSxHQUFHO1VBQUVLLFFBQVEsRUFBRU47UUFBRyxDQUFDO1FBQy9CLE1BQU1hLGVBQWUsR0FBRyxJQUFJLENBQUNDLDBCQUEwQixDQUFDakIsT0FBTyxFQUFFQyxPQUFPLENBQUM7UUFDekUsTUFBTWdDLFdBQVcsR0FBRyxNQUFNakIsZUFBZSxDQUFDLGVBQWUsRUFBRVosTUFBTSxDQUFDO1FBQ2xFLE1BQU04QixRQUFRLEdBQUcsTUFBTWxCLGVBQWUsQ0FBQyxtQkFBbUIsRUFBRVosTUFBTSxDQUFDO1FBQ25FLE1BQU0rQixNQUFNLEdBQUdMLGVBQUMsQ0FBQ0MsR0FBRyxDQUFDRSxXQUFXLEVBQUUsUUFBUSxFQUFFLElBQUksQ0FBQztRQUNqRCxNQUFNNUIsS0FBSyxHQUFHeUIsZUFBQyxDQUFDQyxHQUFHLENBQUNFLFdBQVcsRUFBRSxTQUFTLENBQUM7UUFDM0MsTUFBTTNCLFdBQVcsR0FBR3dCLGVBQUMsQ0FBQ0MsR0FBRyxDQUFDRSxXQUFXLEVBQUUsZUFBZSxDQUFDOztRQUV2RDtRQUNBLElBQUlFLE1BQU0sRUFBRTtVQUNWLElBQUlELFFBQVEsRUFBRTtZQUNaLE9BQU9oQyxRQUFRLENBQUNpQixNQUFNLENBQUM7Y0FDckJDLFVBQVUsRUFBRSxHQUFHO2NBQ2ZSLElBQUksRUFBRTtnQkFDSlMsRUFBRSxFQUFFLElBQUk7Z0JBQ1JuQixRQUFRLEVBQUU7a0JBQ1JrQyxHQUFHLEVBQUVqQyxFQUFFO2tCQUNQa0MsTUFBTSxFQUFFaEMsS0FBZTtrQkFDdkJpQyxZQUFZLEVBQUVoQyxXQUFxQjtrQkFDbkM2QixNQUFNLEVBQUVBLE1BQWdCO2tCQUN4QkQsUUFBUSxFQUFFQTtnQkFDWjtjQUNGO1lBQ0YsQ0FBQyxDQUFDO1VBQ0osQ0FBQyxNQUNDLE9BQU9oQyxRQUFRLENBQUNpQixNQUFNLENBQUM7WUFDckJDLFVBQVUsRUFBRSxHQUFHO1lBQ2ZSLElBQUksRUFBRTtjQUNKUyxFQUFFLEVBQUUsS0FBSztjQUNURyxLQUFLLEVBQUU7WUFDVDtVQUNGLENBQUMsQ0FBQztRQUNOLENBQUMsTUFBTTtVQUNMLE9BQU90QixRQUFRLENBQUNpQixNQUFNLENBQUM7WUFDckJDLFVBQVUsRUFBRSxHQUFHO1lBQ2ZSLElBQUksRUFBRTtjQUNKUyxFQUFFLEVBQUUsS0FBSztjQUNURyxLQUFLLEVBQUU7WUFDVDtVQUNGLENBQUMsQ0FBQztRQUNKO01BQ0YsQ0FBQyxDQUFDLE9BQU9GLEdBQUcsRUFBRTtRQUNaQyxPQUFPLENBQUNDLEtBQUssQ0FBQywrQ0FBK0MsRUFBRUYsR0FBRyxDQUFDO1FBQ25FLE9BQU9wQixRQUFRLENBQUNpQixNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZSLElBQUksRUFBRTtZQUNKUyxFQUFFLEVBQUUsS0FBSztZQUNURyxLQUFLLEVBQUVGLEdBQUcsQ0FBQ0c7VUFDYjtRQUNGLENBQUMsQ0FBQztNQUNKO0lBQ0YsQ0FBQztJQUFBL0MsZUFBQSxzQkFFYSxPQUNac0IsT0FBOEIsRUFDOUJDLE9BQW9DLEVBQ3BDQyxRQUE2QyxLQUNtQjtNQUNoRSxJQUFJO1FBQ0YsTUFBTTtVQUFFcUM7UUFBTSxDQUFDLEdBQUd0QyxPQUFPLENBQUNXLElBQXlCO1FBQ25ELE1BQU1SLE1BQU0sR0FBRztVQUFFbUMsS0FBSyxFQUFFQTtRQUFNLENBQUM7UUFDL0IsTUFBTXZCLGVBQWUsR0FBRyxJQUFJLENBQUNDLDBCQUEwQixDQUFDakIsT0FBTyxFQUFFQyxPQUFPLENBQUM7UUFDekUsTUFBTXVDLFFBQVEsR0FBRyxNQUFNeEIsZUFBZSxDQUFDLG9CQUFvQixFQUFFWixNQUFNLENBQUM7UUFDcEUsT0FBT0YsUUFBUSxDQUFDaUIsTUFBTSxDQUFDO1VBQ3JCQyxVQUFVLEVBQUUsR0FBRztVQUNmUixJQUFJLEVBQUU7WUFDSlMsRUFBRSxFQUFFLElBQUk7WUFDUm5CLFFBQVEsRUFBRXNDO1VBQ1o7UUFDRixDQUFDLENBQUM7TUFDSixDQUFDLENBQUMsT0FBT2xCLEdBQUcsRUFBRTtRQUNaQyxPQUFPLENBQUNDLEtBQUssQ0FBQyxnREFBZ0QsRUFBRUYsR0FBRyxDQUFDO1FBQ3BFLE9BQU9wQixRQUFRLENBQUNpQixNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZSLElBQUksRUFBRTtZQUNKUyxFQUFFLEVBQUUsS0FBSztZQUNURyxLQUFLLEVBQUVGLEdBQUcsQ0FBQ0c7VUFDYjtRQUNGLENBQUMsQ0FBQztNQUNKO0lBQ0YsQ0FBQztJQUNEO0FBQ0Y7QUFDQTtJQUZFL0MsZUFBQSxxQkFHYSxPQUNYc0IsT0FBOEIsRUFDOUJDLE9BQW9DLEVBQ3BDQyxRQUE2QyxLQUNrQztNQUMvRSxJQUFJO1FBQ0YsTUFBTTtVQUFFdUMsSUFBSTtVQUFFQyxJQUFJO1VBQUVDLE1BQU07VUFBRUMsYUFBYTtVQUFFQztRQUFVLENBQUMsR0FBRzVDLE9BQU8sQ0FBQ00sS0FNaEU7UUFFRCxNQUFNdUMsYUFBd0MsR0FBRztVQUMvQ1YsR0FBRyxFQUFFLDBCQUEwQjtVQUMvQixxQkFBcUIsRUFBRSw2QkFBNkI7VUFDcEQscUJBQXFCLEVBQUUsNkJBQTZCO1VBQ3BELHVCQUF1QixFQUFFO1FBQzNCLENBQUM7UUFFRCxNQUFNaEMsTUFBTSxHQUFHO1VBQ2JxQyxJQUFJLEVBQUVNLFFBQVEsQ0FBQ04sSUFBSSxFQUFFLEVBQUUsQ0FBQztVQUN4QkMsSUFBSSxFQUFFSyxRQUFRLENBQUNMLElBQUksRUFBRSxFQUFFLENBQUM7VUFDeEJDLE1BQU07VUFDTkUsU0FBUyxFQUFFQyxhQUFhLENBQUNELFNBQVMsQ0FBQyxJQUFJQyxhQUFhLENBQUNWLEdBQUc7VUFDeERRO1FBQ0YsQ0FBQztRQUVELE1BQU01QixlQUFlLEdBQUcsSUFBSSxDQUFDQywwQkFBMEIsQ0FBQ2pCLE9BQU8sRUFBRUMsT0FBTyxDQUFDO1FBQ3pFLE1BQU0rQyxpQkFBc0IsR0FBRyxNQUFNaEMsZUFBZSxDQUFDLGdCQUFnQixFQUFFWixNQUFNLENBQUM7UUFDOUUsTUFBTTZDLFlBQVksR0FBR0QsaUJBQWlCLENBQUNFLGFBQWE7UUFDcEQsTUFBTUMsT0FBTyxHQUFHSCxpQkFBaUIsQ0FBQ0csT0FBTyxDQUFDQyxHQUFHLENBQUVqQixNQUFzQixLQUFNO1VBQ3pFRSxNQUFNLEVBQUVGLE1BQU0sQ0FBQ0UsTUFBZ0I7VUFDL0JDLFlBQVksRUFBRUgsTUFBTSxDQUFDRyxZQUFzQjtVQUMzQ0YsR0FBRyxFQUFFRCxNQUFNLENBQUNDLEdBQUc7VUFDZkQsTUFBTSxFQUFFQSxNQUFNLENBQUNBLE1BQU07VUFDckJELFFBQVEsRUFBRTtRQUNaLENBQUMsQ0FBQyxDQUFDOztRQUVIO1FBQ0EsSUFBSWUsWUFBWSxFQUFFO1VBQ2hCO1VBQ0EsTUFBTUksR0FBRyxHQUFHRixPQUFPLENBQUNDLEdBQUcsQ0FBRWpCLE1BQXNCLElBQUtBLE1BQU0sQ0FBQ0MsR0FBRyxDQUFDLENBQUNrQixJQUFJLENBQUMsR0FBRyxDQUFDO1VBQ3pFLE1BQU1DLGVBQW9CLEdBQUcsTUFBTXZDLGVBQWUsQ0FBQyxtQkFBbUIsRUFBRTtZQUFFUCxRQUFRLEVBQUU0QztVQUFJLENBQUMsQ0FBQztVQUMxRixJQUFJLENBQUNFLGVBQWUsQ0FBQy9CLEtBQUssRUFBRTtZQUMxQjJCLE9BQU8sQ0FBQ0MsR0FBRyxDQUFFakIsTUFBc0IsSUFBSztjQUN0Q0EsTUFBTSxDQUFDRCxRQUFRLEdBQUdxQixlQUFlLENBQUNwQixNQUFNLENBQUNDLEdBQUcsQ0FBQztZQUMvQyxDQUFDLENBQUM7WUFDRixPQUFPbEMsUUFBUSxDQUFDaUIsTUFBTSxDQUFDO2NBQ3JCQyxVQUFVLEVBQUUsR0FBRztjQUNmUixJQUFJLEVBQUU7Z0JBQUVTLEVBQUUsRUFBRSxJQUFJO2dCQUFFbkIsUUFBUSxFQUFFO2tCQUFFaUQsT0FBTyxFQUFFQSxPQUFPO2tCQUFFRixZQUFZLEVBQUVBLFlBQVk7a0JBQUVmLFFBQVEsRUFBRXFCO2dCQUFnQjtjQUFFO1lBQzFHLENBQUMsQ0FBQztVQUNKLENBQUMsTUFDQyxPQUFPckQsUUFBUSxDQUFDaUIsTUFBTSxDQUFDO1lBQ3JCQyxVQUFVLEVBQUUsR0FBRztZQUNmUixJQUFJLEVBQUU7Y0FDSlMsRUFBRSxFQUFFLEtBQUs7Y0FDVEcsS0FBSyxFQUFFK0IsZUFBZSxHQUFHQSxlQUFlLENBQUMvQixLQUFLLEdBQUc7WUFDbkQ7VUFDRixDQUFDLENBQUM7UUFDTjtRQUNBLE9BQU90QixRQUFRLENBQUNpQixNQUFNLENBQUM7VUFDckJDLFVBQVUsRUFBRSxHQUFHO1VBQ2ZSLElBQUksRUFBRTtZQUFFUyxFQUFFLEVBQUUsSUFBSTtZQUFFbkIsUUFBUSxFQUFFO2NBQUVpRCxPQUFPLEVBQUVBLE9BQU87Y0FBRUYsWUFBWSxFQUFFQSxZQUFZO2NBQUVmLFFBQVEsRUFBRSxDQUFDO1lBQUU7VUFBRTtRQUM3RixDQUFDLENBQUM7TUFDSixDQUFDLENBQUMsT0FBT1osR0FBRyxFQUFFO1FBQ1osSUFBSUEsR0FBRyxDQUFDRixVQUFVLEtBQUssR0FBRyxJQUFJRSxHQUFHLENBQUNWLElBQUksQ0FBQ1ksS0FBSyxDQUFDZ0MsSUFBSSxLQUFLLDJCQUEyQixFQUFFO1VBQ2pGLE9BQU90RCxRQUFRLENBQUNpQixNQUFNLENBQUM7WUFDckJDLFVBQVUsRUFBRSxHQUFHO1lBQ2ZSLElBQUksRUFBRTtjQUFFUyxFQUFFLEVBQUUsSUFBSTtjQUFFbkIsUUFBUSxFQUFFO2dCQUFFaUQsT0FBTyxFQUFFLEVBQUU7Z0JBQUVGLFlBQVksRUFBRSxDQUFDO2dCQUFFZixRQUFRLEVBQUU7Y0FBSztZQUFFO1VBQy9FLENBQUMsQ0FBQztRQUNKO1FBQ0FYLE9BQU8sQ0FBQ0MsS0FBSyxDQUFDLCtDQUErQyxFQUFFRixHQUFHLENBQUM7UUFDbkUsT0FBT3BCLFFBQVEsQ0FBQ2lCLE1BQU0sQ0FBQztVQUNyQkMsVUFBVSxFQUFFLEdBQUc7VUFDZlIsSUFBSSxFQUFFO1lBQ0pTLEVBQUUsRUFBRSxLQUFLO1lBQ1RHLEtBQUssRUFBRSxzQkFBc0IsR0FBR0YsR0FBRyxDQUFDRztVQUN0QztRQUNGLENBQUMsQ0FBQztNQUNKO0lBQ0YsQ0FBQztFQUFBO0FBQ0g7QUFBQ2dDLE9BQUEsQ0FBQWhGLE9BQUEsR0FBQW1CLGFBQUE7QUFBQThELE1BQUEsQ0FBQUQsT0FBQSxHQUFBQSxPQUFBLENBQUFoRixPQUFBIn0=