/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.temperature;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Record;
import org.jooq.Result;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.MetricFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.temperature.DimensionalTemperatureFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.NodeLevelDimensionalSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.ShardProfileSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.HeatZoneAssigner;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.ShardStore;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureVector;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.TemperatureMetricsBase;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.byShard.calculators.AvgShardBasedTemperatureCalculator;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.byShard.calculators.ShardBasedTemperatureCalculator;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.capacity.calculators.TotalNodeTemperatureCalculator;
import org.opensearch.performanceanalyzer.rca.store.metric.temperature.shardIndependent.calculators.ShardIndependentTemperatureCalculator;
import org.opensearch.performanceanalyzer.rca.store.rca.hotshard.IndexShardKey;

public class DimensionalTemperatureCalculator {
    private static final Logger LOG = LogManager.getLogger(DimensionalTemperatureCalculator.class);

    public static DimensionalTemperatureFlowUnit getTemperatureForDimension(ShardStore shardStore, TemperatureDimension dimension, ShardBasedTemperatureCalculator resourceByShardId, AvgShardBasedTemperatureCalculator avgResUsageByAllShards, ShardIndependentTemperatureCalculator resourceShardIndependent, TotalNodeTemperatureCalculator resourcePeakUsage, TemperatureVector.NormalizedValue threshold) {
        ArrayList allFlowUnits = new ArrayList();
        List shardIdBasedFlowUnits = resourceByShardId.getFlowUnits();
        List avgResUsageFlowUnits = avgResUsageByAllShards.getFlowUnits();
        List resourcePeakFlowUnits = resourcePeakUsage.getFlowUnits();
        allFlowUnits.add(shardIdBasedFlowUnits);
        allFlowUnits.add(avgResUsageFlowUnits);
        allFlowUnits.add(resourcePeakFlowUnits);
        AtomicBoolean emptyFlowUnit = new AtomicBoolean(false);
        allFlowUnits.forEach(flowUnitAcrossOneCalculator -> {
            if (((MetricFlowUnit)flowUnitAcrossOneCalculator.get(0)).isEmpty()) {
                LOG.debug("Empty flowUnitAcrossOneCalculator");
                emptyFlowUnit.set(true);
            }
        });
        if (emptyFlowUnit.get()) {
            return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
        }
        AtomicBoolean noEntriesInFlowUnit = new AtomicBoolean(false);
        allFlowUnits.forEach(flowUnitAcrossOneCalculator -> {
            if (((MetricFlowUnit)flowUnitAcrossOneCalculator.get(0)).getData().size() == 0) {
                LOG.debug("No Entries in flowUnits");
                noEntriesInFlowUnit.set(true);
            }
        });
        if (noEntriesInFlowUnit.get()) {
            return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
        }
        LOG.debug("shardIdBasedFlowUnits " + String.valueOf(((MetricFlowUnit)shardIdBasedFlowUnits.get(0)).getData()));
        LOG.debug("avgResUsageFlowUnits " + String.valueOf(((MetricFlowUnit)avgResUsageFlowUnits.get(0)).getData()));
        LOG.debug("resourcePeakFlowUnits " + String.valueOf(((MetricFlowUnit)resourcePeakFlowUnits.get(0)).getData()));
        if (((Record)((MetricFlowUnit)shardIdBasedFlowUnits.get(0)).getData().get(0)).size() != 3) {
            throw new IllegalArgumentException("Size more than expected: " + String.valueOf(shardIdBasedFlowUnits));
        }
        if (((Record)((MetricFlowUnit)avgResUsageFlowUnits.get(0)).getData().get(0)).size() != 1) {
            throw new IllegalArgumentException("Size more than expected:\n" + String.valueOf(((MetricFlowUnit)avgResUsageFlowUnits.get(0)).getData()) + "\n found: " + ((MetricFlowUnit)avgResUsageFlowUnits.get(0)).getData().intoArrays().length);
        }
        if (((Record)((MetricFlowUnit)resourcePeakFlowUnits.get(0)).getData().get(0)).size() != 1) {
            throw new IllegalArgumentException("Size more than expected: \n" + String.valueOf(((MetricFlowUnit)resourcePeakFlowUnits.get(0)).getData()));
        }
        double avgUsageAcrossShards = -1.0;
        try {
            List values = ((MetricFlowUnit)avgResUsageFlowUnits.get(0)).getData().getValues("shard_avg", Double.class);
            if (values == null || values.get(0) == null) {
                return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
            }
            avgUsageAcrossShards = (Double)values.get(0);
        }
        catch (Exception ex) {
            LOG.error("DBError getting shard average:", (Throwable)ex);
            return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
        }
        double totalUsageInNode = -1.0;
        try {
            List values = ((MetricFlowUnit)resourcePeakFlowUnits.get(0)).getData().getValues(TemperatureMetricsBase.AGGR_OVER_AGGR_NAME, Double.class);
            if (values == null || values.get(0) == null) {
                return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
            }
            totalUsageInNode = (Double)values.get(0);
        }
        catch (Exception ex) {
            LOG.error("DBError getting shard average:", (Throwable)ex);
            return new DimensionalTemperatureFlowUnit(System.currentTimeMillis());
        }
        TemperatureVector.NormalizedValue normalizedConsumptionAcrossShards = TemperatureVector.NormalizedValue.calculate(avgUsageAcrossShards, totalUsageInNode);
        Result<Record> valuesOverShards = ((MetricFlowUnit)shardIdBasedFlowUnits.get(0)).getData();
        NodeLevelDimensionalSummary nodeDimensionProfile = new NodeLevelDimensionalSummary(dimension, normalizedConsumptionAcrossShards, totalUsageInNode);
        nodeDimensionProfile.setNumberOfShards(valuesOverShards.size());
        for (Record record : valuesOverShards) {
            String indexName = (String)record.getValue(ColumnTypes.IndexName.name(), String.class);
            int shardId = (Integer)record.getValue(ColumnTypes.ShardID.name(), Integer.class);
            double usageByShard = (Double)record.getValue(ColumnTypes.sum.name(), Double.class);
            TemperatureVector.NormalizedValue normalizedConsumptionByShard = TemperatureVector.NormalizedValue.calculate(usageByShard, totalUsageInNode);
            HeatZoneAssigner.Zone heatZoneForShard = HeatZoneAssigner.assign(normalizedConsumptionByShard, normalizedConsumptionAcrossShards, threshold);
            IndexShardKey indexShardKey = new IndexShardKey(indexName, shardId);
            ShardProfileSummary shardProfileSummary = shardStore.getOrCreateIfAbsent(indexShardKey);
            shardProfileSummary.addTemperatureForDimension(dimension, normalizedConsumptionByShard);
            nodeDimensionProfile.addShardToZone(shardProfileSummary, heatZoneForShard);
        }
        return new DimensionalTemperatureFlowUnit(System.currentTimeMillis(), nodeDimensionProfile);
    }

    static enum ColumnTypes {
        IndexName,
        ShardID,
        sum;

    }
}

