/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.imageio;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.DeferRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.MagicNumberRegistryEntry;
import org.apache.batik.util.ParsedURL;

public abstract class AbstractImageIORegistryEntry
extends MagicNumberRegistryEntry {
    public AbstractImageIORegistryEntry(String string, String[] stringArray, String[] stringArray2, MagicNumberRegistryEntry.MagicNumber[] magicNumberArray) {
        super(string, 1100.0f, stringArray, stringArray2, magicNumberArray);
    }

    public AbstractImageIORegistryEntry(String string, String string2, String string3, int n, byte[] byArray) {
        super(string, 1100.0f, string2, string3, n, byArray);
    }

    public Filter handleStream(InputStream inputStream, ParsedURL parsedURL, boolean bl) {
        Object[] objectArray;
        String string;
        final DeferRable deferRable = new DeferRable();
        final InputStream inputStream2 = inputStream;
        if (parsedURL != null) {
            string = "url.format.unreadable";
            objectArray = new Object[]{this.getFormatName(), parsedURL};
        } else {
            string = "stream.format.unreadable";
            objectArray = new Object[]{this.getFormatName()};
        }
        Thread thread = new Thread(){

            public void run() {
                Filter filter;
                try {
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByMIMEType(AbstractImageIORegistryEntry.this.getMimeTypes().get(0).toString());
                    if (!iterator.hasNext()) {
                        throw new UnsupportedOperationException("No image reader for " + AbstractImageIORegistryEntry.this.getFormatName() + " available!");
                    }
                    ImageReader imageReader = iterator.next();
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream2);
                    imageReader.setInput(imageInputStream, true);
                    int n = 0;
                    deferRable.setBounds(new Rectangle2D.Double(0.0, 0.0, imageReader.getWidth(n), imageReader.getHeight(n)));
                    BufferedImage bufferedImage = imageReader.read(n);
                    CachableRed cachableRed = GraphicsUtil.wrap(bufferedImage);
                    cachableRed = new Any2sRGBRed(cachableRed);
                    cachableRed = new FormatRed(cachableRed, GraphicsUtil.sRGB_Unpre);
                    WritableRaster writableRaster = (WritableRaster)cachableRed.getData();
                    ColorModel colorModel = cachableRed.getColorModel();
                    BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
                    cachableRed = GraphicsUtil.wrap(bufferedImage2);
                    filter = new RedRable(cachableRed);
                }
                catch (IOException iOException) {
                    filter = ImageTagRegistry.getBrokenLinkImage(AbstractImageIORegistryEntry.this, string, objectArray);
                }
                catch (ThreadDeath threadDeath) {
                    Filter filter2 = ImageTagRegistry.getBrokenLinkImage(AbstractImageIORegistryEntry.this, string, objectArray);
                    deferRable.setSource(filter2);
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    filter = ImageTagRegistry.getBrokenLinkImage(AbstractImageIORegistryEntry.this, string, objectArray);
                }
                deferRable.setSource(filter);
            }
        };
        thread.start();
        return deferRable;
    }
}

