/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrExpressionChecker;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrValueAccessScopeChecker;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrExpressionChecker;", "Lorg/jetbrains/kotlin/ir/expressions/IrValueAccessExpression;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrValueAccessChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "ir.backend.common"})
public final class IrValueAccessScopeChecker
implements IrExpressionChecker<IrValueAccessExpression> {
    @NotNull
    public static final IrValueAccessScopeChecker INSTANCE = new IrValueAccessScopeChecker();

    private IrValueAccessScopeChecker() {
    }

    @Override
    public void check(@NotNull IrValueAccessExpression expression2, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!context.getValueSymbolScopeStack().isVisibleInCurrentScope(expression2.getSymbol())) {
            context.error(expression2, "The following expression references a value that is not available in the current scope.");
        }
    }
}

