/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.coyote.ErrorState;
import org.apache.coyote.NonPipeliningProcessor;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.coyote.http2.Http2UpgradeHandler;
import org.apache.coyote.http2.SendfileData;
import org.apache.coyote.http2.Stream;
import org.apache.coyote.http2.StreamException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

class StreamProcessor
extends AbstractProcessor
implements NonPipeliningProcessor {
    private static final Log log = LogFactory.getLog(StreamProcessor.class);
    private static final StringManager sm = StringManager.getManager(StreamProcessor.class);
    private static final Set<String> H2_PSEUDO_HEADERS_REQUEST = new HashSet<String>();
    private final Lock processLock = new ReentrantLock();
    private final Http2UpgradeHandler handler;
    private final Stream stream;
    private SendfileData sendfileData = null;
    private SendfileState sendfileState = null;

    StreamProcessor(Http2UpgradeHandler http2UpgradeHandler, Stream stream, Adapter adapter, SocketWrapperBase<?> socketWrapperBase) {
        super(adapter, stream.getCoyoteRequest(), stream.getCoyoteResponse());
        this.handler = http2UpgradeHandler;
        this.stream = stream;
        this.setSocketWrapper(socketWrapperBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void process(SocketEvent socketEvent) {
        try {
            this.processLock.lock();
            try {
                if (!this.stream.equals(this.handler.getStream(this.stream.getIdAsInt()))) {
                    return;
                }
                AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
                try {
                    socketState = this.process(this.socketWrapper, socketEvent);
                    if (socketState == AbstractEndpoint.Handler.SocketState.LONG) {
                        this.handler.getProtocol().getHttp11Protocol().addWaitingProcessor(this);
                    } else if (socketState == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        this.handler.getProtocol().getHttp11Protocol().removeWaitingProcessor(this);
                        if (!this.stream.isInputFinished() && this.getErrorState().isIoAllowed()) {
                            StreamException streamException = new StreamException(sm.getString("streamProcessor.cancel", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}), Http2Error.NO_ERROR, this.stream.getIdAsInt());
                            this.stream.close(streamException);
                        } else if (!this.getErrorState().isConnectionIoAllowed()) {
                            ConnectionException connectionException = new ConnectionException(sm.getString("streamProcessor.error.connection", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}), Http2Error.INTERNAL_ERROR);
                            this.stream.close(connectionException);
                        } else if (!this.getErrorState().isIoAllowed()) {
                            StreamException streamException = this.stream.getResetException();
                            if (streamException == null) {
                                streamException = new StreamException(sm.getString("streamProcessor.error.stream", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}), Http2Error.INTERNAL_ERROR, this.stream.getIdAsInt());
                            }
                            this.stream.close(streamException);
                        } else if (!this.stream.isActive()) {
                            this.stream.replace();
                        }
                    }
                }
                catch (Exception exception) {
                    String string = sm.getString("streamProcessor.error.connection", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()});
                    if (log.isDebugEnabled()) {
                        log.debug((Object)string, (Throwable)exception);
                    }
                    ConnectionException connectionException = new ConnectionException(string, Http2Error.INTERNAL_ERROR, exception);
                    this.stream.close(connectionException);
                    socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
                }
                finally {
                    if (socketState == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        this.stream.recycle();
                        this.recycle();
                    }
                }
            }
            finally {
                this.processLock.unlock();
            }
        }
        finally {
            this.handler.executeQueuedStream();
        }
    }

    @Override
    protected final void prepareResponse() throws IOException {
        this.response.setCommitted(true);
        if (this.handler.hasAsyncIO() && this.handler.getProtocol().getUseSendfile()) {
            this.prepareSendfile();
        }
        StreamProcessor.prepareHeaders(this.request, this.response, this.sendfileData == null, this.handler.getProtocol(), this.stream);
        this.stream.writeHeaders();
    }

    private void prepareSendfile() {
        String string = (String)this.stream.getCoyoteRequest().getAttribute("org.apache.tomcat.sendfile.filename");
        if (string != null) {
            this.sendfileData = new SendfileData();
            this.sendfileData.path = new File(string).toPath();
            this.sendfileData.pos = (Long)this.stream.getCoyoteRequest().getAttribute("org.apache.tomcat.sendfile.start");
            this.sendfileData.end = (Long)this.stream.getCoyoteRequest().getAttribute("org.apache.tomcat.sendfile.end");
            this.sendfileData.left = this.sendfileData.end - this.sendfileData.pos;
            this.sendfileData.stream = this.stream;
        }
    }

    static void prepareHeaders(Request request, Response response, boolean bl, Http2Protocol http2Protocol, Stream stream) {
        String string;
        MimeHeaders mimeHeaders = response.getMimeHeaders();
        int n = response.getStatus();
        mimeHeaders.addValue(":status").setString(Integer.toString(n));
        if (bl && http2Protocol != null && http2Protocol.useCompression(request, response)) {
            stream.addOutputFilter(new GzipOutputFilter());
        }
        if (n >= 200 && n != 204 && n != 205 && n != 304) {
            long l;
            String string2;
            string = response.getContentType();
            if (string != null) {
                mimeHeaders.setValue("content-type").setString(string);
            }
            if ((string2 = response.getContentLanguage()) != null) {
                mimeHeaders.setValue("content-language").setString(string2);
            }
            if ((l = response.getContentLengthLong()) != -1L && mimeHeaders.getValue("content-length") == null) {
                mimeHeaders.addValue("content-length").setLong(l);
            }
        } else {
            if (stream != null) {
                stream.configureVoidOutputFilter();
            }
            if (n == 205) {
                response.setContentLength(0L);
            } else {
                response.setContentLength(-1L);
            }
        }
        if (n >= 200 && mimeHeaders.getValue("date") == null) {
            mimeHeaders.addValue("date").setString(FastHttpDateFormat.getCurrentDate());
        }
        if (http2Protocol != null) {
            string = ((AbstractHttp11Protocol)http2Protocol.getHttp11Protocol()).getServer();
            if (string == null) {
                if (((AbstractHttp11Protocol)http2Protocol.getHttp11Protocol()).getServerRemoveAppProvidedValues()) {
                    mimeHeaders.removeHeader("server");
                }
            } else {
                mimeHeaders.setValue("Server").setString(string);
            }
        }
    }

    @Override
    protected final void finishResponse() throws IOException {
        this.sendfileState = this.handler.processSendfile(this.sendfileData);
        if (this.sendfileState != SendfileState.PENDING) {
            this.stream.getOutputBuffer().end();
        }
    }

    @Override
    protected final void ack(ContinueResponseTiming continueResponseTiming) {
        if ((continueResponseTiming == ContinueResponseTiming.ALWAYS || continueResponseTiming == this.handler.getProtocol().getContinueResponseTimingInternal()) && !this.response.isCommitted() && this.request.hasExpectation()) {
            try {
                this.stream.writeAck();
            }
            catch (IOException iOException) {
                this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
            }
        }
    }

    @Override
    protected void earlyHints() throws IOException {
        this.stream.writeEarlyHints();
    }

    @Override
    protected final void flush() throws IOException {
        this.stream.getOutputBuffer().flush();
    }

    @Override
    protected final int available(boolean bl) {
        return this.stream.getInputBuffer().available();
    }

    @Override
    protected final void setRequestBody(ByteChunk byteChunk) {
        this.stream.getInputBuffer().insertReplayedBody(byteChunk);
        try {
            this.stream.receivedEndOfStream();
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    @Override
    protected final void setSwallowResponse() {
    }

    @Override
    protected final void disableSwallowRequest() {
    }

    @Override
    protected void processSocketEvent(SocketEvent socketEvent, boolean bl) {
        if (bl) {
            this.handler.processStreamOnContainerThread(this, socketEvent);
        } else {
            this.process(socketEvent);
        }
    }

    @Override
    protected final boolean isReadyForRead() {
        return this.stream.getInputBuffer().isReadyForRead();
    }

    @Override
    protected final boolean isRequestBodyFullyRead() {
        return this.stream.getInputBuffer().isRequestBodyFullyRead();
    }

    @Override
    protected final void registerReadInterest() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final boolean isReadyForWrite() {
        return this.stream.isReadyForWrite();
    }

    @Override
    protected final void executeDispatches() {
        Iterator<DispatchType> iterator = this.getIteratorAndClearDispatches();
        while (iterator != null && iterator.hasNext()) {
            DispatchType dispatchType = iterator.next();
            this.processSocketEvent(dispatchType.getSocketStatus(), true);
        }
    }

    @Override
    protected final boolean isPushSupported() {
        return this.stream.isPushSupported();
    }

    @Override
    protected final void doPush(Request request) {
        try {
            this.stream.push(request);
        }
        catch (IOException iOException) {
            this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
            this.response.setErrorException(iOException);
        }
    }

    @Override
    protected boolean isTrailerFieldsReady() {
        return this.stream.isTrailerFieldsReady();
    }

    @Override
    protected boolean isTrailerFieldsSupported() {
        return this.stream.isTrailerFieldsSupported();
    }

    @Override
    protected Object getConnectionID() {
        return this.stream.getConnectionId();
    }

    @Override
    protected Object getStreamID() {
        return this.stream.getIdAsString().toString();
    }

    @Override
    public final void recycle() {
        RequestGroupInfo requestGroupInfo = this.handler.getProtocol().getGlobal();
        if (requestGroupInfo != null) {
            requestGroupInfo.removeRequestProcessor(this.request.getRequestProcessor());
        }
        this.setSocketWrapper(null);
    }

    @Override
    protected final Log getLog() {
        return log;
    }

    @Override
    public final void pause() {
    }

    @Override
    public final AbstractEndpoint.Handler.SocketState service(SocketWrapperBase<?> socketWrapperBase) throws IOException {
        try {
            if (this.validateRequest()) {
                this.adapter.service(this.request, this.response);
            } else {
                this.response.setStatus(400);
                this.adapter.log(this.request, this.response, 0L);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
            }
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("streamProcessor.service.error"), (Throwable)exception);
            }
            this.response.setStatus(500);
            this.setErrorState(ErrorState.CLOSE_NOW, exception);
        }
        if (this.sendfileState == SendfileState.PENDING) {
            return AbstractEndpoint.Handler.SocketState.SENDFILE;
        }
        if (this.getErrorState().isError()) {
            this.action(ActionCode.CLOSE, null);
            this.request.updateCounters();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.action(ActionCode.CLOSE, null);
        this.request.updateCounters();
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    private boolean validateRequest() {
        HttpParser httpParser = ((AbstractHttp11Protocol)this.handler.getProtocol().getHttp11Protocol()).getHttpParser();
        String string = this.request.method().toString();
        if (!HttpParser.isToken(string)) {
            return false;
        }
        String string2 = this.request.scheme().toString();
        if (!HttpParser.isScheme(string2)) {
            return false;
        }
        ByteChunk byteChunk = this.request.requestURI().getByteChunk();
        for (int i = byteChunk.getStart(); i < byteChunk.getEnd(); ++i) {
            if (!httpParser.isNotRequestTargetRelaxed(byteChunk.getBuffer()[i])) continue;
            return false;
        }
        String string3 = this.request.queryString().toString();
        if (string3 != null) {
            for (char c : string3.toCharArray()) {
                if (httpParser.isQueryRelaxed(c)) continue;
                return false;
            }
        }
        Object object = this.request.getMimeHeaders();
        Enumeration<String> enumeration = ((MimeHeaders)object).names();
        while (enumeration.hasMoreElements()) {
            String string4 = enumeration.nextElement();
            if (H2_PSEUDO_HEADERS_REQUEST.contains(string4) || HttpParser.isToken(string4)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected final boolean flushBufferedWrite() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("streamProcessor.flushBufferedWrite.entry", new Object[]{this.stream.getConnectionId(), this.stream.getIdAsString()}));
        }
        if (this.stream.flush(false)) {
            if (this.stream.isReadyForWrite()) {
                throw new IllegalStateException();
            }
            return true;
        }
        return false;
    }

    @Override
    protected final AbstractEndpoint.Handler.SocketState dispatchEndRequest() throws IOException {
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    public void timeoutAsync(long l) {
        if (this.stream.getInputBuffer().timeoutRead(l)) {
            this.stream.getCoyoteRequest().setAttribute("javax.servlet.error.exception", new SocketTimeoutException(sm.getString("streamProcessor.streamReadTimeout")));
            this.processSocketEvent(SocketEvent.ERROR, true);
        } else {
            super.timeoutAsync(l);
        }
    }

    static {
        H2_PSEUDO_HEADERS_REQUEST.add(":method");
        H2_PSEUDO_HEADERS_REQUEST.add(":scheme");
        H2_PSEUDO_HEADERS_REQUEST.add(":authority");
        H2_PSEUDO_HEADERS_REQUEST.add(":path");
    }
}

