/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagCheckerAsserts;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagCheckerFixCommand;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.mapcss.ConditionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.PlaceholderExpression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.MapCSSParser;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

final class MapCSSTagCheckerRule
implements Predicate<OsmPrimitive> {
    final MapCSSRule rule;
    final List<MapCSSTagCheckerFixCommand> fixCommands;
    final List<String> alternatives;
    final Map<Instruction.AssignmentInstruction, Severity> errors;
    final Collection<String> setClassExpressions;
    boolean deletion;
    String group;
    private static final String POSSIBLE_THROWS = "throwError/throwWarning/throwOther";

    MapCSSTagCheckerRule(MapCSSRule rule) {
        this.rule = rule;
        this.fixCommands = new ArrayList<MapCSSTagCheckerFixCommand>();
        this.alternatives = new ArrayList<String>();
        this.errors = new HashMap<Instruction.AssignmentInstruction, Severity>();
        this.setClassExpressions = new HashSet<String>();
    }

    MapCSSTagCheckerRule(MapCSSTagCheckerRule check) {
        this.rule = check.rule;
        this.fixCommands = Utils.toUnmodifiableList(check.fixCommands);
        this.alternatives = Utils.toUnmodifiableList(check.alternatives);
        this.errors = Utils.toUnmodifiableMap(check.errors);
        this.setClassExpressions = Utils.toUnmodifiableList(check.setClassExpressions);
        this.deletion = check.deletion;
        this.group = check.group;
    }

    MapCSSTagCheckerRule toImmutable() {
        return new MapCSSTagCheckerRule(this);
    }

    static MapCSSTagCheckerRule ofMapCSSRule(MapCSSRule rule, Consumer<String> assertionConsumer) throws IllegalDataException {
        MapCSSTagCheckerRule check = new MapCSSTagCheckerRule(rule);
        HashMap<String, Boolean> assertions = new HashMap<String, Boolean>();
        for (Instruction i : rule.declaration.instructions) {
            if (!(i instanceof Instruction.AssignmentInstruction)) continue;
            Instruction.AssignmentInstruction ai = (Instruction.AssignmentInstruction)i;
            if (ai.isSetInstruction) {
                check.setClassExpressions.add(ai.key);
                continue;
            }
            try {
                String val;
                String string = ai.val instanceof Expression ? (String)Optional.ofNullable(((Expression)ai.val).evaluate(new Environment())).map(Object::toString).map(String::intern).orElse(null) : (ai.val instanceof String ? (String)ai.val : (val = ai.val instanceof Keyword ? ((Keyword)ai.val).val : null));
                if ("throwError".equals(ai.key)) {
                    check.errors.put(ai, Severity.ERROR);
                    continue;
                }
                if ("throwWarning".equals(ai.key)) {
                    check.errors.put(ai, Severity.WARNING);
                    continue;
                }
                if ("throwOther".equals(ai.key)) {
                    check.errors.put(ai, Severity.OTHER);
                    continue;
                }
                if (ai.key.startsWith("throw")) {
                    Logging.log(Logging.LEVEL_WARN, "Unsupported " + ai.key + " instruction. Allowed instructions are throwError/throwWarning/throwOther.", null);
                    continue;
                }
                if ("fixAdd".equals(ai.key)) {
                    check.fixCommands.add(MapCSSTagCheckerFixCommand.fixAdd(ai.val));
                    continue;
                }
                if ("fixRemove".equals(ai.key)) {
                    CheckParameterUtil.ensureThat(!(ai.val instanceof String) || val == null || !val.contains("="), "Unexpected '='. Please only specify the key to remove in: " + ai);
                    check.fixCommands.add(MapCSSTagCheckerFixCommand.fixRemove(ai.val));
                    continue;
                }
                if (val != null && "fixChangeKey".equals(ai.key)) {
                    CheckParameterUtil.ensureThat(val.contains("=>"), "Separate old from new key by '=>'!");
                    String[] x = val.split("=>", 2);
                    String oldKey = Utils.removeWhiteSpaces(x[0]);
                    String newKey = Utils.removeWhiteSpaces(x[1]);
                    check.fixCommands.add(MapCSSTagCheckerFixCommand.fixChangeKey(oldKey, newKey));
                    continue;
                }
                if (val != null && "fixDeleteObject".equals(ai.key)) {
                    CheckParameterUtil.ensureThat("this".equals(val), "fixDeleteObject must be followed by 'this'");
                    check.deletion = true;
                    continue;
                }
                if (val != null && "suggestAlternative".equals(ai.key)) {
                    check.alternatives.add(val);
                    continue;
                }
                if (val != null && "assertMatch".equals(ai.key) && !assertions.containsKey(val)) {
                    assertions.put(val, Boolean.TRUE);
                    continue;
                }
                if (val != null && "assertNoMatch".equals(ai.key) && !assertions.containsKey(val)) {
                    assertions.put(val, Boolean.FALSE);
                    continue;
                }
                if (val != null && "group".equals(ai.key)) {
                    check.group = val;
                    continue;
                }
                if (ai.key.startsWith("-")) {
                    Logging.debug("Ignoring extension instruction: " + ai.key + ": " + ai.val);
                    continue;
                }
                throw new IllegalDataException("Cannot add instruction " + ai.key + ": " + ai.val + "!");
            }
            catch (IllegalArgumentException e) {
                throw new IllegalDataException(e);
            }
        }
        if (check.errors.isEmpty() && check.setClassExpressions.isEmpty()) {
            throw new IllegalDataException("No throwError/throwWarning/throwOther given! You should specify a validation error message for " + rule.selectors);
        }
        if (check.errors.size() > 1) {
            throw new IllegalDataException("More than one throwError/throwWarning/throwOther given! You should specify a single validation error message for " + rule.selectors);
        }
        if (assertionConsumer != null) {
            MapCSSTagCheckerAsserts.checkAsserts(check, assertions, assertionConsumer);
        }
        return check.toImmutable();
    }

    static MapCSSTagChecker.ParseResult readMapCSS(Reader css) throws ParseException {
        return MapCSSTagCheckerRule.readMapCSS(css, null);
    }

    static MapCSSTagChecker.ParseResult readMapCSS(Reader css, Consumer<String> assertionConsumer) throws ParseException {
        CheckParameterUtil.ensureParameterNotNull(css, "css");
        MapCSSStyleSource source = new MapCSSStyleSource("");
        MapCSSParser preprocessor = new MapCSSParser(css, MapCSSParser.LexicalState.PREPROCESSOR);
        try (StringReader mapcss = new StringReader(preprocessor.pp_root(source));){
            new MapCSSParser(mapcss, MapCSSParser.LexicalState.DEFAULT).sheet(source);
        }
        source.removeMetaRules();
        ArrayList<MapCSSTagCheckerRule> parseChecks = new ArrayList<MapCSSTagCheckerRule>();
        for (MapCSSRule rule : source.rules) {
            try {
                parseChecks.add(MapCSSTagCheckerRule.ofMapCSSRule(rule, assertionConsumer));
            }
            catch (IllegalDataException e) {
                Logging.error("Cannot add MapCSS rule: " + e.getMessage());
                source.logError(e);
            }
        }
        return new MapCSSTagChecker.ParseResult(parseChecks, source.getErrors());
    }

    @Override
    public boolean test(OsmPrimitive primitive) {
        return this.whichSelectorMatchesPrimitive(primitive) != null;
    }

    Selector whichSelectorMatchesPrimitive(OsmPrimitive primitive) {
        return this.whichSelectorMatchesEnvironment(new Environment(primitive, new MultiCascade(), "default", null));
    }

    Selector whichSelectorMatchesEnvironment(Environment env) {
        return this.rule.selectors.stream().filter(i -> i.matches(env.clearSelectorMatchingInformation())).findFirst().orElse(null);
    }

    static String insertArguments(Selector matchingSelector, String s, OsmPrimitive p) {
        return PlaceholderExpression.insertArguments(matchingSelector, s, p);
    }

    Command fixPrimitive(OsmPrimitive p) {
        if (p.getDataSet() == null || this.fixCommands.isEmpty() && !this.deletion) {
            return null;
        }
        try {
            Selector matchingSelector = this.whichSelectorMatchesPrimitive(p);
            Collection cmds = this.fixCommands.stream().map(fixCommand -> fixCommand.createCommand(p, matchingSelector)).filter(Objects::nonNull).collect(Collectors.toList());
            if (this.deletion && !p.isDeleted()) {
                cmds.add(new DeleteCommand(p));
            }
            return cmds.isEmpty() ? null : new SequenceCommand(I18n.tr("Fix of {0}", this.getDescriptionForMatchingSelector(p, matchingSelector)), cmds);
        }
        catch (IllegalArgumentException e) {
            Logging.error(e);
            return null;
        }
    }

    String getMessage(Selector selector, OsmPrimitive p) {
        if (this.errors.isEmpty()) {
            return this.rule.declaration.toString();
        }
        Object val = this.errors.keySet().iterator().next().val;
        selector = selector == null && p != null ? this.whichSelectorMatchesPrimitive(p) : selector;
        return String.valueOf(val instanceof Expression ? ((Expression)val).evaluate(new Environment(p).withSelector(selector)) : val);
    }

    String getDescription(Selector selector, OsmPrimitive p) {
        if (this.alternatives.isEmpty()) {
            return this.getMessage(selector, p);
        }
        return I18n.tr("{0}, use {1} instead", this.getMessage(selector, p), String.join((CharSequence)I18n.tr(" or ", new Object[0]), this.alternatives));
    }

    String getDescriptionForMatchingSelector(OsmPrimitive p, Selector matchingSelector) {
        return MapCSSTagCheckerRule.insertArguments(matchingSelector, this.getDescription(matchingSelector, p), p);
    }

    Severity getSeverity() {
        return this.errors.isEmpty() ? null : this.errors.values().iterator().next();
    }

    public String toString() {
        return this.getDescription(null, null);
    }

    List<TestError> getErrorsForPrimitive(OsmPrimitive p, Selector matchingSelector, Environment env, Test tester) {
        ArrayList<TestError> res = new ArrayList<TestError>();
        if (matchingSelector != null && !this.errors.isEmpty()) {
            Command fix = this.fixPrimitive(p);
            String description = this.getDescriptionForMatchingSelector(p, matchingSelector);
            String description1 = this.group == null ? description : this.group;
            String description2 = this.group == null ? null : description;
            String selector = matchingSelector.toString();
            TestError.Builder errorBuilder = TestError.builder(tester, this.getSeverity(), 3000).messageWithManuallyTranslatedDescription(description1, description2, selector);
            if (fix != null) {
                errorBuilder.fix(() -> fix);
            }
            if (env.child instanceof OsmPrimitive) {
                res.add(errorBuilder.primitives(p, (OsmPrimitive)env.child).build());
            } else if (env.children != null) {
                for (IPrimitive c : env.children) {
                    Object is;
                    if (!(c instanceof OsmPrimitive)) continue;
                    errorBuilder = TestError.builder(tester, this.getSeverity(), 3000).messageWithManuallyTranslatedDescription(description1, description2, selector);
                    if (fix != null) {
                        errorBuilder.fix(() -> fix);
                    }
                    boolean hiliteFound = false;
                    if (env.intersections != null && (is = env.intersections.get(c)) != null) {
                        errorBuilder.highlight((Area)is);
                        hiliteFound = true;
                    }
                    if (env.crossingWaysMap != null && !hiliteFound && (is = env.crossingWaysMap.get(c)) != null) {
                        HashSet<WaySegment> toHilite = new HashSet<WaySegment>();
                        for (List wsList : is.values()) {
                            toHilite.addAll(wsList);
                        }
                        errorBuilder.highlightWaySegments(toHilite);
                    }
                    res.add(errorBuilder.primitives(p, (OsmPrimitive)c).build());
                }
            } else if (env.parent != null) {
                boolean imcompletePrimitives = false;
                if (matchingSelector instanceof Selector.ChildOrParentSelector) {
                    Selector right = ((Selector.ChildOrParentSelector)matchingSelector).right;
                    if (right.getConditions().stream().anyMatch(ConditionFactory.ClassCondition.class::isInstance)) {
                        imcompletePrimitives = true;
                    }
                }
                if (imcompletePrimitives) {
                    res.add(errorBuilder.primitives(p).highlight(p).imcompletePrimitives().build());
                } else {
                    res.add(errorBuilder.primitives(p, (OsmPrimitive)env.parent).highlight(p).build());
                }
            } else {
                res.add(errorBuilder.primitives(p).build());
            }
        }
        return res;
    }
}

