# LSP configs

LSP configurations provided by nvim-lspconfig are listed below. This
documentation is autogenerated from the Lua files. You can view this file in
Nvim by running `:help lspconfig-all`.

- [ada_ls](#ada_ls)
- [agda_ls](#agda_ls)
- [aiken](#aiken)
- [air](#air)
- [alloy_ls](#alloy_ls)
- [anakin_language_server](#anakin_language_server)
- [angularls](#angularls)
- [ansiblels](#ansiblels)
- [antlersls](#antlersls)
- [arduino_language_server](#arduino_language_server)
- [asm_lsp](#asm_lsp)
- [ast_grep](#ast_grep)
- [astro](#astro)
- [atlas](#atlas)
- [autohotkey_lsp](#autohotkey_lsp)
- [autotools_ls](#autotools_ls)
- [awk_ls](#awk_ls)
- [azure_pipelines_ls](#azure_pipelines_ls)
- [bacon_ls](#bacon_ls)
- [ballerina](#ballerina)
- [basedpyright](#basedpyright)
- [bashls](#bashls)
- [basics_ls](#basics_ls)
- [bazelrc_lsp](#bazelrc_lsp)
- [beancount](#beancount)
- [bicep](#bicep)
- [biome](#biome)
- [bitbake_language_server](#bitbake_language_server)
- [blueprint_ls](#blueprint_ls)
- [bqls](#bqls)
- [bright_script](#bright_script)
- [bsl_ls](#bsl_ls)
- [buck2](#buck2)
- [buddy_ls](#buddy_ls)
- [buf_ls](#buf_ls)
- [bufls](#bufls)
- [bzl](#bzl)
- [c3_lsp](#c3_lsp)
- [cairo_ls](#cairo_ls)
- [cds_lsp](#cds_lsp)
- [circom-lsp](#circom-lsp)
- [clangd](#clangd)
- [clarity_lsp](#clarity_lsp)
- [clojure_lsp](#clojure_lsp)
- [cmake](#cmake)
- [cobol_ls](#cobol_ls)
- [coffeesense](#coffeesense)
- [contextive](#contextive)
- [coq_lsp](#coq_lsp)
- [crystalline](#crystalline)
- [csharp_ls](#csharp_ls)
- [css_variables](#css_variables)
- [cssls](#cssls)
- [cssmodules_ls](#cssmodules_ls)
- [cucumber_language_server](#cucumber_language_server)
- [cue](#cue)
- [custom_elements_ls](#custom_elements_ls)
- [cypher_ls](#cypher_ls)
- [daedalus_ls](#daedalus_ls)
- [dafny](#dafny)
- [dagger](#dagger)
- [dartls](#dartls)
- [dcmls](#dcmls)
- [debputy](#debputy)
- [denols](#denols)
- [dhall_lsp_server](#dhall_lsp_server)
- [diagnosticls](#diagnosticls)
- [digestif](#digestif)
- [djlsp](#djlsp)
- [docker_compose_language_service](#docker_compose_language_service)
- [dockerls](#dockerls)
- [dolmenls](#dolmenls)
- [dotls](#dotls)
- [dprint](#dprint)
- [ds_pinyin_lsp](#ds_pinyin_lsp)
- [dts_lsp](#dts_lsp)
- [earthlyls](#earthlyls)
- [ecsact](#ecsact)
- [elixirls](#elixirls)
- [elmls](#elmls)
- [elp](#elp)
- [ember](#ember)
- [emmet_language_server](#emmet_language_server)
- [emmet_ls](#emmet_ls)
- [emmylua_ls](#emmylua_ls)
- [erg_language_server](#erg_language_server)
- [erlangls](#erlangls)
- [esbonio](#esbonio)
- [eslint](#eslint)
- [facility_language_server](#facility_language_server)
- [fennel_language_server](#fennel_language_server)
- [fennel_ls](#fennel_ls)
- [fish_lsp](#fish_lsp)
- [flow](#flow)
- [flux_lsp](#flux_lsp)
- [foam_ls](#foam_ls)
- [fortls](#fortls)
- [fsautocomplete](#fsautocomplete)
- [fsharp_language_server](#fsharp_language_server)
- [fstar](#fstar)
- [futhark_lsp](#futhark_lsp)
- [gdscript](#gdscript)
- [gdshader_lsp](#gdshader_lsp)
- [gh_actions_ls](#gh_actions_ls)
- [ghcide](#ghcide)
- [ghdl_ls](#ghdl_ls)
- [ginko_ls](#ginko_ls)
- [gitlab_ci_ls](#gitlab_ci_ls)
- [glasgow](#glasgow)
- [gleam](#gleam)
- [glsl_analyzer](#glsl_analyzer)
- [glslls](#glslls)
- [gnls](#gnls)
- [golangci_lint_ls](#golangci_lint_ls)
- [gopls](#gopls)
- [gradle_ls](#gradle_ls)
- [grammarly](#grammarly)
- [graphql](#graphql)
- [groovyls](#groovyls)
- [guile_ls](#guile_ls)
- [harper_ls](#harper_ls)
- [hdl_checker](#hdl_checker)
- [helm_ls](#helm_ls)
- [hhvm](#hhvm)
- [hie](#hie)
- [hlasm](#hlasm)
- [hls](#hls)
- [hoon_ls](#hoon_ls)
- [html](#html)
- [htmx](#htmx)
- [hydra_lsp](#hydra_lsp)
- [hyprls](#hyprls)
- [idris2_lsp](#idris2_lsp)
- [intelephense](#intelephense)
- [janet_lsp](#janet_lsp)
- [java_language_server](#java_language_server)
- [jdtls](#jdtls)
- [jedi_language_server](#jedi_language_server)
- [jinja_lsp](#jinja_lsp)
- [jqls](#jqls)
- [jsonls](#jsonls)
- [julials](#julials)
- [just](#just)
- [kcl](#kcl)
- [koka](#koka)
- [kotlin_language_server](#kotlin_language_server)
- [kulala_ls](#kulala_ls)
- [lean3ls](#lean3ls)
- [lelwel_ls](#lelwel_ls)
- [lemminx](#lemminx)
- [lexical](#lexical)
- [lsp_ai](#lsp_ai)
- [ltex](#ltex)
- [ltex_plus](#ltex_plus)
- [lua_ls](#lua_ls)
- [luau_lsp](#luau_lsp)
- [lwc_ls](#lwc_ls)
- [m68k](#m68k)
- [markdown_oxide](#markdown_oxide)
- [marko-js](#marko-js)
- [marksman](#marksman)
- [mdx_analyzer](#mdx_analyzer)
- [mesonlsp](#mesonlsp)
- [metals](#metals)
- [millet](#millet)
- [mint](#mint)
- [mlir_lsp_server](#mlir_lsp_server)
- [mlir_pdll_lsp_server](#mlir_pdll_lsp_server)
- [mm0_ls](#mm0_ls)
- [mojo](#mojo)
- [motoko_lsp](#motoko_lsp)
- [move_analyzer](#move_analyzer)
- [msbuild_project_tools_server](#msbuild_project_tools_server)
- [muon](#muon)
- [mutt_ls](#mutt_ls)
- [nelua_lsp](#nelua_lsp)
- [neocmake](#neocmake)
- [nextflow_ls](#nextflow_ls)
- [nextls](#nextls)
- [nginx_language_server](#nginx_language_server)
- [nickel_ls](#nickel_ls)
- [nil_ls](#nil_ls)
- [nim_langserver](#nim_langserver)
- [nimls](#nimls)
- [nixd](#nixd)
- [nomad_lsp](#nomad_lsp)
- [ntt](#ntt)
- [nushell](#nushell)
- [nxls](#nxls)
- [ocamlls](#ocamlls)
- [ocamllsp](#ocamllsp)
- [ols](#ols)
- [omnisharp](#omnisharp)
- [opencl_ls](#opencl_ls)
- [openscad_ls](#openscad_ls)
- [openscad_lsp](#openscad_lsp)
- [pact_ls](#pact_ls)
- [pasls](#pasls)
- [pbls](#pbls)
- [perlls](#perlls)
- [perlnavigator](#perlnavigator)
- [perlpls](#perlpls)
- [pest_ls](#pest_ls)
- [phan](#phan)
- [phpactor](#phpactor)
- [pico8_ls](#pico8_ls)
- [pkgbuild_language_server](#pkgbuild_language_server)
- [please](#please)
- [pli](#pli)
- [poryscript_pls](#poryscript_pls)
- [postgres_lsp](#postgres_lsp)
- [prismals](#prismals)
- [prolog_ls](#prolog_ls)
- [prosemd_lsp](#prosemd_lsp)
- [protols](#protols)
- [psalm](#psalm)
- [pug](#pug)
- [puppet](#puppet)
- [purescriptls](#purescriptls)
- [pylsp](#pylsp)
- [pylyzer](#pylyzer)
- [pyre](#pyre)
- [pyright](#pyright)
- [qmlls](#qmlls)
- [quick_lint_js](#quick_lint_js)
- [r_language_server](#r_language_server)
- [racket_langserver](#racket_langserver)
- [raku_navigator](#raku_navigator)
- [reason_ls](#reason_ls)
- [regal](#regal)
- [regols](#regols)
- [remark_ls](#remark_ls)
- [rescriptls](#rescriptls)
- [rls](#rls)
- [rnix](#rnix)
- [robotcode](#robotcode)
- [robotframework_ls](#robotframework_ls)
- [roc_ls](#roc_ls)
- [rome](#rome)
- [roslyn_ls](#roslyn_ls)
- [rpmspec](#rpmspec)
- [rubocop](#rubocop)
- [ruby_lsp](#ruby_lsp)
- [ruff](#ruff)
- [ruff_lsp](#ruff_lsp)
- [rune_languageserver](#rune_languageserver)
- [rust_analyzer](#rust_analyzer)
- [salt_ls](#salt_ls)
- [scheme_langserver](#scheme_langserver)
- [scry](#scry)
- [selene3p_ls](#selene3p_ls)
- [serve_d](#serve_d)
- [shopify_theme_ls](#shopify_theme_ls)
- [sixtyfps](#sixtyfps)
- [slangd](#slangd)
- [slint_lsp](#slint_lsp)
- [smarty_ls](#smarty_ls)
- [smithy_ls](#smithy_ls)
- [snakeskin_ls](#snakeskin_ls)
- [snyk_ls](#snyk_ls)
- [solang](#solang)
- [solargraph](#solargraph)
- [solc](#solc)
- [solidity](#solidity)
- [solidity_ls](#solidity_ls)
- [solidity_ls_nomicfoundation](#solidity_ls_nomicfoundation)
- [somesass_ls](#somesass_ls)
- [sorbet](#sorbet)
- [sourcekit](#sourcekit)
- [spectral](#spectral)
- [spyglassmc_language_server](#spyglassmc_language_server)
- [sqlls](#sqlls)
- [sqls](#sqls)
- [sqruff](#sqruff)
- [standardrb](#standardrb)
- [starlark_rust](#starlark_rust)
- [starpls](#starpls)
- [statix](#statix)
- [steep](#steep)
- [stimulus_ls](#stimulus_ls)
- [stylelint_lsp](#stylelint_lsp)
- [stylua3p_ls](#stylua3p_ls)
- [superhtml](#superhtml)
- [svelte](#svelte)
- [svlangserver](#svlangserver)
- [svls](#svls)
- [swift_mesonls](#swift_mesonls)
- [syntax_tree](#syntax_tree)
- [systemd_ls](#systemd_ls)
- [tabby_ml](#tabby_ml)
- [tailwindcss](#tailwindcss)
- [taplo](#taplo)
- [tblgen_lsp_server](#tblgen_lsp_server)
- [teal_ls](#teal_ls)
- [templ](#templ)
- [terraform_lsp](#terraform_lsp)
- [terraformls](#terraformls)
- [texlab](#texlab)
- [textlsp](#textlsp)
- [tflint](#tflint)
- [theme_check](#theme_check)
- [thriftls](#thriftls)
- [tilt_ls](#tilt_ls)
- [tinymist](#tinymist)
- [ts_ls](#ts_ls)
- [ts_query_ls](#ts_query_ls)
- [tsp_server](#tsp_server)
- [ttags](#ttags)
- [turbo_ls](#turbo_ls)
- [turtle_ls](#turtle_ls)
- [tvm_ffi_navigator](#tvm_ffi_navigator)
- [twiggy_language_server](#twiggy_language_server)
- [typeprof](#typeprof)
- [typos_lsp](#typos_lsp)
- [typst_lsp](#typst_lsp)
- [uiua](#uiua)
- [ungrammar_languageserver](#ungrammar_languageserver)
- [unison](#unison)
- [unocss](#unocss)
- [uvls](#uvls)
- [v_analyzer](#v_analyzer)
- [vacuum](#vacuum)
- [vala_ls](#vala_ls)
- [vale_ls](#vale_ls)
- [verible](#verible)
- [veridian](#veridian)
- [veryl_ls](#veryl_ls)
- [vhdl_ls](#vhdl_ls)
- [vimls](#vimls)
- [visualforce_ls](#visualforce_ls)
- [vls](#vls)
- [volar](#volar)
- [vscoqtop](#vscoqtop)
- [vtsls](#vtsls)
- [vuels](#vuels)
- [wasm_language_tools](#wasm_language_tools)
- [wgsl_analyzer](#wgsl_analyzer)
- [yamlls](#yamlls)
- [yang_lsp](#yang_lsp)
- [yls](#yls)
- [ziggy](#ziggy)
- [ziggy_schema](#ziggy_schema)
- [zk](#zk)
- [zls](#zls)

## ada_ls

https://github.com/AdaCore/ada_language_server

Installation instructions can be found [here](https://github.com/AdaCore/ada_language_server#Install).

Workspace-specific [settings](https://github.com/AdaCore/ada_language_server/blob/master/doc/settings.md) such as `projectFile` can be provided in a `.als.json` file at the root of the workspace.
Alternatively, configuration may be passed as a "settings" object to `vim.lsp.config('ada_ls', {})`:

```lua
vim.lsp.config('ada_ls', {
    settings = {
      ada = {
        projectFile = "project.gpr";
        scenarioVariables = { ... };
      }
    }
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('ada_ls')
```

Default config:
- `cmd` :
  ```lua
  { "ada_language_server" }
  ```
- `filetypes` :
  ```lua
  { "ada" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/ada_ls.lua:23](../lsp/ada_ls.lua#L23)

---

## agda_ls

https://github.com/agda/agda-language-server

Language Server for Agda.

Snippet to enable the language server:
```lua
vim.lsp.enable('agda_ls')
```

Default config:
- `cmd` :
  ```lua
  { "als" }
  ```
- `filetypes` :
  ```lua
  { "agda" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/agda_ls.lua:9](../lsp/agda_ls.lua#L9)

---

## aiken

https://github.com/aiken-lang/aiken

A language server for Aiken Programming Language.
[Installation](https://aiken-lang.org/installation-instructions)

It can be i

Snippet to enable the language server:
```lua
vim.lsp.enable('aiken')
```

Default config:
- `cmd` :
  ```lua
  { "aiken", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "aiken" }
  ```
- `root_markers` :
  ```lua
  { "aiken.toml", ".git" }
  ```

---

## air

https://github.com/posit-dev/air

Air is an R formatter and language server, written in Rust.

Refer to the [documentation](https://posit-dev.github.io/air/editors.html) for more details.

Snippet to enable the language server:
```lua
vim.lsp.enable('air')
```

Default config:
- `cmd` :
  ```lua
  { "air", "language-server" }
  ```
- `filetypes` :
  ```lua
  { "r" }
  ```
- `root_markers` :
  ```lua
  { "air.toml", ".air.toml", ".git" }
  ```

---

## alloy_ls

https://github.com/AlloyTools/org.alloytools.alloy

Alloy is a formal specification language for describing structures and a tool for exploring them.

You may also need to configure the filetype for Alloy (*.als) files:

```
autocmd BufNewFile,BufRead *.als set filetype=alloy
```

or

```lua
vim.filetype.add({
  pattern = {
    ['.*/*.als'] = 'alloy',
  },
})
```

Alternatively, you may use a syntax plugin like https://github.com/runoshun/vim-alloy.

Snippet to enable the language server:
```lua
vim.lsp.enable('alloy_ls')
```

Default config:
- `cmd` :
  ```lua
  { "alloy", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "alloy" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## anakin_language_server

https://pypi.org/project/anakin-language-server/

`anakin-language-server` is yet another Jedi Python language server.

Available options:

* Initialization: https://github.com/muffinmad/anakin-language-server#initialization-option
* Configuration: https://github.com/muffinmad/anakin-language-server#configuration-options

Snippet to enable the language server:
```lua
vim.lsp.enable('anakin_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "anakinls" }
  ```
- `filetypes` :
  ```lua
  { "python" }
  ```
- `root_markers` :
  ```lua
  { "pyproject.toml", "setup.py", "setup.cfg", "requirements.txt", "Pipfile", ".git" }
  ```
- `settings` :
  ```lua
  {
    anakinls = {
      pyflakes_errors = { "ImportStarNotPermitted", "UndefinedExport", "UndefinedLocal", "UndefinedName", "DuplicateArgument", "MultiValueRepeatedKeyLiteral", "MultiValueRepeatedKeyVariable", "FutureFeatureNotDefined", "LateFutureImport", "ReturnOutsideFunction", "YieldOutsideFunction", "ContinueOutsideLoop", "BreakOutsideLoop", "TwoStarredExpressions", "TooManyExpressionsInStarredAssignment", "ForwardAnnotationSyntaxError", "RaiseNotImplemented", "StringDotFormatExtraPositionalArguments", "StringDotFormatExtraNamedArguments", "StringDotFormatMissingArgument", "StringDotFormatMixingAutomatic", "StringDotFormatInvalidFormat", "PercentFormatInvalidFormat", "PercentFormatMixedPositionalAndNamed", "PercentFormatUnsupportedFormat", "PercentFormatPositionalCountMismatch", "PercentFormatExtraNamedArguments", "PercentFormatMissingArgument", "PercentFormatExpectedMapping", "PercentFormatExpectedSequence", "PercentFormatStarRequiresSequence" }
    }
  }
  ```

---

## angularls

https://github.com/angular/vscode-ng-language-service
`angular-language-server` can be installed via npm `npm install -g @angular/language-server`.

Note, that if you override the default `cmd`, you must also update `on_new_config` to set `new_config.cmd` during startup.

```lua
local project_library_path = "/path/to/project/lib"
local cmd = {"ngserver", "--stdio", "--tsProbeLocations", project_library_path , "--ngProbeLocations", project_library_path}

require'lspconfig'.angularls.setup{
  cmd = cmd,
  on_new_config = function(new_config,new_root_dir)
    new_config.cmd = cmd
  end,
}
```

Snippet to enable the language server:
```lua
vim.lsp.enable('angularls')
```

Default config:
- `cmd` :
  ```lua
  { "ngserver", "--stdio", "--tsProbeLocations", "../..,?/node_modules", "--ngProbeLocations", "../../@angular/language-server/node_modules,?/node_modules/@angular/language-server/node_modules", "--angularCoreVersion", "" }
  ```
- `filetypes` :
  ```lua
  { "typescript", "html", "typescriptreact", "typescript.tsx", "htmlangular" }
  ```
- `root_markers` :
  ```lua
  { "angular.json", "nx.json" }
  ```

---

## ansiblels

https://github.com/ansible/vscode-ansible

Language server for the ansible configuration management tool.

`ansible-language-server` can be installed via `npm`:

```sh
npm install -g @ansible/ansible-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('ansiblels')
```

Default config:
- `cmd` :
  ```lua
  { "ansible-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "yaml.ansible" }
  ```
- `root_markers` :
  ```lua
  { "ansible.cfg", ".ansible-lint" }
  ```
- `settings` :
  ```lua
  {
    ansible = {
      ansible = {
        path = "ansible"
      },
      executionEnvironment = {
        enabled = false
      },
      python = {
        interpreterPath = "python"
      },
      validation = {
        enabled = true,
        lint = {
          enabled = true,
          path = "ansible-lint"
        }
      }
    }
  }
  ```

---

## antlersls

https://www.npmjs.com/package/antlers-language-server

`antlersls` can be installed via `npm`:
```sh
npm install -g antlers-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('antlersls')
```

Default config:
- `cmd` :
  ```lua
  { "antlersls", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "html", "antlers" }
  ```
- `root_markers` :
  ```lua
  { "composer.json" }
  ```

---

## arduino_language_server

https://github.com/arduino/arduino-language-server

Language server for Arduino

The `arduino-language-server` can be installed by running:

```
go install github.com/arduino/arduino-language-server@latest
```

The `arduino-cli` tool must also be installed. Follow [these
installation instructions](https://arduino.github.io/arduino-cli/latest/installation/) for
your platform.

After installing `arduino-cli`, follow [these
instructions](https://arduino.github.io/arduino-cli/latest/getting-started/#create-a-configuration-file)
for generating a configuration file if you haven't done so already, and make
sure you [install any relevant platforms
libraries](https://arduino.github.io/arduino-cli/latest/getting-started/#install-the-core-for-your-board).

The language server also requires `clangd` to be installed. Follow [these
installation instructions](https://clangd.llvm.org/installation) for your
platform.

If you don't have a sketch yet create one.

```sh
$ arduino-cli sketch new test
$ cd test
```

You will need a `sketch.yaml` file in order for the language server to understand your project. It will also save you passing options to `arduino-cli` each time you compile or upload a file. You can generate the file by using the following commands.


First gather some information about your board. Make sure your board is connected and run the following:

```sh
$ arduino-cli board list
Port         Protocol Type              Board Name  FQBN            Core
/dev/ttyACM0 serial   Serial Port (USB) Arduino Uno arduino:avr:uno arduino:avr
```

Then generate the file:

```sh
arduino-cli board attach -p /dev/ttyACM0 -b arduino:avr:uno test.ino
```

The resulting file should look like this:

```yaml
default_fqbn: arduino:avr:uno
default_port: /dev/ttyACM0
```

Your folder structure should look like this:

```
.
├── test.ino
└── sketch.yaml
```

For further instructions about configuration options, run `arduino-language-server --help`.

Note that an upstream bug makes keywords in some cases become undefined by the language server.
Ref: https://github.com/arduino/arduino-ide/issues/159

Snippet to enable the language server:
```lua
vim.lsp.enable('arduino_language_server')
```

Default config:
- `capabilities` :
  ```lua
  {
    textDocument = {
      semanticTokens = vim.NIL
    },
    workspace = {
      semanticTokens = vim.NIL
    }
  }
  ```
- `cmd` :
  ```lua
  { "arduino-language-server" }
  ```
- `filetypes` :
  ```lua
  { "arduino" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/arduino_language_server.lua:73](../lsp/arduino_language_server.lua#L73)

---

## asm_lsp

https://github.com/bergercookie/asm-lsp

Language Server for NASM/GAS/GO Assembly

`asm-lsp` can be installed via cargo:
cargo install asm-lsp

Snippet to enable the language server:
```lua
vim.lsp.enable('asm_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "asm-lsp" }
  ```
- `filetypes` :
  ```lua
  { "asm", "vmasm" }
  ```
- `root_markers` :
  ```lua
  { ".asm-lsp.toml", ".git" }
  ```

---

## ast_grep

https://ast-grep.github.io/

ast-grep(sg) is a fast and polyglot tool for code structural search, lint, rewriting at large scale.
ast-grep LSP only works in projects that have `sgconfig.y[a]ml` in their root directories.
```sh
npm install [-g] @ast-grep/cli
```

Snippet to enable the language server:
```lua
vim.lsp.enable('ast_grep')
```

Default config:
- `cmd` :
  ```lua
  { "ast-grep", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "c", "cpp", "rust", "go", "java", "python", "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx", "html", "css", "kotlin", "dart", "lua" }
  ```
- `root_markers` :
  ```lua
  { "sgconfig.yaml", "sgconfig.yml" }
  ```

---

## astro

https://github.com/withastro/language-tools/tree/main/packages/language-server

`astro-ls` can be installed via `npm`:
```sh
npm install -g @astrojs/language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('astro')
```

Default config:
- `before_init` source (use "gF" to open): [../lsp/astro.lua:15](../lsp/astro.lua#L15)
- `cmd` :
  ```lua
  { "astro-ls", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "astro" }
  ```
- `init_options` :
  ```lua
  {
    typescript = {}
  }
  ```
- `root_markers` :
  ```lua
  { "package.json", "tsconfig.json", "jsconfig.json", ".git" }
  ```

---

## atlas

https://github.com/ariga/atlas

Language server for Atlas config and schema files.

You may also need to configure the filetype for *.hcl files:

```vim
autocmd BufNewFile,BufRead atlas.hcl set filetype=atlas-config
autocmd BufNewFile,BufRead *.my.hcl set filetype=atlas-schema-mysql
autocmd BufNewFile,BufRead *.pg.hcl set filetype=atlas-schema-postgresql
autocmd BufNewFile,BufRead *.lt.hcl set filetype=atlas-schema-sqlite
autocmd BufNewFile,BufRead *.ch.hcl set filetype=atlas-schema-clickhouse
autocmd BufNewFile,BufRead *.ms.hcl set filetype=atlas-schema-mssql
autocmd BufNewFile,BufRead *.rs.hcl set filetype=atlas-schema-redshift
autocmd BufNewFile,BufRead *.test.hcl set filetype=atlas-test
autocmd BufNewFile,BufRead *.plan.hcl set filetype=atlas-plan
autocmd BufNewFile,BufRead *.rule.hcl set filetype=atlas-rule
```

or

```lua
vim.filetype.add({
  filename = {
    ['atlas.hcl'] = 'atlas-config',
  },
  pattern = {
    ['.*/*.my.hcl'] = 'atlas-schema-mysql',
    ['.*/*.pg.hcl'] = 'atlas-schema-postgresql',
    ['.*/*.lt.hcl'] = 'atlas-schema-sqlite',
    ['.*/*.ch.hcl'] = 'atlas-schema-clickhouse',
    ['.*/*.ms.hcl'] = 'atlas-schema-mssql',
    ['.*/*.rs.hcl'] = 'atlas-schema-redshift',
    ['.*/*.test.hcl'] = 'atlas-test',
    ['.*/*.plan.hcl'] = 'atlas-plan',
    ['.*/*.rule.hcl'] = 'atlas-rule',
  },
})
```

Optionally, tell treesitter to treat Atlas filetypes as HCL for better syntax highlighting:

```lua
vim.treesitter.language.register('hcl', 'atlas-config')
vim.treesitter.language.register('hcl', 'atlas-schema-mysql')
vim.treesitter.language.register('hcl', 'atlas-schema-postgresql')
vim.treesitter.language.register('hcl', 'atlas-schema-sqlite')
vim.treesitter.language.register('hcl', 'atlas-schema-clickhouse')
vim.treesitter.language.register('hcl', 'atlas-schema-mssql')
vim.treesitter.language.register('hcl', 'atlas-schema-redshift')
vim.treesitter.language.register('hcl', 'atlas-test')
vim.treesitter.language.register('hcl', 'atlas-plan')
vim.treesitter.language.register('hcl', 'atlas-rule')
```

Snippet to enable the language server:
```lua
vim.lsp.enable('atlas')
```

Default config:
- `cmd` :
  ```lua
  { "atlas", "tool", "lsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "atlas-*" }
  ```
- `root_markers` :
  ```lua
  { "atlas.hcl" }
  ```

---

## autohotkey_lsp

https://github.com/thqby/vscode-autohotkey2-lsp

AutoHotkey v2.0 LSP implementation

NOTE: AutoHotkey is Windows-only.

Snippet to enable the language server:
```lua
vim.lsp.enable('autohotkey_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "autohotkey_lsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "autohotkey" }
  ```
- `flags` :
  ```lua
  {
    debounce_text_changes = 500
  }
  ```
- `init_options` :
  ```lua
  {
    ActionWhenV1IsDetected = "Continue",
    AutoLibInclude = "All",
    CommentTags = "^;;\\s*(?<tag>.+)",
    CompleteFunctionParens = false,
    Diagnostics = {
      ClassStaticMemberCheck = true,
      ParamsCheck = true
    },
    FormatOptions = {
      array_style = "expand",
      brace_style = "One True Brace",
      break_chained_methods = false,
      ignore_comment = false,
      indent_string = "\t",
      max_preserve_newlines = 2,
      object_style = "none",
      preserve_newlines = true,
      space_after_double_colon = true,
      space_before_conditional = true,
      space_in_empty_paren = false,
      space_in_other = true,
      space_in_paren = false,
      wrap_line_length = 0
    },
    InterpreterPath = "",
    SymbolFoldinFromOpenBrace = false,
    locale = "en-us"
  }
  ```
- `root_markers` :
  ```lua
  { "package.json" }
  ```

---

## autotools_ls

https://github.com/Freed-Wu/autotools-language-server

`autotools-language-server` can be installed via `pip`:
```sh
pip install autotools-language-server
```

Language server for autoconf, automake and make using tree sitter in python.

Snippet to enable the language server:
```lua
vim.lsp.enable('autotools_ls')
```

Default config:
- `cmd` :
  ```lua
  { "autotools-language-server" }
  ```
- `filetypes` :
  ```lua
  { "config", "automake", "make" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/autotools_ls.lua:16](../lsp/autotools_ls.lua#L16)

---

## awk_ls

https://github.com/Beaglefoot/awk-language-server/

`awk-language-server` can be installed via `npm`:
```sh
npm install -g awk-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('awk_ls')
```

Default config:
- `cmd` :
  ```lua
  { "awk-language-server" }
  ```
- `filetypes` :
  ```lua
  { "awk" }
  ```

---

## azure_pipelines_ls

https://github.com/microsoft/azure-pipelines-language-server

An Azure Pipelines language server

`azure-pipelines-ls` can be installed via `npm`:

```sh
npm install -g azure-pipelines-language-server
```

By default `azure-pipelines-ls` will only work in files named `azure-pipelines.yml`, this can be changed by providing additional settings like so:
```lua
vim.lsp.config('azure_pipelines_ls', {
  ... -- other configuration for setup {}
  settings = {
      yaml = {
          schemas = {
              ["https://raw.githubusercontent.com/microsoft/azure-pipelines-vscode/master/service-schema.json"] = {
                  "/azure-pipeline*.y*l",
                  "/*.azure*",
                  "Azure-Pipelines/**/*.y*l",
                  "Pipelines/*.y*l",
              },
          },
      },
  },
})
```
The Azure Pipelines LSP is a fork of `yaml-language-server` and as such the same settings can be passed to it as `yaml-language-server`.

Snippet to enable the language server:
```lua
vim.lsp.enable('azure_pipelines_ls')
```

Default config:
- `cmd` :
  ```lua
  { "azure-pipelines-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "yaml" }
  ```
- `root_markers` :
  ```lua
  { "azure-pipelines.yml" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## bacon_ls

https://github.com/crisidev/bacon-ls

A Language Server Protocol wrapper for [bacon](https://dystroy.org/bacon/).
It offers textDocument/diagnostic and workspace/diagnostic capabilities for Rust
workspaces using the Bacon export locations file.

It requires `bacon` and `bacon-ls` to be installed on the system using
[mason.nvim](https://github.com/williamboman/mason.nvim) or manually

```sh
$ cargo install --locked bacon bacon-ls
```

Settings can be changed using the `init_options` dictionary:util

```lua
init_options = {
    -- Bacon export filename (default: .bacon-locations).
    locationsFile = ".bacon-locations",
    -- Try to update diagnostics every time the file is saved (default: true).
    updateOnSave = true,
    --  How many milliseconds to wait before updating diagnostics after a save (default: 1000).
    updateOnSaveWaitMillis = 1000,
    -- Try to update diagnostics every time the file changes (default: true).
    updateOnChange = true,
    -- Try to validate that bacon preferences are setup correctly to work with bacon-ls (default: true).
    validateBaconPreferences = true,
    -- f no bacon preferences file is found, create a new preferences file with the bacon-ls job definition (default: true).
    createBaconPreferencesFile = true,
    -- Run bacon in background for the bacon-ls job (default: true)
    runBaconInBackground = true,
    -- Command line arguments to pass to bacon running in background (default "--headless -j bacon-ls")
    runBaconInBackgroundCommandArguments = "--headless -j bacon-ls",
    -- How many milliseconds to wait between background diagnostics check to synchronize all open files (default: 2000).
    synchronizeAllOpenFilesWaitMillis = 2000,
}
```

Snippet to enable the language server:
```lua
vim.lsp.enable('bacon_ls')
```

Default config:
- `cmd` :
  ```lua
  { "bacon-ls" }
  ```
- `filetypes` :
  ```lua
  { "rust" }
  ```
- `init_options` :
  ```lua
  {}
  ```
- `root_markers` :
  ```lua
  { ".bacon-locations", "Cargo.toml" }
  ```

---

## ballerina

Ballerina language server

The Ballerina language's CLI tool comes with its own language server implementation.
The `bal` command line tool must be installed and available in your system's PATH.

Snippet to enable the language server:
```lua
vim.lsp.enable('ballerina')
```

Default config:
- `cmd` :
  ```lua
  { "bal", "start-language-server" }
  ```
- `filetypes` :
  ```lua
  { "ballerina" }
  ```
- `root_markers` :
  ```lua
  { "Ballerina.toml" }
  ```

---

## basedpyright

https://detachhead.github.io/basedpyright

`basedpyright`, a static type checker and language server for python

Snippet to enable the language server:
```lua
vim.lsp.enable('basedpyright')
```

Default config:
- `cmd` :
  ```lua
  { "basedpyright-langserver", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "python" }
  ```
- `on_attach` source (use "gF" to open): [../lsp/basedpyright.lua:22](../lsp/basedpyright.lua#L22)
- `root_markers` :
  ```lua
  { "pyproject.toml", "setup.py", "setup.cfg", "requirements.txt", "Pipfile", "pyrightconfig.json", ".git" }
  ```
- `settings` :
  ```lua
  {
    basedpyright = {
      analysis = {
        autoSearchPaths = true,
        diagnosticMode = "openFilesOnly",
        useLibraryCodeForTypes = true
      }
    }
  }
  ```

---

## bashls

https://github.com/bash-lsp/bash-language-server

`bash-language-server` can be installed via `npm`:
```sh
npm i -g bash-language-server
```

Language server for bash, written using tree sitter in typescript.

Snippet to enable the language server:
```lua
vim.lsp.enable('bashls')
```

Default config:
- `cmd` :
  ```lua
  { "bash-language-server", "start" }
  ```
- `filetypes` :
  ```lua
  { "bash", "sh" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {
    bashIde = {
      globPattern = "*@(.sh|.inc|.bash|.command)"
    }
  }
  ```

---

## basics_ls

https://github.com/antonk52/basics-language-server/

Buffer, path, and snippet completion

```sh
npm install -g basics-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('basics_ls')
```

Default config:
- `cmd` :
  ```lua
  { "basics-language-server" }
  ```
- `settings` :
  ```lua
  {
    buffer = {
      enable = true,
      minCompletionLength = 4
    },
    path = {
      enable = true
    },
    snippet = {
      enable = false,
      sources = {}
    }
  }
  ```

---

## bazelrc_lsp

https://github.com/salesforce-misc/bazelrc-lsp

`bazelrc-lsp` is a LSP for `.bazelrc` configuration files.

The `.bazelrc` file type is not detected automatically, you can register it manually (see below) or override the filetypes:

```lua
vim.filetype.add {
  pattern = {
    ['.*.bazelrc'] = 'bazelrc',
  },
}
```

Snippet to enable the language server:
```lua
vim.lsp.enable('bazelrc_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "bazelrc-lsp", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "bazelrc" }
  ```
- `root_markers` :
  ```lua
  { "WORKSPACE", "WORKSPACE.bazel", "MODULE.bazel" }
  ```

---

## beancount

https://github.com/polarmutex/beancount-language-server#installation

See https://github.com/polarmutex/beancount-language-server#configuration for configuration options

Snippet to enable the language server:
```lua
vim.lsp.enable('beancount')
```

Default config:
- `cmd` :
  ```lua
  { "beancount-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "beancount", "bean" }
  ```
- `init_options` :
  ```lua
  {}
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## bicep

https://github.com/azure/bicep
Bicep language server

Bicep language server can be installed by downloading and extracting a release of bicep-langserver.zip from [Bicep GitHub releases](https://github.com/Azure/bicep/releases).

Bicep language server requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

Neovim does not have built-in support for the bicep filetype which is required for lspconfig to automatically launch the language server.

Filetype detection can be added via an autocmd:
```lua
vim.cmd [[ autocmd BufNewFile,BufRead *.bicep set filetype=bicep ]]
```

**By default, bicep language server does not have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of the unzipped run script or binary.

```lua
local bicep_lsp_bin = "/path/to/bicep-langserver/Bicep.LangServer.dll"
vim.lsp.config('bicep', {
    cmd = { "dotnet", bicep_lsp_bin };
    ...
})
```

To download the latest release and place in /usr/local/bin/bicep-langserver:
```bash
(cd $(mktemp -d) \
    && curl -fLO https://github.com/Azure/bicep/releases/latest/download/bicep-langserver.zip \
    && rm -rf /usr/local/bin/bicep-langserver \
    && unzip -d /usr/local/bin/bicep-langserver bicep-langserver.zip)
```

Snippet to enable the language server:
```lua
vim.lsp.enable('bicep')
```

Default config:
- `filetypes` :
  ```lua
  { "bicep" }
  ```
- `init_options` :
  ```lua
  {}
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## biome

https://biomejs.dev

Toolchain of the web. [Successor of Rome](https://biomejs.dev/blog/annoucing-biome).

```sh
npm install [-g] @biomejs/biome
```

Snippet to enable the language server:
```lua
vim.lsp.enable('biome')
```

Default config:
- `cmd` :
  ```lua
  { "biome", "lsp-proxy" }
  ```
- `filetypes` :
  ```lua
  { "astro", "css", "graphql", "javascript", "javascriptreact", "json", "jsonc", "svelte", "typescript", "typescript.tsx", "typescriptreact", "vue" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/biome.lua:12](../lsp/biome.lua#L12)
- `workspace_required` : `true`

---

## bitbake_language_server

🛠️ bitbake language server

Snippet to enable the language server:
```lua
vim.lsp.enable('bitbake_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "bitbake-language-server" }
  ```
- `filetypes` :
  ```lua
  { "bitbake" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## blueprint_ls

https://gitlab.gnome.org/jwestman/blueprint-compiler

`blueprint-compiler` can be installed via your system package manager.

Language server for the blueprint markup language, written in python and part
of the blueprint-compiler.

Snippet to enable the language server:
```lua
vim.lsp.enable('blueprint_ls')
```

Default config:
- `cmd` :
  ```lua
  { "blueprint-compiler", "lsp" }
  ```
- `cmd_env` :
  ```lua
  {
    GLOB_PATTERN = "*@(.blp)"
  }
  ```
- `filetypes` :
  ```lua
  { "blueprint" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## bqls

https://github.com/kitagry/bqls

The `bqls` BigQuery language server can be installed by running:

```sh
$ go install github.com/kitagry/bqls@latest
```

Snippet to enable the language server:
```lua
vim.lsp.enable('bqls')
```

Default config:
- `cmd` :
  ```lua
  { "bqls" }
  ```
- `filetypes` :
  ```lua
  { "sql" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## bright_script

https://github.com/RokuCommunity/brighterscript

`brightscript` can be installed via `npm`:
```sh
npm install -g brighterscript
```

Snippet to enable the language server:
```lua
vim.lsp.enable('bright_script')
```

Default config:
- `cmd` :
  ```lua
  { "bsc", "--lsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "brs" }
  ```
- `root_markers` :
  ```lua
  { "makefile", "Makefile", ".git" }
  ```
- `single_file_support` : `true`

---

## bsl_ls

https://github.com/1c-syntax/bsl-language-server

Language Server Protocol implementation for 1C (BSL) - 1C:Enterprise 8 and OneScript languages.

Snippet to enable the language server:
```lua
vim.lsp.enable('bsl_ls')
```

Default config:
- `filetypes` :
  ```lua
  { "bsl", "os" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## buck2

https://github.com/facebook/buck2

Build system, successor to Buck

To better detect Buck2 project files, the following can be added:

```
vim.cmd [[ autocmd BufRead,BufNewFile *.bxl,BUCK,TARGETS set filetype=bzl ]]
```

Snippet to enable the language server:
```lua
vim.lsp.enable('buck2')
```

Default config:
- `cmd` :
  ```lua
  { "buck2", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "bzl" }
  ```
- `root_markers` :
  ```lua
  { ".buckconfig" }
  ```

---

## buddy_ls

https://github.com/buddy-compiler/buddy-mlir#buddy-lsp-server
The Language Server for the buddy-mlir, a drop-in replacement for mlir-lsp-server,
supporting new dialects defined in buddy-mlir.
`buddy-lsp-server` can be installed at the buddy-mlir repository (buddy-compiler/buddy-mlir)

Snippet to enable the language server:
```lua
vim.lsp.enable('buddy_ls')
```

Default config:
- `cmd` :
  ```lua
  { "buddy-lsp-server" }
  ```
- `filetypes` :
  ```lua
  { "mlir" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## buf_ls

https://github.com/bufbuild/buf

buf beta lsp included in the cli itself

buf beta lsp is a Protobuf language server compatible with Buf modules and workspaces

Snippet to enable the language server:
```lua
vim.lsp.enable('buf_ls')
```

Default config:
- `cmd` :
  ```lua
  { "buf", "beta", "lsp", "--timeout=0", "--log-format=text" }
  ```
- `filetypes` :
  ```lua
  { "proto" }
  ```
- `root_markers` :
  ```lua
  { "buf.yaml", ".git" }
  ```

---

## bufls

https://github.com/bufbuild/buf-language-server

`buf-language-server` can be installed via `go install`:
```sh
go install github.com/bufbuild/buf-language-server/cmd/bufls@latest
```

bufls is a Protobuf language server compatible with Buf modules and workspaces

Snippet to enable the language server:
```lua
vim.lsp.enable('bufls')
```

Default config:
- `cmd` :
  ```lua
  { "bufls", "serve" }
  ```
- `filetypes` :
  ```lua
  { "proto" }
  ```
- `root_markers` :
  ```lua
  { "buf.work.yaml", ".git" }
  ```

---

## bzl

https://bzl.io/

https://docs.stack.build/docs/cli/installation

https://docs.stack.build/docs/vscode/starlark-language-server

Snippet to enable the language server:
```lua
vim.lsp.enable('bzl')
```

Default config:
- `cmd` :
  ```lua
  { "bzl", "lsp", "serve" }
  ```
- `filetypes` :
  ```lua
  { "bzl" }
  ```
- `root_markers` :
  ```lua
  { "WORKSPACE", "WORKSPACE.bazel" }
  ```

---

## c3_lsp

https://github.com/pherrymason/c3-lsp

Language Server for c3.

Snippet to enable the language server:
```lua
vim.lsp.enable('c3_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "c3lsp" }
  ```
- `filetypes` :
  ```lua
  { "c3", "c3i" }
  ```
- `root_markers` :
  ```lua
  { "project.json", "manifest.json", ".git" }
  ```

---

## cairo_ls

[Cairo Language Server](https://github.com/starkware-libs/cairo/tree/main/crates/cairo-lang-language-server)

First, install Cairo following [this tutorial](https://book.cairo-lang.org/ch01-01-installation.html)

Then enable Cairo Language Server in your Lua configuration.
```lua
vim.lsp.enable('cairo_ls')
```

*cairo-language-server is still under active development, some features might not work yet !*

Snippet to enable the language server:
```lua
vim.lsp.enable('cairo_ls')
```

Default config:
- `cmd` :
  ```lua
  { "scarb-cairo-language-server", "/C", "--node-ipc" }
  ```
- `filetypes` :
  ```lua
  { "cairo" }
  ```
- `init_options` :
  ```lua
  {
    hostInfo = "neovim"
  }
  ```
- `root_markers` :
  ```lua
  { "Scarb.toml", "cairo_project.toml", ".git" }
  ```

---

## cds_lsp

https://cap.cloud.sap/docs/

`cds-lsp` can be installed via `npm`:

```sh
npm i -g @sap/cds-lsp
```

Snippet to enable the language server:
```lua
vim.lsp.enable('cds_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "cds-lsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "cds" }
  ```
- `root_markers` :
  ```lua
  { "package.json", "db", "srv" }
  ```
- `settings` :
  ```lua
  {
    cds = {
      validate = true
    }
  }
  ```

---

## circom-lsp

[Circom Language Server](https://github.com/rubydusa/circom-lsp)

`circom-lsp`, the language server for the Circom language.

Snippet to enable the language server:
```lua
vim.lsp.enable('circom-lsp')
```

Default config:
- `cmd` :
  ```lua
  { "circom-lsp" }
  ```
- `filetypes` :
  ```lua
  { "circom" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## clangd

https://clangd.llvm.org/installation.html

- **NOTE:** Clang >= 11 is recommended! See [#23](https://github.com/neovim/nvim-lspconfig/issues/23).
- If `compile_commands.json` lives in a build directory, you should
  symlink it to the root of your source tree.
  ```
  ln -s /path/to/myproject/build/compile_commands.json /path/to/myproject/
  ```
- clangd relies on a [JSON compilation database](https://clang.llvm.org/docs/JSONCompilationDatabase.html)
  specified as compile_commands.json, see https://clangd.llvm.org/installation#compile_commandsjson

Snippet to enable the language server:
```lua
vim.lsp.enable('clangd')
```

Default config:
- `capabilities` :
  ```lua
  {
    offsetEncoding = { "utf-8", "utf-16" },
    textDocument = {
      completion = {
        editsNearCursor = true
      }
    }
  }
  ```
- `cmd` :
  ```lua
  { "clangd" }
  ```
- `filetypes` :
  ```lua
  { "c", "cpp", "objc", "objcpp", "cuda", "proto" }
  ```
- `on_attach` source (use "gF" to open): [../lsp/clangd.lua:60](../lsp/clangd.lua#L60)
- `root_markers` :
  ```lua
  { ".clangd", ".clang-tidy", ".clang-format", "compile_commands.json", "compile_flags.txt", "configure.ac", ".git" }
  ```

---

## clarity_lsp

`clarity-lsp` is a language server for the Clarity language. Clarity is a decidable smart contract language that optimizes for predictability and security. Smart contracts allow developers to encode essential business logic on a blockchain.

 To learn how to configure the clarity language server, see the [clarity-lsp documentation](https://github.com/hirosystems/clarity-lsp).

Snippet to enable the language server:
```lua
vim.lsp.enable('clarity_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "clarity-lsp" }
  ```
- `filetypes` :
  ```lua
  { "clar", "clarity" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## clojure_lsp

https://github.com/clojure-lsp/clojure-lsp

Clojure Language Server

Snippet to enable the language server:
```lua
vim.lsp.enable('clojure_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "clojure-lsp" }
  ```
- `filetypes` :
  ```lua
  { "clojure", "edn" }
  ```
- `root_markers` :
  ```lua
  { "project.clj", "deps.edn", "build.boot", "shadow-cljs.edn", ".git", "bb.edn" }
  ```

---

## cmake

https://github.com/regen100/cmake-language-server

CMake LSP Implementation

Snippet to enable the language server:
```lua
vim.lsp.enable('cmake')
```

Default config:
- `cmd` :
  ```lua
  { "cmake-language-server" }
  ```
- `filetypes` :
  ```lua
  { "cmake" }
  ```
- `init_options` :
  ```lua
  {
    buildDirectory = "build"
  }
  ```
- `root_markers` :
  ```lua
  { "CMakePresets.json", "CTestConfig.cmake", ".git", "build", "cmake" }
  ```

---

## cobol_ls

Cobol language support

Snippet to enable the language server:
```lua
vim.lsp.enable('cobol_ls')
```

Default config:
- `cmd` :
  ```lua
  { "cobol-language-support" }
  ```
- `filetypes` :
  ```lua
  { "cobol" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## coffeesense

https://github.com/phil294/coffeesense

CoffeeSense Language Server
`coffeesense-language-server` can be installed via `npm`:
```sh
npm install -g coffeesense-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('coffeesense')
```

Default config:
- `cmd` :
  ```lua
  { "coffeesense-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "coffee" }
  ```
- `root_markers` :
  ```lua
  { "package.json" }
  ```

---

## contextive

https://github.com/dev-cycles/contextive

Language Server for Contextive.

Contextive allows you to define terms in a central file and provides auto-completion suggestions and hover panels for these terms wherever they're used.

To install the language server, you need to download the appropriate [GitHub release asset](https://github.com/dev-cycles/contextive/releases/) for your operating system and architecture.

After the download unzip the Contextive.LanguageServer binary and copy the file into a folder that is included in your system's PATH.

Snippet to enable the language server:
```lua
vim.lsp.enable('contextive')
```

Default config:
- `cmd` :
  ```lua
  { "Contextive.LanguageServer" }
  ```
- `root_markers` :
  ```lua
  { ".contextive", ".git" }
  ```

---

## coq_lsp

https://github.com/ejgallego/coq-lsp/

Snippet to enable the language server:
```lua
vim.lsp.enable('coq_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "coq-lsp" }
  ```
- `filetypes` :
  ```lua
  { "coq" }
  ```
- `root_markers` :
  ```lua
  { "_CoqProject", ".git" }
  ```

---

## crystalline

https://github.com/elbywan/crystalline

Crystal language server.

Snippet to enable the language server:
```lua
vim.lsp.enable('crystalline')
```

Default config:
- `cmd` :
  ```lua
  { "crystalline" }
  ```
- `filetypes` :
  ```lua
  { "crystal" }
  ```
- `root_markers` :
  ```lua
  { "shard.yml", ".git" }
  ```

---

## csharp_ls

https://github.com/razzmatazz/csharp-language-server

Language Server for C#.

csharp-ls requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

The preferred way to install csharp-ls is with `dotnet tool install --global csharp-ls`.

Snippet to enable the language server:
```lua
vim.lsp.enable('csharp_ls')
```

Default config:
- `cmd` :
  ```lua
  { "csharp-ls" }
  ```
- `filetypes` :
  ```lua
  { "cs" }
  ```
- `init_options` :
  ```lua
  {
    AutomaticWorkspaceInit = true
  }
  ```
- `root_dir` source (use "gF" to open): [../lsp/csharp_ls.lua:13](../lsp/csharp_ls.lua#L13)

---

## css_variables

https://github.com/vunguyentuan/vscode-css-variables/tree/master/packages/css-variables-language-server

CSS variables autocompletion and go-to-definition

`css-variables-language-server` can be installed via `npm`:

```sh
npm i -g css-variables-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('css_variables')
```

Default config:
- `cmd` :
  ```lua
  { "css-variables-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "css", "scss", "less" }
  ```
- `root_markers` :
  ```lua
  { "package.json", ".git" }
  ```
- `settings` :
  ```lua
  {
    cssVariables = {
      blacklistFolders = { "**/.cache", "**/.DS_Store", "**/.git", "**/.hg", "**/.next", "**/.svn", "**/bower_components", "**/CVS", "**/dist", "**/node_modules", "**/tests", "**/tmp" },
      lookupFiles = { "**/*.less", "**/*.scss", "**/*.sass", "**/*.css" }
    }
  }
  ```

---

## cssls

https://github.com/hrsh7th/vscode-langservers-extracted

`css-languageserver` can be installed via `npm`:

```sh
npm i -g vscode-langservers-extracted
```

Neovim does not currently include built-in snippets. `vscode-css-language-server` only provides completions when snippet support is enabled. To enable completion, install a snippet plugin and add the following override to your language client capabilities during setup.

```lua
--Enable (broadcasting) snippet capability for completion
local capabilities = vim.lsp.protocol.make_client_capabilities()
capabilities.textDocument.completion.completionItem.snippetSupport = true

vim.lsp.config('cssls', {
  capabilities = capabilities,
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('cssls')
```

Default config:
- `cmd` :
  ```lua
  { "vscode-css-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "css", "scss", "less" }
  ```
- `init_options` :
  ```lua
  {
    provideFormatter = true
  }
  ```
- `root_markers` :
  ```lua
  { "package.json", ".git" }
  ```
- `settings` :
  ```lua
  {
    css = {
      validate = true
    },
    less = {
      validate = true
    },
    scss = {
      validate = true
    }
  }
  ```

---

## cssmodules_ls

https://github.com/antonk52/cssmodules-language-server

Language server for autocompletion and go-to-definition functionality for CSS modules.

You can install cssmodules-language-server via npm:
```sh
npm install -g cssmodules-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('cssmodules_ls')
```

Default config:
- `cmd` :
  ```lua
  { "cssmodules-language-server" }
  ```
- `filetypes` :
  ```lua
  { "javascript", "javascriptreact", "typescript", "typescriptreact" }
  ```
- `root_markers` :
  ```lua
  { "package.json" }
  ```

---

## cucumber_language_server

https://cucumber.io
https://github.com/cucumber/common
https://www.npmjs.com/package/@cucumber/language-server

Language server for Cucumber.

`cucumber-language-server` can be installed via `npm`:
```sh
npm install -g @cucumber/language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('cucumber_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "cucumber-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "cucumber" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## cue

https://github.com/cue-lang/cue

CUE makes it easy to validate data, write schemas, and ensure configurations align with policies.

Snippet to enable the language server:
```lua
vim.lsp.enable('cue')
```

Default config:
- `cmd` :
  ```lua
  { "cue", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "cue" }
  ```
- `root_markers` :
  ```lua
  { "cue.mod", ".git" }
  ```

---

## custom_elements_ls

https://github.com/Matsuuu/custom-elements-language-server

`custom-elements-languageserver` depends on `typescript`. Both packages can be installed via `npm`:
```sh
npm install -g typescript custom-elements-languageserver
```
To configure typescript language server, add a
[`tsconfig.json`](https://www.typescriptlang.org/docs/handbook/tsconfig-json.html) or
[`jsconfig.json`](https://code.visualstudio.com/docs/languages/jsconfig) to the root of your
project.
Here's an example that disables type checking in JavaScript files.
```json
{
  "compilerOptions": {
    "module": "commonjs",
    "target": "es6",
    "checkJs": false
  },
  "exclude": [
    "node_modules"
  ]
}
```

Snippet to enable the language server:
```lua
vim.lsp.enable('custom_elements_ls')
```

Default config:
- `cmd` :
  ```lua
  { "custom-elements-languageserver", "--stdio" }
  ```
- `init_options` :
  ```lua
  {
    hostInfo = "neovim"
  }
  ```
- `root_dir` source (use "gF" to open): [../lsp/custom_elements_ls.lua:26](../lsp/custom_elements_ls.lua#L26)

---

## cypher_ls

https://github.com/neo4j/cypher-language-support/tree/main/packages/language-server

`cypher-language-server`, language server for Cypher query language.
Part of the umbrella project cypher-language-support: https://github.com/neo4j/cypher-language-support

`cypher-language-server` can be installed via `npm`:
```sh
npm i -g @neo4j-cypher/language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('cypher_ls')
```

Default config:
- `cmd` :
  ```lua
  { "cypher-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "cypher" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## daedalus_ls

DaedalusLanguageServer

Snippet to enable the language server:
```lua
vim.lsp.enable('daedalus_ls')
```

Default config:
- `cmd` :
  ```lua
  { "DaedalusLanguageServer" }
  ```
- `filetypes` :
  ```lua
  { "d" }
  ```
- `root_markers` :
  ```lua
  { "Gothic.src", "Camera.src", "Menu.src", "Music.src", "ParticleFX.src", "SFX.src", "VisualFX.src" }
  ```
- `settings` :
  ```lua
  {
    DaedalusLanguageServer = {
      fileEncoding = "Windows-1252",
      inlayHints = {
        constants = true
      },
      loglevel = "debug",
      numParserThreads = 16,
      srcFileEncoding = "Windows-1252"
    }
  }
  ```

---

## dafny

Support for the Dafny language server.

Snippet to enable the language server:
```lua
vim.lsp.enable('dafny')
```

Default config:
- `cmd` :
  ```lua
  { "dafny", "server" }
  ```
- `filetypes` :
  ```lua
  { "dfy", "dafny" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## dagger

https://github.com/dagger/cuelsp

Dagger's lsp server for cuelang.

Snippet to enable the language server:
```lua
vim.lsp.enable('dagger')
```

Default config:
- `cmd` :
  ```lua
  { "cuelsp" }
  ```
- `filetypes` :
  ```lua
  { "cue" }
  ```
- `root_markers` :
  ```lua
  { "cue.mod", ".git" }
  ```

---

## dartls

https://github.com/dart-lang/sdk/tree/master/pkg/analysis_server/tool/lsp_spec

Language server for dart.

Snippet to enable the language server:
```lua
vim.lsp.enable('dartls')
```

Default config:
- `cmd` :
  ```lua
  { "dart", "language-server", "--protocol=lsp" }
  ```
- `filetypes` :
  ```lua
  { "dart" }
  ```
- `init_options` :
  ```lua
  {
    closingLabels = true,
    flutterOutline = true,
    onlyAnalyzeProjectsWithOpenFiles = true,
    outline = true,
    suggestFromUnimportedLibraries = true
  }
  ```
- `root_markers` :
  ```lua
  { "pubspec.yaml" }
  ```
- `settings` :
  ```lua
  {
    dart = {
      completeFunctionCalls = true,
      showTodos = true
    }
  }
  ```

---

## dcmls

https://dcm.dev/

Language server for DCM analyzer.

Snippet to enable the language server:
```lua
vim.lsp.enable('dcmls')
```

Default config:
- `cmd` :
  ```lua
  { "dcm", "start-server", "--client=neovim" }
  ```
- `filetypes` :
  ```lua
  { "dart" }
  ```
- `root_markers` :
  ```lua
  { "pubspec.yaml" }
  ```

---

## debputy

https://salsa.debian.org/debian/debputy

Language Server for Debian packages.

Snippet to enable the language server:
```lua
vim.lsp.enable('debputy')
```

Default config:
- `cmd` :
  ```lua
  { "debputy", "lsp", "server" }
  ```
- `filetypes` :
  ```lua
  { "debcontrol", "debcopyright", "debchangelog", "make", "yaml" }
  ```
- `root_markers` :
  ```lua
  { "debian" }
  ```

---

## denols

https://github.com/denoland/deno

Deno's built-in language server

To appropriately highlight codefences returned from denols, you will need to augment vim.g.markdown_fenced languages
 in your init.lua. Example:

```lua
vim.g.markdown_fenced_languages = {
  "ts=typescript"
}
```

Snippet to enable the language server:
```lua
vim.lsp.enable('denols')
```

Default config:
- `cmd` :
  ```lua
  { "deno", "lsp" }
  ```
- `cmd_env` :
  ```lua
  {
    NO_COLOR = true
  }
  ```
- `filetypes` :
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx" }
  ```
- `handlers` :
  ```lua
  {
    ["textDocument/definition"] = <function 1>,
    ["textDocument/references"] = <function 1>,
    ["textDocument/typeDefinition"] = <function 1>
  }
  ```
- `on_attach` source (use "gF" to open): [../lsp/denols.lua:66](../lsp/denols.lua#L66)
- `root_markers` :
  ```lua
  { "deno.json", "deno.jsonc", ".git" }
  ```
- `settings` :
  ```lua
  {
    deno = {
      enable = true,
      suggest = {
        imports = {
          hosts = {
            ["https://deno.land"] = true
          }
        }
      }
    }
  }
  ```

---

## dhall_lsp_server

https://github.com/dhall-lang/dhall-haskell/tree/master/dhall-lsp-server

language server for dhall

`dhall-lsp-server` can be installed via cabal:
```sh
cabal install dhall-lsp-server
```
prebuilt binaries can be found [here](https://github.com/dhall-lang/dhall-haskell/releases).

Snippet to enable the language server:
```lua
vim.lsp.enable('dhall_lsp_server')
```

Default config:
- `cmd` :
  ```lua
  { "dhall-lsp-server" }
  ```
- `filetypes` :
  ```lua
  { "dhall" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## diagnosticls

https://github.com/iamcco/diagnostic-languageserver

Diagnostic language server integrate with linters.

Snippet to enable the language server:
```lua
vim.lsp.enable('diagnosticls')
```

Default config:
- `cmd` :
  ```lua
  { "diagnostic-languageserver", "--stdio" }
  ```
- `filetypes` :
  ```lua
  {}
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## digestif

https://github.com/astoff/digestif

Digestif is a code analyzer, and a language server, for LaTeX, ConTeXt et caterva. It provides

context-sensitive completion, documentation, code navigation, and related functionality to any

text editor that speaks the LSP protocol.

Snippet to enable the language server:
```lua
vim.lsp.enable('digestif')
```

Default config:
- `cmd` :
  ```lua
  { "digestif" }
  ```
- `filetypes` :
  ```lua
  { "tex", "plaintex", "context" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## djlsp

https://github.com/fourdigits/django-template-lsp

`djlsp`, a language server for Django templates.

Snippet to enable the language server:
```lua
vim.lsp.enable('djlsp')
```

Default config:
- `cmd` :
  ```lua
  { "djlsp" }
  ```
- `filetypes` :
  ```lua
  { "html", "htmldjango" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## docker_compose_language_service

https://github.com/microsoft/compose-language-service
This project contains a language service for Docker Compose.

`compose-language-service` can be installed via `npm`:

```sh
npm install @microsoft/compose-language-service
```

Note: If the docker-compose-langserver doesn't startup when entering a `docker-compose.yaml` file, make sure that the filetype is `yaml.docker-compose`. You can set with: `:set filetype=yaml.docker-compose`.

Snippet to enable the language server:
```lua
vim.lsp.enable('docker_compose_language_service')
```

Default config:
- `cmd` :
  ```lua
  { "docker-compose-langserver", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "yaml.docker-compose" }
  ```
- `root_markers` :
  ```lua
  { "docker-compose.yaml", "docker-compose.yml", "compose.yaml", "compose.yml" }
  ```

---

## dockerls

https://github.com/rcjsuen/dockerfile-language-server-nodejs

`docker-langserver` can be installed via `npm`:
```sh
npm install -g dockerfile-language-server-nodejs
```

Additional configuration can be applied in the following way:
```lua
vim.lsp.config('dockerls', {
    settings = {
        docker = {
	    languageserver = {
	        formatter = {
		    ignoreMultilineInstructions = true,
		},
	    },
	}
    }
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('dockerls')
```

Default config:
- `cmd` :
  ```lua
  { "docker-langserver", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "dockerfile" }
  ```
- `root_markers` :
  ```lua
  { "Dockerfile" }
  ```

---

## dolmenls

https://github.com/Gbury/dolmen/blob/master/doc/lsp.md

`dolmenls` can be installed via `opam`
```sh
opam install dolmen_lsp
```

Snippet to enable the language server:
```lua
vim.lsp.enable('dolmenls')
```

Default config:
- `cmd` :
  ```lua
  { "dolmenls" }
  ```
- `filetypes` :
  ```lua
  { "smt2", "tptp", "p", "cnf", "icnf", "zf" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## dotls

https://github.com/nikeee/dot-language-server

`dot-language-server` can be installed via `npm`:
```sh
npm install -g dot-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('dotls')
```

Default config:
- `cmd` :
  ```lua
  { "dot-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "dot" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## dprint

https://github.com/dprint/dprint

Pluggable and configurable code formatting platform written in Rust.

Snippet to enable the language server:
```lua
vim.lsp.enable('dprint')
```

Default config:
- `cmd` :
  ```lua
  { "dprint", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "javascript", "javascriptreact", "typescript", "typescriptreact", "json", "jsonc", "markdown", "python", "toml", "rust", "roslyn", "graphql" }
  ```
- `root_markers` :
  ```lua
  { "dprint.json", ".dprint.json", "dprint.jsonc", ".dprint.jsonc" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## ds_pinyin_lsp

https://github.com/iamcco/ds-pinyin-lsp
Dead simple Pinyin language server for input Chinese without IME(input method).
To install, download the latest [release](https://github.com/iamcco/ds-pinyin-lsp/releases) and ensure `ds-pinyin-lsp` is on your path.
And make ensure the database file `dict.db3` is also downloaded. And put the path to `dict.dbs` in the following code.

```lua

vim.lsp.config('ds_pinyin_lsp', {
    init_options = {
        db_path = "your_path_to_database"
    }
})

```

Snippet to enable the language server:
```lua
vim.lsp.enable('ds_pinyin_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "ds-pinyin-lsp" }
  ```
- `filetypes` :
  ```lua
  { "markdown", "org" }
  ```
- `init_options` :
  ```lua
  {
    completion_on = true,
    match_as_same_as_input = true,
    match_long_input = true,
    max_suggest = 15,
    show_symbols = true,
    show_symbols_by_n_times = 0,
    show_symbols_only_follow_by_hanzi = false
  }
  ```
- `on_attach` source (use "gF" to open): [../lsp/ds_pinyin_lsp.lua:45](../lsp/ds_pinyin_lsp.lua#L45)
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## dts_lsp

`dts-lsp` is an LSP for Devicetree files built on top of tree-sitter-devicetree grammar.
Language servers can be used in many editors, such as Visual Studio Code, Emacs
or Vim

Install `dts-lsp` from https://github.com/igor-prusov/dts-lsp and add it to path

`dts-lsp` doesn't require any configuration.

More about Devicetree:
https://www.devicetree.org/
https://docs.zephyrproject.org/latest/build/dts/index.html

Snippet to enable the language server:
```lua
vim.lsp.enable('dts_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "dts-lsp" }
  ```
- `filetypes` :
  ```lua
  { "dts", "dtsi", "overlay" }
  ```
- `name` :
  ```lua
  "dts_lsp"
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## earthlyls

https://github.com/glehmann/earthlyls

A fast language server for earthly.

Snippet to enable the language server:
```lua
vim.lsp.enable('earthlyls')
```

Default config:
- `cmd` :
  ```lua
  { "earthlyls" }
  ```
- `filetypes` :
  ```lua
  { "earthfile" }
  ```
- `root_markers` :
  ```lua
  { "Earthfile" }
  ```

---

## ecsact

https://github.com/ecsact-dev/ecsact_lsp_server

Language server for Ecsact.

The default cmd assumes `ecsact_lsp_server` is in your PATH. Typically from the
Ecsact SDK: https://ecsact.dev/start

Snippet to enable the language server:
```lua
vim.lsp.enable('ecsact')
```

Default config:
- `cmd` :
  ```lua
  { "ecsact_lsp_server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "ecsact" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## elixirls

https://github.com/elixir-lsp/elixir-ls

`elixir-ls` can be installed by following the instructions [here](https://github.com/elixir-lsp/elixir-ls#building-and-running).

1. Download the zip from https://github.com/elixir-lsp/elixir-ls/releases/latest/
2. Unzip it and make it executable.
   ```bash
   unzip elixir-ls.zip -d /path/to/elixir-ls
   # Unix
   chmod +x /path/to/elixir-ls/language_server.sh
   ```

**By default, elixir-ls doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of your unzipped elixir-ls.

```lua
vim.lsp.config('elixirls', {
    -- Unix
    cmd = { "/path/to/elixir-ls/language_server.sh" };
    -- Windows
    cmd = { "/path/to/elixir-ls/language_server.bat" };
    ...
})
```

'root_dir' is chosen like this: if two or more directories containing `mix.exs` were found when searching directories upward, the second one (higher up) is chosen, with the assumption that it is the root of an umbrella app. Otherwise the directory containing the single mix.exs that was found is chosen.

Snippet to enable the language server:
```lua
vim.lsp.enable('elixirls')
```

Default config:
- `filetypes` :
  ```lua
  { "elixir", "eelixir", "heex", "surface" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/elixirls.lua:28](../lsp/elixirls.lua#L28)

---

## elmls

https://github.com/elm-tooling/elm-language-server#installation

If you don't want to use Nvim to install it, then you can use:
```sh
npm install -g elm elm-test elm-format @elm-tooling/elm-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('elmls')
```

Default config:
- `capabilities` :
  ```lua
  {
    offsetEncoding = { "utf-8", "utf-16" }
  }
  ```
- `cmd` :
  ```lua
  { "elm-language-server" }
  ```
- `filetypes` :
  ```lua
  { "elm" }
  ```
- `init_options` :
  ```lua
  {
    disableElmLSDiagnostics = false,
    elmReviewDiagnostics = "off",
    onlyUpdateDiagnosticsOnSave = false,
    skipInstallPackageConfirmation = false
  }
  ```
- `root_dir` source (use "gF" to open): [../lsp/elmls.lua:15](../lsp/elmls.lua#L15)

---

## elp

https://whatsapp.github.io/erlang-language-platform

ELP integrates Erlang into modern IDEs via the language server protocol and was
inspired by rust-analyzer.

Snippet to enable the language server:
```lua
vim.lsp.enable('elp')
```

Default config:
- `cmd` :
  ```lua
  { "elp", "server" }
  ```
- `filetypes` :
  ```lua
  { "erlang" }
  ```
- `root_markers` :
  ```lua
  { "rebar.config", "erlang.mk", ".git" }
  ```

---

## ember

https://github.com/ember-tooling/ember-language-server

`ember-language-server` can be installed via `npm`:

```sh
npm install -g @ember-tooling/ember-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('ember')
```

Default config:
- `cmd` :
  ```lua
  { "ember-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "handlebars", "typescript", "javascript", "typescript.glimmer", "javascript.glimmer" }
  ```
- `root_markers` :
  ```lua
  { "ember-cli-build.js", ".git" }
  ```

---

## emmet_language_server

https://github.com/olrtg/emmet-language-server

Package can be installed via `npm`:
```sh
npm install -g @olrtg/emmet-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('emmet_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "emmet-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "css", "eruby", "html", "htmldjango", "javascriptreact", "less", "pug", "sass", "scss", "typescriptreact", "htmlangular" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## emmet_ls

https://github.com/aca/emmet-ls

Package can be installed via `npm`:
```sh
npm install -g emmet-ls
```

Snippet to enable the language server:
```lua
vim.lsp.enable('emmet_ls')
```

Default config:
- `cmd` :
  ```lua
  { "emmet-ls", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "astro", "css", "eruby", "html", "htmldjango", "javascriptreact", "less", "pug", "sass", "scss", "svelte", "typescriptreact", "vue", "htmlangular" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## emmylua_ls

https://github.com/EmmyLuaLs/emmylua-analyzer-rust

Emmylua Analyzer Rust. Language Server for Lua.

`emmylua_ls` can be installed using `cargo` by following the instructions[here]
(https://github.com/EmmyLuaLs/emmylua-analyzer-rust?tab=readme-ov-file#install).

The default `cmd` assumes that the `emmylua_ls` binary can be found in `$PATH`.
It might require you to provide cargo binaries installation path in it.

Snippet to enable the language server:
```lua
vim.lsp.enable('emmylua_ls')
```

Default config:
- `cmd` :
  ```lua
  { "emmylua_ls" }
  ```
- `filetypes` :
  ```lua
  { "lua" }
  ```
- `root_markers` :
  ```lua
  { ".luarc.json", ".emmyrc.json", ".luacheckrc", ".git" }
  ```
- `workspace_required` : `false`

---

## erg_language_server

https://github.com/erg-lang/erg#flags ELS

ELS (erg-language-server) is a language server for the Erg programming language.

erg-language-server can be installed via `cargo` and used as follows:

```sh
cargo install erg --features els
erg --language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('erg_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "erg", "--language-server" }
  ```
- `filetypes` :
  ```lua
  { "erg" }
  ```
- `root_markers` :
  ```lua
  { "package.er", ".git" }
  ```

---

## erlangls

https://erlang-ls.github.io

Language Server for Erlang.

Clone [erlang_ls](https://github.com/erlang-ls/erlang_ls)
Compile the project with `make` and copy resulting binaries somewhere in your $PATH eg. `cp _build/*/bin/* ~/local/bin`

Installation instruction can be found [here](https://github.com/erlang-ls/erlang_ls).

Installation requirements:
    - [Erlang OTP 21+](https://github.com/erlang/otp)
    - [rebar3 3.9.1+](https://github.com/erlang/rebar3)

Snippet to enable the language server:
```lua
vim.lsp.enable('erlangls')
```

Default config:
- `cmd` :
  ```lua
  { "erlang_ls" }
  ```
- `filetypes` :
  ```lua
  { "erlang" }
  ```
- `root_markers` :
  ```lua
  { "rebar.config", "erlang.mk", ".git" }
  ```

---

## esbonio

https://github.com/swyddfa/esbonio

Esbonio is a language server for [Sphinx](https://www.sphinx-doc.org/en/master/) documentation projects.
The language server can be installed via pip

```
pip install esbonio
```

Since Sphinx is highly extensible you will get best results if you install the language server in the same
Python environment as the one used to build your documentation. To ensure that the correct Python environment
is picked up, you can either launch `nvim` with the correct environment activated.

```
source env/bin/activate
nvim
```

Or you can modify the default `cmd` to include the full path to the Python interpreter.

```lua
vim.lsp.config('esbonio', {
  cmd = { '/path/to/virtualenv/bin/python', '-m', 'esbonio' }
})
```

Esbonio supports a number of config values passed as `init_options` on startup, for example.

```lua
vim.lsp.config('esbonio', {
  init_options = {
    server = {
      logLevel = "debug"
    },
    sphinx = {
      confDir = "/path/to/docs",
      srcDir = "${confDir}/../docs-src"
    }
})
```

A full list and explanation of the available options can be found [here](https://docs.esbon.io/en/esbonio-language-server-v0.16.4/lsp/getting-started.html?editor=neovim-lspconfig#configuration)

Snippet to enable the language server:
```lua
vim.lsp.enable('esbonio')
```

Default config:
- `cmd` :
  ```lua
  { "python3", "-m", "esbonio" }
  ```
- `filetypes` :
  ```lua
  { "rst" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## eslint

https://github.com/hrsh7th/vscode-langservers-extracted

`vscode-eslint-language-server` is a linting engine for JavaScript / Typescript.
It can be installed via `npm`:

```sh
npm i -g vscode-langservers-extracted
```

`vscode-eslint-language-server` provides an `EslintFixAll` command that can be used to format a document on save:
```lua
vim.lsp.config('eslint', {
  --- ...
  on_attach = function(client, bufnr)
    vim.api.nvim_create_autocmd("BufWritePre", {
      buffer = bufnr,
      command = "EslintFixAll",
    })
  end,
})
```

See [vscode-eslint](https://github.com/microsoft/vscode-eslint/blob/55871979d7af184bf09af491b6ea35ebd56822cf/server/src/eslintServer.ts#L216-L229) for configuration options.

Messages handled in lspconfig: `eslint/openDoc`, `eslint/confirmESLintExecution`, `eslint/probeFailed`, `eslint/noLibrary`

Additional messages you can handle: `eslint/noConfig`

Snippet to enable the language server:
```lua
vim.lsp.enable('eslint')
```

Default config:
- `before_init` source (use "gF" to open): [../lsp/eslint.lua:34](../lsp/eslint.lua#L34)
- `cmd` :
  ```lua
  { "vscode-eslint-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx", "vue", "svelte", "astro" }
  ```
- `handlers` :
  ```lua
  {
    ["eslint/confirmESLintExecution"] = <function 1>,
    ["eslint/noLibrary"] = <function 2>,
    ["eslint/openDoc"] = <function 3>,
    ["eslint/probeFailed"] = <function 4>
  }
  ```
- `on_attach` source (use "gF" to open): [../lsp/eslint.lua:34](../lsp/eslint.lua#L34)
- `root_dir` source (use "gF" to open): [../lsp/eslint.lua:34](../lsp/eslint.lua#L34)
- `settings` :
  ```lua
  {
    codeAction = {
      disableRuleComment = {
        enable = true,
        location = "separateLine"
      },
      showDocumentation = {
        enable = true
      }
    },
    codeActionOnSave = {
      enable = false,
      mode = "all"
    },
    experimental = {
      useFlatConfig = false
    },
    format = true,
    nodePath = "",
    onIgnoredFiles = "off",
    problems = {
      shortenToSingleLine = false
    },
    quiet = false,
    rulesCustomizations = {},
    run = "onType",
    useESLintClass = false,
    validate = "on",
    workingDirectory = {
      mode = "location"
    }
  }
  ```

---

## facility_language_server

https://github.com/FacilityApi/FacilityLanguageServer

Facility language server protocol (LSP) support.

Snippet to enable the language server:
```lua
vim.lsp.enable('facility_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "facility-language-server" }
  ```
- `filetypes` :
  ```lua
  { "fsd" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## fennel_language_server

https://github.com/rydesun/fennel-language-server

Fennel language server protocol (LSP) support.

Snippet to enable the language server:
```lua
vim.lsp.enable('fennel_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "fennel-language-server" }
  ```
- `filetypes` :
  ```lua
  { "fennel" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## fennel_ls

https://sr.ht/~xerool/fennel-ls/

A language server for fennel.

fennel-ls is configured using the closest file to your working directory named `flsproject.fnl`.
All fennel-ls configuration options [can be found here](https://git.sr.ht/~xerool/fennel-ls/tree/HEAD/docs/manual.md#configuration).

Snippet to enable the language server:
```lua
vim.lsp.enable('fennel_ls')
```

Default config:
- `capabilities` :
  ```lua
  {
    offsetEncoding = { "utf-8", "utf-16" }
  }
  ```
- `cmd` :
  ```lua
  { "fennel-ls" }
  ```
- `filetypes` :
  ```lua
  { "fennel" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/fennel_ls.lua:10](../lsp/fennel_ls.lua#L10)
- `settings` :
  ```lua
  {}
  ```

---

## fish_lsp

https://github.com/ndonfris/fish-lsp

A Language Server Protocol (LSP) tailored for the fish shell.
This project aims to enhance the coding experience for fish,
by introducing a suite of intelligent features like auto-completion,
scope aware symbol analysis, per-token hover generation, and many others.

[homepage](https://www.fish-lsp.dev/)

Snippet to enable the language server:
```lua
vim.lsp.enable('fish_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "fish-lsp", "start" }
  ```
- `cmd_env` :
  ```lua
  {
    fish_lsp_show_client_popups = false
  }
  ```
- `filetypes` :
  ```lua
  { "fish" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## flow

https://flow.org/
https://github.com/facebook/flow

See below for how to setup Flow itself.
https://flow.org/en/docs/install/

See below for lsp command options.

```sh
npx flow lsp --help
```

Snippet to enable the language server:
```lua
vim.lsp.enable('flow')
```

Default config:
- `cmd` :
  ```lua
  { "npx", "--no-install", "flow", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx" }
  ```
- `root_markers` :
  ```lua
  { ".flowconfig" }
  ```

---

## flux_lsp

https://github.com/influxdata/flux-lsp
`flux-lsp` can be installed via `cargo`:
```sh
cargo install --git https://github.com/influxdata/flux-lsp
```

Snippet to enable the language server:
```lua
vim.lsp.enable('flux_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "flux-lsp" }
  ```
- `filetypes` :
  ```lua
  { "flux" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## foam_ls

https://github.com/FoamScience/foam-language-server

`foam-language-server` can be installed via `npm`
```sh
npm install -g foam-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('foam_ls')
```

Default config:
- `cmd` :
  ```lua
  { "foam-ls", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "foam", "OpenFOAM" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/foam_ls.lua:10](../lsp/foam_ls.lua#L10)

---

## fortls

https://fortls.fortran-lang.org/index.html

fortls is a Fortran Language Server, the server can be installed via pip

```sh
pip install fortls
```

Settings to the server can be passed either through the `cmd` option or through
a local configuration file e.g. `.fortls`. For more information
see the `fortls` [documentation](https://fortls.fortran-lang.org/options.html).

Snippet to enable the language server:
```lua
vim.lsp.enable('fortls')
```

Default config:
- `cmd` :
  ```lua
  { "fortls", "--notify_init", "--hover_signature", "--hover_language=fortran", "--use_signature_help" }
  ```
- `filetypes` :
  ```lua
  { "fortran" }
  ```
- `root_markers` :
  ```lua
  { ".fortls", ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## fsautocomplete

https://github.com/fsharp/FsAutoComplete

Language Server for F# provided by FsAutoComplete (FSAC).

FsAutoComplete requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

The preferred way to install FsAutoComplete is with `dotnet tool install --global fsautocomplete`.

Instructions to compile from source are found on the main [repository](https://github.com/fsharp/FsAutoComplete).

You may also need to configure the filetype as Vim defaults to Forth for `*.fs` files:

`autocmd BufNewFile,BufRead *.fs,*.fsx,*.fsi set filetype=fsharp`

This is automatically done by plugins such as [PhilT/vim-fsharp](https://github.com/PhilT/vim-fsharp), [fsharp/vim-fsharp](https://github.com/fsharp/vim-fsharp), and [adelarsq/neofsharp.vim](https://github.com/adelarsq/neofsharp.vim).

Snippet to enable the language server:
```lua
vim.lsp.enable('fsautocomplete')
```

Default config:
- `cmd` :
  ```lua
  { "fsautocomplete", "--adaptive-lsp-server-enabled" }
  ```
- `filetypes` :
  ```lua
  { "fsharp" }
  ```
- `init_options` :
  ```lua
  {
    AutomaticWorkspaceInit = true
  }
  ```
- `root_dir` source (use "gF" to open): [../lsp/fsautocomplete.lua:22](../lsp/fsautocomplete.lua#L22)
- `settings` :
  ```lua
  {
    FSharp = {
      EnableReferenceCodeLens = true,
      ExternalAutocomplete = false,
      InterfaceStubGeneration = true,
      InterfaceStubGenerationMethodBody = 'failwith "Not Implemented"',
      InterfaceStubGenerationObjectIdentifier = "this",
      Linter = true,
      RecordStubGeneration = true,
      RecordStubGenerationBody = 'failwith "Not Implemented"',
      ResolveNamespaces = true,
      SimplifyNameAnalyzer = true,
      UnionCaseStubGeneration = true,
      UnionCaseStubGenerationBody = 'failwith "Not Implemented"',
      UnusedDeclarationsAnalyzer = true,
      UnusedOpensAnalyzer = true,
      UseSdkScripts = true,
      keywordsAutocomplete = true
    }
  }
  ```

---

## fsharp_language_server

F# Language Server
https://github.com/faldor20/fsharp-language-server

An implementation of the language server protocol using the F# Compiler Service.

Build the project from source and override the command path to location of DLL.

If filetype determination is not already performed by an available plugin ([PhilT/vim-fsharp](https://github.com/PhilT/vim-fsharp), [fsharp/vim-fsharp](https://github.com/fsharp/vim-fsharp), and [adelarsq/neofsharp.vim](https://github.com/adelarsq/neofsharp.vim).
), then the following must be added to initialization configuration:


`autocmd BufNewFile,BufRead *.fs,*.fsx,*.fsi set filetype=fsharp`

Snippet to enable the language server:
```lua
vim.lsp.enable('fsharp_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "dotnet", "FSharpLanguageServer.dll" }
  ```
- `filetypes` :
  ```lua
  { "fsharp" }
  ```
- `init_options` :
  ```lua
  {
    AutomaticWorkspaceInit = true
  }
  ```
- `root_dir` source (use "gF" to open): [../lsp/fsharp_language_server.lua:18](../lsp/fsharp_language_server.lua#L18)
- `settings` :
  ```lua
  {}
  ```

---

## fstar

https://github.com/FStarLang/FStar

LSP support is included in FStar. Make sure `fstar.exe` is in your PATH.

Snippet to enable the language server:
```lua
vim.lsp.enable('fstar')
```

Default config:
- `cmd` :
  ```lua
  { "fstar.exe", "--lsp" }
  ```
- `filetypes` :
  ```lua
  { "fstar" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## futhark_lsp

https://github.com/diku-dk/futhark

Futhark Language Server

This language server comes with the futhark compiler and is run with the command
```
futhark lsp
```

Snippet to enable the language server:
```lua
vim.lsp.enable('futhark_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "futhark", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "futhark", "fut" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## gdscript

https://github.com/godotengine/godot

Language server for GDScript, used by Godot Engine.

Snippet to enable the language server:
```lua
vim.lsp.enable('gdscript')
```

Default config:
- `cmd` source (use "gF" to open): [../lsp/gdscript.lua:10](../lsp/gdscript.lua#L10)
- `filetypes` :
  ```lua
  { "gd", "gdscript", "gdscript3" }
  ```
- `root_markers` :
  ```lua
  { "project.godot", ".git" }
  ```

---

## gdshader_lsp

https://github.com/godofavacyn/gdshader-lsp

A language server for the Godot Shading language.

Snippet to enable the language server:
```lua
vim.lsp.enable('gdshader_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "gdshader-lsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "gdshader", "gdshaderinc" }
  ```
- `root_markers` :
  ```lua
  { "project.godot" }
  ```

---

## gh_actions_ls

https://github.com/lttb/gh-actions-language-server

Language server for GitHub Actions.

The projects [forgejo](https://forgejo.org/) and [gitea](https://about.gitea.com/)
design their actions to be as compatible to github as possible
with only [a few differences](https://docs.gitea.com/usage/actions/comparison#unsupported-workflows-syntax) between the systems.
The `gh_actions_ls` is therefore enabled for those `yaml` files as well.

The `gh-actions-language-server` can be installed via `npm`:

```sh
npm install -g gh-actions-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('gh_actions_ls')
```

Default config:
- `capabilities` :
  ```lua
  {
    workspace = {
      didChangeWorkspaceFolders = {
        dynamicRegistration = true
      }
    }
  }
  ```
- `cmd` :
  ```lua
  { "gh-actions-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "yaml" }
  ```
- `root_markers` :
  ```lua
  { ".github/workflows", ".forgejo/workflows", ".gitea/workflows" }
  ```
- `workspace_required` : `true`

---

## ghcide

https://github.com/digital-asset/ghcide

A library for building Haskell IDE tooling.
"ghcide" isn't for end users now. Use "haskell-language-server" instead of "ghcide".

Snippet to enable the language server:
```lua
vim.lsp.enable('ghcide')
```

Default config:
- `cmd` :
  ```lua
  { "ghcide", "--lsp" }
  ```
- `filetypes` :
  ```lua
  { "haskell", "lhaskell" }
  ```
- `root_markers` :
  ```lua
  { "stack.yaml", "hie-bios", "BUILD.bazel", "cabal.config", "package.yaml" }
  ```

---

## ghdl_ls

https://github.com/ghdl/ghdl-language-server

A language server for VHDL, using ghdl as its backend.

`ghdl-ls` is part of pyghdl, for installation instructions see
[the upstream README](https://github.com/ghdl/ghdl/tree/master/pyGHDL/lsp).

Snippet to enable the language server:
```lua
vim.lsp.enable('ghdl_ls')
```

Default config:
- `cmd` :
  ```lua
  { "ghdl-ls" }
  ```
- `filetypes` :
  ```lua
  { "vhdl" }
  ```
- `root_markers` :
  ```lua
  { "hdl-prj.json", ".git" }
  ```

---

## ginko_ls

`ginko_ls` is meant to be a feature-complete language server for device-trees.
 Language servers can be used in many editors, such as Visual Studio Code, Emacs
 or Vim

 Install `ginko_ls` from https://github.com/Schottkyc137/ginko and add it to path

 `ginko_ls` doesn't require any configuration.

Snippet to enable the language server:
```lua
vim.lsp.enable('ginko_ls')
```

Default config:
- `cmd` :
  ```lua
  { "ginko_ls" }
  ```
- `filetypes` :
  ```lua
  { "dts" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## gitlab_ci_ls

https://github.com/alesbrelih/gitlab-ci-ls

Language Server for Gitlab CI

`gitlab-ci-ls` can be installed via cargo:
cargo install gitlab-ci-ls

Snippet to enable the language server:
```lua
vim.lsp.enable('gitlab_ci_ls')
```

Default config:
- `cmd` :
  ```lua
  { "gitlab-ci-ls" }
  ```
- `filetypes` :
  ```lua
  { "yaml.gitlab" }
  ```
- `init_options` :
  ```lua
  {
    cache_path = "/home/runner/.cache/gitlab-ci-ls/",
    log_path = "/home/runner/.cache/gitlab-ci-ls//log/gitlab-ci-ls.log"
  }
  ```
- `root_dir` source (use "gF" to open): [../lsp/gitlab_ci_ls.lua:14](../lsp/gitlab_ci_ls.lua#L14)

---

## glasgow

https://github.com/nolanderc/glasgow

Provides language features for WGSL (WebGPU Shading Language):
- Completions:
    - Local functions/variables/types.
    - Fields and swizzles.
    - Builtin types and functions (`dot`, `reflect`, `textureSample`, `vec3`, `mat4x2`, etc.)
- Hover Documentation:
    - Function signatures.
    - Variable types.
    - Includes builtin types and functions. Text is taken from the WGSL specification.
- Goto Definition
- Find all References
- Rename
- Formatter

`glasgow` can be installed via `cargo`:
```sh
cargo install glasgow
```

Snippet to enable the language server:
```lua
vim.lsp.enable('glasgow')
```

Default config:
- `cmd` :
  ```lua
  { "glasgow" }
  ```
- `filetypes` :
  ```lua
  { "wgsl" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## gleam

https://github.com/gleam-lang/gleam

A language server for Gleam Programming Language.

It comes with the Gleam compiler, for installation see: [Installing Gleam](https://gleam.run/getting-started/installing/)

Snippet to enable the language server:
```lua
vim.lsp.enable('gleam')
```

Default config:
- `cmd` :
  ```lua
  { "gleam", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "gleam" }
  ```
- `root_markers` :
  ```lua
  { "gleam.toml", ".git" }
  ```

---

## glsl_analyzer

https://github.com/nolanderc/glsl_analyzer

Language server for GLSL

Snippet to enable the language server:
```lua
vim.lsp.enable('glsl_analyzer')
```

Default config:
- `capabilities` :
  ```lua
  {}
  ```
- `cmd` :
  ```lua
  { "glsl_analyzer" }
  ```
- `filetypes` :
  ```lua
  { "glsl", "vert", "tesc", "tese", "frag", "geom", "comp" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## glslls

https://github.com/svenstaro/glsl-language-server

Language server implementation for GLSL

`glslls` can be compiled and installed manually, or, if your distribution has access to the AUR,
via the `glsl-language-server` AUR package

Snippet to enable the language server:
```lua
vim.lsp.enable('glslls')
```

Default config:
- `capabilities` :
  ```lua
  {
    offsetEncoding = { "utf-8", "utf-16" },
    textDocument = {
      completion = {
        editsNearCursor = true
      }
    }
  }
  ```
- `cmd` :
  ```lua
  { "glslls", "--stdin" }
  ```
- `filetypes` :
  ```lua
  { "glsl", "vert", "tesc", "tese", "frag", "geom", "comp" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## gnls

https://github.com/microsoft/gnls

Microsoft's language server for GN build files.

Assuming there is a `gnls` script somewhere in your `$PATH`, containing
for example:

```shell
GNLS_SRC_DIR=</path/to/gnls>

exec node ${GNLS_SRC_DIR}/build/server.js $@
```

Snippet to enable the language server:
```lua
vim.lsp.enable('gnls')
```

Default config:
- `cmd` :
  ```lua
  { "gnls", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "gn" }
  ```
- `root_markers` :
  ```lua
  { ".gn", ".git" }
  ```

---

## golangci_lint_ls

Combination of both lint server and client

https://github.com/nametake/golangci-lint-langserver
https://github.com/golangci/golangci-lint


Installation of binaries needed is done via

```
go install github.com/nametake/golangci-lint-langserver@latest
go install github.com/golangci/golangci-lint/cmd/golangci-lint@latest
```

Snippet to enable the language server:
```lua
vim.lsp.enable('golangci_lint_ls')
```

Default config:
- `cmd` :
  ```lua
  { "golangci-lint-langserver" }
  ```
- `filetypes` :
  ```lua
  { "go", "gomod" }
  ```
- `init_options` :
  ```lua
  {
    command = { "golangci-lint", "run", "--output.json.path=stdout", "--show-stats=false" }
  }
  ```
- `root_markers` :
  ```lua
  { ".golangci.yml", ".golangci.yaml", ".golangci.toml", ".golangci.json", "go.work", "go.mod", ".git" }
  ```

---

## gopls

https://github.com/golang/tools/tree/master/gopls

Google's lsp server for golang.

Snippet to enable the language server:
```lua
vim.lsp.enable('gopls')
```

Default config:
- `cmd` :
  ```lua
  { "gopls" }
  ```
- `filetypes` :
  ```lua
  { "go", "gomod", "gowork", "gotmpl" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/gopls.lua:21](../lsp/gopls.lua#L21)

---

## gradle_ls

https://github.com/microsoft/vscode-gradle

Microsoft's lsp server for gradle files

If you're setting this up manually, build vscode-gradle using `./gradlew installDist` and point `cmd` to the `gradle-language-server` generated in the build directory

Snippet to enable the language server:
```lua
vim.lsp.enable('gradle_ls')
```

Default config:
- `cmd` :
  ```lua
  { "gradle-language-server" }
  ```
- `filetypes` :
  ```lua
  { "groovy" }
  ```
- `init_options` :
  ```lua
  {
    settings = {
      gradleWrapperEnabled = true
    }
  }
  ```
- `root_markers` :
  ```lua
  { "settings.gradle", "build.gradle" }
  ```

---

## grammarly

https://github.com/znck/grammarly

`grammarly-languageserver` can be installed via `npm`:

```sh
npm i -g grammarly-languageserver
```

WARNING: Since this language server uses Grammarly's API, any document you open with it running is shared with them. Please evaluate their [privacy policy](https://www.grammarly.com/privacy-policy) before using this.

Snippet to enable the language server:
```lua
vim.lsp.enable('grammarly')
```

Default config:
- `cmd` :
  ```lua
  { "grammarly-languageserver", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "markdown" }
  ```
- `handlers` :
  ```lua
  {
    ["$/updateDocumentState"] = <function 1>
  }
  ```
- `init_options` :
  ```lua
  {
    clientId = "client_BaDkMgx4X19X9UxxYRCXZo"
  }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## graphql

https://github.com/graphql/graphiql/tree/main/packages/graphql-language-service-cli

`graphql-lsp` can be installed via `npm`:

```sh
npm install -g graphql-language-service-cli
```

Note that you must also have [the graphql package](https://github.com/graphql/graphql-js) installed within your project and create a [GraphQL config file](https://the-guild.dev/graphql/config/docs).

Snippet to enable the language server:
```lua
vim.lsp.enable('graphql')
```

Default config:
- `cmd` :
  ```lua
  { "graphql-lsp", "server", "-m", "stream" }
  ```
- `filetypes` :
  ```lua
  { "graphql", "typescriptreact", "javascriptreact" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/graphql.lua:15](../lsp/graphql.lua#L15)

---

## groovyls

https://github.com/prominic/groovy-language-server.git

Requirements:
 - Linux/macOS (for now)
 - Java 11+

`groovyls` can be installed by following the instructions [here](https://github.com/prominic/groovy-language-server.git#build).

If you have installed groovy language server, you can set the `cmd` custom path as follow:

```lua
vim.lsp.config('groovyls', {
    -- Unix
    cmd = { "java", "-jar", "path/to/groovyls/groovy-language-server-all.jar" },
    ...
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('groovyls')
```

Default config:
- `cmd` :
  ```lua
  { "java", "-jar", "groovy-language-server-all.jar" }
  ```
- `filetypes` :
  ```lua
  { "groovy" }
  ```
- `root_markers` :
  ```lua
  { "Jenkinsfile", ".git" }
  ```

---

## guile_ls

https://codeberg.org/rgherdt/scheme-lsp-server

The recommended way is to install guile-lsp-server is using Guix. Unfortunately it is still not available at the official Guix channels, but you can use the provided channel guix.scm in the repo:
```sh
guix package -f guix.scm
```

Checkout the repo for more info.

Note: This LSP will start on `scheme.guile` filetype. You can set this file type using `:help modeline` or adding https://gitlab.com/HiPhish/guile.vim to your plugins to automatically set it.

Snippet to enable the language server:
```lua
vim.lsp.enable('guile_ls')
```

Default config:
- `cmd` :
  ```lua
  { "guile-lsp-server" }
  ```
- `filetypes` :
  ```lua
  { "scheme.guile" }
  ```
- `root_markers` :
  ```lua
  { "guix.scm", ".git" }
  ```

---

## harper_ls

https://github.com/automattic/harper

The language server for Harper, the slim, clean language checker for developers.

See our [documentation](https://writewithharper.com/docs/integrations/neovim) for more information on settings.

In short, they should look something like this:
```lua
vim.lsp.config('harper_ls', {
  settings = {
    ["harper-ls"] = {
      userDictPath = "~/dict.txt"
    }
  },
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('harper_ls')
```

Default config:
- `cmd` :
  ```lua
  { "harper-ls", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "c", "cpp", "cs", "gitcommit", "go", "html", "java", "javascript", "lua", "markdown", "nix", "python", "ruby", "rust", "swift", "toml", "typescript", "typescriptreact", "haskell", "cmake", "typst", "php", "dart" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## hdl_checker

https://github.com/suoto/hdl_checker
Language server for hdl-checker.
Install using: `pip install hdl-checker --upgrade`

Snippet to enable the language server:
```lua
vim.lsp.enable('hdl_checker')
```

Default config:
- `cmd` :
  ```lua
  { "hdl_checker", "--lsp" }
  ```
- `filetypes` :
  ```lua
  { "vhdl", "verilog", "systemverilog" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## helm_ls

https://github.com/mrjosh/helm-ls

Helm Language server. (This LSP is in early development)

`helm Language server` can be installed by following the instructions [here](https://github.com/mrjosh/helm-ls).

The default `cmd` assumes that the `helm_ls` binary can be found in `$PATH`.

If need Helm file highlight use [vim-helm](https://github.com/towolf/vim-helm) plugin.

Snippet to enable the language server:
```lua
vim.lsp.enable('helm_ls')
```

Default config:
- `capabilities` :
  ```lua
  {
    workspace = {
      didChangeWatchedFiles = {
        dynamicRegistration = true
      }
    }
  }
  ```
- `cmd` :
  ```lua
  { "helm_ls", "serve" }
  ```
- `filetypes` :
  ```lua
  { "helm" }
  ```
- `root_markers` :
  ```lua
  { "Chart.yaml" }
  ```

---

## hhvm

Language server for programs written in Hack
https://hhvm.com/
https://github.com/facebook/hhvm
See below for how to setup HHVM & typechecker:
https://docs.hhvm.com/hhvm/getting-started/getting-started

Snippet to enable the language server:
```lua
vim.lsp.enable('hhvm')
```

Default config:
- `cmd` :
  ```lua
  { "hh_client", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "php", "hack" }
  ```
- `root_markers` :
  ```lua
  { ".hhconfig" }
  ```

---

## hie

https://github.com/haskell/haskell-ide-engine

the following init_options are supported (see https://github.com/haskell/haskell-ide-engine#configuration):
```lua
init_options = {
  languageServerHaskell = {
    hlintOn = bool;
    maxNumberOfProblems = number;
    diagnosticsDebounceDuration = number;
    liquidOn = bool (default false);
    completionSnippetsOn = bool (default true);
    formatOnImportOn = bool (default true);
    formattingProvider = string (default "brittany", alternate "floskell");
  }
}
```

Snippet to enable the language server:
```lua
vim.lsp.enable('hie')
```

Default config:
- `cmd` :
  ```lua
  { "hie-wrapper", "--lsp" }
  ```
- `filetypes` :
  ```lua
  { "haskell" }
  ```
- `root_markers` :
  ```lua
  { "stack.yaml", "package.yaml", ".git" }
  ```

---

## hlasm

`hlasm_language_server` is a language server for the High Level Assembler language used on IBM SystemZ mainframes.

To learn how to configure the HLASM language server, see the [HLASM Language Support documentation](https://github.com/eclipse-che4z/che-che4z-lsp-for-hlasm).

Snippet to enable the language server:
```lua
vim.lsp.enable('hlasm')
```

Default config:
- `cmd` :
  ```lua
  { "hlasm_language_server" }
  ```
- `filetypes` :
  ```lua
  { "hlasm" }
  ```
- `root_markers` :
  ```lua
  { ".hlasmplugin" }
  ```

---

## hls

https://github.com/haskell/haskell-language-server

Haskell Language Server

If you are using HLS 1.9.0.0, enable the language server to launch on Cabal files as well:

```lua
vim.lsp.config('hls', {
  filetypes = { 'haskell', 'lhaskell', 'cabal' },
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('hls')
```

Default config:
- `cmd` :
  ```lua
  { "haskell-language-server-wrapper", "--lsp" }
  ```
- `filetypes` :
  ```lua
  { "haskell", "lhaskell" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/hls.lua:17](../lsp/hls.lua#L17)
- `settings` :
  ```lua
  {
    haskell = {
      cabalFormattingProvider = "cabalfmt",
      formattingProvider = "ormolu"
    }
  }
  ```

---

## hoon_ls

https://github.com/urbit/hoon-language-server

A language server for Hoon.

The language server can be installed via `npm install -g @hoon-language-server`

Start a fake ~zod with `urbit -F zod`.
Start the language server at the Urbit Dojo prompt with: `|start %language-server`

Snippet to enable the language server:
```lua
vim.lsp.enable('hoon_ls')
```

Default config:
- `cmd` :
  ```lua
  { "hoon-language-server" }
  ```
- `filetypes` :
  ```lua
  { "hoon" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## html

https://github.com/hrsh7th/vscode-langservers-extracted

`vscode-html-language-server` can be installed via `npm`:
```sh
npm i -g vscode-langservers-extracted
```

Neovim does not currently include built-in snippets. `vscode-html-language-server` only provides completions when snippet support is enabled.
To enable completion, install a snippet plugin and add the following override to your language client capabilities during setup.

The code-formatting feature of the lsp can be controlled with the `provideFormatter` option.

```lua
--Enable (broadcasting) snippet capability for completion
local capabilities = vim.lsp.protocol.make_client_capabilities()
capabilities.textDocument.completion.completionItem.snippetSupport = true

vim.lsp.config('html', {
  capabilities = capabilities,
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('html')
```

Default config:
- `cmd` :
  ```lua
  { "vscode-html-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "html", "templ" }
  ```
- `init_options` :
  ```lua
  {
    configurationSection = { "html", "css", "javascript" },
    embeddedLanguages = {
      css = true,
      javascript = true
    },
    provideFormatter = true
  }
  ```
- `root_markers` :
  ```lua
  { "package.json", ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## htmx

https://github.com/ThePrimeagen/htmx-lsp

`htmx-lsp` can be installed via `cargo`:
```sh
cargo install htmx-lsp
```

Lsp is still very much work in progress and experimental. Use at your own risk.

Snippet to enable the language server:
```lua
vim.lsp.enable('htmx')
```

Default config:
- `cmd` :
  ```lua
  { "htmx-lsp" }
  ```
- `filetypes` :
  ```lua
  { "aspnetcorerazor", "astro", "astro-markdown", "blade", "clojure", "django-html", "htmldjango", "edge", "eelixir", "elixir", "ejs", "erb", "eruby", "gohtml", "gohtmltmpl", "haml", "handlebars", "hbs", "html", "htmlangular", "html-eex", "heex", "jade", "leaf", "liquid", "markdown", "mdx", "mustache", "njk", "nunjucks", "php", "razor", "slim", "twig", "javascript", "javascriptreact", "reason", "rescript", "typescript", "typescriptreact", "vue", "svelte", "templ" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## hydra_lsp

https://github.com/Retsediv/hydra-lsp

LSP for Hydra Python package config files.

Snippet to enable the language server:
```lua
vim.lsp.enable('hydra_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "hydra-lsp" }
  ```
- `filetypes` :
  ```lua
  { "yaml" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## hyprls

https://github.com/hyprland-community/hyprls

`hyprls` can be installed via `go`:
```sh
go install github.com/ewen-lbh/hyprls/cmd/hyprls@latest
```

Snippet to enable the language server:
```lua
vim.lsp.enable('hyprls')
```

Default config:
- `cmd` :
  ```lua
  { "hyprls", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "hyprlang" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## idris2_lsp

https://github.com/idris-community/idris2-lsp

The Idris 2 language server.

Plugins for the Idris 2 filetype include
[Idris2-Vim](https://github.com/edwinb/idris2-vim) (fewer features, stable) and
[Nvim-Idris2](https://github.com/ShinKage/nvim-idris2) (cutting-edge,
experimental).

Idris2-Lsp requires a build of Idris 2 that includes the "Idris 2 API" package.
Package managers with known support for this build include the
[AUR](https://aur.archlinux.org/packages/idris2/) and
[Homebrew](https://formulae.brew.sh/formula/idris2#default).

If your package manager does not support the Idris 2 API, you will need to build
Idris 2 from source. Refer to the
[the Idris 2 installation instructions](https://github.com/idris-lang/Idris2/blob/main/INSTALL.md)
for details.  Steps 5 and 8 are listed as "optional" in that guide, but they are
necessary in order to make the Idris 2 API available.

You need to install a version of Idris2-Lsp that is compatible with your
version of Idris 2. There should be a branch corresponding to every released
Idris 2 version after v0.4.0. Use the latest commit on that branch. For example,
if you have Idris v0.5.1, you should use the v0.5.1 branch of Idris2-Lsp.

If your Idris 2 version is newer than the newest Idris2-Lsp branch, use the
latest commit on the `master` branch, and set a reminder to check the Idris2-Lsp
repo for the release of a compatible versioned branch.

Snippet to enable the language server:
```lua
vim.lsp.enable('idris2_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "idris2-lsp" }
  ```
- `filetypes` :
  ```lua
  { "idris2" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/idris2_lsp.lua:34](../lsp/idris2_lsp.lua#L34)

---

## intelephense

https://intelephense.com/

`intelephense` can be installed via `npm`:
```sh
npm install -g intelephense
```

```lua
-- See https://github.com/bmewburn/intelephense-docs/blob/master/installation.md#initialisation-options
init_options = {
  storagePath = …, -- Optional absolute path to storage dir. Defaults to os.tmpdir().
  globalStoragePath = …, -- Optional absolute path to a global storage dir. Defaults to os.homedir().
  licenceKey = …, -- Optional licence key or absolute path to a text file containing the licence key.
  clearCache = …, -- Optional flag to clear server state. State can also be cleared by deleting {storagePath}/intelephense
}
-- See https://github.com/bmewburn/intelephense-docs
settings = {
  intelephense = {
    files = {
      maxSize = 1000000;
    };
  };
}
```

Snippet to enable the language server:
```lua
vim.lsp.enable('intelephense')
```

Default config:
- `cmd` :
  ```lua
  { "intelephense", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "php" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/intelephense.lua:30](../lsp/intelephense.lua#L30)

---

## janet_lsp

https://github.com/CFiggers/janet-lsp

A Language Server Protocol implementation for Janet.

Snippet to enable the language server:
```lua
vim.lsp.enable('janet_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "janet-lsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "janet" }
  ```
- `root_markers` :
  ```lua
  { "project.janet", ".git" }
  ```

---

## java_language_server

https://github.com/georgewfraser/java-language-server

Java language server

Point `cmd` to `lang_server_linux.sh` or the equivalent script for macOS/Windows provided by java-language-server

Snippet to enable the language server:
```lua
vim.lsp.enable('java_language_server')
```

Default config:
- `filetypes` :
  ```lua
  { "java" }
  ```
- `root_markers` :
  ```lua
  { "build.gradle", "build.gradle.kts", "pom.xml", ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## jdtls

https://projects.eclipse.org/projects/eclipse.jdt.ls

Language server for Java.

IMPORTANT: If you want all the features jdtls has to offer, [nvim-jdtls](https://github.com/mfussenegger/nvim-jdtls)
is highly recommended. If all you need is diagnostics, completion, imports, gotos and formatting and some code actions
you can keep reading here.

For manual installation you can download precompiled binaries from the
[official downloads site](http://download.eclipse.org/jdtls/snapshots/?d)
and ensure that the `PATH` variable contains the `bin` directory of the extracted archive.

```lua
  -- init.lua
  vim.lsp.enable('jdtls')
```

You can also pass extra custom jvm arguments with the JDTLS_JVM_ARGS environment variable as a space separated list of arguments,
that will be converted to multiple --jvm-arg=<param> args when passed to the jdtls script. This will allow for example tweaking
the jvm arguments or integration with external tools like lombok:

```sh
export JDTLS_JVM_ARGS="-javaagent:$HOME/.local/share/java/lombok.jar"
```

For automatic installation you can use the following unofficial installers/launchers under your own risk:
  - [jdtls-launcher](https://github.com/eruizc-dev/jdtls-launcher) (Includes lombok support by default)
    ```lua
      -- init.lua
      vim.lsp.config('jdtls', { cmd = { 'jdtls' } })
    ```

Snippet to enable the language server:
```lua
vim.lsp.enable('jdtls')
```

Default config:
- `cmd` :
  ```lua
  { "jdtls", "-configuration", "/home/runner/.cache/jdtls/config", "-data", "/home/runner/.cache/jdtls/workspace" }
  ```
- `filetypes` :
  ```lua
  { "java" }
  ```
- `handlers` :
  ```lua
  {
    ["language/status"] = <function 1>,
    ["textDocument/codeAction"] = <function 2>,
    ["textDocument/rename"] = <function 3>,
    ["workspace/applyEdit"] = <function 4>
  }
  ```
- `init_options` :
  ```lua
  {
    jvm_args = {},
    workspace = "/home/runner/.cache/jdtls/workspace"
  }
  ```
- `root_markers` :
  ```lua
  { ".git", "build.gradle", "build.gradle.kts", "build.xml", "pom.xml", "settings.gradle", "settings.gradle.kts" }
  ```

---

## jedi_language_server

https://github.com/pappasam/jedi-language-server

`jedi-language-server`, a language server for Python, built on top of jedi

Snippet to enable the language server:
```lua
vim.lsp.enable('jedi_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "jedi-language-server" }
  ```
- `filetypes` :
  ```lua
  { "python" }
  ```
- `root_markers` :
  ```lua
  { "pyproject.toml", "setup.py", "setup.cfg", "requirements.txt", "Pipfile", ".git" }
  ```

---

## jinja_lsp

jinja-lsp enhances minijinja development experience by providing Helix/Nvim users with advanced features such as autocomplete, syntax highlighting, hover, goto definition, code actions and linting.

The file types are not detected automatically, you can register them manually (see below) or override the filetypes:

```lua
vim.filetype.add {
  extension = {
    jinja = 'jinja',
    jinja2 = 'jinja',
    j2 = 'jinja',
  },
}
```

Snippet to enable the language server:
```lua
vim.lsp.enable('jinja_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "jinja-lsp" }
  ```
- `filetypes` :
  ```lua
  { "jinja" }
  ```
- `name` :
  ```lua
  "jinja_lsp"
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## jqls

https://github.com/wader/jq-lsp
Language server for jq, written using Go.
You can install the server easily using go install:
```sh
# install directly
go install github.com/wader/jq-lsp@master
# copy binary to $PATH
cp $(go env GOPATH)/bin/jq-lsp /usr/local/bin
```
Note: To activate properly nvim needs to know the jq filetype.
You can add it via:
```lua
vim.cmd([[au BufRead,BufNewFile *.jq setfiletype jq]])
```

Snippet to enable the language server:
```lua
vim.lsp.enable('jqls')
```

Default config:
- `cmd` :
  ```lua
  { "jq-lsp" }
  ```
- `filetypes` :
  ```lua
  { "jq" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## jsonls

https://github.com/hrsh7th/vscode-langservers-extracted

vscode-json-language-server, a language server for JSON and JSON schema

`vscode-json-language-server` can be installed via `npm`:
```sh
npm i -g vscode-langservers-extracted
```

`vscode-json-language-server` only provides completions when snippet support is enabled. If you use Neovim older than v0.10 you need to enable completion, install a snippet plugin and add the following override to your language client capabilities during setup.

```lua
--Enable (broadcasting) snippet capability for completion
local capabilities = vim.lsp.protocol.make_client_capabilities()
capabilities.textDocument.completion.completionItem.snippetSupport = true

vim.lsp.config('jsonls', {
  capabilities = capabilities,
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('jsonls')
```

Default config:
- `cmd` :
  ```lua
  { "vscode-json-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "json", "jsonc" }
  ```
- `init_options` :
  ```lua
  {
    provideFormatter = true
  }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## julials

https://github.com/julia-vscode/julia-vscode

LanguageServer.jl can be installed with `julia` and `Pkg`:
```sh
julia --project=~/.julia/environments/nvim-lspconfig -e 'using Pkg; Pkg.add("LanguageServer")'
```
where `~/.julia/environments/nvim-lspconfig` is the location where
the default configuration expects LanguageServer.jl to be installed.

To update an existing install, use the following command:
```sh
julia --project=~/.julia/environments/nvim-lspconfig -e 'using Pkg; Pkg.update()'
```

Note: In order to have LanguageServer.jl pick up installed packages or dependencies in a
Julia project, you must make sure that the project is instantiated:
```sh
julia --project=/path/to/my/project -e 'using Pkg; Pkg.instantiate()'
```

Note: The julia programming language searches for global environments within the `environments/`
folder of `$JULIA_DEPOT_PATH` entries. By default this simply `~/.julia/environments`

Snippet to enable the language server:
```lua
vim.lsp.enable('julials')
```

Default config:
- `cmd` :
  ```lua
  { "julia", "--startup-file=no", "--history-file=no", "-e", '    # Load LanguageServer.jl: attempt to load from ~/.julia/environments/nvim-lspconfig\n    # with the regular load path as a fallback\n    ls_install_path = joinpath(\n        get(DEPOT_PATH, 1, joinpath(homedir(), ".julia")),\n        "environments", "nvim-lspconfig"\n    )\n    pushfirst!(LOAD_PATH, ls_install_path)\n    using LanguageServer\n    popfirst!(LOAD_PATH)\n    depot_path = get(ENV, "JULIA_DEPOT_PATH", "")\n    project_path = let\n        dirname(something(\n            ## 1. Finds an explicitly set project (JULIA_PROJECT)\n            Base.load_path_expand((\n                p = get(ENV, "JULIA_PROJECT", nothing);\n                p === nothing ? nothing : isempty(p) ? nothing : p\n            )),\n            ## 2. Look for a Project.toml file in the current working directory,\n            ##    or parent directories, with $HOME as an upper boundary\n            Base.current_project(),\n            ## 3. First entry in the load path\n            get(Base.load_path(), 1, nothing),\n            ## 4. Fallback to default global environment,\n            ##    this is more or less unreachable\n            Base.load_path_expand("@v#.#"),\n        ))\n    end\n    @info "Running language server" VERSION pwd() project_path depot_path\n    server = LanguageServer.LanguageServerInstance(stdin, stdout, project_path, depot_path)\n    server.runlinter = true\n    run(server)\n  ' }
  ```
- `filetypes` :
  ```lua
  { "julia" }
  ```
- `on_attach` source (use "gF" to open): [../lsp/julials.lua:119](../lsp/julials.lua#L119)
- `root_markers` :
  ```lua
  { "Project.toml", "JuliaProject.toml" }
  ```

---

## just

https://github.com/terror/just-lsp

`just-lsp` is an LSP for just built on top of the tree-sitter-just parser.

Snippet to enable the language server:
```lua
vim.lsp.enable('just')
```

Default config:
- `cmd` :
  ```lua
  { "just-lsp" }
  ```
- `filetypes` :
  ```lua
  { "just" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## kcl

https://github.com/kcl-lang/kcl.nvim

Language server for the KCL configuration and policy language.

Snippet to enable the language server:
```lua
vim.lsp.enable('kcl')
```

Default config:
- `cmd` :
  ```lua
  { "kcl-language-server" }
  ```
- `filetypes` :
  ```lua
  { "kcl" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## koka

https://koka-lang.github.io/koka/doc/index.html
Koka is a functional programming language with effect types and handlers.

Snippet to enable the language server:
```lua
vim.lsp.enable('koka')
```

Default config:
- `cmd` :
  ```lua
  { "koka", "--language-server", "--lsstdio" }
  ```
- `filetypes` :
  ```lua
  { "koka" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## kotlin_language_server

A kotlin language server which was developed for internal usage and
released afterwards. Maintaining is not done by the original author,
but by fwcd.

It is built via gradle and developed on github.
Source and additional description:
https://github.com/fwcd/kotlin-language-server

This server requires vim to be aware of the kotlin-filetype.
You could refer for this capability to:
https://github.com/udalov/kotlin-vim (recommended)
Note that there is no LICENSE specified yet.

For faster startup, you can setup caching by specifying a storagePath
in the init_options. The default is your home directory.

Snippet to enable the language server:
```lua
vim.lsp.enable('kotlin_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "kotlin-language-server" }
  ```
- `filetypes` :
  ```lua
  { "kotlin" }
  ```
- `init_options` :
  ```lua
  {}
  ```
- `root_markers` :
  ```lua
  { "settings.gradle", "settings.gradle.kts", "build.xml", "pom.xml", "build.gradle", "build.gradle.kts" }
  ```

---

## kulala_ls

https://github.com/mistweaverco/kulala-ls

A minimal language server for HTTP syntax.

Snippet to enable the language server:
```lua
vim.lsp.enable('kulala_ls')
```

Default config:
- `cmd` :
  ```lua
  { "kulala-ls", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "http" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## lean3ls

https://github.com/leanprover/lean-client-js/tree/master/lean-language-server

Lean installation instructions can be found
[here](https://leanprover-community.github.io/get_started.html#regular-install).

Once Lean is installed, you can install the Lean 3 language server by running
```sh
npm install -g lean-language-server
```

Note: that if you're using [lean.nvim](https://github.com/Julian/lean.nvim),
that plugin fully handles the setup of the Lean language server,
and you shouldn't set up `lean3ls` both with it and `lspconfig`.

Snippet to enable the language server:
```lua
vim.lsp.enable('lean3ls')
```

Default config:
- `cmd` :
  ```lua
  { "lean-language-server", "--stdio", "--", "-M", "4096", "-T", "100000" }
  ```
- `filetypes` :
  ```lua
  { "lean3" }
  ```
- `offset_encoding` :
  ```lua
  "utf-32"
  ```
- `root_dir` source (use "gF" to open): [../lsp/lean3ls.lua:19](../lsp/lean3ls.lua#L19)

---

## lelwel_ls

https://github.com/0x2a-42/lelwel

Language server for lelwel grammars.

You can install `lelwel-ls` via cargo:
```sh
cargo install --features="lsp" lelwel
```

Snippet to enable the language server:
```lua
vim.lsp.enable('lelwel_ls')
```

Default config:
- `cmd` :
  ```lua
  { "lelwel-ls" }
  ```
- `filetypes` :
  ```lua
  { "llw" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## lemminx

https://github.com/eclipse/lemminx

The easiest way to install the server is to get a binary from https://github.com/redhat-developer/vscode-xml/releases and place it on your PATH.

NOTE to macOS users: Binaries from unidentified developers are blocked by default. If you trust the downloaded binary, run it once, cancel the prompt, then remove the binary from Gatekeeper quarantine with `xattr -d com.apple.quarantine lemminx`. It should now run without being blocked.

Snippet to enable the language server:
```lua
vim.lsp.enable('lemminx')
```

Default config:
- `cmd` :
  ```lua
  { "lemminx" }
  ```
- `filetypes` :
  ```lua
  { "xml", "xsd", "xsl", "xslt", "svg" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## lexical

https://github.com/lexical-lsp/lexical

Lexical is a next-generation language server for the Elixir programming language.

Follow the [Detailed Installation Instructions](https://github.com/lexical-lsp/lexical/blob/main/pages/installation.md)

**By default, `lexical` doesn't have a `cmd` set.**
This is because nvim-lspconfig does not make assumptions about your path.

Snippet to enable the language server:
```lua
vim.lsp.enable('lexical')
```

Default config:
- `filetypes` :
  ```lua
  { "elixir", "eelixir", "heex", "surface" }
  ```
- `root_markers` :
  ```lua
  { "mix.exs", ".git" }
  ```

---

## lsp_ai

https://github.com/SilasMarvin/lsp-ai

LSP-AI is an open source language server that serves as a backend for AI-powered functionality in your favorite code
editors. It offers features like in-editor chatting with LLMs and code completions.


You will need to provide configuration for the inference backends and models you want to use, as well as configure
completion/code actions. See the [wiki docs](https://github.com/SilasMarvin/lsp-ai/wiki/Configuration) and
[examples](https://github.com/SilasMarvin/lsp-ai/blob/main/examples/nvim) for more information.

Snippet to enable the language server:
```lua
vim.lsp.enable('lsp_ai')
```

Default config:
- `cmd` :
  ```lua
  { "lsp-ai" }
  ```
- `filetypes` :
  ```lua
  {}
  ```
- `init_options` :
  ```lua
  {
    memory = {
      file_store = vim.empty_dict()
    },
    models = vim.empty_dict()
  }
  ```

---

## ltex

https://github.com/valentjn/ltex-ls

LTeX Language Server: LSP language server for LanguageTool 🔍✔️ with support for LaTeX 🎓, Markdown 📝, and others

To install, download the latest [release](https://github.com/valentjn/ltex-ls/releases) and ensure `ltex-ls` is on your path.

This server accepts configuration via the `settings` key.

```lua
  settings = {
		ltex = {
			language = "en-GB",
		},
	},
```

To support org files or R sweave, users can define a custom filetype autocommand (or use a plugin which defines these filetypes):

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.org set filetype=org ]]
```

Snippet to enable the language server:
```lua
vim.lsp.enable('ltex')
```

Default config:
- `cmd` :
  ```lua
  { "ltex-ls" }
  ```
- `filetypes` :
  ```lua
  { "bib", "gitcommit", "markdown", "org", "plaintex", "rst", "rnoweb", "tex", "pandoc", "quarto", "rmd", "context", "html", "xhtml", "mail", "text" }
  ```
- `get_language_id` source (use "gF" to open): [../lsp/ltex.lua:74](../lsp/ltex.lua#L74)
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {
    ltex = {
      enabled = { "bibtex", "gitcommit", "markdown", "org", "tex", "restructuredtext", "rsweave", "latex", "quarto", "rmd", "context", "html", "xhtml", "mail", "plaintext" }
    }
  }
  ```

---

## ltex_plus

https://github.com/ltex-plus/ltex-ls-plus

LTeX Language Server: LSP language server for LanguageTool 🔍✔️ with support for LaTeX 🎓, Markdown 📝, and others

To install, download the latest [release](https://github.com/ltex-plus/ltex-ls-plus) and ensure `ltex-ls-plus` is on your path.

This server accepts configuration via the `settings` key.

```lua
  settings = {
    ltex = {
      language = "en-GB",
    },
  },
```

To support org files or R sweave, users can define a custom filetype autocommand (or use a plugin which defines these filetypes):

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.org set filetype=org ]]
```

Snippet to enable the language server:
```lua
vim.lsp.enable('ltex_plus')
```

Default config:
- `cmd` :
  ```lua
  { "ltex-ls-plus" }
  ```
- `filetypes` :
  ```lua
  { "bib", "context", "gitcommit", "html", "markdown", "org", "pandoc", "plaintex", "quarto", "mail", "mdx", "rmd", "rnoweb", "rst", "tex", "text", "typst", "xhtml" }
  ```
- `get_language_id` source (use "gF" to open): [../lsp/ltex_plus.lua:39](../lsp/ltex_plus.lua#L39)
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {
    ltex = {
      enabled = { "bib", "context", "gitcommit", "html", "markdown", "org", "pandoc", "plaintex", "quarto", "mail", "mdx", "rmd", "rnoweb", "rst", "tex", "latex", "text", "typst", "xhtml" }
    }
  }
  ```

---

## lua_ls

https://github.com/luals/lua-language-server

Lua language server.

`lua-language-server` can be installed by following the instructions [here](https://luals.github.io/#neovim-install).

The default `cmd` assumes that the `lua-language-server` binary can be found in `$PATH`.

If you primarily use `lua-language-server` for Neovim, and want to provide completions,
analysis, and location handling for plugins on runtime path, you can use the following
settings.

```lua
vim.lsp.config('lua_ls', {
  on_init = function(client)
    if client.workspace_folders then
      local path = client.workspace_folders[1].name
      if path ~= vim.fn.stdpath('config') and (vim.uv.fs_stat(path..'/.luarc.json') or vim.uv.fs_stat(path..'/.luarc.jsonc')) then
        return
      end
    end

    client.config.settings.Lua = vim.tbl_deep_extend('force', client.config.settings.Lua, {
      runtime = {
        -- Tell the language server which version of Lua you're using
        -- (most likely LuaJIT in the case of Neovim)
        version = 'LuaJIT'
      },
      -- Make the server aware of Neovim runtime files
      workspace = {
        checkThirdParty = false,
        library = {
          vim.env.VIMRUNTIME
          -- Depending on the usage, you might want to add additional paths here.
          -- "${3rd}/luv/library"
          -- "${3rd}/busted/library",
        }
        -- or pull in all of 'runtimepath'. NOTE: this is a lot slower and will cause issues when working on your own configuration (see https://github.com/neovim/nvim-lspconfig/issues/3189)
        -- library = vim.api.nvim_get_runtime_file("", true)
      }
    })
  end,
  settings = {
    Lua = {}
  }
})
```

See `lua-language-server`'s [documentation](https://luals.github.io/wiki/settings/) for an explanation of the above fields:
* [Lua.runtime.path](https://luals.github.io/wiki/settings/#runtimepath)
* [Lua.workspace.library](https://luals.github.io/wiki/settings/#workspacelibrary)

Snippet to enable the language server:
```lua
vim.lsp.enable('lua_ls')
```

Default config:
- `cmd` :
  ```lua
  { "lua-language-server" }
  ```
- `filetypes` :
  ```lua
  { "lua" }
  ```
- `root_markers` :
  ```lua
  { ".luarc.json", ".luarc.jsonc", ".luacheckrc", ".stylua.toml", "stylua.toml", "selene.toml", "selene.yml", ".git" }
  ```

---

## luau_lsp

https://github.com/JohnnyMorganz/luau-lsp

Language server for the [Luau](https://luau-lang.org/) language.

`luau-lsp` can be installed by downloading one of the release assets available at https://github.com/JohnnyMorganz/luau-lsp.

You might also have to set up automatic filetype detection for Luau files, for example like so:

```vim
autocmd BufRead,BufNewFile *.luau setf luau
```

Snippet to enable the language server:
```lua
vim.lsp.enable('luau_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "luau-lsp", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "luau" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## lwc_ls

https://github.com/forcedotcom/lightning-language-server/

Language server for Lightning Web Components.

For manual installation, utilize the official [NPM package](https://www.npmjs.com/package/@salesforce/lwc-language-server).
Then, configure `cmd` to run the Node script at the unpacked location:

```lua
vim.lsp.config('lwc_ls', {
  cmd = {
    'node',
    '/path/to/node_modules/@salesforce/lwc-language-server/bin/lwc-language-server.js',
    '--stdio'
  }
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('lwc_ls')
```

Default config:
- `cmd` :
  ```lua
  { "lwc-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "javascript", "html" }
  ```
- `init_options` :
  ```lua
  {
    embeddedLanguages = {
      javascript = true
    }
  }
  ```
- `root_markers` :
  ```lua
  { "sfdx-project.json" }
  ```

---

## m68k

https://github.com/grahambates/m68k-lsp

Language server for Motorola 68000 family assembly

`m68k-lsp-server` can be installed via `npm`:

```sh
npm install -g m68k-lsp-server
```

Ensure you are using the 68k asm syntax variant in Neovim.

```lua
vim.g.asmsyntax = 'asm68k'
```

Snippet to enable the language server:
```lua
vim.lsp.enable('m68k')
```

Default config:
- `cmd` :
  ```lua
  { "m68k-lsp-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "asm68k" }
  ```
- `root_markers` :
  ```lua
  { "Makefile", ".git" }
  ```

---

## markdown_oxide

https://github.com/Feel-ix-343/markdown-oxide

Editor Agnostic PKM: you bring the text editor and we
bring the PKM.

Inspired by and compatible with Obsidian.

Check the readme to see how to properly setup.

Snippet to enable the language server:
```lua
vim.lsp.enable('markdown_oxide')
```

Default config:
- `cmd` :
  ```lua
  { "markdown-oxide" }
  ```
- `filetypes` :
  ```lua
  { "markdown" }
  ```
- `on_attach` source (use "gF" to open): [../lsp/markdown_oxide.lua:11](../lsp/markdown_oxide.lua#L11)
- `root_markers` :
  ```lua
  { ".git", ".obsidian", ".moxide.toml" }
  ```

---

## marko-js

https://github.com/marko-js/language-server

Using the Language Server Protocol to improve Marko's developer experience.

Can be installed via npm:
```
npm i -g @marko/language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('marko-js')
```

Default config:
- `cmd` :
  ```lua
  { "marko-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "marko" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## marksman

https://github.com/artempyanykh/marksman

Marksman is a Markdown LSP server providing completion, cross-references, diagnostics, and more.

Marksman works on MacOS, Linux, and Windows and is distributed as a self-contained binary for each OS.

Pre-built binaries can be downloaded from https://github.com/artempyanykh/marksman/releases

Snippet to enable the language server:
```lua
vim.lsp.enable('marksman')
```

Default config:
- `cmd` :
  ```lua
  { "marksman", "server" }
  ```
- `filetypes` :
  ```lua
  { "markdown", "markdown.mdx" }
  ```
- `root_markers` :
  ```lua
  { ".marksman.toml", ".git" }
  ```

---

## mdx_analyzer

https://github.com/mdx-js/mdx-analyzer

`mdx-analyzer`, a language server for MDX

Snippet to enable the language server:
```lua
vim.lsp.enable('mdx_analyzer')
```

Default config:
- `before_init` source (use "gF" to open): [../lsp/mdx_analyzer.lua:11](../lsp/mdx_analyzer.lua#L11)
- `cmd` :
  ```lua
  { "mdx-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "mdx" }
  ```
- `init_options` :
  ```lua
  {
    typescript = {}
  }
  ```
- `root_markers` :
  ```lua
  { "package.json" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## mesonlsp

https://github.com/JCWasmx86/mesonlsp

An unofficial, unendorsed language server for meson written in C++

Snippet to enable the language server:
```lua
vim.lsp.enable('mesonlsp')
```

Default config:
- `cmd` :
  ```lua
  { "mesonlsp", "--lsp" }
  ```
- `filetypes` :
  ```lua
  { "meson" }
  ```
- `root_markers` :
  ```lua
  { "meson.build", "meson_options.txt", "meson.options", ".git" }
  ```

---

## metals

https://scalameta.org/metals/

Scala language server with rich IDE features.

See full instructions in the Metals documentation:

https://scalameta.org/metals/docs/editors/vim#using-an-alternative-lsp-client

Note: that if you're using [nvim-metals](https://github.com/scalameta/nvim-metals), that plugin fully handles the setup and installation of Metals, and you shouldn't set up Metals both with it and `lspconfig`.

To install Metals, make sure to have [coursier](https://get-coursier.io/docs/cli-installation) installed, and once you do you can install the latest Metals with `cs install metals`.

Snippet to enable the language server:
```lua
vim.lsp.enable('metals')
```

Default config:
- `capabilities` :
  ```lua
  {
    workspace = {
      configuration = false
    }
  }
  ```
- `cmd` :
  ```lua
  { "metals" }
  ```
- `filetypes` :
  ```lua
  { "scala" }
  ```
- `init_options` :
  ```lua
  {
    compilerOptions = {
      snippetAutoIndent = false
    },
    isHttpEnabled = true,
    statusBarProvider = "show-message"
  }
  ```
- `root_markers` :
  ```lua
  { "build.sbt", "build.sc", "build.gradle", "pom.xml" }
  ```

---

## millet

https://github.com/azdavis/millet

Millet, a language server for Standard ML

To use with nvim:

1. Install a Rust toolchain: https://rustup.rs
2. Clone the repo
3. Run `cargo build --release --bin lang-srv`
4. Move `target/release/lang-srv` to somewhere on your $PATH as `millet`

Snippet to enable the language server:
```lua
vim.lsp.enable('millet')
```

Default config:
- `cmd` :
  ```lua
  { "millet" }
  ```
- `filetypes` :
  ```lua
  { "sml" }
  ```
- `root_markers` :
  ```lua
  { "millet.toml" }
  ```

---

## mint

https://www.mint-lang.com

Install Mint using the [instructions](https://www.mint-lang.com/install).
The language server is included since version 0.12.0.

Snippet to enable the language server:
```lua
vim.lsp.enable('mint')
```

Default config:
- `cmd` :
  ```lua
  { "mint", "ls" }
  ```
- `filetypes` :
  ```lua
  { "mint" }
  ```
- `root_markers` :
  ```lua
  { "mint.json", ".git" }
  ```

---

## mlir_lsp_server

https://mlir.llvm.org/docs/Tools/MLIRLSP/#mlir-lsp-language-server--mlir-lsp-server=

The Language Server for the LLVM MLIR language

`mlir-lsp-server` can be installed at the llvm-project repository (https://github.com/llvm/llvm-project)

Snippet to enable the language server:
```lua
vim.lsp.enable('mlir_lsp_server')
```

Default config:
- `cmd` :
  ```lua
  { "mlir-lsp-server" }
  ```
- `filetypes` :
  ```lua
  { "mlir" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## mlir_pdll_lsp_server

https://mlir.llvm.org/docs/Tools/MLIRLSP/#pdll-lsp-language-server--mlir-pdll-lsp-server

The Language Server for the LLVM PDLL language

`mlir-pdll-lsp-server` can be installed at the llvm-project repository (https://github.com/llvm/llvm-project)

Snippet to enable the language server:
```lua
vim.lsp.enable('mlir_pdll_lsp_server')
```

Default config:
- `cmd` :
  ```lua
  { "mlir-pdll-lsp-server" }
  ```
- `filetypes` :
  ```lua
  { "pdll" }
  ```
- `root_markers` :
  ```lua
  { "pdll_compile_commands.yml", ".git" }
  ```

---

## mm0_ls

https://github.com/digama0/mm0

Language Server for the metamath-zero theorem prover.

Requires [mm0-rs](https://github.com/digama0/mm0/tree/master/mm0-rs) to be installed
and available on the `PATH`.

Snippet to enable the language server:
```lua
vim.lsp.enable('mm0_ls')
```

Default config:
- `cmd` :
  ```lua
  { "mm0-rs", "server" }
  ```
- `filetypes` :
  ```lua
  { "metamath-zero" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## mojo

https://github.com/modularml/mojo

`mojo-lsp-server` can be installed [via Modular](https://developer.modular.com/download)

Mojo is a new programming language that bridges the gap between research and production by combining Python syntax and ecosystem with systems programming and metaprogramming features.

Snippet to enable the language server:
```lua
vim.lsp.enable('mojo')
```

Default config:
- `cmd` :
  ```lua
  { "mojo-lsp-server" }
  ```
- `filetypes` :
  ```lua
  { "mojo" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## motoko_lsp

https://github.com/dfinity/vscode-motoko

Language server for the Motoko programming language.

Snippet to enable the language server:
```lua
vim.lsp.enable('motoko_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "motoko-lsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "motoko" }
  ```
- `init_options` :
  ```lua
  {
    formatter = "auto"
  }
  ```
- `root_markers` :
  ```lua
  { "dfx.json", ".git" }
  ```

---

## move_analyzer

https://github.com/move-language/move/tree/main/language/move-analyzer

Language server for Move

The `move-analyzer` can be installed by running:

```
cargo install --git https://github.com/move-language/move move-analyzer
```

See [`move-analyzer`'s doc](https://github.com/move-language/move/blob/1b258a06e3c7d2bc9174578aac92cca3ac19de71/language/move-analyzer/editors/code/README.md#how-to-install) for details.

Snippet to enable the language server:
```lua
vim.lsp.enable('move_analyzer')
```

Default config:
- `cmd` :
  ```lua
  { "move-analyzer" }
  ```
- `filetypes` :
  ```lua
  { "move" }
  ```
- `root_markers` :
  ```lua
  { "Move.toml" }
  ```

---

## msbuild_project_tools_server

https://github.com/tintoy/msbuild-project-tools-server/

MSBuild Project Tools Server can be installed by following the README.MD on the above repository.

Example config:
```lua
vim.lsp.config('msbuild_project_tools_server', {
  cmd = {'dotnet', '/path/to/server/MSBuildProjectTools.LanguageServer.Host.dll'}
})
```

There's no builtin filetypes for msbuild files, would require some filetype aliases:

```lua
vim.filetype.add({
  extension = {
    props = 'msbuild',
    tasks = 'msbuild',
    targets = 'msbuild',
  },
  pattern = {
    [ [[.*\..*proj]] ] = 'msbuild',
  },
})
```

Optionally tell treesitter to treat `msbuild` as `xml` so you can get syntax highlighting if you have the treesitter-xml-parser installed.

```lua
vim.treesitter.language.register('xml', { 'msbuild' })
```

Snippet to enable the language server:
```lua
vim.lsp.enable('msbuild_project_tools_server')
```

Default config:
- `cmd` :
  ```lua
  { "dotnet", "MSBuildProjectTools.LanguageServer.Host.dll" }
  ```
- `filetypes` :
  ```lua
  { "msbuild" }
  ```
- `init_options` :
  ```lua
  {}
  ```
- `root_dir` source (use "gF" to open): [../lsp/msbuild_project_tools_server.lua:38](../lsp/msbuild_project_tools_server.lua#L38)

---

## muon

https://muon.build

Snippet to enable the language server:
```lua
vim.lsp.enable('muon')
```

Default config:
- `cmd` :
  ```lua
  { "muon", "analyze", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "meson" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/muon.lua:4](../lsp/muon.lua#L4)

---

## mutt_ls

https://github.com/neomutt/mutt-language-server

A language server for (neo)mutt's muttrc. It can be installed via pip.

```sh
pip install mutt-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('mutt_ls')
```

Default config:
- `cmd` :
  ```lua
  { "mutt-language-server" }
  ```
- `filetypes` :
  ```lua
  { "muttrc", "neomuttrc" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## nelua_lsp

https://github.com/codehz/nelua-lsp

nelua-lsp is an experimental nelua language server.

You need [nelua.vim](https://github.com/stefanos82/nelua.vim/blob/main/ftdetect/nelua.vim) for nelua files to be recognized or add this to your config:

in vimscript:
```vimscript
au BufNewFile,BufRead *.nelua setf nelua
```

in lua:
```lua
vim.api.nvim_create_autocmd({ "BufNewFile", "BufRead" }, { pattern = { "*.nelua" }, command = "setf nelua"})
```

**By default, nelua-lsp doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of the unzipped run script or binary.

```lua
vim.lsp.config('nelua_lsp.setup, {
    cmd = { "nelua", "-L", "/path/to/nelua-lsp/", "--script", "/path/to/nelua-lsp/nelua-lsp.lua" },
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('nelua_lsp')
```

Default config:
- `filetypes` :
  ```lua
  { "nelua" }
  ```
- `root_markers` :
  ```lua
  { "Makefile", ".git", "*.nelua" }
  ```

---

## neocmake

https://github.com/Decodetalkers/neocmakelsp

CMake LSP Implementation

Neovim does not currently include built-in snippets. `neocmakelsp` only provides completions when snippet support is enabled. To enable completion, install a snippet plugin and add the following override to your language client capabilities during setup.

```lua
--Enable (broadcasting) snippet capability for completion
local capabilities = vim.lsp.protocol.make_client_capabilities()
capabilities.textDocument.completion.completionItem.snippetSupport = true

vim.lsp.config('neocmake', {
  capabilities = capabilities,
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('neocmake')
```

Default config:
- `cmd` :
  ```lua
  { "neocmakelsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "cmake" }
  ```
- `root_markers` :
  ```lua
  { ".git", "build", "cmake" }
  ```

---

## nextflow_ls

https://github.com/nextflow-io/language-server

Requirements:
 - Java 17+

`nextflow_ls` can be installed by following the instructions [here](https://github.com/nextflow-io/language-server#development).

If you have installed nextflow language server, you can set the `cmd` custom path as follow:

```lua
vim.lsp.config('nextflow_ls', {
    cmd = { 'java', '-jar', 'nextflow-language-server-all.jar' },
    filetypes = { 'nextflow' },
    settings = {
      nextflow = {
        files = {
          exclude = { '.git', '.nf-test', 'work' },
        },
      },
    },
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('nextflow_ls')
```

Default config:
- `cmd` :
  ```lua
  { "java", "-jar", "nextflow-language-server-all.jar" }
  ```
- `filetypes` :
  ```lua
  { "nextflow" }
  ```
- `root_markers` :
  ```lua
  { "nextflow.config", ".git" }
  ```
- `settings` :
  ```lua
  {
    nextflow = {
      files = {
        exclude = { ".git", ".nf-test", "work" }
      }
    }
  }
  ```

---

## nextls

https://github.com/elixir-tools/next-ls

**By default, next-ls does not set its `cmd`. Please see the following [detailed instructions](https://www.elixir-tools.dev/docs/next-ls/installation/) for possible installation methods.**

Snippet to enable the language server:
```lua
vim.lsp.enable('nextls')
```

Default config:
- `filetypes` :
  ```lua
  { "elixir", "eelixir", "heex", "surface" }
  ```
- `root_markers` :
  ```lua
  { "mix.exs", ".git" }
  ```

---

## nginx_language_server

https://pypi.org/project/nginx-language-server/

`nginx-language-server` can be installed via pip:

```sh
pip install -U nginx-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('nginx_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "nginx-language-server" }
  ```
- `filetypes` :
  ```lua
  { "nginx" }
  ```
- `root_markers` :
  ```lua
  { "nginx.conf", ".git" }
  ```

---

## nickel_ls

Nickel Language Server

https://github.com/tweag/nickel

`nls` can be installed with nix, or cargo, from the Nickel repository.
```sh
git clone https://github.com/tweag/nickel.git
```

Nix:
```sh
cd nickel
nix-env -f . -i
```

cargo:
```sh
cd nickel/lsp/nls
cargo install --path .
```

In order to have lspconfig detect Nickel filetypes (a prerequisite for autostarting a server),
install the [Nickel vim plugin](https://github.com/nickel-lang/vim-nickel).

Snippet to enable the language server:
```lua
vim.lsp.enable('nickel_ls')
```

Default config:
- `cmd` :
  ```lua
  { "nls" }
  ```
- `filetypes` :
  ```lua
  { "ncl", "nickel" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## nil_ls

https://github.com/oxalica/nil

A new language server for Nix Expression Language.

If you are using Nix with Flakes support, run `nix profile install github:oxalica/nil` to install.
Check the repository README for more information.

_See an example config at https://github.com/oxalica/nil/blob/main/dev/nvim-lsp.nix._

Snippet to enable the language server:
```lua
vim.lsp.enable('nil_ls')
```

Default config:
- `cmd` :
  ```lua
  { "nil" }
  ```
- `filetypes` :
  ```lua
  { "nix" }
  ```
- `root_markers` :
  ```lua
  { "flake.nix", ".git" }
  ```

---

## nim_langserver

https://github.com/nim-lang/langserver


`nim-langserver` can be installed via the `nimble` package manager:
```sh
nimble install nimlangserver
```

Snippet to enable the language server:
```lua
vim.lsp.enable('nim_langserver')
```

Default config:
- `cmd` :
  ```lua
  { "nimlangserver" }
  ```
- `filetypes` :
  ```lua
  { "nim" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/nim_langserver.lua:13](../lsp/nim_langserver.lua#L13)

---

## nimls

https://github.com/PMunch/nimlsp

`nimlsp` can be installed via the `nimble` package manager:

```sh
nimble install nimlsp
```

Snippet to enable the language server:
```lua
vim.lsp.enable('nimls')
```

Default config:
- `cmd` :
  ```lua
  { "nimlsp" }
  ```
- `filetypes` :
  ```lua
  { "nim" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/nimls.lua:13](../lsp/nimls.lua#L13)

---

## nixd

https://github.com/nix-community/nixd

Nix language server, based on nix libraries.

If you are using Nix with Flakes support, run `nix profile install github:nix-community/nixd` to install.
Check the repository README for more information.

Snippet to enable the language server:
```lua
vim.lsp.enable('nixd')
```

Default config:
- `cmd` :
  ```lua
  { "nixd" }
  ```
- `filetypes` :
  ```lua
  { "nix" }
  ```
- `root_markers` :
  ```lua
  { "flake.nix", "git" }
  ```

---

## nomad_lsp

https://github.com/juliosueiras/nomad-lsp

Written in Go, compilation is needed for `nomad_lsp` to be used. Please see the [original repository](https://github.com/juliosuieras/nomad-lsp).

Add the executable to your system or vim PATH and it will be set to go.

No configuration option is needed unless you choose not to add `nomad-lsp` executable to the PATH. You should know what you are doing if you choose so.

```lua
vim.lsp.enable('nomad_lsp')
```

However, a `hcl.nomad` or `nomad` filetype should be defined.

Description of your jobs should be written in `.nomad` files for the LSP client to configure the server's `root_dir` configuration option.

Snippet to enable the language server:
```lua
vim.lsp.enable('nomad_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "nomad-lsp" }
  ```
- `filetypes` :
  ```lua
  { "hcl.nomad", "nomad" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/nomad_lsp.lua:26](../lsp/nomad_lsp.lua#L26)

---

## ntt

https://github.com/nokia/ntt
Installation instructions can be found [here](https://github.com/nokia/ntt#Install).
Can be configured by passing a "settings" object to `ntt.setup{}`:
```lua
vim.lsp.config('ntt', {
    settings = {
      ntt = {
      }
    }
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('ntt')
```

Default config:
- `cmd` :
  ```lua
  { "ntt", "langserver" }
  ```
- `filetypes` :
  ```lua
  { "ttcn" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## nushell

https://github.com/nushell/nushell

Nushell built-in language server.

Snippet to enable the language server:
```lua
vim.lsp.enable('nushell')
```

Default config:
- `cmd` :
  ```lua
  { "nu", "--lsp" }
  ```
- `filetypes` :
  ```lua
  { "nu" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## nxls

https://github.com/nrwl/nx-console/tree/master/apps/nxls

nxls, a language server for Nx Workspaces

`nxls` can be installed via `npm`:
```sh
npm i -g nxls
```

Snippet to enable the language server:
```lua
vim.lsp.enable('nxls')
```

Default config:
- `cmd` :
  ```lua
  { "nxls", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "json", "jsonc" }
  ```
- `root_markers` :
  ```lua
  { "nx.json", ".git" }
  ```

---

## ocamlls

https://github.com/ocaml-lsp/ocaml-language-server

`ocaml-language-server` can be installed via `npm`
```sh
npm install -g ocaml-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('ocamlls')
```

Default config:
- `cmd` :
  ```lua
  { "ocaml-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "ocaml", "reason" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/ocamlls.lua:12](../lsp/ocamlls.lua#L12)

---

## ocamllsp

https://github.com/ocaml/ocaml-lsp

`ocaml-lsp` can be installed as described in [installation guide](https://github.com/ocaml/ocaml-lsp#installation).

To install the lsp server in a particular opam switch:
```sh
opam install ocaml-lsp-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('ocamllsp')
```

Default config:
- `cmd` :
  ```lua
  { "ocamllsp" }
  ```
- `filetypes` :
  ```lua
  { "ocaml", "menhir", "ocamlinterface", "ocamllex", "reason", "dune" }
  ```
- `get_language_id` source (use "gF" to open): [../lsp/ocamllsp.lua:27](../lsp/ocamllsp.lua#L27)
- `root_dir` source (use "gF" to open): [../lsp/ocamllsp.lua:27](../lsp/ocamllsp.lua#L27)

---

## ols

https://github.com/DanielGavin/ols

`Odin Language Server`.

Snippet to enable the language server:
```lua
vim.lsp.enable('ols')
```

Default config:
- `cmd` :
  ```lua
  { "ols" }
  ```
- `filetypes` :
  ```lua
  { "odin" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/ols.lua:9](../lsp/ols.lua#L9)

---

## omnisharp

https://github.com/omnisharp/omnisharp-roslyn
OmniSharp server based on Roslyn workspaces

`omnisharp-roslyn` can be installed by downloading and extracting a release from [here](https://github.com/OmniSharp/omnisharp-roslyn/releases).
OmniSharp can also be built from source by following the instructions [here](https://github.com/omnisharp/omnisharp-roslyn#downloading-omnisharp).

OmniSharp requires the [dotnet-sdk](https://dotnet.microsoft.com/download) to be installed.

**By default, omnisharp-roslyn doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path. You must add the following to your init.vim or init.lua to set `cmd` to the absolute path ($HOME and ~ are not expanded) of the unzipped run script or binary.

For `go_to_definition` to work fully, extended `textDocument/definition` handler is needed, for example see [omnisharp-extended-lsp.nvim](https://github.com/Hoffs/omnisharp-extended-lsp.nvim)

Snippet to enable the language server:
```lua
vim.lsp.enable('omnisharp')
```

Default config:
- `capabilities` :
  ```lua
  {
    workspace = {
      workspaceFolders = false
    }
  }
  ```
- `cmd` :
  ```lua
  { "OmniSharp", "-z", "--hostPID", "12345", "DotNet:enablePackageRestore=false", "--encoding", "utf-8", "--languageserver" }
  ```
- `filetypes` :
  ```lua
  { "cs", "vb" }
  ```
- `init_options` :
  ```lua
  {}
  ```
- `root_markers` :
  ```lua
  { ".sln", ".csproj", "omnisharp.json", "function.json" }
  ```
- `settings` :
  ```lua
  {
    FormattingOptions = {
      EnableEditorConfigSupport = true
    },
    MsBuild = {},
    RenameOptions = {},
    RoslynExtensionsOptions = {},
    Sdk = {
      IncludePrereleases = true
    }
  }
  ```

---

## opencl_ls

https://github.com/Galarius/opencl-language-server

Build instructions can be found [here](https://github.com/Galarius/opencl-language-server/blob/main/_dev/build.md).

Prebuilt binaries are available for Linux, macOS and Windows [here](https://github.com/Galarius/opencl-language-server/releases).

Snippet to enable the language server:
```lua
vim.lsp.enable('opencl_ls')
```

Default config:
- `cmd` :
  ```lua
  { "opencl-language-server" }
  ```
- `filetypes` :
  ```lua
  { "opencl" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## openscad_ls

https://github.com/dzhu/openscad-language-server

A Language Server Protocol server for OpenSCAD

You can build and install `openscad-language-server` binary with `cargo`:
```sh
cargo install openscad-language-server
```

Vim does not have built-in syntax for the `openscad` filetype currently.

This can be added via an autocmd:

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.scad set filetype=openscad ]]
```

or by installing a filetype plugin such as https://github.com/sirtaj/vim-openscad

Snippet to enable the language server:
```lua
vim.lsp.enable('openscad_ls')
```

Default config:
- `cmd` :
  ```lua
  { "openscad-language-server" }
  ```
- `filetypes` :
  ```lua
  { "openscad" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## openscad_lsp

https://github.com/Leathong/openscad-LSP

A Language Server Protocol server for OpenSCAD

You can build and install `openscad-lsp` binary with `cargo`:
```sh
cargo install openscad-lsp
```

Snippet to enable the language server:
```lua
vim.lsp.enable('openscad_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "openscad-lsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "openscad" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## pact_ls

https://github.com/kadena-io/pact-lsp

The Pact language server

Snippet to enable the language server:
```lua
vim.lsp.enable('pact_ls')
```

Default config:
- `cmd` :
  ```lua
  { "pact-lsp" }
  ```
- `filetypes` :
  ```lua
  { "pact" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## pasls

https://github.com/genericptr/pascal-language-server

An LSP server implementation for Pascal variants that are supported by Free Pascal, including Object Pascal. It uses CodeTools from Lazarus as backend.

First set `cmd` to the Pascal lsp binary.

Customization options are passed to pasls as environment variables for example in your `.bashrc`:
```bash
export FPCDIR='/usr/lib/fpc/src'      # FPC source directory (This is the only required option for the server to work).
export PP='/usr/lib/fpc/3.2.2/ppcx64' # Path to the Free Pascal compiler executable.
export LAZARUSDIR='/usr/lib/lazarus'  # Path to the Lazarus sources.
export FPCTARGET=''                   # Target operating system for cross compiling.
export FPCTARGETCPU='x86_64'          # Target CPU for cross compiling.
```

Snippet to enable the language server:
```lua
vim.lsp.enable('pasls')
```

Default config:
- `cmd` :
  ```lua
  { "pasls" }
  ```
- `filetypes` :
  ```lua
  { "pascal" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/pasls.lua:20](../lsp/pasls.lua#L20)

---

## pbls

https://git.sr.ht/~rrc/pbls

Prerequisites: Ensure protoc is on your $PATH.

`pbls` can be installed via `cargo install`:
```sh
cargo install --git https://git.sr.ht/~rrc/pbls
```

pbls is a Language Server for protobuf

Snippet to enable the language server:
```lua
vim.lsp.enable('pbls')
```

Default config:
- `cmd` :
  ```lua
  { "pbls" }
  ```
- `filetypes` :
  ```lua
  { "proto" }
  ```
- `root_markers` :
  ```lua
  { ".pbls.toml", ".git" }
  ```

---

## perlls

https://github.com/richterger/Perl-LanguageServer/tree/master/clients/vscode/perl

`Perl-LanguageServer`, a language server for Perl.

To use the language server, ensure that you have Perl::LanguageServer installed and perl command is on your path.

Snippet to enable the language server:
```lua
vim.lsp.enable('perlls')
```

Default config:
- `cmd` :
  ```lua
  { "perl", "-MPerl::LanguageServer", "-e", "Perl::LanguageServer::run", "--", "--port 13603", "--nostdio 0" }
  ```
- `filetypes` :
  ```lua
  { "perl" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {
    perl = {
      fileFilter = { ".pm", ".pl" },
      ignoreDirs = ".git",
      perlCmd = "perl",
      perlInc = " "
    }
  }
  ```

---

## perlnavigator

https://github.com/bscan/PerlNavigator

A Perl language server. It can be installed via npm:

```sh
npm i -g perlnavigator-server
```

At minimum, you will need `perl` in your path. If you want to use a non-standard `perl` you will need to set your configuration like so:
```lua
settings = {
  perlnavigator = {
    perlPath = '/some/odd/location/my-perl'
  }
}
```

The `contributes.configuration.properties` section of `perlnavigator`'s `package.json` has all available configuration settings. All
settings have a reasonable default, but, at minimum, you may want to point `perlnavigator` at your `perltidy` and `perlcritic` configurations.

Snippet to enable the language server:
```lua
vim.lsp.enable('perlnavigator')
```

Default config:
- `cmd` :
  ```lua
  { "perlnavigator" }
  ```
- `filetypes` :
  ```lua
  { "perl" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## perlpls

https://github.com/FractalBoy/perl-language-server
https://metacpan.org/pod/PLS

`PLS`, another language server for Perl.

To use the language server, ensure that you have PLS installed and that it is in your path

Snippet to enable the language server:
```lua
vim.lsp.enable('perlpls')
```

Default config:
- `cmd` :
  ```lua
  { "pls" }
  ```
- `filetypes` :
  ```lua
  { "perl" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {
    perl = {
      perlcritic = {
        enabled = false
      },
      syntax = {
        enabled = true
      }
    }
  }
  ```

---

## pest_ls

https://github.com/pest-parser/pest-ide-tools

Language server for pest grammars.

Snippet to enable the language server:
```lua
vim.lsp.enable('pest_ls')
```

Default config:
- `cmd` :
  ```lua
  { "pest-language-server" }
  ```
- `filetypes` :
  ```lua
  { "pest" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## phan

https://github.com/phan/phan

Installation: https://github.com/phan/phan#getting-started

Snippet to enable the language server:
```lua
vim.lsp.enable('phan')
```

Default config:
- `cmd` :
  ```lua
  { "phan", "-m", "json", "--no-color", "--no-progress-bar", "-x", "-u", "-S", "--language-server-on-stdin", "--allow-polyfill-parser" }
  ```
- `filetypes` :
  ```lua
  { "php" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/phan.lua:22](../lsp/phan.lua#L22)

---

## phpactor

https://github.com/phpactor/phpactor

Installation: https://phpactor.readthedocs.io/en/master/usage/standalone.html#global-installation

Snippet to enable the language server:
```lua
vim.lsp.enable('phpactor')
```

Default config:
- `cmd` :
  ```lua
  { "phpactor", "language-server" }
  ```
- `filetypes` :
  ```lua
  { "php" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/phpactor.lua:9](../lsp/phpactor.lua#L9)

---

## pico8_ls

https://github.com/japhib/pico8-ls

Full language support for the PICO-8 dialect of Lua.

Snippet to enable the language server:
```lua
vim.lsp.enable('pico8_ls')
```

Default config:
- `cmd` :
  ```lua
  { "pico8-ls", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "p8" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/pico8_ls.lua:9](../lsp/pico8_ls.lua#L9)
- `settings` :
  ```lua
  {}
  ```

---

## pkgbuild_language_server

https://github.com/Freed-Wu/pkgbuild-language-server

Language server for ArchLinux/Windows Msys2's PKGBUILD.

Snippet to enable the language server:
```lua
vim.lsp.enable('pkgbuild_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "pkgbuild-language-server" }
  ```
- `filetypes` :
  ```lua
  { "PKGBUILD" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## please

https://github.com/thought-machine/please

High-performance extensible build system for reproducible multi-language builds.

The `plz` binary will automatically install the LSP for you on first run

Snippet to enable the language server:
```lua
vim.lsp.enable('please')
```

Default config:
- `cmd` :
  ```lua
  { "plz", "tool", "lps" }
  ```
- `filetypes` :
  ```lua
  { "bzl" }
  ```
- `root_markers` :
  ```lua
  { ".plzconfig" }
  ```

---

## pli

`pli_language_server` is a language server for the PL/I language used on IBM SystemZ mainframes.

To learn how to configure the PL/I language server, see the [PL/I Language Support documentation](https://github.com/zowe/zowe-pli-language-support).

Snippet to enable the language server:
```lua
vim.lsp.enable('pli')
```

Default config:
- `cmd` :
  ```lua
  { "pli_language_server" }
  ```
- `filetypes` :
  ```lua
  { "pli" }
  ```
- `root_markers` :
  ```lua
  { ".pliplugin" }
  ```

---

## poryscript_pls

https://github.com/huderlem/poryscript-pls

Language server for poryscript (a high level scripting language for GBA-era Pokémon decompilation projects)

Snippet to enable the language server:
```lua
vim.lsp.enable('poryscript_pls')
```

Default config:
- `cmd` :
  ```lua
  { "poryscript-pls" }
  ```
- `filetypes` :
  ```lua
  { "pory" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## postgres_lsp

https://pgtools.dev

A collection of language tools and a Language Server Protocol (LSP) implementation for Postgres, focusing on developer experience and reliable SQL tooling.

Snippet to enable the language server:
```lua
vim.lsp.enable('postgres_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "postgrestools", "lsp-proxy" }
  ```
- `filetypes` :
  ```lua
  { "sql" }
  ```
- `root_markers` :
  ```lua
  { "postgrestools.jsonc" }
  ```

---

## prismals

Language Server for the Prisma JavaScript and TypeScript ORM

`@prisma/language-server` can be installed via npm
```sh
npm install -g @prisma/language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('prismals')
```

Default config:
- `cmd` :
  ```lua
  { "prisma-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "prisma" }
  ```
- `root_markers` :
  ```lua
  { ".git", "package.json" }
  ```
- `settings` :
  ```lua
  {
    prisma = {
      prismaFmtBinPath = ""
    }
  }
  ```

---

## prolog_ls

https://github.com/jamesnvc/lsp_server

Language Server Protocol server for SWI-Prolog

Snippet to enable the language server:
```lua
vim.lsp.enable('prolog_ls')
```

Default config:
- `cmd` :
  ```lua
  { "swipl", "-g", "use_module(library(lsp_server)).", "-g", "lsp_server:main", "-t", "halt", "--", "stdio" }
  ```
- `filetypes` :
  ```lua
  { "prolog" }
  ```
- `root_markers` :
  ```lua
  { "pack.pl" }
  ```

---

## prosemd_lsp

https://github.com/kitten/prosemd-lsp

An experimental LSP for Markdown.

Please see the manual installation instructions: https://github.com/kitten/prosemd-lsp#manual-installation

Snippet to enable the language server:
```lua
vim.lsp.enable('prosemd_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "prosemd-lsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "markdown" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## protols

https://github.com/coder3101/protols

`protols` can be installed via `cargo`:
```sh
cargo install protols
```

A Language Server for proto3 files. It uses tree-sitter and runs in single file mode.

Snippet to enable the language server:
```lua
vim.lsp.enable('protols')
```

Default config:
- `cmd` :
  ```lua
  { "protols" }
  ```
- `filetypes` :
  ```lua
  { "proto" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## psalm

https://github.com/vimeo/psalm

Can be installed with composer.
```sh
composer global require vimeo/psalm
```

Snippet to enable the language server:
```lua
vim.lsp.enable('psalm')
```

Default config:
- `cmd` :
  ```lua
  { "psalm", "--language-server" }
  ```
- `filetypes` :
  ```lua
  { "php" }
  ```
- `root_markers` :
  ```lua
  { "psalm.xml", "psalm.xml.dist" }
  ```

---

## pug

https://github.com/opa-oz/pug-lsp

An implementation of the Language Protocol Server for [Pug.js](http://pugjs.org)

PugLSP can be installed via `go get github.com/opa-oz/pug-lsp`, or manually downloaded from [releases page](https://github.com/opa-oz/pug-lsp/releases)

Snippet to enable the language server:
```lua
vim.lsp.enable('pug')
```

Default config:
- `cmd` :
  ```lua
  { "pug-lsp" }
  ```
- `filetypes` :
  ```lua
  { "pug" }
  ```
- `root_markers` :
  ```lua
  { "package.json" }
  ```

---

## puppet

LSP server for Puppet.

Installation:

- Clone the editor-services repository:
    https://github.com/puppetlabs/puppet-editor-services

- Navigate into that directory and run: `bundle install`

- Install the 'puppet-lint' gem: `gem install puppet-lint`

- Add that repository to $PATH.

- Ensure you can run `puppet-languageserver` from outside the editor-services directory.

Snippet to enable the language server:
```lua
vim.lsp.enable('puppet')
```

Default config:
- `cmd` :
  ```lua
  { "puppet-languageserver", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "puppet" }
  ```
- `root_markers` :
  ```lua
  { "manifests", ".puppet-lint.rc", "hiera.yaml", ".git" }
  ```

---

## purescriptls

https://github.com/nwolverson/purescript-language-server

The `purescript-language-server` can be added to your project and `$PATH` via

* JavaScript package manager such as npm, pnpm, Yarn, et al.
* Nix under the `nodePackages` and `nodePackages_latest` package sets

Snippet to enable the language server:
```lua
vim.lsp.enable('purescriptls')
```

Default config:
- `cmd` :
  ```lua
  { "purescript-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "purescript" }
  ```
- `root_markers` :
  ```lua
  { "bower.json", "flake.nix", "psc-package.json", "shell.nix", "spago.dhall", "spago.yaml" }
  ```

---

## pylsp

https://github.com/python-lsp/python-lsp-server

A Python 3.6+ implementation of the Language Server Protocol.

See the [project's README](https://github.com/python-lsp/python-lsp-server) for installation instructions.

Configuration options are documented [here](https://github.com/python-lsp/python-lsp-server/blob/develop/CONFIGURATION.md).
In order to configure an option, it must be translated to a nested Lua table and included in the `settings` argument to the `config('pylsp', {})` function.
For example, in order to set the `pylsp.plugins.pycodestyle.ignore` option:
```lua
vim.lsp.config('pylsp', {
  settings = {
    pylsp = {
      plugins = {
        pycodestyle = {
          ignore = {'W391'},
          maxLineLength = 100
        }
      }
    }
  }
})
```

Note: This is a community fork of `pyls`.

Snippet to enable the language server:
```lua
vim.lsp.enable('pylsp')
```

Default config:
- `cmd` :
  ```lua
  { "pylsp" }
  ```
- `filetypes` :
  ```lua
  { "python" }
  ```
- `root_markers` :
  ```lua
  { "pyproject.toml", "setup.py", "setup.cfg", "requirements.txt", "Pipfile", ".git" }
  ```

---

## pylyzer

https://github.com/mtshiba/pylyzer

`pylyzer`, a fast static code analyzer & language server for Python.

Snippet to enable the language server:
```lua
vim.lsp.enable('pylyzer')
```

Default config:
- `cmd` :
  ```lua
  { "pylyzer", "--server" }
  ```
- `filetypes` :
  ```lua
  { "python" }
  ```
- `root_markers` :
  ```lua
  { "setup.py", "tox.ini", "requirements.txt", "Pipfile", "pyproject.toml", ".git" }
  ```
- `settings` :
  ```lua
  {
    python = {
      checkOnType = false,
      diagnostics = true,
      inlayHints = true,
      smartCompletion = true
    }
  }
  ```

---

## pyre

https://pyre-check.org/

`pyre` a static type checker for Python 3.

`pyre` offers an extremely limited featureset. It currently only supports diagnostics,
which are triggered on save.

Do not report issues for missing features in `pyre` to `lspconfig`.

Snippet to enable the language server:
```lua
vim.lsp.enable('pyre')
```

Default config:
- `cmd` :
  ```lua
  { "pyre", "persistent" }
  ```
- `filetypes` :
  ```lua
  { "python" }
  ```
- `root_markers` :
  ```lua
  { ".pyre_configuration" }
  ```

---

## pyright

https://github.com/microsoft/pyright

`pyright`, a static type checker and language server for python

Snippet to enable the language server:
```lua
vim.lsp.enable('pyright')
```

Default config:
- `cmd` :
  ```lua
  { "pyright-langserver", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "python" }
  ```
- `on_attach` source (use "gF" to open): [../lsp/pyright.lua:22](../lsp/pyright.lua#L22)
- `root_markers` :
  ```lua
  { "pyproject.toml", "setup.py", "setup.cfg", "requirements.txt", "Pipfile", "pyrightconfig.json", ".git" }
  ```
- `settings` :
  ```lua
  {
    python = {
      analysis = {
        autoSearchPaths = true,
        diagnosticMode = "openFilesOnly",
        useLibraryCodeForTypes = true
      }
    }
  }
  ```

---

## qmlls

https://doc.qt.io/qt-6/qtqml-tooling-qmlls.html

> QML Language Server is a tool shipped with Qt that helps you write code in your favorite (LSP-supporting) editor.

Source in the [QtDeclarative repository](https://code.qt.io/cgit/qt/qtdeclarative.git/)

Snippet to enable the language server:
```lua
vim.lsp.enable('qmlls')
```

Default config:
- `cmd` :
  ```lua
  { "qmlls" }
  ```
- `filetypes` :
  ```lua
  { "qml", "qmljs" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## quick_lint_js

https://quick-lint-js.com/

quick-lint-js finds bugs in JavaScript programs.

See installation [instructions](https://quick-lint-js.com/install/)

Snippet to enable the language server:
```lua
vim.lsp.enable('quick_lint_js')
```

Default config:
- `cmd` :
  ```lua
  { "quick-lint-js", "--lsp-server" }
  ```
- `filetypes` :
  ```lua
  { "javascript", "typescript" }
  ```
- `root_markers` :
  ```lua
  { "package.json", "jsconfig.json", ".git" }
  ```

---

## r_language_server

[languageserver](https://github.com/REditorSupport/languageserver) is an
implementation of the Microsoft's Language Server Protocol for the R
language.

It is released on CRAN and can be easily installed by

```r
install.packages("languageserver")
```

Snippet to enable the language server:
```lua
vim.lsp.enable('r_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "R", "--no-echo", "-e", "languageserver::run()" }
  ```
- `filetypes` :
  ```lua
  { "r", "rmd", "quarto" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/r_language_server.lua:12](../lsp/r_language_server.lua#L12)

---

## racket_langserver

[https://github.com/jeapostrophe/racket-langserver](https://github.com/jeapostrophe/racket-langserver)

The Racket language server. This project seeks to use
[DrRacket](https://github.com/racket/drracket)'s public API to provide
functionality that mimics DrRacket's code tools as closely as possible.

Install via `raco`: `raco pkg install racket-langserver`

Snippet to enable the language server:
```lua
vim.lsp.enable('racket_langserver')
```

Default config:
- `cmd` :
  ```lua
  { "racket", "--lib", "racket-langserver" }
  ```
- `filetypes` :
  ```lua
  { "racket", "scheme" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## raku_navigator

https://github.com/bscan/RakuNavigator
A Raku language server
**By default, raku_navigator doesn't have a `cmd` set.** This is because nvim-lspconfig does not make assumptions about your path.
You have to install the language server manually.
Clone the RakuNavigator repo, install based on the [instructions](https://github.com/bscan/raku_Navigator#installation-for-other-editors),
and point `cmd` to `server.js` inside the `server/out` directory:
```lua
cmd = {'node', '<path_to_repo>/server/out/server.js', '--stdio'}
```
At minimum, you will need `raku` in your path. If you want to use a non-standard `raku` you will need to set your configuration like so:
```lua
settings = {
  raku_navigator = {
    rakuPath = '/some/odd/location/my-raku'
  }
}
```
The `contributes.configuration.properties` section of `raku_navigator`'s `package.json` has all available configuration settings. All
settings have a reasonable default, but, at minimum, you may want to point `raku_navigator` at your `raku_tidy` and `raku_critic` configurations.

Snippet to enable the language server:
```lua
vim.lsp.enable('raku_navigator')
```

Default config:
- `cmd` :
  ```lua
  {}
  ```
- `filetypes` :
  ```lua
  { "raku" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## reason_ls

Reason language server

You can install reason language server from [reason-language-server](https://github.com/jaredly/reason-language-server) repository.

Snippet to enable the language server:
```lua
vim.lsp.enable('reason_ls')
```

Default config:
- `cmd` :
  ```lua
  { "reason-language-server" }
  ```
- `filetypes` :
  ```lua
  { "reason" }
  ```
- `root_markers` :
  ```lua
  { "bsconfig.json", ".git" }
  ```

---

## regal

https://github.com/StyraInc/regal

A linter for Rego, with support for running as an LSP server.

`regal` can be installed by running:
```sh
go install github.com/StyraInc/regal@latest
```

Snippet to enable the language server:
```lua
vim.lsp.enable('regal')
```

Default config:
- `cmd` :
  ```lua
  { "regal", "language-server" }
  ```
- `filetypes` :
  ```lua
  { "rego" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/regal.lua:14](../lsp/regal.lua#L14)

---

## regols

https://github.com/kitagry/regols

OPA Rego language server.

`regols` can be installed by running:
```sh
go install github.com/kitagry/regols@latest
```

Snippet to enable the language server:
```lua
vim.lsp.enable('regols')
```

Default config:
- `cmd` :
  ```lua
  { "regols" }
  ```
- `filetypes` :
  ```lua
  { "rego" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/regols.lua:14](../lsp/regols.lua#L14)

---

## remark_ls

https://github.com/remarkjs/remark-language-server

`remark-language-server` can be installed via `npm`:
```sh
npm install -g remark-language-server
```

`remark-language-server` uses the same
[configuration files](https://github.com/remarkjs/remark/tree/main/packages/remark-cli#example-config-files-json-yaml-js)
as `remark-cli`.

This uses a plugin based system. Each plugin needs to be installed locally using `npm` or `yarn`.

For example, given the following `.remarkrc.json`:

```json
{
  "presets": [
    "remark-preset-lint-recommended"
  ]
}
```

`remark-preset-lint-recommended` needs to be installed in the local project:

```sh
npm install remark-preset-lint-recommended
```

Snippet to enable the language server:
```lua
vim.lsp.enable('remark_ls')
```

Default config:
- `cmd` :
  ```lua
  { "remark-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "markdown" }
  ```
- `root_markers` :
  ```lua
  { ".remarkrc", ".remarkrc.json", ".remarkrc.js", ".remarkrc.cjs", ".remarkrc.mjs", ".remarkrc.yml", ".remarkrc.yaml", ".remarkignore" }
  ```

---

## rescriptls

https://github.com/rescript-lang/rescript-vscode/tree/master/server

ReScript Language Server can be installed via npm:
```sh
npm install -g @rescript/language-server
```

See [package.json](https://github.com/rescript-lang/rescript-vscode/blob/master/package.json#L139)
for init_options supported.

For example, in order to disable the `inlayHints` option:
```lua
vim.lsp.config('rescriptls', {
  settings = {
    rescript = {
      settings = {
        inlayHints = { enable = false },
      },
    },
  })
}
```

Snippet to enable the language server:
```lua
vim.lsp.enable('rescriptls')
```

Default config:
- `cmd` :
  ```lua
  { "rescript-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "rescript" }
  ```
- `init_options` :
  ```lua
  {
    extensionConfiguration = {
      allowBuiltInFormatter = true,
      askToStartBuild = false,
      cache = {
        projectConfig = {
          enabled = true
        }
      },
      codeLens = true,
      incrementalTypechecking = {
        acrossFiles = true,
        enabled = true
      },
      inlayHints = {
        enable = true
      }
    }
  }
  ```
- `root_markers` :
  ```lua
  { "bsconfig.json", "rescript.json", ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## rls

https://github.com/rust-lang/rls

rls, a language server for Rust

See https://github.com/rust-lang/rls#setup to setup rls itself.
See https://github.com/rust-lang/rls#configuration for rls-specific settings.
All settings listed on the rls configuration section of the readme
must be set under settings.rust as follows:

```lua
vim.lsp.config('rls', {
  settings = {
    rust = {
      unstable_features = true,
      build_on_save = false,
      all_features = true,
    },
  },
})
```

If you want to use rls for a particular build, eg nightly, set cmd as follows:

```lua
cmd = {"rustup", "run", "nightly", "rls"}
```

Snippet to enable the language server:
```lua
vim.lsp.enable('rls')
```

Default config:
- `cmd` :
  ```lua
  { "rls" }
  ```
- `filetypes` :
  ```lua
  { "rust" }
  ```
- `root_markers` :
  ```lua
  { "Cargo.toml" }
  ```

---

## rnix

https://github.com/nix-community/rnix-lsp

A language server for Nix providing basic completion and formatting via nixpkgs-fmt.

To install manually, run `cargo install rnix-lsp`. If you are using nix, rnix-lsp is in nixpkgs.

This server accepts configuration via the `settings` key.

Snippet to enable the language server:
```lua
vim.lsp.enable('rnix')
```

Default config:
- `cmd` :
  ```lua
  { "rnix-lsp" }
  ```
- `filetypes` :
  ```lua
  { "nix" }
  ```
- `init_options` :
  ```lua
  {}
  ```
- `root_dir` source (use "gF" to open): [../lsp/rnix.lua:10](../lsp/rnix.lua#L10)
- `settings` :
  ```lua
  {}
  ```

---

## robotcode

https://robotcode.io

RobotCode - Language Server Protocol implementation for Robot Framework.

Snippet to enable the language server:
```lua
vim.lsp.enable('robotcode')
```

Default config:
- `cmd` :
  ```lua
  { "robotcode", "language-server" }
  ```
- `filetypes` :
  ```lua
  { "robot", "resource" }
  ```
- `get_language_id` source (use "gF" to open): [../lsp/robotcode.lua:6](../lsp/robotcode.lua#L6)
- `root_markers` :
  ```lua
  { "robot.toml", "pyproject.toml", "Pipfile", ".git" }
  ```

---

## robotframework_ls

https://github.com/robocorp/robotframework-lsp

Language Server Protocol implementation for Robot Framework.

Snippet to enable the language server:
```lua
vim.lsp.enable('robotframework_ls')
```

Default config:
- `cmd` :
  ```lua
  { "robotframework_ls" }
  ```
- `filetypes` :
  ```lua
  { "robot" }
  ```
- `root_markers` :
  ```lua
  { "robotidy.toml", "pyproject.toml", "conda.yaml", "robot.yaml", ".git" }
  ```

---

## roc_ls

https://github.com/roc-lang/roc/tree/main/crates/language_server#roc_language_server

The built-in language server for the Roc programming language.
[Installation](https://github.com/roc-lang/roc/tree/main/crates/language_server#installing)

Snippet to enable the language server:
```lua
vim.lsp.enable('roc_ls')
```

Default config:
- `cmd` :
  ```lua
  { "roc_language_server" }
  ```
- `filetypes` :
  ```lua
  { "roc" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## rome

https://rome.tools

Language server for the Rome Frontend Toolchain.

(Unmaintained, use [Biome](https://biomejs.dev/blog/annoucing-biome) instead.)

```sh
npm install [-g] rome
```

Snippet to enable the language server:
```lua
vim.lsp.enable('rome')
```

Default config:
- `cmd` :
  ```lua
  { "rome", "lsp-proxy" }
  ```
- `filetypes` :
  ```lua
  { "javascript", "javascriptreact", "json", "typescript", "typescript.tsx", "typescriptreact" }
  ```
- `root_markers` :
  ```lua
  { "package.json", "node_modules", ".git" }
  ```

---

## roslyn_ls

https://github.com/dotnet/roslyn

To install the server, compile from source or download as nuget package.
Go to `https://dev.azure.com/azure-public/vside/_artifacts/feed/vs-impl/NuGet/Microsoft.CodeAnalysis.LanguageServer.<platform>/overview`
replace `<platform>` with one of the following `linux-x64`, `osx-x64`, `win-x64`, `neutral` (for more info on the download location see https://github.com/dotnet/roslyn/issues/71474#issuecomment-2177303207).
Download and extract it (nuget's are zip files).
- if you chose `neutral` nuget version, then you have to change the `cmd` like so:
  cmd = {
    'dotnet',
    '<my_folder>/Microsoft.CodeAnalysis.LanguageServer.dll',
    '--logLevel', -- this property is required by the server
    'Information',
    '--extensionLogDirectory', -- this property is required by the server
    fs.joinpath(uv.os_tmpdir(), 'roslyn_ls/logs'),
    '--stdio',
  },
  where `<my_folder>` has to be the folder you extracted the nuget package to.
- for all other platforms put the extracted folder to neovim's PATH (`vim.env.PATH`)

Snippet to enable the language server:
```lua
vim.lsp.enable('roslyn_ls')
```

Default config:
- `capabilities` :
  ```lua
  {
    textDocument = {
      diagnostic = {
        dynamicRegistration = true
      }
    }
  }
  ```
- `cmd` :
  ```lua
  { "Microsoft.CodeAnalysis.LanguageServer", "--logLevel", "Information", "--extensionLogDirectory", "/tmp/roslyn_ls/logs", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "cs" }
  ```
- `handlers` :
  ```lua
  {
    ["razor/provideDynamicFileInfo"] = <function 1>,
    ["workspace/_roslyn_projectHasUnresolvedDependencies"] = <function 2>,
    ["workspace/_roslyn_projectNeedsRestore"] = <function 3>,
    ["workspace/projectInitializationComplete"] = <function 4>
  }
  ```
- `name` :
  ```lua
  "roslyn_ls"
  ```
- `offset_encoding` :
  ```lua
  "utf-8"
  ```
- `on_init` :
  ```lua
  { <function 1> }
  ```
- `root_dir` source (use "gF" to open): [../lsp/roslyn_ls.lua:92](../lsp/roslyn_ls.lua#L92)
- `settings` :
  ```lua
  {
    ["csharp|background_analysis"] = {
      dotnet_analyzer_diagnostics_scope = "fullSolution",
      dotnet_compiler_diagnostics_scope = "fullSolution"
    },
    ["csharp|code_lens"] = {
      dotnet_enable_references_code_lens = true
    },
    ["csharp|completion"] = {
      dotnet_provide_regex_completions = true,
      dotnet_show_completion_items_from_unimported_namespaces = true,
      dotnet_show_name_completion_suggestions = true
    },
    ["csharp|inlay_hints"] = {
      csharp_enable_inlay_hints_for_implicit_object_creation = true,
      csharp_enable_inlay_hints_for_implicit_variable_types = true,
      csharp_enable_inlay_hints_for_lambda_parameter_types = true,
      csharp_enable_inlay_hints_for_types = true,
      dotnet_enable_inlay_hints_for_indexer_parameters = true,
      dotnet_enable_inlay_hints_for_literal_parameters = true,
      dotnet_enable_inlay_hints_for_object_creation_parameters = true,
      dotnet_enable_inlay_hints_for_other_parameters = true,
      dotnet_enable_inlay_hints_for_parameters = true,
      dotnet_suppress_inlay_hints_for_parameters_that_differ_only_by_suffix = true,
      dotnet_suppress_inlay_hints_for_parameters_that_match_argument_name = true,
      dotnet_suppress_inlay_hints_for_parameters_that_match_method_intent = true
    },
    ["csharp|symbol_search"] = {
      dotnet_search_reference_assemblies = true
    }
  }
  ```

---

## rpmspec

https://github.com/dcermak/rpm-spec-language-server

Language server protocol (LSP) support for RPM Spec files.

`rpm-spec-language-server` can be installed by running,

```sh
pip install rpm-spec-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('rpmspec')
```

Default config:
- `cmd` :
  ```lua
  { "rpm_lsp_server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "spec" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## rubocop

https://github.com/rubocop/rubocop

Snippet to enable the language server:
```lua
vim.lsp.enable('rubocop')
```

Default config:
- `cmd` :
  ```lua
  { "rubocop", "--lsp" }
  ```
- `filetypes` :
  ```lua
  { "ruby" }
  ```
- `root_markers` :
  ```lua
  { "Gemfile", ".git" }
  ```

---

## ruby_lsp

https://shopify.github.io/ruby-lsp/

This gem is an implementation of the language server protocol specification for
Ruby, used to improve editor features.

Install the gem. There's no need to require it, since the server is used as a
standalone executable.

```sh
gem install ruby-lsp
```

Snippet to enable the language server:
```lua
vim.lsp.enable('ruby_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "ruby-lsp" }
  ```
- `filetypes` :
  ```lua
  { "ruby", "eruby" }
  ```
- `init_options` :
  ```lua
  {
    formatter = "auto"
  }
  ```
- `root_markers` :
  ```lua
  { "Gemfile", ".git" }
  ```

---

## ruff

https://github.com/astral-sh/ruff

A Language Server Protocol implementation for Ruff, an extremely fast Python linter and code formatter, written in Rust. It can be installed via `pip`.

```sh
pip install ruff
```

**Available in Ruff `v0.4.5` in beta and stabilized in Ruff `v0.5.3`.**

This is the new built-in language server written in Rust. It supports the same feature set as `ruff-lsp`, but with superior performance and no installation required. Note that the `ruff-lsp` server will continue to be maintained until further notice.

Server settings can be provided via:

```lua
vim.lsp.config('ruff', {
  init_options = {
    settings = {
      -- Server settings should go here
    }
  }
})
```

Refer to the [documentation](https://docs.astral.sh/ruff/editors/) for more details.

Snippet to enable the language server:
```lua
vim.lsp.enable('ruff')
```

Default config:
- `cmd` :
  ```lua
  { "ruff", "server" }
  ```
- `filetypes` :
  ```lua
  { "python" }
  ```
- `root_markers` :
  ```lua
  { "pyproject.toml", "ruff.toml", ".ruff.toml", ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## ruff_lsp

https://github.com/astral-sh/ruff-lsp

A Language Server Protocol implementation for Ruff, an extremely fast Python linter and code transformation tool, written in Rust. It can be installed via pip.

```sh
pip install ruff-lsp
```

Extra CLI arguments for `ruff` can be provided via

```lua
vim.lsp.config('ruff_lsp', {
  init_options = {
    settings = {
      -- Any extra CLI arguments for `ruff` go here.
      args = {},
    }
  }
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('ruff_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "ruff-lsp" }
  ```
- `filetypes` :
  ```lua
  { "python" }
  ```
- `root_markers` :
  ```lua
  { "pyproject.toml", "ruff.toml", ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## rune_languageserver

https://crates.io/crates/rune-languageserver

A language server for the [Rune](https://rune-rs.github.io/) Language,
an embeddable dynamic programming language for Rust

Snippet to enable the language server:
```lua
vim.lsp.enable('rune_languageserver')
```

Default config:
- `cmd` :
  ```lua
  { "rune-languageserver" }
  ```
- `filetypes` :
  ```lua
  { "rune" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## rust_analyzer

https://github.com/rust-lang/rust-analyzer

rust-analyzer (aka rls 2.0), a language server for Rust


See [docs](https://rust-analyzer.github.io/book/configuration.html) for extra settings. The settings can be used like this:
```lua
vim.lsp.config('rust_analyzer', {
  settings = {
    ['rust-analyzer'] = {
      diagnostics = {
        enable = false;
      }
    }
  }
})
```

Note: do not set `init_options` for this LS config, it will be automatically populated by the contents of settings["rust-analyzer"] per
https://github.com/rust-lang/rust-analyzer/blob/eb5da56d839ae0a9e9f50774fa3eb78eb0964550/docs/dev/lsp-extensions.md?plain=1#L26.

Snippet to enable the language server:
```lua
vim.lsp.enable('rust_analyzer')
```

Default config:
- `before_init` source (use "gF" to open): [../lsp/rust_analyzer.lua:56](../lsp/rust_analyzer.lua#L56)
- `capabilities` :
  ```lua
  {
    experimental = {
      serverStatusNotification = true
    }
  }
  ```
- `cmd` :
  ```lua
  { "rust-analyzer" }
  ```
- `filetypes` :
  ```lua
  { "rust" }
  ```
- `on_attach` source (use "gF" to open): [../lsp/rust_analyzer.lua:56](../lsp/rust_analyzer.lua#L56)
- `root_dir` source (use "gF" to open): [../lsp/rust_analyzer.lua:56](../lsp/rust_analyzer.lua#L56)

---

## salt_ls

Language server for Salt configuration files.
https://github.com/dcermak/salt-lsp

The language server can be installed with `pip`:
```sh
pip install salt-lsp
```

Snippet to enable the language server:
```lua
vim.lsp.enable('salt_ls')
```

Default config:
- `cmd` :
  ```lua
  { "salt_lsp_server" }
  ```
- `filetypes` :
  ```lua
  { "sls" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## scheme_langserver

https://github.com/ufo5260987423/scheme-langserver
`scheme-langserver`, a language server protocol implementation for scheme.
And for nvim user, please add .sls to scheme file extension list.

Snippet to enable the language server:
```lua
vim.lsp.enable('scheme_langserver')
```

Default config:
- `cmd` :
  ```lua
  { "scheme-langserver", "~/.scheme-langserver.log", "enable", "disable" }
  ```
- `filetypes` :
  ```lua
  { "scheme" }
  ```
- `root_markers` :
  ```lua
  { "Akku.manifest", ".git" }
  ```

---

## scry

https://github.com/crystal-lang-tools/scry

Crystal language server.

Snippet to enable the language server:
```lua
vim.lsp.enable('scry')
```

Default config:
- `cmd` :
  ```lua
  { "scry" }
  ```
- `filetypes` :
  ```lua
  { "crystal" }
  ```
- `root_markers` :
  ```lua
  { "shard.yml", ".git" }
  ```

---

## selene3p_ls

https://github.com/antonk52/lua-3p-language-servers

3rd party Language Server for Selene lua linter

Snippet to enable the language server:
```lua
vim.lsp.enable('selene3p_ls')
```

Default config:
- `cmd` :
  ```lua
  { "selene-3p-language-server" }
  ```
- `filetypes` :
  ```lua
  { "lua" }
  ```
- `root_markers` :
  ```lua
  { "selene.toml" }
  ```

---

## serve_d

https://github.com/Pure-D/serve-d

Microsoft language server protocol implementation for D using workspace-d.
Download a binary from https://github.com/Pure-D/serve-d/releases and put it in your $PATH.

Snippet to enable the language server:
```lua
vim.lsp.enable('serve_d')
```

Default config:
- `cmd` :
  ```lua
  { "serve-d" }
  ```
- `filetypes` :
  ```lua
  { "d" }
  ```
- `root_markers` :
  ```lua
  { "dub.json", "dub.sdl", ".git" }
  ```

---

## shopify_theme_ls

https://shopify.dev/docs/api/shopify-cli

[Language Server](https://shopify.dev/docs/themes/tools/cli/language-server) and Theme Check (linter) for Shopify themes.

`shopify` can be installed via npm `npm install -g @shopify/cli`.

Note: This LSP already includes Theme Check so you don't need to use the `theme_check` server configuration as well.

Snippet to enable the language server:
```lua
vim.lsp.enable('shopify_theme_ls')
```

Default config:
- `cmd` :
  ```lua
  { "shopify", "theme", "language-server" }
  ```
- `filetypes` :
  ```lua
  { "liquid" }
  ```
- `root_markers` :
  ```lua
  { ".shopifyignore", ".theme-check.yml", ".theme-check.yaml", "shopify.theme.toml" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## sixtyfps

https://github.com/sixtyfpsui/sixtyfps
`SixtyFPS`'s language server

You can build and install `sixtyfps-lsp` binary with `cargo`:
```sh
cargo install sixtyfps-lsp
```

Vim does not have built-in syntax for the `sixtyfps` filetype currently.

This can be added via an autocmd:

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.60 set filetype=sixtyfps ]]
```

or by installing a filetype plugin such as https://github.com/RustemB/sixtyfps-vim

Snippet to enable the language server:
```lua
vim.lsp.enable('sixtyfps')
```

Default config:
- `cmd` :
  ```lua
  { "sixtyfps-lsp" }
  ```
- `filetypes` :
  ```lua
  { "sixtyfps" }
  ```

---

## slangd

https://github.com/shader-slang/slang

The `slangd` binary can be downloaded as part of [slang releases](https://github.com/shader-slang/slang/releases) or
by [building `slang` from source](https://github.com/shader-slang/slang/blob/master/docs/building.md).

The server can be configured by passing a "settings" object to `slangd.setup{}`:

```lua
vim.lsp.config('slangd', {
  settings = {
    slang = {
      predefinedMacros = {"MY_VALUE_MACRO=1"},
      inlayHints = {
        deducedTypes = true,
        parameterNames = true,
      }
    }
  }
})
```
Available options are documented [here](https://github.com/shader-slang/slang-vscode-extension/tree/main?tab=readme-ov-file#configurations)
or in more detail [here](https://github.com/shader-slang/slang-vscode-extension/blob/main/package.json#L70).

Snippet to enable the language server:
```lua
vim.lsp.enable('slangd')
```

Default config:
- `cmd` :
  ```lua
  { "slangd" }
  ```
- `filetypes` :
  ```lua
  { "hlsl", "shaderslang" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## slint_lsp

https://github.com/slint-ui/slint
`Slint`'s language server

You can build and install `slint-lsp` binary with `cargo`:
```sh
cargo install slint-lsp
```

Vim does not have built-in syntax for the `slint` filetype at this time.

This can be added via an autocmd:

```lua
vim.cmd [[ autocmd BufRead,BufNewFile *.slint set filetype=slint ]]
```

Snippet to enable the language server:
```lua
vim.lsp.enable('slint_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "slint-lsp" }
  ```
- `filetypes` :
  ```lua
  { "slint" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## smarty_ls

https://github.com/landeaux/vscode-smarty-langserver-extracted

Language server for Smarty.

`smarty-language-server` can be installed via `npm`:

```sh
npm i -g vscode-smarty-langserver-extracted
```

Snippet to enable the language server:
```lua
vim.lsp.enable('smarty_ls')
```

Default config:
- `cmd` :
  ```lua
  { "smarty-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "smarty" }
  ```
- `init_options` :
  ```lua
  {}
  ```
- `root_dir` source (use "gF" to open): [../lsp/smarty_ls.lua:15](../lsp/smarty_ls.lua#L15)
- `settings` :
  ```lua
  {
    css = {
      validate = true
    },
    smarty = {
      pluginDirs = {}
    }
  }
  ```

---

## smithy_ls

https://github.com/awslabs/smithy-language-server

`Smithy Language Server`, A Language Server Protocol implementation for the Smithy IDL

Snippet to enable the language server:
```lua
vim.lsp.enable('smithy_ls')
```

Default config:
- `cmd` :
  ```lua
  { "smithy-language-server", "0" }
  ```
- `filetypes` :
  ```lua
  { "smithy" }
  ```
- `root_markers` :
  ```lua
  { "smithy-build.json", "build.gradle", "build.gradle.kts", ".git" }
  ```

---

## snakeskin_ls

https://www.npmjs.com/package/@snakeskin/cli

`snakeskin cli` can be installed via `npm`:
```sh
npm install -g @snakeskin/cli
```

Snippet to enable the language server:
```lua
vim.lsp.enable('snakeskin_ls')
```

Default config:
- `cmd` :
  ```lua
  { "snakeskin-cli", "lsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "ss" }
  ```
- `root_markers` :
  ```lua
  { "package.json" }
  ```

---

## snyk_ls

https://github.com/snyk/snyk-ls

LSP for Snyk Open Source, Snyk Infrastructure as Code, and Snyk Code.

Snippet to enable the language server:
```lua
vim.lsp.enable('snyk_ls')
```

Default config:
- `cmd` :
  ```lua
  { "snyk-ls" }
  ```
- `filetypes` :
  ```lua
  { "go", "gomod", "javascript", "typescript", "json", "python", "requirements", "helm", "yaml", "terraform", "terraform-vars" }
  ```
- `init_options` :
  ```lua
  {
    activateSnykCode = "true"
  }
  ```
- `root_markers` :
  ```lua
  { ".git", ".snyk" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## solang

A language server for Solidity

 See the [documentation](https://solang.readthedocs.io/en/latest/installing.html) for installation instructions.

 The language server only provides the following capabilities:
 * Syntax highlighting
 * Diagnostics
 * Hover

 There is currently no support for completion, goto definition, references, or other functionality.

Snippet to enable the language server:
```lua
vim.lsp.enable('solang')
```

Default config:
- `cmd` :
  ```lua
  { "solang", "language-server", "--target", "evm" }
  ```
- `filetypes` :
  ```lua
  { "solidity" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## solargraph

https://solargraph.org/

solargraph, a language server for Ruby

You can install solargraph via gem install.

```sh
gem install --user-install solargraph
```

Snippet to enable the language server:
```lua
vim.lsp.enable('solargraph')
```

Default config:
- `cmd` :
  ```lua
  { "solargraph", "stdio" }
  ```
- `filetypes` :
  ```lua
  { "ruby" }
  ```
- `init_options` :
  ```lua
  {
    formatting = true
  }
  ```
- `root_markers` :
  ```lua
  { "Gemfile", ".git" }
  ```
- `settings` :
  ```lua
  {
    solargraph = {
      diagnostics = true
    }
  }
  ```

---

## solc

https://docs.soliditylang.org/en/latest/installing-solidity.html

solc is the native language server for the Solidity language.

Snippet to enable the language server:
```lua
vim.lsp.enable('solc')
```

Default config:
- `cmd` :
  ```lua
  { "solc", "--lsp" }
  ```
- `filetypes` :
  ```lua
  { "solidity" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/solc.lua:9](../lsp/solc.lua#L9)

---

## solidity

https://github.com/qiuxiang/solidity-ls

npm i solidity-ls -g

Make sure that solc is installed and it's the same version of the file.  solc-select is recommended.

Solidity language server is a LSP with autocomplete, go to definition and diagnostics.

If you use brownie, use this root_markers:
root_markers = { 'brownie-config.yaml', '.git' }

on includePath, you can add an extra path to search for external libs, on remapping you can remap lib <> path, like:

```lua
{ solidity = { includePath = '/Users/your_user/.brownie/packages/', remapping = { ["@OpenZeppelin/"] = 'OpenZeppelin/openzeppelin-contracts@4.6.0/' } } }
```

**For brownie users**
Change the root_markers to:

```lua
root_markers = { 'brownie-config.yaml', '.git' }
```

The best way of using it is to have a package.json in your project folder with the packages that you will use.
After installing with package.json, just create a `remappings.txt` with:

```
@OpenZeppelin/=node_modules/OpenZeppelin/openzeppelin-contracts@4.6.0/
```

You can omit the node_modules as well.

Snippet to enable the language server:
```lua
vim.lsp.enable('solidity')
```

Default config:
- `cmd` :
  ```lua
  { "solidity-ls", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "solidity" }
  ```
- `root_markers` :
  ```lua
  { ".git", "package.json" }
  ```
- `settings` :
  ```lua
  {
    solidity = {
      includePath = "",
      remapping = {}
    }
  }
  ```

---

## solidity_ls

https://github.com/juanfranblanco/vscode-solidity

`vscode-solidity-server` can be installed via `npm`:

```sh
npm install -g vscode-solidity-server
```

`vscode-solidity-server` is a language server for the Solidity language ported from the VSCode "solidity" extension.

Snippet to enable the language server:
```lua
vim.lsp.enable('solidity_ls')
```

Default config:
- `cmd` :
  ```lua
  { "vscode-solidity-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "solidity" }
  ```
- `root_markers` :
  ```lua
  { "hardhat.config.js", "hardhat.config.ts", "foundry.toml", "remappings.txt", "truffle.js", "truffle-config.js", "ape-config.yaml", ".git", "package.json" }
  ```

---

## solidity_ls_nomicfoundation

https://github.com/NomicFoundation/hardhat-vscode/blob/development/server/README.md

`nomicfoundation-solidity-language-server` can be installed via `npm`:

```sh
npm install -g @nomicfoundation/solidity-language-server
```

A language server for the Solidity programming language, built by the Nomic Foundation for the Ethereum community.

Snippet to enable the language server:
```lua
vim.lsp.enable('solidity_ls_nomicfoundation')
```

Default config:
- `cmd` :
  ```lua
  { "nomicfoundation-solidity-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "solidity" }
  ```
- `root_markers` :
  ```lua
  { "hardhat.config.js", "hardhat.config.ts", "foundry.toml", "remappings.txt", "truffle.js", "truffle-config.js", "ape-config.yaml", ".git", "package.json" }
  ```

---

## somesass_ls

https://github.com/wkillerud/some-sass/tree/main/packages/language-server

`some-sass-language-server` can be installed via `npm`:

```sh
npm i -g some-sass-language-server
```

The language server provides:

- Full support for @use and @forward, including aliases, prefixes and hiding.
- Workspace-wide code navigation and refactoring, such as Rename Symbol.
- Rich documentation through SassDoc.
- Language features for %placeholder-selectors, both when using them and writing them.
- Suggestions and hover info for built-in Sass modules, when used with @use.

Snippet to enable the language server:
```lua
vim.lsp.enable('somesass_ls')
```

Default config:
- `cmd` :
  ```lua
  { "some-sass-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "scss", "sass" }
  ```
- `name` :
  ```lua
  "somesass_ls"
  ```
- `root_markers` :
  ```lua
  { ".git", ".package.json" }
  ```
- `settings` :
  ```lua
  {
    somesass = {
      suggestAllFromOpenDocument = true
    }
  }
  ```

---

## sorbet

https://sorbet.org

Sorbet is a fast, powerful type checker designed for Ruby.

You can install Sorbet via gem install. You might also be interested in how to set
Sorbet up for new projects: https://sorbet.org/docs/adopting.

```sh
gem install sorbet
```

Snippet to enable the language server:
```lua
vim.lsp.enable('sorbet')
```

Default config:
- `cmd` :
  ```lua
  { "srb", "tc", "--lsp" }
  ```
- `filetypes` :
  ```lua
  { "ruby" }
  ```
- `root_markers` :
  ```lua
  { "Gemfile", ".git" }
  ```

---

## sourcekit

https://github.com/swiftlang/sourcekit-lsp

Language server for Swift and C/C++/Objective-C.

Snippet to enable the language server:
```lua
vim.lsp.enable('sourcekit')
```

Default config:
- `capabilities` :
  ```lua
  {
    textDocument = {
      diagnostic = {
        dynamicRegistration = true,
        relatedDocumentSupport = true
      }
    },
    workspace = {
      didChangeWatchedFiles = {
        dynamicRegistration = true
      }
    }
  }
  ```
- `cmd` :
  ```lua
  { "sourcekit-lsp" }
  ```
- `filetypes` :
  ```lua
  { "swift", "objc", "objcpp", "c", "cpp" }
  ```
- `get_language_id` source (use "gF" to open): [../lsp/sourcekit.lua:9](../lsp/sourcekit.lua#L9)
- `root_dir` source (use "gF" to open): [../lsp/sourcekit.lua:9](../lsp/sourcekit.lua#L9)

---

## spectral

https://github.com/luizcorreia/spectral-language-server
 `A flexible JSON/YAML linter for creating automated style guides, with baked in support for OpenAPI v2 & v3.`

`spectral-language-server` can be installed via `npm`:
```sh
npm i -g spectral-language-server
```
See [vscode-spectral](https://github.com/stoplightio/vscode-spectral#extension-settings) for configuration options.

Snippet to enable the language server:
```lua
vim.lsp.enable('spectral')
```

Default config:
- `cmd` :
  ```lua
  { "spectral-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "yaml", "json", "yml" }
  ```
- `root_markers` :
  ```lua
  { ".spectral.yaml", ".spectral.yml", ".spectral.json", ".spectral.js" }
  ```
- `settings` :
  ```lua
  {
    enable = true,
    run = "onType",
    validateLanguages = { "yaml", "json", "yml" }
  }
  ```

---

## spyglassmc_language_server

https://github.com/SpyglassMC/Spyglass/tree/main/packages/language-server

Language server for Minecraft datapacks.

`spyglassmc-language-server` can be installed via `npm`:

```sh
npm i -g @spyglassmc/language-server
```

You may also need to configure the filetype:

`autocmd BufNewFile,BufRead *.mcfunction set filetype=mcfunction`

This is automatically done by [CrystalAlpha358/vim-mcfunction](https://github.com/CrystalAlpha358/vim-mcfunction), which also provide syntax highlight.

Snippet to enable the language server:
```lua
vim.lsp.enable('spyglassmc_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "spyglassmc-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "mcfunction" }
  ```
- `root_markers` :
  ```lua
  { "pack.mcmeta" }
  ```

---

## sqlls

https://github.com/joe-re/sql-language-server

This LSP can be installed via  `npm`. Find further instructions on manual installation of the sql-language-server at [joe-re/sql-language-server](https://github.com/joe-re/sql-language-server).

Snippet to enable the language server:
```lua
vim.lsp.enable('sqlls')
```

Default config:
- `cmd` :
  ```lua
  { "sql-language-server", "up", "--method", "stdio" }
  ```
- `filetypes` :
  ```lua
  { "sql", "mysql" }
  ```
- `root_markers` :
  ```lua
  { ".sqllsrc.json" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## sqls

https://github.com/sqls-server/sqls

```lua
vim.lsp.config('sqls', {
  cmd = {"path/to/command", "-config", "path/to/config.yml"};
  ...
})
```
Sqls can be installed via `go install github.com/sqls-server/sqls@latest`. Instructions for compiling Sqls from the source can be found at [sqls-server/sqls](https://github.com/sqls-server/sqls).

Snippet to enable the language server:
```lua
vim.lsp.enable('sqls')
```

Default config:
- `cmd` :
  ```lua
  { "sqls" }
  ```
- `filetypes` :
  ```lua
  { "sql", "mysql" }
  ```
- `root_markers` :
  ```lua
  { "config.yml" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## sqruff

https://github.com/quarylabs/sqruff

`sqruff` can be installed by following the instructions [here](https://github.com/quarylabs/sqruff?tab=readme-ov-file#installation)

Snippet to enable the language server:
```lua
vim.lsp.enable('sqruff')
```

Default config:
- `cmd` :
  ```lua
  { "sqruff", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "sql" }
  ```
- `root_markers` :
  ```lua
  { ".sqruff", ".git" }
  ```

---

## standardrb

https://github.com/testdouble/standard

Ruby Style Guide, with linter & automatic code fixer.

Snippet to enable the language server:
```lua
vim.lsp.enable('standardrb')
```

Default config:
- `cmd` :
  ```lua
  { "standardrb", "--lsp" }
  ```
- `filetypes` :
  ```lua
  { "ruby" }
  ```
- `root_markers` :
  ```lua
  { "Gemfile", ".git" }
  ```

---

## starlark_rust

https://github.com/facebookexperimental/starlark-rust/
The LSP part of `starlark-rust` is not currently documented,
but the implementation works well for linting.
This gives valuable warnings for potential issues in the code,
but does not support refactorings.

It can be installed with cargo: https://crates.io/crates/starlark

Snippet to enable the language server:
```lua
vim.lsp.enable('starlark_rust')
```

Default config:
- `cmd` :
  ```lua
  { "starlark", "--lsp" }
  ```
- `filetypes` :
  ```lua
  { "star", "bzl", "BUILD.bazel" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## starpls

https://github.com/withered-magic/starpls

`starpls` is an LSP implementation for Starlark. Installation instructions can be found in the project's README.

Snippet to enable the language server:
```lua
vim.lsp.enable('starpls')
```

Default config:
- `cmd` :
  ```lua
  { "starpls" }
  ```
- `filetypes` :
  ```lua
  { "bzl" }
  ```
- `root_markers` :
  ```lua
  { "WORKSPACE", "WORKSPACE.bazel", "MODULE.bazel" }
  ```

---

## statix

https://github.com/nerdypepper/statix

lints and suggestions for the nix programming language

Snippet to enable the language server:
```lua
vim.lsp.enable('statix')
```

Default config:
- `cmd` :
  ```lua
  { "statix", "check", "--stdin" }
  ```
- `filetypes` :
  ```lua
  { "nix" }
  ```
- `root_markers` :
  ```lua
  { "flake.nix", ".git" }
  ```

---

## steep

https://github.com/soutaro/steep

`steep` is a static type checker for Ruby.

You need `Steepfile` to make it work. Generate it with `steep init`.

Snippet to enable the language server:
```lua
vim.lsp.enable('steep')
```

Default config:
- `cmd` :
  ```lua
  { "steep", "langserver" }
  ```
- `filetypes` :
  ```lua
  { "ruby", "eruby" }
  ```
- `root_markers` :
  ```lua
  { "Steepfile", ".git" }
  ```

---

## stimulus_ls

https://www.npmjs.com/package/stimulus-language-server

`stimulus-lsp` can be installed via `npm`:

```sh
npm install -g stimulus-language-server
```

or via `yarn`:

```sh
yarn global add stimulus-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('stimulus_ls')
```

Default config:
- `cmd` :
  ```lua
  { "stimulus-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "html", "ruby", "eruby", "blade", "php" }
  ```
- `root_markers` :
  ```lua
  { "Gemfile", ".git" }
  ```

---

## stylelint_lsp

https://github.com/bmatcuk/stylelint-lsp

`stylelint-lsp` can be installed via `npm`:

```sh
npm i -g stylelint-lsp
```

Can be configured by passing a `settings.stylelintplus` object to `stylelint_lsp.setup`:

```lua
vim.lsp.config('stylelint_lsp', {
  settings = {
    stylelintplus = {
      -- see available options in stylelint-lsp documentation
    }
  }
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('stylelint_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "stylelint-lsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "astro", "css", "html", "less", "scss", "sugarss", "vue", "wxss" }
  ```
- `root_markers` :
  ```lua
  { ".stylelintrc", ".stylelintrc.mjs", ".stylelintrc.cjs", ".stylelintrc.js", ".stylelintrc.json", ".stylelintrc.yaml", ".stylelintrc.yml", "stylelint.config.mjs", "stylelint.config.cjs", "stylelint.config.js" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## stylua3p_ls

https://github.com/antonk52/lua-3p-language-servers

3rd party Language Server for Stylua lua formatter

Snippet to enable the language server:
```lua
vim.lsp.enable('stylua3p_ls')
```

Default config:
- `cmd` :
  ```lua
  { "stylua-3p-language-server" }
  ```
- `filetypes` :
  ```lua
  { "lua" }
  ```
- `root_markers` :
  ```lua
  { ".stylua.toml", "stylua.toml" }
  ```

---

## superhtml

https://github.com/kristoff-it/superhtml

HTML Language Server & Templating Language Library

This LSP is designed to tightly adhere to the HTML spec as well as enforcing
some additional rules that ensure HTML clarity.

If you want to disable HTML support for another HTML LSP, add the following
to your configuration:

```lua
vim.lsp.config('superhtml', {
  filetypes = { 'superhtml' }
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('superhtml')
```

Default config:
- `cmd` :
  ```lua
  { "superhtml", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "superhtml", "html" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## svelte

https://github.com/sveltejs/language-tools/tree/master/packages/language-server

Note: assuming that [ts_ls](#ts_ls) is setup, full JavaScript/TypeScript support (find references, rename, etc of symbols in Svelte files when working in JS/TS files) requires per-project installation and configuration of [typescript-svelte-plugin](https://github.com/sveltejs/language-tools/tree/master/packages/typescript-plugin#usage).

`svelte-language-server` can be installed via `npm`:
```sh
npm install -g svelte-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('svelte')
```

Default config:
- `cmd` :
  ```lua
  { "svelteserver", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "svelte" }
  ```
- `on_attach` source (use "gF" to open): [../lsp/svelte.lua:12](../lsp/svelte.lua#L12)
- `root_markers` :
  ```lua
  { "package.json", ".git" }
  ```

---

## svlangserver

https://github.com/imc-trading/svlangserver

Language server for SystemVerilog.

`svlangserver` can be installed via `npm`:

```sh
$ npm install -g @imc-trading/svlangserver
```

Snippet to enable the language server:
```lua
vim.lsp.enable('svlangserver')
```

Default config:
- `cmd` :
  ```lua
  { "svlangserver" }
  ```
- `filetypes` :
  ```lua
  { "verilog", "systemverilog" }
  ```
- `on_attach` source (use "gF" to open): [../lsp/svlangserver.lua:28](../lsp/svlangserver.lua#L28)
- `root_markers` :
  ```lua
  { ".svlangserver", ".git" }
  ```
- `settings` :
  ```lua
  {
    systemverilog = {
      includeIndexing = { "*.{v,vh,sv,svh}", "**/*.{v,vh,sv,svh}" }
    }
  }
  ```

---

## svls

https://github.com/dalance/svls

Language server for verilog and SystemVerilog

`svls` can be installed via `cargo`:
 ```sh
 cargo install svls
 ```

Snippet to enable the language server:
```lua
vim.lsp.enable('svls')
```

Default config:
- `cmd` :
  ```lua
  { "svls" }
  ```
- `filetypes` :
  ```lua
  { "verilog", "systemverilog" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## swift_mesonls

https://github.com/JCWasmx86/Swift-MesonLSP

Meson language server written in Swift

Snippet to enable the language server:
```lua
vim.lsp.enable('swift_mesonls')
```

Default config:
- `cmd` :
  ```lua
  { "Swift-MesonLSP", "--lsp" }
  ```
- `filetypes` :
  ```lua
  { "meson" }
  ```
- `root_markers` :
  ```lua
  { "meson.build", "meson_options.txt", "meson.options", ".git" }
  ```

---

## syntax_tree

https://ruby-syntax-tree.github.io/syntax_tree/

A fast Ruby parser and formatter.

Syntax Tree is a suite of tools built on top of the internal CRuby parser. It
provides the ability to generate a syntax tree from source, as well as the
tools necessary to inspect and manipulate that syntax tree. It can be used to
build formatters, linters, language servers, and more.

```sh
gem install syntax_tree
```

Snippet to enable the language server:
```lua
vim.lsp.enable('syntax_tree')
```

Default config:
- `cmd` :
  ```lua
  { "stree", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "ruby" }
  ```
- `root_markers` :
  ```lua
  { ".streerc", "Gemfile", ".git" }
  ```

---

## systemd_ls

https://github.com/psacawa/systemd-language-server

`systemd-language-server` can be installed via `pip`:
```sh
pip install systemd-language-server
```

Language Server for Systemd unit files

Snippet to enable the language server:
```lua
vim.lsp.enable('systemd_ls')
```

Default config:
- `cmd` :
  ```lua
  { "systemd-language-server" }
  ```
- `filetypes` :
  ```lua
  { "systemd" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## tabby_ml

https://tabby.tabbyml.com/blog/running-tabby-as-a-language-server

Language server for Tabby, an opensource, self-hosted AI coding assistant.

`tabby-agent` can be installed via `npm`:

```sh
npm install --global tabby-agent
```

Snippet to enable the language server:
```lua
vim.lsp.enable('tabby_ml')
```

Default config:
- `cmd` :
  ```lua
  { "tabby-agent", "--lsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  {}
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## tailwindcss

https://github.com/tailwindlabs/tailwindcss-intellisense

Tailwind CSS Language Server can be installed via npm:

npm install -g @tailwindcss/language-server

Snippet to enable the language server:
```lua
vim.lsp.enable('tailwindcss')
```

Default config:
- `before_init` source (use "gF" to open): [../lsp/tailwindcss.lua:9](../lsp/tailwindcss.lua#L9)
- `cmd` :
  ```lua
  { "tailwindcss-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "aspnetcorerazor", "astro", "astro-markdown", "blade", "clojure", "django-html", "htmldjango", "edge", "eelixir", "elixir", "ejs", "erb", "eruby", "gohtml", "gohtmltmpl", "haml", "handlebars", "hbs", "html", "htmlangular", "html-eex", "heex", "jade", "leaf", "liquid", "markdown", "mdx", "mustache", "njk", "nunjucks", "php", "razor", "slim", "twig", "css", "less", "postcss", "sass", "scss", "stylus", "sugarss", "javascript", "javascriptreact", "reason", "rescript", "typescript", "typescriptreact", "vue", "svelte", "templ" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/tailwindcss.lua:9](../lsp/tailwindcss.lua#L9)
- `settings` :
  ```lua
  {
    tailwindCSS = {
      classAttributes = { "class", "className", "class:list", "classList", "ngClass" },
      includeLanguages = {
        eelixir = "html-eex",
        eruby = "erb",
        htmlangular = "html",
        templ = "html"
      },
      lint = {
        cssConflict = "warning",
        invalidApply = "error",
        invalidConfigPath = "error",
        invalidScreen = "error",
        invalidTailwindDirective = "error",
        invalidVariant = "error",
        recommendedVariantOrder = "warning"
      },
      validate = true
    }
  }
  ```
- `workspace_required` : `true`

---

## taplo

https://taplo.tamasfe.dev/cli/usage/language-server.html

Language server for Taplo, a TOML toolkit.

`taplo-cli` can be installed via `cargo`:
```sh
cargo install --features lsp --locked taplo-cli
```

Snippet to enable the language server:
```lua
vim.lsp.enable('taplo')
```

Default config:
- `cmd` :
  ```lua
  { "taplo", "lsp", "stdio" }
  ```
- `filetypes` :
  ```lua
  { "toml" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## tblgen_lsp_server

https://mlir.llvm.org/docs/Tools/MLIRLSP/#tablegen-lsp-language-server--tblgen-lsp-server

The Language Server for the LLVM TableGen language

`tblgen-lsp-server` can be installed at the llvm-project repository (https://github.com/llvm/llvm-project)

Snippet to enable the language server:
```lua
vim.lsp.enable('tblgen_lsp_server')
```

Default config:
- `cmd` :
  ```lua
  { "tblgen-lsp-server" }
  ```
- `filetypes` :
  ```lua
  { "tablegen" }
  ```
- `root_markers` :
  ```lua
  { "tablegen_compile_commands.yml", ".git" }
  ```

---

## teal_ls

https://github.com/teal-language/teal-language-server

Install with:
```
luarocks install teal-language-server
```

Optional Command Args:
* "--log-mode=by_date" - Enable logging in $HOME/.cache/teal-language-server. Log name will be date + pid of process
* "--log-mode=by_proj_path" - Enable logging in $HOME/.cache/teal-language-server. Log name will be project path + pid of process
* "--verbose=true" - Increases log level.  Does nothing unless log-mode is set

Snippet to enable the language server:
```lua
vim.lsp.enable('teal_ls')
```

Default config:
- `cmd` :
  ```lua
  { "teal-language-server" }
  ```
- `filetypes` :
  ```lua
  { "teal" }
  ```
- `root_markers` :
  ```lua
  { "tlconfig.lua" }
  ```

---

## templ

https://templ.guide

The official language server for the templ HTML templating language.

Snippet to enable the language server:
```lua
vim.lsp.enable('templ')
```

Default config:
- `cmd` :
  ```lua
  { "templ", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "templ" }
  ```
- `root_markers` :
  ```lua
  { "go.work", "go.mod", ".git" }
  ```

---

## terraform_lsp

https://github.com/juliosueiras/terraform-lsp

Terraform language server
Download a released binary from
https://github.com/juliosueiras/terraform-lsp/releases.

From https://github.com/hashicorp/terraform-ls#terraform-ls-vs-terraform-lsp:

Both HashiCorp and the maintainer of terraform-lsp expressed interest in
collaborating on a language server and are working towards a _long-term_
goal of a single stable and feature-complete implementation.

For the time being both projects continue to exist, giving users the
choice:

- `terraform-ls` providing
  - overall stability (by relying only on public APIs)
  - compatibility with any provider and any Terraform >=0.12.0 currently
    less features
  - due to project being younger and relying on public APIs which may
    not offer the same functionality yet

- `terraform-lsp` providing
  - currently more features
  - compatibility with a single particular Terraform (0.12.20 at time of writing)
    - configs designed for other 0.12 versions may work, but interpretation may be inaccurate
  - less stability (due to reliance on Terraform's own internal packages)

Snippet to enable the language server:
```lua
vim.lsp.enable('terraform_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "terraform-lsp" }
  ```
- `filetypes` :
  ```lua
  { "terraform", "hcl" }
  ```
- `root_markers` :
  ```lua
  { ".terraform", ".git" }
  ```

---

## terraformls

https://github.com/hashicorp/terraform-ls

Terraform language server
Download a released binary from https://github.com/hashicorp/terraform-ls/releases.

From https://github.com/hashicorp/terraform-ls#terraform-ls-vs-terraform-lsp:

Both HashiCorp and the maintainer of terraform-lsp expressed interest in
collaborating on a language server and are working towards a _long-term_
goal of a single stable and feature-complete implementation.

For the time being both projects continue to exist, giving users the
choice:

- `terraform-ls` providing
  - overall stability (by relying only on public APIs)
  - compatibility with any provider and any Terraform >=0.12.0 currently
    less features
  - due to project being younger and relying on public APIs which may
    not offer the same functionality yet

- `terraform-lsp` providing
  - currently more features
  - compatibility with a single particular Terraform (0.12.20 at time of writing)
    - configs designed for other 0.12 versions may work, but interpretation may be inaccurate
  - less stability (due to reliance on Terraform's own internal packages)

Note, that the `settings` configuration option uses the `workspace/didChangeConfiguration` event,
[which is not supported by terraform-ls](https://github.com/hashicorp/terraform-ls/blob/main/docs/features.md).
Instead you should use `init_options` which passes the settings as part of the LSP initialize call
[as is required by terraform-ls](https://github.com/hashicorp/terraform-ls/blob/main/docs/SETTINGS.md#how-to-pass-settings).

Snippet to enable the language server:
```lua
vim.lsp.enable('terraformls')
```

Default config:
- `cmd` :
  ```lua
  { "terraform-ls", "serve" }
  ```
- `filetypes` :
  ```lua
  { "terraform", "terraform-vars" }
  ```
- `root_markers` :
  ```lua
  { ".terraform", ".git" }
  ```

---

## texlab

https://github.com/latex-lsp/texlab

A completion engine built from scratch for (La)TeX.

See https://github.com/latex-lsp/texlab/wiki/Configuration for configuration options.

Snippet to enable the language server:
```lua
vim.lsp.enable('texlab')
```

Default config:
- `cmd` :
  ```lua
  { "texlab" }
  ```
- `filetypes` :
  ```lua
  { "tex", "plaintex", "bib" }
  ```
- `on_attach` source (use "gF" to open): [../lsp/texlab.lua:164](../lsp/texlab.lua#L164)
- `root_markers` :
  ```lua
  { ".git", ".latexmkrc", ".texlabroot", "texlabroot", "Tectonic.toml" }
  ```
- `settings` :
  ```lua
  {
    texlab = {
      bibtexFormatter = "texlab",
      build = {
        args = { "-pdf", "-interaction=nonstopmode", "-synctex=1", "%f" },
        executable = "latexmk",
        forwardSearchAfter = false,
        onSave = false
      },
      chktex = {
        onEdit = false,
        onOpenAndSave = false
      },
      diagnosticsDelay = 300,
      formatterLineLength = 80,
      forwardSearch = {
        args = {}
      },
      latexFormatter = "latexindent",
      latexindent = {
        modifyLineBreaks = false
      }
    }
  }
  ```

---

## textlsp

https://github.com/hangyav/textLSP

`textLSP` is an LSP server for text spell and grammar checking with various AI tools.
It supports multiple text file formats, such as LaTeX, Org or txt.

For the available text analyzer tools and their configuration, see the [GitHub](https://github.com/hangyav/textLSP) page.
By default, all analyzers are disabled in textLSP, since most of them need special settings.
For quick testing, LanguageTool is enabled in the default `nvim-lspconfig` configuration.

To install run: `pip install textLSP`

Snippet to enable the language server:
```lua
vim.lsp.enable('textlsp')
```

Default config:
- `cmd` :
  ```lua
  { "textlsp" }
  ```
- `filetypes` :
  ```lua
  { "text", "tex", "org" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {
    textLSP = {
      analysers = {
        languagetool = {
          check_text = {
            on_change = false,
            on_open = true,
            on_save = true
          },
          enabled = true
        }
      },
      documents = {
        org = {
          org_todo_keywords = { "TODO", "IN_PROGRESS", "DONE" }
        }
      }
    }
  }
  ```

---

## tflint

https://github.com/terraform-linters/tflint

A pluggable Terraform linter that can act as lsp server.
Installation instructions can be found in https://github.com/terraform-linters/tflint#installation.

Snippet to enable the language server:
```lua
vim.lsp.enable('tflint')
```

Default config:
- `cmd` :
  ```lua
  { "tflint", "--langserver" }
  ```
- `filetypes` :
  ```lua
  { "terraform" }
  ```
- `root_markers` :
  ```lua
  { ".terraform", ".git", ".tflint.hcl" }
  ```

---

## theme_check

https://github.com/Shopify/shopify-cli

`theme-check-language-server` is bundled with `shopify-cli` or it can also be installed via

https://github.com/Shopify/theme-check#installation

**NOTE:**
If installed via Homebrew, `cmd` must be set to 'theme-check-liquid-server'

```lua
vim.lsp.config('theme_check, {
  cmd = { 'theme-check-liquid-server' }
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('theme_check')
```

Default config:
- `cmd` :
  ```lua
  { "theme-check-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "liquid" }
  ```
- `root_markers` :
  ```lua
  { ".theme-check.yml" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## thriftls

https://github.com/joyme123/thrift-ls

you can install thriftls by mason or download binary here: https://github.com/joyme123/thrift-ls/releases

Snippet to enable the language server:
```lua
vim.lsp.enable('thriftls')
```

Default config:
- `cmd` :
  ```lua
  { "thriftls" }
  ```
- `filetypes` :
  ```lua
  { "thrift" }
  ```
- `root_markers` :
  ```lua
  { ".thrift" }
  ```

---

## tilt_ls

https://github.com/tilt-dev/tilt

Tilt language server.

You might need to add filetype detection manually:

```vim
autocmd BufRead Tiltfile setf=tiltfile
```

Snippet to enable the language server:
```lua
vim.lsp.enable('tilt_ls')
```

Default config:
- `cmd` :
  ```lua
  { "tilt", "lsp", "start" }
  ```
- `filetypes` :
  ```lua
  { "tiltfile" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## tinymist

https://github.com/Myriad-Dreamin/tinymist
An integrated language service for Typst [taɪpst]. You can also call it "微霭" [wēi ǎi] in Chinese.

Currently some of Tinymist's workspace commands are supported, namely:
`LspTinymistExportSvg`, `LspTinymistExportPng`, `LspTinymistExportPdf
`LspTinymistExportMarkdown`, `LspTinymistExportText`, `LspTinymistExportQuery`,
`LspTinymistExportAnsiHighlight`, `LspTinymistGetServerInfo`,
`LspTinymistGetDocumentTrace`, `LspTinymistGetWorkspaceLabels`, and
`LspTinymistGetDocumentMetrics`.

Snippet to enable the language server:
```lua
vim.lsp.enable('tinymist')
```

Default config:
- `cmd` :
  ```lua
  { "tinymist" }
  ```
- `filetypes` :
  ```lua
  { "typst" }
  ```
- `on_attach` source (use "gF" to open): [../lsp/tinymist.lua:52](../lsp/tinymist.lua#L52)
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## ts_ls

https://github.com/typescript-language-server/typescript-language-server

`ts_ls`, aka `typescript-language-server`, is a Language Server Protocol implementation for TypeScript wrapping `tsserver`. Note that `ts_ls` is not `tsserver`.

`typescript-language-server` depends on `typescript`. Both packages can be installed via `npm`:
```sh
npm install -g typescript typescript-language-server
```

To configure typescript language server, add a
[`tsconfig.json`](https://www.typescriptlang.org/docs/handbook/tsconfig-json.html) or
[`jsconfig.json`](https://code.visualstudio.com/docs/languages/jsconfig) to the root of your
project.

Here's an example that disables type checking in JavaScript files.

```json
{
  "compilerOptions": {
    "module": "commonjs",
    "target": "es6",
    "checkJs": false
  },
  "exclude": [
    "node_modules"
  ]
}
```

### Vue support

As of 2.0.0, Volar no longer supports TypeScript itself. Instead, a plugin
adds Vue support to this language server.

*IMPORTANT*: It is crucial to ensure that `@vue/typescript-plugin` and `volar `are of identical versions.

```lua
vim.lsp.config('ts_ls', {
  init_options = {
    plugins = {
      {
        name = "@vue/typescript-plugin",
        location = "/usr/local/lib/node_modules/@vue/typescript-plugin",
        languages = {"javascript", "typescript", "vue"},
      },
    },
  },
  filetypes = {
    "javascript",
    "typescript",
    "vue",
  },
})

-- You must make sure volar is setup
-- e.g. require'lspconfig'.volar.setup{}
-- See volar's section for more information
```

`location` MUST be defined. If the plugin is installed in `node_modules`,
`location` can have any value.

`languages` must include `vue` even if it is listed in `filetypes`.

`filetypes` is extended here to include Vue SFC.

Snippet to enable the language server:
```lua
vim.lsp.enable('ts_ls')
```

Default config:
- `cmd` :
  ```lua
  { "typescript-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx" }
  ```
- `handlers` :
  ```lua
  {
    ["_typescript.rename"] = <function 1>
  }
  ```
- `init_options` :
  ```lua
  {
    hostInfo = "neovim"
  }
  ```
- `root_markers` :
  ```lua
  { "tsconfig.json", "jsconfig.json", "package.json", ".git" }
  ```

---

## ts_query_ls

https://github.com/ribru17/ts_query_ls
Can be configured by passing a "settings" object to `vim.lsp.config('ts_query_ls', {})`:
```lua
vim.lsp.config('ts_query_ls', {
    settings = {
      parser_install_directories = {
        -- If using nvim-treesitter with lazy.nvim
        vim.fs.joinpath(
          vim.fn.stdpath('data'),
          '/lazy/nvim-treesitter/parser/'
        ),
      },
      -- This setting is provided by default
      parser_aliases = {
        ecma = 'javascript',
        jsx = 'javascript',
        php_only = 'php',
      },
      -- E.g. zed support
      language_retrieval_patterns = {
        'languages/src/([^/]+)/[^/]+\\.scm$',
      },
    },
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('ts_query_ls')
```

Default config:
- `cmd` :
  ```lua
  { "ts_query_ls" }
  ```
- `filetypes` :
  ```lua
  { "query" }
  ```
- `root_markers` :
  ```lua
  { "queries", ".git" }
  ```
- `settings` :
  ```lua
  {
    parser_aliases = {
      ecma = "javascript",
      jsx = "javascript",
      php_only = "php"
    }
  }
  ```

---

## tsp_server

https://github.com/microsoft/typespec

The language server for TypeSpec, a language for defining cloud service APIs and shapes.

`tsp-server` can be installed together with the typespec compiler via `npm`:
```sh
npm install -g @typespec/compiler
```

Snippet to enable the language server:
```lua
vim.lsp.enable('tsp_server')
```

Default config:
- `cmd` :
  ```lua
  { "tsp-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "typespec" }
  ```
- `root_markers` :
  ```lua
  { "tspconfig.yaml", ".git" }
  ```

---

## ttags

https://github.com/npezza93/ttags

Snippet to enable the language server:
```lua
vim.lsp.enable('ttags')
```

Default config:
- `cmd` :
  ```lua
  { "ttags", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "ruby", "rust", "javascript", "haskell" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## turbo_ls

https://www.npmjs.com/package/turbo-language-server

`turbo-language-server` can be installed via `npm`:

```sh
npm install -g turbo-language-server
```

or via `yarn`:

```sh
yarn global add turbo-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('turbo_ls')
```

Default config:
- `cmd` :
  ```lua
  { "turbo-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "html", "ruby", "eruby", "blade", "php" }
  ```
- `root_markers` :
  ```lua
  { "Gemfile", ".git" }
  ```

---

## turtle_ls

https://github.com/stardog-union/stardog-language-servers/tree/master/packages/turtle-language-server
`turtle-language-server`, An editor-agnostic server providing language intelligence (diagnostics, hover tooltips, etc.) for the W3C standard Turtle RDF syntax via the Language Server Protocol.
installable via npm install -g turtle-language-server or yarn global add turtle-language-server.
requires node.

Snippet to enable the language server:
```lua
vim.lsp.enable('turtle_ls')
```

Default config:
- `cmd` :
  ```lua
  { "node",
    [3] = "--stdio"
  }
  ```
- `filetypes` :
  ```lua
  { "turtle", "ttl" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## tvm_ffi_navigator

https://github.com/tqchen/ffi-navigator

The Language Server for FFI calls in TVM to be able jump between python and C++

FFI navigator can be installed with `pip install ffi-navigator`, buf for more details, please see
https://github.com/tqchen/ffi-navigator?tab=readme-ov-file#installation

Snippet to enable the language server:
```lua
vim.lsp.enable('tvm_ffi_navigator')
```

Default config:
- `cmd` :
  ```lua
  { "python", "-m", "ffi_navigator.langserver" }
  ```
- `filetypes` :
  ```lua
  { "python", "cpp" }
  ```
- `root_markers` :
  ```lua
  { "pyproject.toml", ".git" }
  ```

---

## twiggy_language_server

https://github.com/moetelo/twiggy

`twiggy-language-server` can be installed via `npm`:
```sh
npm install -g twiggy-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('twiggy_language_server')
```

Default config:
- `cmd` :
  ```lua
  { "twiggy-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "twig" }
  ```
- `root_markers` :
  ```lua
  { "composer.json", ".git" }
  ```

---

## typeprof

https://github.com/ruby/typeprof

`typeprof` is the built-in analysis and LSP tool for Ruby 3.1+.

Snippet to enable the language server:
```lua
vim.lsp.enable('typeprof')
```

Default config:
- `cmd` :
  ```lua
  { "typeprof", "--lsp", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "ruby", "eruby" }
  ```
- `root_markers` :
  ```lua
  { "Gemfile", ".git" }
  ```

---

## typos_lsp

https://github.com/crate-ci/typos
https://github.com/tekumara/typos-lsp

A Language Server Protocol implementation for Typos, a low false-positive
source code spell checker, written in Rust. Download it from the releases page
on GitHub: https://github.com/tekumara/typos-lsp/releases

Snippet to enable the language server:
```lua
vim.lsp.enable('typos_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "typos-lsp" }
  ```
- `root_markers` :
  ```lua
  { "typos.toml", "_typos.toml", ".typos.toml", "pyproject.toml", "Cargo.toml" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## typst_lsp

https://github.com/nvarner/typst-lsp

Language server for Typst.

Snippet to enable the language server:
```lua
vim.lsp.enable('typst_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "typst-lsp" }
  ```
- `filetypes` :
  ```lua
  { "typst" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## uiua

https://github.com/uiua-lang/uiua/

The builtin language server of the Uiua interpreter.

The Uiua interpreter can be installed with `cargo install uiua`

Snippet to enable the language server:
```lua
vim.lsp.enable('uiua')
```

Default config:
- `cmd` :
  ```lua
  { "uiua", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "uiua" }
  ```
- `root_markers` :
  ```lua
  { "main.ua", ".fmt.ua", ".git" }
  ```

---

## ungrammar_languageserver

https://github.com/binhtran432k/ungrammar-language-features
Language Server for Ungrammar.

Ungrammar Language Server can be installed via npm:
```sh
npm i ungrammar-languageserver -g
```

Snippet to enable the language server:
```lua
vim.lsp.enable('ungrammar_languageserver')
```

Default config:
- `cmd` :
  ```lua
  { "ungrammar-languageserver", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "ungrammar" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {
    ungrammar = {
      format = {
        enable = true
      },
      validate = {
        enable = true
      }
    }
  }
  ```

---

## unison

https://github.com/unisonweb/unison/blob/trunk/docs/language-server.markdown

Snippet to enable the language server:
```lua
vim.lsp.enable('unison')
```

Default config:
- `cmd` :
  ```lua
  { "nc", "localhost", "5757" }
  ```
- `filetypes` :
  ```lua
  { "unison" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/unison.lua:7](../lsp/unison.lua#L7)
- `settings` :
  ```lua
  {}
  ```

---

## unocss

https://github.com/xna00/unocss-language-server

UnoCSS Language Server can be installed via npm:
```sh
npm i unocss-language-server -g
```

Snippet to enable the language server:
```lua
vim.lsp.enable('unocss')
```

Default config:
- `cmd` :
  ```lua
  { "unocss-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "erb", "haml", "hbs", "html", "css", "postcss", "javascript", "javascriptreact", "markdown", "ejs", "php", "svelte", "typescript", "typescriptreact", "vue-html", "vue", "sass", "scss", "less", "stylus", "astro", "rescript", "rust" }
  ```
- `root_markers` :
  ```lua
  { "unocss.config.js", "unocss.config.ts", "uno.config.js", "uno.config.ts" }
  ```
- `workspace_required` : `true`

---

## uvls

https://codeberg.org/caradhras/uvls
Language server for UVL, written using tree sitter and rust.
You can install the server easily using cargo:
```sh
git clone https://codeberg.org/caradhras/uvls
cd  uvls
cargo install --path .
```
Note: To activate properly nvim needs to know the uvl filetype.
You can add it via:
```lua
vim.cmd([[au BufRead,BufNewFile *.uvl setfiletype uvl]])
```

Snippet to enable the language server:
```lua
vim.lsp.enable('uvls')
```

Default config:
- `cmd` :
  ```lua
  { "uvls" }
  ```
- `filetypes` :
  ```lua
  { "uvl" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## v_analyzer

https://github.com/vlang/v-analyzer

V language server.

`v-analyzer` can be installed by following the instructions [here](https://github.com/vlang/v-analyzer#installation).

Snippet to enable the language server:
```lua
vim.lsp.enable('v_analyzer')
```

Default config:
- `cmd` :
  ```lua
  { "v-analyzer" }
  ```
- `filetypes` :
  ```lua
  { "v", "vsh", "vv" }
  ```
- `root_markers` :
  ```lua
  { "v.mod", ".git" }
  ```

---

## vacuum

Vacuum is the worlds fastest OpenAPI 3, OpenAPI 2 / Swagger linter and quality analysis tool.

 You can install vacuum using mason or follow the instructions here: https://github.com/daveshanley/vacuum

 The file types are not detected automatically, you can register them manually (see below) or override the filetypes:

 ```lua
 vim.filetype.add {
   pattern = {
     ['openapi.*%.ya?ml'] = 'yaml.openapi',
     ['openapi.*%.json'] = 'json.openapi',
   },
 }
 ```

Snippet to enable the language server:
```lua
vim.lsp.enable('vacuum')
```

Default config:
- `cmd` :
  ```lua
  { "vacuum", "language-server" }
  ```
- `filetypes` :
  ```lua
  { "yaml.openapi", "json.openapi" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## vala_ls

https://github.com/Prince781/vala-language-server

Snippet to enable the language server:
```lua
vim.lsp.enable('vala_ls')
```

Default config:
- `cmd` :
  ```lua
  { "vala-language-server" }
  ```
- `filetypes` :
  ```lua
  { "vala", "genie" }
  ```
- `root_dir` source (use "gF" to open): [../lsp/vala_ls.lua:26](../lsp/vala_ls.lua#L26)

---

## vale_ls

https://github.com/errata-ai/vale-ls

An implementation of the Language Server Protocol (LSP) for the Vale command-line tool.

Snippet to enable the language server:
```lua
vim.lsp.enable('vale_ls')
```

Default config:
- `cmd` :
  ```lua
  { "vale-ls" }
  ```
- `filetypes` :
  ```lua
  { "markdown", "text", "tex", "rst" }
  ```
- `root_markers` :
  ```lua
  { ".vale.ini" }
  ```

---

## verible

https://github.com/chipsalliance/verible

A linter and formatter for verilog and SystemVerilog files.

Release binaries can be downloaded from [here](https://github.com/chipsalliance/verible/releases)
and placed in a directory on PATH.

See https://github.com/chipsalliance/verible/tree/master/verilog/tools/ls/README.md for options.

Snippet to enable the language server:
```lua
vim.lsp.enable('verible')
```

Default config:
- `cmd` :
  ```lua
  { "verible-verilog-ls" }
  ```
- `filetypes` :
  ```lua
  { "systemverilog", "verilog" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## veridian

https://github.com/vivekmalneedi/veridian

A SystemVerilog LanguageServer.

Download the latest release for your OS from the releases page

Install with slang feature, if C++17 compiler is available:
```
cargo install --git https://github.com/vivekmalneedi/veridian.git --all-features
```

Install if C++17 compiler is not available:
```
cargo install --git https://github.com/vivekmalneedi/veridian.git
```

Snippet to enable the language server:
```lua
vim.lsp.enable('veridian')
```

Default config:
- `cmd` :
  ```lua
  { "veridian" }
  ```
- `filetypes` :
  ```lua
  { "systemverilog", "verilog" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## veryl_ls

https://github.com/veryl-lang/veryl

Language server for Veryl

`veryl-ls` can be installed via `cargo`:
 ```sh
 cargo install veryl-ls
 ```

Snippet to enable the language server:
```lua
vim.lsp.enable('veryl_ls')
```

Default config:
- `cmd` :
  ```lua
  { "veryl-ls" }
  ```
- `filetypes` :
  ```lua
  { "veryl" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## vhdl_ls

Install vhdl_ls from https://github.com/VHDL-LS/rust_hdl and add it to path

Configuration

The language server needs to know your library mapping to perform full analysis of the code. For this it uses a configuration file in the TOML format named vhdl_ls.toml.

vhdl_ls will load configuration files in the following order of priority (first to last):

    A file named .vhdl_ls.toml in the user home folder.
    A file name from the VHDL_LS_CONFIG environment variable.
    A file named vhdl_ls.toml in the workspace root.

Settings in a later files overwrites those from previously loaded files.

Example vhdl_ls.toml
```
# File names are either absolute or relative to the parent folder of the vhdl_ls.toml file
[libraries]
lib2.files = [
  'pkg2.vhd',
]
lib1.files = [
  'pkg1.vhd',
  'tb_ent.vhd'
]
```

Snippet to enable the language server:
```lua
vim.lsp.enable('vhdl_ls')
```

Default config:
- `cmd` :
  ```lua
  { "vhdl_ls" }
  ```
- `filetypes` :
  ```lua
  { "vhd", "vhdl" }
  ```
- `root_markers` :
  ```lua
  { "vhdl_ls.toml", ".vhdl_ls.toml" }
  ```

---

## vimls

https://github.com/iamcco/vim-language-server

You can install vim-language-server via npm:
```sh
npm install -g vim-language-server
```

Snippet to enable the language server:
```lua
vim.lsp.enable('vimls')
```

Default config:
- `cmd` :
  ```lua
  { "vim-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "vim" }
  ```
- `init_options` :
  ```lua
  {
    diagnostic = {
      enable = true
    },
    indexes = {
      count = 3,
      gap = 100,
      projectRootPatterns = { "runtime", "nvim", ".git", "autoload", "plugin" },
      runtimepath = true
    },
    isNeovim = true,
    iskeyword = "@,48-57,_,192-255,-#",
    runtimepath = "",
    suggest = {
      fromRuntimepath = true,
      fromVimruntime = true
    },
    vimruntime = ""
  }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## visualforce_ls

https://github.com/forcedotcom/salesforcedx-vscode

Language server for Visualforce.

For manual installation, download the .vsix archive file from the
[forcedotcom/salesforcedx-vscode](https://github.com/forcedotcom/salesforcedx-vscode)
GitHub releases. Then, configure `cmd` to run the Node script at the unpacked location:

```lua
vim.lsp.config('visualforce_ls', {
  cmd = {
    'node',
    '/path/to/unpacked/archive/extension/node_modules/@salesforce/salesforcedx-visualforce-language-server/out/src/visualforceServer.js',
    '--stdio'
  }
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('visualforce_ls')
```

Default config:
- `filetypes` :
  ```lua
  { "visualforce" }
  ```
- `init_options` :
  ```lua
  {
    embeddedLanguages = {
      css = true,
      javascript = true
    }
  }
  ```
- `root_markers` :
  ```lua
  { "sfdx-project.json" }
  ```

---

## vls

https://github.com/vlang/vls

V language server.

`v-language-server` can be installed by following the instructions [here](https://github.com/vlang/vls#installation).

Snippet to enable the language server:
```lua
vim.lsp.enable('vls')
```

Default config:
- `cmd` :
  ```lua
  { "v", "ls" }
  ```
- `filetypes` :
  ```lua
  { "v", "vlang" }
  ```
- `root_markers` :
  ```lua
  { "v.mod", ".git" }
  ```

---

## volar

https://github.com/vuejs/language-tools/tree/master/packages/language-server

Volar language server for Vue

Volar can be installed via npm:
```sh
npm install -g @vue/language-server
```

Volar by default supports Vue 3 projects.
For Vue 2 projects, [additional configuration](https://github.com/vuejs/language-tools/blob/master/extensions/vscode/README.md?plain=1#L19) are required.

**Hybrid Mode (by default)**

In this mode, the Vue Language Server exclusively manages the CSS/HTML sections.
You need the `ts_ls` server with the `@vue/typescript-plugin` plugin to support TypeScript in `.vue` files.
See `ts_ls` section for more information

**No Hybrid Mode**

Volar will run embedded `ts_ls` therefore there is no need to run it separately.
```lua
local lspconfig = require('lspconfig')

lspconfig.volar.setup {
  -- add filetypes for typescript, javascript and vue
  filetypes = { 'typescript', 'javascript', 'javascriptreact', 'typescriptreact', 'vue' },
  init_options = {
    vue = {
      -- disable hybrid mode
      hybridMode = false,
    },
  },
}
-- you must remove ts_ls setup
-- lspconfig.ts_ls.setup {}
```

**Overriding the default TypeScript Server used by Volar**

The default config looks for TypeScript in the local `node_modules`. This can lead to issues
e.g. when working on a [monorepo](https://monorepo.tools/). The alternatives are:

- use a global TypeScript Server installation
```lua
require'lspconfig'.volar.setup {
  init_options = {
    typescript = {
      -- replace with your global TypeScript library path
      tsdk = '/path/to/node_modules/typescript/lib'
    }
  }
}
```

- use a local server and fall back to a global TypeScript Server installation
```lua
require'lspconfig'.volar.setup {
  init_options = {
    typescript = {
      -- replace with your global TypeScript library path
      tsdk = '/path/to/node_modules/typescript/lib'
    }
  },
  on_new_config = function(new_config, new_root_dir)
    local lib_path = vim.fs.find('node_modules/typescript/lib', { path = new_root_dir, upward = true })[1]
    if lib_path then
      new_config.init_options.typescript.tsdk = lib_path
    end
  end
}
```

Snippet to enable the language server:
```lua
vim.lsp.enable('volar')
```

Default config:
- `before_init` source (use "gF" to open): [../lsp/volar.lua:88](../lsp/volar.lua#L88)
- `cmd` :
  ```lua
  { "vue-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "vue" }
  ```
- `init_options` :
  ```lua
  {
    typescript = {
      tsdk = ""
    }
  }
  ```
- `root_markers` :
  ```lua
  { "package.json" }
  ```

---

## vscoqtop

https://github.com/coq-community/vscoq

Snippet to enable the language server:
```lua
vim.lsp.enable('vscoqtop')
```

Default config:
- `cmd` :
  ```lua
  { "vscoqtop" }
  ```
- `filetypes` :
  ```lua
  { "coq" }
  ```
- `root_markers` :
  ```lua
  { "_CoqProject", ".git" }
  ```

---

## vtsls

https://github.com/yioneko/vtsls

`vtsls` can be installed with npm:
```sh
npm install -g @vtsls/language-server
```

To configure a TypeScript project, add a
[`tsconfig.json`](https://www.typescriptlang.org/docs/handbook/tsconfig-json.html)
or [`jsconfig.json`](https://code.visualstudio.com/docs/languages/jsconfig) to
the root of your project.

Snippet to enable the language server:
```lua
vim.lsp.enable('vtsls')
```

Default config:
- `cmd` :
  ```lua
  { "vtsls", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "javascript", "javascriptreact", "javascript.jsx", "typescript", "typescriptreact", "typescript.tsx" }
  ```
- `root_markers` :
  ```lua
  { "tsconfig.json", "package.json", "jsconfig.json", ".git" }
  ```

---

## vuels

https://github.com/vuejs/vetur/tree/master/server

Vue language server(vls)
`vue-language-server` can be installed via `npm`:
```sh
npm install -g vls
```

Snippet to enable the language server:
```lua
vim.lsp.enable('vuels')
```

Default config:
- `cmd` :
  ```lua
  { "vls" }
  ```
- `filetypes` :
  ```lua
  { "vue" }
  ```
- `init_options` :
  ```lua
  {
    config = {
      css = {},
      emmet = {},
      html = {
        suggest = {}
      },
      javascript = {
        format = {}
      },
      stylusSupremacy = {},
      typescript = {
        format = {}
      },
      vetur = {
        completion = {
          autoImport = false,
          tagCasing = "kebab",
          useScaffoldSnippets = false
        },
        format = {
          defaultFormatter = {
            js = "none",
            ts = "none"
          },
          defaultFormatterOptions = {},
          scriptInitialIndent = false,
          styleInitialIndent = false
        },
        useWorkspaceDependencies = false,
        validation = {
          script = true,
          style = true,
          template = true
        }
      }
    }
  }
  ```
- `root_markers` :
  ```lua
  { "package.json", "vue.config.js" }
  ```

---

## wasm_language_tools

https://github.com/g-plane/wasm-language-tools

WebAssembly Language Tools aims to provide and improve the editing experience of WebAssembly Text Format.
It also provides an out-of-the-box formatter (a.k.a. pretty printer) for WebAssembly Text Format.

Snippet to enable the language server:
```lua
vim.lsp.enable('wasm_language_tools')
```

Default config:
- `cmd` :
  ```lua
  { "wat_server" }
  ```
- `filetypes` :
  ```lua
  { "wat" }
  ```

---

## wgsl_analyzer

https://github.com/wgsl-analyzer/wgsl-analyzer

`wgsl-analyzer` can be installed via `cargo`:
```sh
cargo install --git https://github.com/wgsl-analyzer/wgsl-analyzer wgsl-analyzer
```

Snippet to enable the language server:
```lua
vim.lsp.enable('wgsl_analyzer')
```

Default config:
- `cmd` :
  ```lua
  { "wgsl-analyzer" }
  ```
- `filetypes` :
  ```lua
  { "wgsl" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {}
  ```

---

## yamlls

https://github.com/redhat-developer/yaml-language-server

`yaml-language-server` can be installed via `yarn`:
```sh
yarn global add yaml-language-server
```

To use a schema for validation, there are two options:

1. Add a modeline to the file. A modeline is a comment of the form:

```
# yaml-language-server: $schema=<urlToTheSchema|relativeFilePath|absoluteFilePath}>
```

where the relative filepath is the path relative to the open yaml file, and the absolute filepath
is the filepath relative to the filesystem root ('/' on unix systems)

2. Associated a schema url, relative , or absolute (to root of project, not to filesystem root) path to
the a glob pattern relative to the detected project root. Check `:checkhealth vim.lsp` to determine the resolved project
root.

```lua
vim.lsp.config('yamlls', {
  ... -- other configuration for setup {}
  settings = {
    yaml = {
      ... -- other settings. note this overrides the lspconfig defaults.
      schemas = {
        ["https://json.schemastore.org/github-workflow.json"] = "/.github/workflows/*",
        ["../path/relative/to/file.yml"] = "/.github/workflows/*",
        ["/path/from/root/of/project"] = "/.github/workflows/*",
      },
    },
  }
})
```

Currently, kubernetes is special-cased in yammls, see the following upstream issues:
* [#211](https://github.com/redhat-developer/yaml-language-server/issues/211).
* [#307](https://github.com/redhat-developer/yaml-language-server/issues/307).

To override a schema to use a specific k8s schema version (for example, to use 1.18):

```lua
vim.lsp.config('yamlls', {
  ... -- other configuration for setup {}
  settings = {
    yaml = {
      ... -- other settings. note this overrides the lspconfig defaults.
      schemas = {
        ["https://raw.githubusercontent.com/yannh/kubernetes-json-schema/refs/heads/master/v1.32.1-standalone-strict/all.json"] = "/*.k8s.yaml",
        ... -- other schemas
      },
    },
  }
})
```

Snippet to enable the language server:
```lua
vim.lsp.enable('yamlls')
```

Default config:
- `cmd` :
  ```lua
  { "yaml-language-server", "--stdio" }
  ```
- `filetypes` :
  ```lua
  { "yaml", "yaml.docker-compose", "yaml.gitlab" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```
- `settings` :
  ```lua
  {
    redhat = {
      telemetry = {
        enabled = false
      }
    }
  }
  ```

---

## yang_lsp

https://github.com/TypeFox/yang-lsp

A Language Server for the YANG data modeling language.

Snippet to enable the language server:
```lua
vim.lsp.enable('yang_lsp')
```

Default config:
- `cmd` :
  ```lua
  { "yang-language-server" }
  ```
- `filetypes` :
  ```lua
  { "yang" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## yls

https://pypi.org/project/yls-yara/

An YLS plugin adding YARA linting capabilities.

This plugin runs yara.compile on every save, parses the errors, and returns list of diagnostic messages.

Language Server: https://github.com/avast/yls

Snippet to enable the language server:
```lua
vim.lsp.enable('yls')
```

Default config:
- `cmd` :
  ```lua
  { "yls", "-vv" }
  ```
- `filetypes` :
  ```lua
  { "yar", "yara" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## ziggy

https://ziggy-lang.io/documentation/ziggy-lsp/

Language server for the Ziggy data serialization format

Snippet to enable the language server:
```lua
vim.lsp.enable('ziggy')
```

Default config:
- `cmd` :
  ```lua
  { "ziggy", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "ziggy" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## ziggy_schema

https://ziggy-lang.io/documentation/ziggy-lsp/

Language server for schema files of the Ziggy data serialization format

Snippet to enable the language server:
```lua
vim.lsp.enable('ziggy_schema')
```

Default config:
- `cmd` :
  ```lua
  { "ziggy", "lsp", "--schema" }
  ```
- `filetypes` :
  ```lua
  { "ziggy_schema" }
  ```
- `root_markers` :
  ```lua
  { ".git" }
  ```

---

## zk

https://github.com/mickael-menu/zk

A plain text note-taking assistant

Snippet to enable the language server:
```lua
vim.lsp.enable('zk')
```

Default config:
- `cmd` :
  ```lua
  { "zk", "lsp" }
  ```
- `filetypes` :
  ```lua
  { "markdown" }
  ```
- `on_attach` source (use "gF" to open): [../lsp/zk.lua:15](../lsp/zk.lua#L15)
- `root_markers` :
  ```lua
  { ".zk" }
  ```

---

## zls

https://github.com/zigtools/zls

Zig LSP implementation + Zig Language Server

Snippet to enable the language server:
```lua
vim.lsp.enable('zls')
```

Default config:
- `cmd` :
  ```lua
  { "zls" }
  ```
- `filetypes` :
  ```lua
  { "zig", "zir" }
  ```
- `root_markers` :
  ```lua
  { "zls.json", "build.zig", ".git" }
  ```
- `workspace_required` : `false`

---

