/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.openide.modules.Dependency;
import org.openide.util.NbBundle;
import org.openide.util.Union2;

final class IllegalModuleException
extends IllegalArgumentException {
    private final Reason reason;
    private final Map<Module, Set<Union2<Dependency, InvalidException>>> bogus;

    IllegalModuleException(Reason reason, Module module) {
        this(reason, Collections.singletonMap(module, Collections.emptySet()));
    }

    IllegalModuleException(Reason reason, Map<Module, Set<Union2<Dependency, InvalidException>>> map) {
        this.reason = reason;
        this.bogus = map;
    }

    @Override
    public String getMessage() {
        return MessageFormat.format(this.reason.msg, this.bogus);
    }

    @Override
    public String getLocalizedMessage() {
        if (this.reason.l10n != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<Module, Set<Union2<Dependency, InvalidException>>> entry : this.bogus.entrySet()) {
                Module module = entry.getKey();
                stringBuilder.append(module.getDisplayName()).append("[").append(module.getCodeNameBase()).append("]");
                for (Union2<Dependency, InvalidException> union2 : entry.getValue()) {
                    if (!union2.hasFirst()) continue;
                    stringBuilder.append("\n - ").append(((Dependency)union2.first()).toString());
                }
                stringBuilder.append("\n");
            }
            return NbBundle.getMessage(Reason.class, (String)this.reason.l10n, (Object)stringBuilder.toString());
        }
        return this.getMessage();
    }

    static enum Reason {
        DELETE_FIXED_MODULE("fixed module: {0}"),
        DELETE_ENABLED_MODULE("enabled module: {0}"),
        RELOAD_FIXED_MODULE("reload fixed module: {0}"),
        RELOAD_ENABLED_MODULE("reload enabled module: {0}"),
        ENABLE_MISSING("Not all requested modules can be enabled: {0}", "MSG_ENABLE_MISSING"),
        ENABLE_TESTING("Would also need to enable: {0}"),
        DISABLE_TOO("Would also need to disable: {0}"),
        SIMULATE_ENABLE_AUTOLOAD("Cannot simulate enabling an autoload: {0}", "MSG_ENABLE_MISSING"),
        SIMULATE_ENABLE_EAGER("Cannot simulate enabling an eager module: {0}", "MSG_ENABLE_MISSING"),
        SIMULATE_ENABLE_ALREADY("Already enabled: {0}"),
        SIMULATE_ENABLE_INVALID("Not managed by me: {0}"),
        SIMULATE_DISABLE_AUTOLOAD("Cannot disable autoload: {0}"),
        SIMULATE_DISABLE_EAGER("Cannot disable eager module: {0}"),
        SIMULATE_DISABLE_FIXED("Cannot disable fixed module: {0}"),
        SIMULATE_DISABLE_ALREADY("Already disabled: {0}");

        final String msg;
        final String l10n;

        private Reason(String string2) {
            this(string2, null);
        }

        private Reason(String string2, String string3) {
            this.msg = string2;
            this.l10n = string3;
        }
    }
}

